/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class IntegerValue
extends NumericValue {
    public static final IntegerValue ZERO = new IntegerValue(0L);
    private static final BigInteger ZERO_BIGINTEGER = new BigInteger("0");
    private static final BigInteger ONE_BIGINTEGER = new BigInteger("1");
    private static final BigInteger MINUS_ONE_BIGINTEGER = new BigInteger("-1");
    private static final BigInteger LARGEST_LONG = new BigInteger("9223372036854775808");
    private static final BigInteger SMALLEST_LONG = LARGEST_LONG.negate();
    private static final BigInteger LARGEST_INT = new BigInteger("4294967296");
    private static final BigInteger SMALLEST_INT = LARGEST_INT.negate();
    private static final BigInteger LARGEST_SHORT = new BigInteger("65536");
    private static final BigInteger SMALLEST_SHORT = LARGEST_SHORT.negate();
    private static final BigInteger LARGEST_BYTE = new BigInteger("256");
    private static final BigInteger SMALLEST_BYTE = LARGEST_BYTE.negate();
    private BigInteger value;
    private int type = 31;

    public IntegerValue(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public IntegerValue(long value, int type) throws XPathException {
        this(value);
        this.type = type;
        if (!IntegerValue.checkType(value, type)) {
            throw new XPathException("Value is not a valid integer for type " + Type.getTypeName(type));
        }
    }

    public IntegerValue(String stringValue) throws XPathException {
        try {
            this.value = new BigInteger(StringValue.trimWhitespace(stringValue));
        }
        catch (NumberFormatException e) {
            throw new XPathException("failed to convert '" + stringValue + "' to an integer: " + e.getMessage(), e);
        }
    }

    public IntegerValue(String stringValue, int requiredType) throws XPathException {
        this.type = requiredType;
        try {
            this.value = new BigInteger(StringValue.trimWhitespace(stringValue));
            if (!this.checkType(this.value, this.type)) {
                throw new XPathException("FORG0001: can not convert '" + stringValue + "' to " + Type.getTypeName(this.type));
            }
        }
        catch (NumberFormatException e) {
            throw new XPathException("FORG0001: can not convert '" + stringValue + "' to " + Type.getTypeName(this.type));
        }
    }

    public IntegerValue(BigInteger value, int requiredType) {
        this.value = value;
        this.type = requiredType;
    }

    public IntegerValue(BigInteger integer) {
        this.value = integer;
    }

    private boolean checkType(BigInteger value2, int type2) throws XPathException {
        switch (this.type) {
            case 37: {
                return this.value.compareTo(SMALLEST_LONG) != -1 && this.value.compareTo(LARGEST_LONG) != 1;
            }
            case 31: 
            case 32: {
                return true;
            }
            case 46: {
                return this.value.compareTo(ZERO_BIGINTEGER) == 1;
            }
            case 41: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1;
            }
            case 36: {
                return this.value.compareTo(ZERO_BIGINTEGER) == -1;
            }
            case 35: {
                return this.value.compareTo(ONE_BIGINTEGER) == -1;
            }
            case 38: {
                return this.value.compareTo(SMALLEST_INT) == 1 && this.value.compareTo(LARGEST_INT) == -1;
            }
            case 39: {
                return this.value.compareTo(SMALLEST_SHORT) == 1 && this.value.compareTo(LARGEST_SHORT) == -1;
            }
            case 40: {
                return this.value.compareTo(SMALLEST_BYTE) == 1 && this.value.compareTo(LARGEST_BYTE) == -1;
            }
            case 42: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1 && this.value.compareTo(LARGEST_LONG) == -1;
            }
            case 43: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1 && this.value.compareTo(LARGEST_INT) == -1;
            }
            case 44: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1 && this.value.compareTo(LARGEST_SHORT) == -1;
            }
            case 45: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1 && this.value.compareTo(LARGEST_BYTE) == -1;
            }
        }
        throw new XPathException("Unknown type: " + Type.getTypeName(this.type));
    }

    private static final boolean checkType(long value, int type) throws XPathException {
        switch (type) {
            case 31: 
            case 32: 
            case 37: {
                return true;
            }
            case 35: {
                return value < 1L;
            }
            case 36: {
                return value < 0L;
            }
            case 38: {
                return value >= -4294967295L && value <= 0xFFFFFFFFL;
            }
            case 39: {
                return value >= -65535L && value <= 65535L;
            }
            case 40: {
                return value >= -255L && value <= 255L;
            }
            case 41: {
                return value > -1L;
            }
            case 42: {
                return value > -1L;
            }
            case 43: {
                return value > -1L && value <= 0xFFFFFFFFL;
            }
            case 44: {
                return value > -1L && value <= 65535L;
            }
            case 45: {
                return value > -1L && value <= 255L;
            }
            case 46: {
                return value > 0L;
            }
        }
        throw new XPathException("Unknown type: " + Type.getTypeName(type));
    }

    public int getType() {
        return this.type;
    }

    public boolean hasFractionalPart() {
        return false;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public long getValue() {
        return this.value.longValue();
    }

    public void setValue(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public boolean isNaN() {
        return false;
    }

    public boolean isInfinite() {
        return false;
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 31: 
            case 37: {
                return this;
            }
            case 32: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value, requiredType);
            }
            case 34: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 33: {
                return new FloatValue(this.value.floatValue());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 23: {
                return this.value.compareTo(ZERO_BIGINTEGER) == 0 ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException("err:FORG0001: cannot convert '" + Type.getTypeName(this.getType()) + " (" + this.value + ")' into " + Type.getTypeName(requiredType));
    }

    public int getInt() throws XPathException {
        return this.value.intValue();
    }

    public long getLong() throws XPathException {
        return this.value.longValue();
    }

    public double getDouble() throws XPathException {
        return this.value.doubleValue();
    }

    public NumericValue ceiling() throws XPathException {
        return this;
    }

    public NumericValue floor() throws XPathException {
        return this;
    }

    public NumericValue round() throws XPathException {
        return this;
    }

    public NumericValue round(IntegerValue precision) throws XPathException {
        if (precision.getInt() <= 0) {
            return (IntegerValue)((DecimalValue)this.convertTo(32)).round(precision).convertTo(31);
        }
        return this;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.subtract(((IntegerValue)other).value), this.type);
        }
        return ((ComputableValue)this.convertTo(other.getType())).minus(other);
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.add(((IntegerValue)other).value), this.type);
        }
        return ((ComputableValue)this.convertTo(other.getType())).plus(other);
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.multiply(((IntegerValue)other).value), this.type);
        }
        if (Type.subTypeOf(other.getType(), 53)) {
            return other.mult(this);
        }
        return ((ComputableValue)this.convertTo(other.getType())).mult(other);
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (other instanceof IntegerValue) {
            if (((IntegerValue)other).isZero()) {
                throw new XPathException("FOAR0001 : division by zero");
            }
            BigDecimal d = new BigDecimal(this.value);
            BigDecimal od = new BigDecimal(((IntegerValue)other).value);
            int scale = Math.max(18, Math.max(d.scale(), od.scale()));
            return new DecimalValue(d.divide(od, scale, 5));
        }
        return ((ComputableValue)this.convertTo(other.getType())).div(other);
    }

    public IntegerValue idiv(NumericValue other) throws XPathException {
        if (other.isZero()) {
            throw new XPathException("FOAR0001: division by zero");
        }
        ComputableValue result = this.div(other);
        return new IntegerValue(((IntegerValue)result.convertTo(31)).getLong());
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            BigInteger ov = ((IntegerValue)other).value;
            if (!((IntegerValue)other).effectiveBooleanValue()) {
                throw new XPathException("division by zero");
            }
            return new IntegerValue(this.value.remainder(ov), this.type);
        }
        return ((NumericValue)this.convertTo(other.getType())).mod(other);
    }

    public NumericValue negate() throws XPathException {
        return new IntegerValue(this.value.negate());
    }

    public NumericValue abs() throws XPathException {
        return new IntegerValue(this.value.abs(), this.type);
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.max(((IntegerValue)other).value));
        }
        return ((NumericValue)this.convertTo(other.getType())).max(collator, other);
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.min(((IntegerValue)other).value));
        }
        return ((NumericValue)this.convertTo(other.getType())).min(collator, other);
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(IntegerValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 1;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 2;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 3;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 4;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 5;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 6;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(IntegerValue.class)) {
            return this;
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(this.value.longValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer(v.value.intValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short(v.value.shortValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte(v.value.byteValue());
        }
        if (target == Double.class || target == Double.TYPE) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return new Double(v.getValue());
        }
        if (target == Float.class || target == Float.TYPE) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return new Float(v.value);
        }
        if (target == Boolean.class || target == Boolean.TYPE) {
            return new BooleanValue(this.effectiveBooleanValue());
        }
        if (target == String.class) {
            return this.value.toString();
        }
        if (target == Object.class) {
            return this.value;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 31)) {
            return this.value.compareTo(((IntegerValue)other).value);
        }
        return this.getType() > other.getType() ? 1 : -1;
    }
}

