/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.parser.XQueryAST;

public class XPathException
extends Exception {
    private int line = 0;
    private int column = 0;
    private String message = null;
    private List callStack = null;

    public XPathException(String message) {
        this.message = message;
    }

    public XPathException(XQueryAST ast, String message) {
        this.message = message;
        this.setASTNode(ast);
    }

    public XPathException(String message, int line, int column) {
        this.message = message;
        this.line = line;
        this.column = column;
    }

    public XPathException(Throwable cause) {
        super(cause);
    }

    public XPathException(String message, Throwable cause) {
        super(cause);
        this.message = message;
    }

    public XPathException(XQueryAST ast, String message, Throwable cause) {
        super(cause);
        this.message = message;
        this.setASTNode(ast);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setASTNode(XQueryAST ast) {
        if (ast != null) {
            this.line = ast.getLine();
            this.column = ast.getColumn();
        }
    }

    public void addFunctionCall(UserDefinedFunction def, XQueryAST ast) {
        if (this.callStack == null) {
            this.callStack = new ArrayList();
        }
        this.callStack.add(new FunctionStackElement(def, ast));
    }

    public void prependMessage(String msg) {
        this.message = msg + this.message;
    }

    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        if (this.message == null) {
            this.message = "";
        }
        buf.append(this.message);
        if (this.getLine() > 0) {
            buf.append(" [at line ");
            buf.append(this.getLine());
            buf.append(", column ");
            buf.append(this.getColumn());
            buf.append("]");
        }
        if (this.callStack != null) {
            buf.append("\nIn call to function:\n");
            Iterator i = this.callStack.iterator();
            while (i.hasNext()) {
                buf.append('\t').append(i.next());
                if (!i.hasNext()) continue;
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    public String getDetailMessage() {
        return this.message;
    }

    public String getMessageAsHTML() {
        StringBuffer buf = new StringBuffer();
        if (this.message == null) {
            this.message = "";
        }
        this.message = this.message.replaceAll("\r?\n", "<br/>");
        buf.append("<h2>").append(this.message);
        if (this.getLine() > 0) {
            buf.append(" [at line ");
            buf.append(this.getLine());
            buf.append(", column ");
            buf.append(this.getColumn());
            buf.append("]");
        }
        buf.append("</h2>");
        if (this.callStack != null) {
            buf.append("<table id=\"xquerytrace\">");
            buf.append("<caption>XQuery Stack Trace</caption>");
            Iterator i = this.callStack.iterator();
            while (i.hasNext()) {
                FunctionStackElement e = (FunctionStackElement)i.next();
                buf.append("<tr><td class=\"func\">").append(e.function).append("</td>");
                buf.append("<td class=\"lineinfo\">").append(e.ast.getLine()).append(':').append(e.ast.getColumn()).append("</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    private static class FunctionStackElement {
        String function;
        XQueryAST ast;

        FunctionStackElement(UserDefinedFunction func, XQueryAST ast) {
            this.function = func.toString();
            this.ast = ast;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.function).append(" [");
            buf.append(this.ast.getLine()).append(":");
            buf.append(this.ast.getColumn()).append(']');
            return buf.toString();
        }
    }
}

