/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class PIConstructor
extends NodeConstructor {
    private static Pattern wsContentStart = Pattern.compile("^(\\s)*(.*)");
    private final String target;
    private String data = null;

    public PIConstructor(XQueryContext context, String pi) throws XPathException {
        super(context);
        int p = pi.indexOf(" ");
        if (p == -1) {
            this.target = pi;
        } else {
            Matcher m;
            this.target = pi.substring(0, p);
            if (++p < pi.length()) {
                this.data = pi.substring(p);
            }
            if ((m = wsContentStart.matcher(this.data)).matches()) {
                this.data = m.group(2);
            }
        }
        if (this.target.equalsIgnoreCase("xml")) {
            throw new XPathException("XPST0003 : The target 'xml' is not allowed in XML processing instructions.");
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        int nodeNr = builder.processingInstruction(this.target, this.data);
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        return node;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("processing-instruction {");
        dumper.display(this.target);
        dumper.display("} {");
        dumper.startIndent();
        dumper.display(this.data);
        dumper.endIndent().nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("processing-instruction {");
        result.append(this.target.toString());
        result.append("} {");
        result.append(this.data.toString());
        result.append("}");
        return result.toString();
    }
}

