/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.Backup;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionConfigurationManager;
import org.exist.collections.IndexInfo;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.dom.SortedNodeSet;
import org.exist.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.protocolhandler.embedded.EmbeddedInputStream;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.security.XMLSecurityManager;
import org.exist.security.xacml.AccessContext;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.DataBackup;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.Compressor;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.Occurrences;
import org.exist.util.SyntaxException;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.validation.ValidationReport;
import org.exist.validation.Validator;
import org.exist.xmldb.XmldbURI;
import org.exist.xmlrpc.QueryResult;
import org.exist.xmlrpc.RpcServer;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Option;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class RpcConnection
extends Thread {
    private static final Logger LOG = Logger.getLogger((Class)RpcConnection.class);
    protected BrokerPool brokerPool;
    protected WeakHashMap documentCache = new WeakHashMap();
    protected boolean terminate = false;
    protected List cachedExpressions = new LinkedList();
    protected RpcServer.ConnectionPool connectionPool;
    private static final int MAX_DOWNLOAD_CHUNK_SIZE = 262144;
    protected String databaseid = "exist";

    public RpcConnection(Configuration conf, RpcServer.ConnectionPool pool, String id) throws EXistException {
        if (id != null && !"".equals(id)) {
            this.databaseid = id;
        }
        this.connectionPool = pool;
        this.brokerPool = BrokerPool.getInstance(this.databaseid);
    }

    public void createCollection(User user, String name, Date created) throws Exception, PermissionDeniedException, URISyntaxException {
        this.createCollection(user, XmldbURI.xmldbUriFor(name), created);
    }

    public void createCollection(User user, XmldbURI collUri, Date created) throws Exception, PermissionDeniedException {
        DBBroker broker = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            Collection current = broker.getOrCreateCollection(transaction, collUri);
            if (created != null) {
                current.setCreationTime(created.getTime());
            }
            LOG.debug((Object)("creating collection " + collUri));
            broker.saveCollection(transaction, current);
            transact.commit(transaction);
            broker.flush();
            LOG.info((Object)("collection " + collUri + " has been created"));
        }
        catch (Exception e) {
            transact.abort(transaction);
            LOG.warn((Object)e);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public void configureCollection(User user, String collName, String configuration) throws EXistException, URISyntaxException {
        this.configureCollection(user, XmldbURI.xmldbUriFor(collName), configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureCollection(User user, XmldbURI collUri, String configuration) throws EXistException {
        DBBroker broker = null;
        Collection collection = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            try {
                collection = broker.openCollection(collUri, 0);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("collection " + collUri + " not found!");
                }
            }
            finally {
                if (collection != null) {
                    collection.release(0);
                }
            }
            CollectionConfigurationManager mgr = this.brokerPool.getConfigurationManager();
            mgr.addConfiguration(transaction, broker, collection, configuration);
            transact.commit(transaction);
            LOG.info((Object)("Configured '" + collection.getURI() + "'"));
        }
        catch (CollectionConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public String createId(User user, String collName) throws EXistException, URISyntaxException {
        return this.createId(user, XmldbURI.xmldbUriFor(collName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId(User user, XmldbURI collUri) throws EXistException {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            XmldbURI id;
            boolean ok;
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found!");
            }
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id.toString();
            return string;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryResult doQuery(User user, DBBroker broker, String xpath, NodeSet contextSet, Hashtable parameters) throws Exception {
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        StringSource source = new StringSource(xpath);
        CompiledXQuery compiled = this.compile(user, broker, source, parameters);
        this.checkPragmas(compiled.getContext(), parameters);
        LockedDocumentMap lockedDocuments = null;
        try {
            long start = System.currentTimeMillis();
            lockedDocuments = this.beginProtected(broker, parameters);
            if (lockedDocuments != null) {
                compiled.getContext().setProtectedDocs(lockedDocuments);
            }
            Sequence result = xquery.execute(compiled, contextSet);
            HTTPUtils.addLastModifiedHeader(result, compiled.getContext());
            LOG.info((Object)("query took " + (System.currentTimeMillis() - start) + "ms."));
            QueryResult queryResult = new QueryResult(compiled.getContext(), result);
            return queryResult;
        }
        catch (XPathException e) {
            QueryResult queryResult = new QueryResult(e);
            return queryResult;
        }
        finally {
            if (lockedDocuments != null) {
                lockedDocuments.unlock();
            }
            if (compiled != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
    }

    protected LockedDocumentMap beginProtected(DBBroker broker, Hashtable parameters) throws EXistException {
        String protectColl = (String)parameters.get("protected");
        if (protectColl == null) {
            return null;
        }
        while (true) {
            DocumentSet docs = null;
            LockedDocumentMap lockedDocuments = new LockedDocumentMap();
            try {
                Collection coll = broker.getCollection(XmldbURI.createInternal(protectColl));
                docs = new DocumentSet();
                coll.allDocs(broker, docs, true, lockedDocuments, 1);
                return lockedDocuments;
            }
            catch (LockException e) {
                LOG.debug((Object)("Deadlock detected. Starting over again. Docs: " + docs.getLength() + "; locked: " + lockedDocuments.size()));
                lockedDocuments.unlock();
                continue;
            }
            break;
        }
    }

    private CompiledXQuery compile(User user, DBBroker broker, Source source, Hashtable parameters) throws XPathException, IOException {
        Vector staticDocuments;
        Hashtable variableDecls;
        Hashtable namespaces;
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
        XQueryContext context = compiled == null ? xquery.newContext(AccessContext.XMLRPC) : compiled.getContext();
        String base = (String)parameters.get("base-uri");
        if (base != null) {
            context.setBaseURI(new AnyURIValue(base));
        }
        if ((namespaces = (Hashtable)parameters.get("namespaces")) != null && namespaces.size() > 0) {
            context.declareNamespaces(namespaces);
        }
        if ((variableDecls = (Hashtable)parameters.get("variables")) != null) {
            Iterator i = variableDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                LOG.debug((Object)("declaring " + entry.getKey().toString() + " = " + entry.getValue()));
                context.declareVariable((String)entry.getKey(), entry.getValue());
            }
        }
        if ((staticDocuments = (Vector)parameters.get("static-documents")) != null) {
            try {
                XmldbURI[] d = new XmldbURI[staticDocuments.size()];
                int j = 0;
                Iterator i = staticDocuments.iterator();
                while (i.hasNext()) {
                    XmldbURI next;
                    d[j] = next = XmldbURI.xmldbUriFor((String)i.next());
                    ++j;
                }
                context.setStaticallyKnownDocuments(d);
            }
            catch (URISyntaxException e) {
                throw new XPathException(e);
            }
        } else if (context.isBaseURIDeclared()) {
            context.setStaticallyKnownDocuments(new XmldbURI[]{context.getBaseURI().toXmldbURI()});
        }
        if (compiled == null) {
            compiled = xquery.compile(context, source);
        }
        return compiled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printDiagnostics(User user, String query, Hashtable parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            StringSource source = new StringSource(query);
            XQuery xquery = broker.getXQueryService();
            XQueryPool pool = xquery.getXQueryPool();
            CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
            if (compiled == null) {
                compiled = this.compile(user, broker, source, parameters);
            }
            StringWriter writer = new StringWriter();
            compiled.dump(writer);
            String string = writer.toString();
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    protected void checkPragmas(XQueryContext context, Hashtable parameters) throws XPathException {
        Option pragma = context.getOption(Option.SERIALIZE_QNAME);
        if (pragma == null) {
            return;
        }
        String[] contents = pragma.tokenizeContents();
        for (int i = 0; i < contents.length; ++i) {
            String[] pair = Option.parseKeyValuePair(contents[i]);
            if (pair == null) {
                throw new XPathException("Unknown parameter found in " + pragma.getQName().getStringValue() + ": '" + contents[i] + "'");
            }
            LOG.debug((Object)("Setting serialization property from pragma: " + pair[0] + " = " + pair[1]));
            parameters.put(pair[0], pair[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQuery(User user, String xpath, Hashtable parameters) throws Exception {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult result = this.doQuery(user, broker, xpath, null, parameters);
            if (result.hasErrors()) {
                throw result.getException();
            }
            result.queryTime = System.currentTimeMillis() - startTime;
            int n = this.connectionPool.resultSets.add(result);
            return n;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    protected String formatErrorMsg(String message) {
        return this.formatErrorMsg("error", message);
    }

    protected String formatErrorMsg(String type, String message) {
        StringBuffer buf = new StringBuffer();
        buf.append("<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
        buf.append("hitCount=\"0\">");
        buf.append('<');
        buf.append(type);
        buf.append('>');
        buf.append(message);
        buf.append("</");
        buf.append(type);
        buf.append("></exist:result>");
        return buf.toString();
    }

    public Hashtable getCollectionDesc(User user, String rootCollection) throws Exception, URISyntaxException {
        return this.getCollectionDesc(user, rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getCollectionDesc(User user, XmldbURI rootUri) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            collection = broker.openCollection(rootUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + rootUri + " not found!");
            }
            Hashtable<String, Object> desc = new Hashtable<String, Object>();
            Vector docs = new Vector();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(user, 4)) {
                Iterator i = collection.iterator(broker);
                while (i.hasNext()) {
                    DocumentImpl doc = (DocumentImpl)i.next();
                    Permission perms = doc.getPermissions();
                    Hashtable<String, Object> hash = new Hashtable<String, Object>(4);
                    hash.put("name", doc.getFileURI().toString());
                    hash.put("owner", perms.getOwner());
                    hash.put("group", perms.getOwnerGroup());
                    hash.put("permissions", new Integer(perms.getPermissions()));
                    hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
                    docs.addElement(hash);
                }
                i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement(((XmldbURI)i.next()).toString());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("documents", docs);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            Hashtable<String, Object> hashtable = desc;
            return hashtable;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Hashtable describeResource(User user, String resourceName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.describeResource(user, XmldbURI.xmldbUriFor(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable describeResource(User user, XmldbURI resourceUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = this.brokerPool.get(user);
        DocumentImpl doc = null;
        Hashtable<String, Object> hash = new Hashtable<String, Object>(5);
        try {
            doc = broker.getXMLResource(resourceUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + resourceUri + " not found!"));
                Hashtable<String, Object> hashtable = hash;
                return hashtable;
            }
            if (!doc.getCollection().getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Not allowed to read collection");
            }
            Permission perms = doc.getPermissions();
            hash.put("name", resourceUri.toString());
            hash.put("owner", perms.getOwner());
            hash.put("group", perms.getOwnerGroup());
            hash.put("permissions", new Integer(perms.getPermissions()));
            hash.put("type", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
            hash.put("content-length", new Integer(doc.getContentLength()));
            hash.put("mime-type", doc.getMetadata().getMimeType());
            hash.put("created", new Date(doc.getMetadata().getCreated()));
            hash.put("modified", new Date(doc.getMetadata().getLastModified()));
            Hashtable<String, Object> hashtable = hash;
            return hashtable;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Hashtable describeCollection(User user, String rootCollection) throws Exception, URISyntaxException {
        return this.describeCollection(user, rootCollection == null ? XmldbURI.ROOT_COLLECTION_URI : XmldbURI.xmldbUriFor(rootCollection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable describeCollection(User user, XmldbURI collUri) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        Collection collection = null;
        try {
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found!");
            }
            Hashtable<String, Object> desc = new Hashtable<String, Object>();
            Vector<String> collections = new Vector<String>();
            if (collection.getPermissions().validate(user, 4)) {
                Iterator i = collection.collectionIterator();
                while (i.hasNext()) {
                    collections.addElement(((XmldbURI)i.next()).toString());
                }
            }
            Permission perms = collection.getPermissions();
            desc.put("collections", collections);
            desc.put("name", collection.getURI().toString());
            desc.put("created", Long.toString(collection.getCreationTime()));
            desc.put("owner", perms.getOwner());
            desc.put("group", perms.getOwnerGroup());
            desc.put("permissions", new Integer(perms.getPermissions()));
            Hashtable<String, Object> hashtable = desc;
            return hashtable;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public String getDocument(User user, String docName, Hashtable parametri) throws Exception, URISyntaxException {
        return this.getDocument(user, XmldbURI.xmldbUriFor(docName), parametri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocument(User user, XmldbURI docUri, Hashtable parametri) throws Exception {
        String string;
        Collection collection;
        DBBroker broker;
        block15: {
            broker = null;
            collection = null;
            DocumentImpl doc = null;
            try {
                String xml;
                broker = this.brokerPool.get(user);
                collection = broker.openCollection(docUri.removeLastSegment(), 0);
                if (collection == null) {
                    LOG.debug((Object)("collection " + docUri.removeLastSegment() + " not found!"));
                    String string2 = null;
                    if (collection != null) {
                        collection.releaseDocument(doc, 0);
                    }
                    if (collection != null) {
                        collection.release(0);
                    }
                    this.brokerPool.release(broker);
                    return string2;
                }
                if (!collection.getPermissions().validate(user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource");
                }
                doc = collection.getDocumentWithLock(broker, docUri.lastSegment(), 0);
                if (doc == null) {
                    LOG.debug((Object)("document " + docUri + " not found!"));
                    throw new EXistException("document not found");
                }
                if (!doc.getPermissions().validate(user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource " + docUri);
                }
                Serializer serializer = broker.getSerializer();
                serializer.setProperties(parametri);
                string = xml = serializer.serialize(doc);
                if (collection == null) break block15;
            }
            catch (NoSuchMethodError nsme) {
                nsme.printStackTrace();
                String string3 = null;
                return string3;
            }
            finally {
                if (collection != null) {
                    collection.releaseDocument(doc, 0);
                }
                if (collection != null) {
                    collection.release(0);
                }
                this.brokerPool.release(broker);
            }
            collection.releaseDocument(doc, 0);
        }
        if (collection != null) {
            collection.release(0);
        }
        this.brokerPool.release(broker);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDocumentData(User user, String docName, Hashtable parameters) throws Exception {
        DBBroker broker;
        DocumentImpl doc;
        Collection collection;
        block15: {
            collection = null;
            doc = null;
            broker = null;
            try {
                Object xml;
                broker = this.brokerPool.get(user);
                XmldbURI docURI = XmldbURI.xmldbUriFor(docName);
                collection = broker.openCollection(docURI.removeLastSegment(), 0);
                if (collection == null) {
                    LOG.debug((Object)("collection " + docURI.removeLastSegment() + " not found!"));
                    throw new EXistException("Collection " + docURI.removeLastSegment() + " not found!");
                }
                if (!collection.getPermissions().validate(user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource");
                }
                doc = collection.getDocumentWithLock(broker, docURI.lastSegment(), 0);
                if (doc == null) {
                    LOG.debug((Object)("document " + docURI + " not found!"));
                    throw new EXistException("document not found");
                }
                if (!doc.getPermissions().validate(user, 4)) {
                    throw new PermissionDeniedException("Insufficient privileges to read resource " + docName);
                }
                String encoding = (String)parameters.get("encoding");
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                if (doc.getResourceType() != 0) break block15;
                Serializer serializer = broker.getSerializer();
                serializer.setProperties(parameters);
                Hashtable<String, Object> result = new Hashtable<String, Object>();
                if (doc.getContentLength() > 262144) {
                    File tempFile = File.createTempFile("eXistRPCC", ".xml");
                    tempFile.deleteOnExit();
                    LOG.debug((Object)("Writing to temporary file: " + tempFile.getName()));
                    FileOutputStream os = new FileOutputStream(tempFile);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, encoding);
                    serializer.serialize(doc, writer);
                    ((Writer)writer).close();
                    byte[] firstChunk = this.getChunk(tempFile, 0);
                    result.put("data", firstChunk);
                    result.put("handle", tempFile.getAbsolutePath());
                    result.put("offset", new Integer(firstChunk.length));
                } else {
                    xml = serializer.serialize(doc);
                    result.put("data", ((String)xml).getBytes(encoding));
                    result.put("offset", new Integer(0));
                }
                xml = result;
                if (collection != null) {
                    collection.releaseDocument(doc, 0);
                    collection.getLock().release(0);
                }
                this.brokerPool.release(broker);
                return xml;
            }
            catch (Throwable throwable) {
                if (collection != null) {
                    collection.releaseDocument(doc, 0);
                    collection.getLock().release(0);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (doc.getContentLength() > 262144) {
            File tempFile = File.createTempFile("eXistRPCC", ".bin");
            tempFile.deleteOnExit();
            LOG.debug((Object)("Writing to temporary file: " + tempFile.getName()));
            FileOutputStream os = new FileOutputStream(tempFile);
            broker.readBinaryResource((BinaryDocument)doc, os);
            ((OutputStream)os).close();
            byte[] firstChunk = this.getChunk(tempFile, 0);
            result.put("data", firstChunk);
            result.put("handle", tempFile.getAbsolutePath());
            result.put("offset", new Integer(firstChunk.length));
        } else {
            byte[] data = broker.getBinaryResource((BinaryDocument)doc);
            result.put("data", data);
            result.put("offset", new Integer(0));
        }
        Hashtable<String, Object> hashtable = result;
        if (collection != null) {
            collection.releaseDocument(doc, 0);
            collection.getLock().release(0);
        }
        this.brokerPool.release(broker);
        return hashtable;
    }

    public Hashtable getNextChunk(User user, String handle, int offset) throws Exception {
        File file = new File(handle);
        if (!file.isFile() || !file.canRead()) {
            throw new EXistException("Invalid handle specified");
        }
        if (offset <= 0 || (long)offset > file.length()) {
            throw new EXistException("No more data available");
        }
        byte[] chunk = this.getChunk(file, offset);
        int nextChunk = offset + chunk.length;
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("data", chunk);
        result.put("handle", handle);
        if ((long)nextChunk == file.length()) {
            file.delete();
            result.put("offset", new Integer(0));
        } else {
            result.put("offset", new Integer(nextChunk));
        }
        return result;
    }

    private byte[] getChunk(File file, int offset) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        raf.seek(offset);
        int remaining = (int)(raf.length() - (long)offset);
        if (remaining > 262144) {
            remaining = 262144;
        }
        byte[] data = new byte[remaining];
        raf.readFully(data);
        raf.close();
        return data;
    }

    public byte[] getBinaryResource(User user, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getBinaryResource(user, XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(User user, XmldbURI name) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(name, 0);
            if (doc == null) {
                throw new EXistException("Resource " + name + " not found");
            }
            if (doc.getResourceType() != 1) {
                throw new EXistException("Document " + name + " is not a binary resource");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            byte[] byArray = broker.getBinaryResource((BinaryDocument)doc);
            return byArray;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public int xupdate(User user, String collectionName, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException, URISyntaxException {
        return this.xupdate(user, XmldbURI.xmldbUriFor(collectionName), xupdate);
    }

    public int xupdate(User user, XmldbURI collUri, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            Collection collection = broker.getCollection(collUri);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("collection " + collUri + " not found");
            }
            DocumentSet docs = collection.allDocs(broker, new DocumentSet(), true, true);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.XMLRPC);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public int xupdateResource(User user, String resource, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException, URISyntaxException {
        return this.xupdateResource(user, XmldbURI.xmldbUriFor(resource), xupdate);
    }

    public int xupdateResource(User user, XmldbURI docUri, String xupdate) throws SAXException, LockException, PermissionDeniedException, EXistException, XPathException {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            DocumentImpl doc = (DocumentImpl)broker.getXMLResource(docUri);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("document " + docUri + " not found");
            }
            if (!doc.getPermissions().validate(user, 4)) {
                transact.abort(transaction);
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            DocumentSet docs = new DocumentSet();
            docs.add(doc);
            XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.XMLRPC);
            Modification[] modifications = processor.parse(new InputSource(new StringReader(xupdate)));
            long mods = 0L;
            for (int i = 0; i < modifications.length; ++i) {
                mods += modifications[i].process(transaction);
                broker.flush();
            }
            transact.commit(transaction);
            int n = (int)mods;
            return n;
        }
        catch (ParserConfigurationException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new EXistException(e.getMessage());
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync() {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(XMLSecurityManager.SYSTEM_USER);
            broker.sync(1);
        }
        catch (EXistException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return true;
    }

    public boolean isXACMLEnabled() {
        return this.brokerPool.getSecurityManager().isXACMLEnabled();
    }

    public boolean dataBackup(User user, String dest) {
        this.brokerPool.triggerSystemTask(new DataBackup(dest));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user) throws EXistException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            DocumentSet docs = broker.getAllXMLResources(new DocumentSet());
            XmldbURI[] names = docs.getNames();
            Vector<String> vec = new Vector<String>();
            for (int i = 0; i < names.length; ++i) {
                vec.addElement(names[i].toString());
            }
            Vector<String> vector = vec;
            return vector;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public Vector getDocumentListing(User user, String collName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getDocumentListing(user, XmldbURI.xmldbUriFor(collName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocumentListing(User user, XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            Vector<String> vec = new Vector<String>();
            if (collection == null) {
                LOG.debug((Object)("collection " + collUri + " not found."));
                Vector<String> vector = vec;
                return vector;
            }
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                vec.addElement(((DocumentImpl)i.next()).getFileURI().toString());
            }
            Vector<String> vector = vec;
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public int getResourceCount(User user, String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getResourceCount(user, XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount(User user, XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            int n = collection.getDocumentCount();
            return n;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public String createResourceId(User user, String collectionName) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.createResourceId(user, XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createResourceId(User user, XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            XmldbURI id;
            boolean ok;
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id.toString();
            return string;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Hashtable listDocumentPermissions(User user, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listDocumentPermissions(user, XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listDocumentPermissions(User user, XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("Collection " + collUri + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + collUri);
            }
            Hashtable result = new Hashtable(collection.getDocumentCount());
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                Permission perm = doc.getPermissions();
                Vector<Object> tmp = new Vector<Object>(3);
                tmp.addElement(perm.getOwner());
                tmp.addElement(perm.getOwnerGroup());
                tmp.addElement(new Integer(perm.getPermissions()));
                result.put(doc.getFileURI().toString(), tmp);
            }
            Hashtable hashtable = result;
            return hashtable;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Hashtable listCollectionPermissions(User user, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.listCollectionPermissions(user, XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable listCollectionPermissions(User user, XmldbURI collUri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("Collection " + collUri + " not found");
            }
            if (!collection.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("not allowed to read collection " + collUri);
            }
            Hashtable result = new Hashtable(collection.getChildCollectionCount());
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI child = (XmldbURI)i.next();
                XmldbURI path = collUri.append(child);
                Collection childColl = broker.getCollection(path);
                Permission perm = childColl.getPermissions();
                Vector<Object> tmp = new Vector<Object>(3);
                tmp.addElement(perm.getOwner());
                tmp.addElement(perm.getOwnerGroup());
                tmp.addElement(new Integer(perm.getPermissions()));
                result.put(child, tmp);
            }
            Hashtable hashtable = result;
            return hashtable;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public int getHits(User user, int resultId) throws EXistException {
        QueryResult qr = this.connectionPool.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        if (qr.result == null) {
            return 0;
        }
        return qr.result.getItemCount();
    }

    public Hashtable getPermissions(User user, String name) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getPermissions(user, XmldbURI.xmldbUriFor(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getPermissions(User user, XmldbURI uri) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(uri, 0);
            Permission perm = null;
            if (collection == null) {
                DocumentImpl doc = null;
                try {
                    doc = broker.getXMLResource(uri, 0);
                    if (doc == null) {
                        throw new EXistException("document or collection " + uri + " not found");
                    }
                    perm = doc.getPermissions();
                }
                finally {
                    if (doc != null) {
                        doc.getUpdateLock().release(0);
                    }
                }
            } else {
                perm = collection.getPermissions();
            }
            Hashtable<String, Object> result = new Hashtable<String, Object>();
            result.put("owner", perm.getOwner());
            result.put("group", perm.getOwnerGroup());
            result.put("permissions", new Integer(perm.getPermissions()));
            Hashtable<String, Object> hashtable = result;
            return hashtable;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Date getCreationDate(User user, String collectionPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getCreationDate(user, XmldbURI.xmldbUriFor(collectionPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreationDate(User user, XmldbURI collUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            Date date = new Date(collection.getCreationTime());
            return date;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Vector getTimestamps(User user, String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getTimestamps(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getTimestamps(User user, XmldbURI docUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + docUri + " not found!"));
                throw new EXistException("document not found");
            }
            DocumentMetadata metadata = doc.getMetadata();
            Vector<Date> vector = new Vector<Date>(2);
            vector.addElement(new Date(metadata.getCreated()));
            vector.addElement(new Date(metadata.getLastModified()));
            Vector<Date> vector2 = vector;
            return vector2;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Hashtable getUser(User user, String name) throws EXistException, PermissionDeniedException {
        User u = this.brokerPool.getSecurityManager().getUser(name);
        if (u == null) {
            throw new EXistException("user " + name + " does not exist");
        }
        Hashtable<String, Object> tab = new Hashtable<String, Object>();
        tab.put("name", u.getName());
        Vector<String> groups = new Vector<String>();
        String[] gl = u.getGroups();
        for (int i = 0; i < gl.length; ++i) {
            groups.addElement(gl[i]);
        }
        tab.put("groups", groups);
        if (u.getHome() != null) {
            tab.put("home", u.getHome().toString());
        }
        return tab;
    }

    public Vector getUsers(User user) throws EXistException, PermissionDeniedException {
        User[] users = this.brokerPool.getSecurityManager().getUsers();
        Vector r = new Vector();
        for (int i = 0; i < users.length; ++i) {
            Hashtable<String, Object> tab = new Hashtable<String, Object>();
            tab.put("name", users[i].getName());
            Vector<String> groups = new Vector<String>();
            String[] gl = users[i].getGroups();
            for (int j = 0; j < gl.length; ++j) {
                groups.addElement(gl[j]);
            }
            tab.put("groups", groups);
            if (users[i].getHome() != null) {
                tab.put("home", users[i].getHome().toString());
            }
            r.addElement(tab);
        }
        return r;
    }

    public Vector getGroups(User user) throws EXistException, PermissionDeniedException {
        String[] groups = this.brokerPool.getSecurityManager().getGroups();
        Vector<String> v = new Vector<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            v.addElement(groups[i]);
        }
        return v;
    }

    public boolean hasDocument(User user, String documentPath) throws Exception, URISyntaxException {
        return this.hasDocument(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDocument(User user, XmldbURI docUri) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            boolean bl = broker.getXMLResource(docUri) != null;
            return bl;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public boolean hasCollection(User user, String collectionName) throws Exception, URISyntaxException {
        return this.hasCollection(user, XmldbURI.xmldbUriFor(collectionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCollection(User user, XmldbURI collUri) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            boolean bl = broker.getCollection(collUri) != null;
            return bl;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public boolean parse(User user, byte[] xml, String documentPath, boolean replace) throws Exception, URISyntaxException {
        return this.parse(user, xml, documentPath, replace, null, null);
    }

    public boolean parse(User user, byte[] xml, XmldbURI docUri, boolean replace) throws Exception {
        return this.parse(user, xml, docUri, replace, null, null);
    }

    public boolean parse(User user, byte[] xml, String documentPath, boolean replace, Date created, Date modified) throws Exception, URISyntaxException {
        return this.parse(user, xml, XmldbURI.xmldbUriFor(documentPath), replace, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(User user, byte[] xml, XmldbURI docUri, boolean replace, Date created, Date modified) throws Exception {
        DBBroker broker = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            long startTime = System.currentTimeMillis();
            broker = this.brokerPool.get(user);
            IndexInfo info = null;
            InputSource source = null;
            Collection collection = null;
            try {
                DocumentImpl old;
                collection = broker.openCollection(docUri.removeLastSegment(), 1);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
                }
                if (!replace && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                    transact.abort(transaction);
                    throw new PermissionDeniedException("Document exists and overwrite is not allowed");
                }
                ByteArrayInputStream is = new ByteArrayInputStream(xml);
                source = new InputSource(is);
                info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                if (created != null) {
                    info.getDocument().getMetadata().setCreated(created.getTime());
                }
                if (modified != null) {
                    info.getDocument().getMetadata().setLastModified(modified.getTime());
                }
            }
            finally {
                if (collection != null) {
                    collection.release(1);
                }
            }
            collection.store(transaction, broker, info, source, false);
            transact.commit(transaction);
            LOG.debug((Object)("parsing " + docUri + " took " + (System.currentTimeMillis() - startTime) + "ms."));
            this.documentCache.clear();
            boolean bl = true;
            this.brokerPool.release(broker);
            return bl;
        }
        catch (Exception e) {
            try {
                transact.abort(transaction);
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public boolean parseLocal(User user, String localFile, String documentPath, boolean replace, String mimeType) throws Exception, URISyntaxException {
        return this.parseLocal(user, localFile, documentPath, replace, mimeType, null, null);
    }

    public boolean parseLocal(User user, String localFile, XmldbURI docUri, boolean replace, String mimeType) throws Exception {
        return this.parseLocal(user, localFile, docUri, replace, mimeType, null, null);
    }

    public boolean parseLocal(User user, String localFile, String documentPath, boolean replace, String mimeType, Date created, Date modified) throws Exception, URISyntaxException {
        return this.parseLocal(user, localFile, XmldbURI.xmldbUriFor(documentPath), replace, mimeType, created, modified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseLocal(User user, String localFile, XmldbURI docUri, boolean replace, String mimeType, Date created, Date modified) throws Exception {
        File file = new File(localFile);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + localFile);
        }
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        BinaryDocument doc = null;
        MimeType mime = MimeTable.getInstance().getContentType(mimeType);
        if (mime == null) {
            mime = MimeType.BINARY_TYPE;
        }
        try {
            broker = this.brokerPool.get(user);
            Collection collection = null;
            IndexInfo info = null;
            InputSource source = null;
            try {
                DocumentImpl old;
                collection = broker.openCollection(docUri.removeLastSegment(), 1);
                if (collection == null) {
                    transact.abort(transaction);
                    throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
                }
                if (!replace && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                    transact.abort(transaction);
                    throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
                }
                if (mime.isXMLType()) {
                    source = new InputSource(file.toURI().toASCIIString());
                    info = collection.validateXMLResource(transaction, broker, docUri.lastSegment(), source);
                    if (created != null) {
                        info.getDocument().getMetadata().setCreated(created.getTime());
                    }
                    if (modified != null) {
                        info.getDocument().getMetadata().setLastModified(modified.getTime());
                    }
                } else {
                    FileInputStream is = new FileInputStream(file);
                    doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), is, mime.getName(), (int)file.length());
                    is.close();
                    if (created != null) {
                        doc.getMetadata().setCreated(created.getTime());
                    }
                    if (modified != null) {
                        doc.getMetadata().setLastModified(modified.getTime());
                    }
                }
            }
            finally {
                if (collection != null) {
                    collection.release(1);
                }
            }
            if (mime.isXMLType()) {
                collection.store(transaction, broker, info, source, false);
            }
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
        file.delete();
        this.documentCache.clear();
        return true;
    }

    public boolean storeBinary(User user, byte[] data, String documentPath, String mimeType, boolean replace) throws Exception, URISyntaxException {
        return this.storeBinary(user, data, documentPath, mimeType, replace, null, null);
    }

    public boolean storeBinary(User user, byte[] data, XmldbURI docUri, String mimeType, boolean replace) throws Exception {
        return this.storeBinary(user, data, docUri, mimeType, replace, null, null);
    }

    public boolean storeBinary(User user, byte[] data, String documentPath, String mimeType, boolean replace, Date created, Date modified) throws Exception, URISyntaxException {
        return this.storeBinary(user, data, XmldbURI.xmldbUriFor(documentPath), mimeType, replace, created, modified);
    }

    public boolean storeBinary(User user, byte[] data, XmldbURI docUri, String mimeType, boolean replace, Date created, Date modified) throws Exception {
        DBBroker broker = null;
        BinaryDocument doc = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            DocumentImpl old;
            broker = this.brokerPool.get(user);
            Collection collection = broker.openCollection(docUri.removeLastSegment(), 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            transaction.registerLock(collection.getLock(), 1);
            if (!replace && (old = collection.getDocument(broker, docUri.lastSegment())) != null) {
                transact.abort(transaction);
                throw new PermissionDeniedException("Old document exists and overwrite is not allowed");
            }
            LOG.debug((Object)("Storing binary resource to collection " + collection.getURI()));
            doc = collection.addBinaryResource(transaction, broker, docUri.lastSegment(), data, mimeType);
            if (created != null) {
                doc.getMetadata().setCreated(created.getTime());
            }
            if (modified != null) {
                doc.getMetadata().setLastModified(modified.getTime());
            }
            transact.commit(transaction);
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
        this.documentCache.clear();
        return doc != null;
    }

    public String upload(User user, byte[] chunk, int length, String fileName, boolean compressed) throws EXistException, IOException {
        File file;
        if (fileName == null || fileName.length() == 0) {
            file = File.createTempFile("rpc", ".xml");
            fileName = file.getAbsolutePath();
            LOG.debug((Object)("created temporary file " + file.getAbsolutePath()));
        } else {
            file = new File(fileName);
        }
        if (!file.canWrite()) {
            throw new EXistException("cannot write to file " + fileName);
        }
        FileOutputStream os = new FileOutputStream(file, true);
        if (compressed) {
            Compressor.uncompress(chunk, os);
        } else {
            os.write(chunk, 0, length);
        }
        os.close();
        return fileName;
    }

    protected String printAll(DBBroker broker, Sequence resultSet, int howmany, int start, Hashtable properties, long queryTime) throws Exception {
        if (resultSet.isEmpty()) {
            return "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
        }
        if (howmany > resultSet.getItemCount() || howmany == 0) {
            howmany = resultSet.getItemCount();
        }
        if (start < 1 || start > resultSet.getItemCount()) {
            throw new EXistException("start parameter out of range");
        }
        StringWriter writer = new StringWriter();
        writer.write("<exist:result xmlns:exist=\"");
        writer.write("http://exist.sourceforge.net/NS/exist");
        writer.write("\" hits=\"");
        writer.write(Integer.toString(resultSet.getItemCount()));
        writer.write("\" start=\"");
        writer.write(Integer.toString(start));
        writer.write("\" count=\"");
        writer.write(Integer.toString(howmany));
        writer.write("\">\n");
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        serializer.setProperties(properties);
        for (int i = --start; i < start + howmany; ++i) {
            Item item = resultSet.itemAt(i);
            if (item == null) continue;
            if (item.getType() == 1) {
                NodeValue node = (NodeValue)item;
                writer.write(serializer.serialize(node));
                continue;
            }
            writer.write("<exist:value type=\"");
            writer.write(Type.getTypeName(item.getType()));
            writer.write("\">");
            writer.write(item.getStringValue());
            writer.write("</exist:value>");
        }
        writer.write("\n</exist:result>");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable compile(User user, String query, Hashtable parameters) throws Exception {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        DBBroker broker = null;
        XQueryPool pool = null;
        CompiledXQuery compiled = null;
        StringSource source = new StringSource(query);
        try {
            broker = this.brokerPool.get(user);
            XQuery xquery = broker.getXQueryService();
            pool = xquery.getXQueryPool();
            compiled = this.compile(user, broker, source, parameters);
            this.brokerPool.release(broker);
            if (compiled != null && pool != null) {
                pool.returnCompiledXQuery(source, compiled);
            }
        }
        catch (XPathException e) {
            try {
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                this.brokerPool.release(broker);
                if (compiled != null && pool != null) {
                    pool.returnCompiledXQuery(source, compiled);
                }
            }
            catch (Throwable throwable) {
                this.brokerPool.release(broker);
                if (compiled != null && pool != null) {
                    pool.returnCompiledXQuery(source, compiled);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(User user, String xpath, int howmany, int start, Hashtable parameters) throws Exception {
        String result;
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = this.doQuery(user, broker, xpath, null, parameters);
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            if (qr == null) {
                String string = "<?xml version=\"1.0\"?>\n<exist:result xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" hitCount=\"0\"/>";
                return string;
            }
            result = this.printAll(broker, qr.result, howmany, start, parameters, System.currentTimeMillis() - startTime);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return result;
    }

    public Hashtable queryP(User user, String xpath, String documentPath, String s_id, Hashtable parameters) throws Exception, URISyntaxException {
        return this.queryP(user, xpath, documentPath == null ? null : XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable queryP(User user, String xpath, XmldbURI docUri, String s_id, Hashtable parameters) throws Exception {
        QueryResult queryResult;
        long startTime = System.currentTimeMillis();
        String sortBy = (String)parameters.get("sort-expr");
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        Vector<Object> result = new Vector<Object>();
        ExtArrayNodeSet nodes = null;
        Sequence resultSeq = null;
        DBBroker broker = null;
        try {
            Cloneable docs;
            Object doc;
            broker = this.brokerPool.get(user);
            if (docUri != null && s_id != null) {
                if (!this.documentCache.containsKey(docUri)) {
                    doc = (DocumentImpl)broker.getXMLResource(docUri);
                    this.documentCache.put(docUri, doc);
                } else {
                    doc = (DocumentImpl)this.documentCache.get(docUri);
                }
                docs = new Vector<String>(1);
                docs.addElement(docUri.toString());
                parameters.put("static-documents", docs);
                if (s_id.length() > 0) {
                    NodeId nodeId = this.brokerPool.getNodeFactory().createFromString(s_id);
                    NodeProxy node = new NodeProxy((DocumentImpl)doc, nodeId);
                    nodes = new ExtArrayNodeSet(1);
                    nodes.add(node);
                }
            }
            if ((queryResult = this.doQuery(user, broker, xpath, nodes, parameters)) == null) {
                doc = ret;
                return doc;
            }
            if (queryResult.hasErrors()) {
                XPathException e = queryResult.getException();
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                docs = ret;
                return docs;
            }
            resultSeq = queryResult.result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + resultSeq.getItemCount()));
            }
            if (sortBy != null) {
                SortedNodeSet sorted = new SortedNodeSet(this.brokerPool, user, sortBy, AccessContext.XMLRPC);
                sorted.addAll(resultSeq);
                resultSeq = sorted;
            }
            if (resultSeq != null) {
                SequenceIterator i = resultSeq.iterate();
                if (i != null) {
                    while (i.hasNext()) {
                        Item next = i.nextItem();
                        if (Type.subTypeOf(next.getType(), -1)) {
                            Vector<String> entry = new Vector<String>();
                            if (((NodeValue)next).getImplementationType() == 1) {
                                NodeProxy p = (NodeProxy)next;
                                entry.addElement(p.getDocument().getURI().toString());
                                entry.addElement(p.getNodeId().toString());
                            } else {
                                entry.addElement("temp_xquery/" + next.hashCode());
                                entry.addElement(String.valueOf(((NodeImpl)next).getNodeNumber()));
                            }
                            result.addElement(entry);
                            continue;
                        }
                        result.addElement(next.getStringValue());
                    }
                } else {
                    LOG.debug((Object)"sequence iterator is null. Should not");
                }
            } else {
                LOG.debug((Object)"result sequence is null. Skipping it...");
            }
        }
        finally {
            this.brokerPool.release(broker);
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.connectionPool.resultSets.add(queryResult);
        ret.put("id", new Integer(id));
        ret.put("results", result);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable execute(User user, String xpath, Hashtable parameters) throws Exception {
        QueryResult queryResult;
        long startTime = System.currentTimeMillis();
        String sortBy = (String)parameters.get("sort-expr");
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        Vector<Object> result = new Vector<Object>();
        NodeSet nodes = null;
        Sequence resultSeq = null;
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            queryResult = this.doQuery(user, broker, xpath, nodes, parameters);
            if (queryResult == null) {
                Hashtable<String, Object> hashtable = ret;
                return hashtable;
            }
            if (queryResult.hasErrors()) {
                XPathException e = queryResult.getException();
                ret.put("error", e.getMessage());
                if (e.getLine() != 0) {
                    ret.put("line", new Integer(e.getLine()));
                    ret.put("column", new Integer(e.getColumn()));
                }
                Hashtable<String, Object> hashtable = ret;
                return hashtable;
            }
            resultSeq = queryResult.result;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("found " + resultSeq.getItemCount()));
            }
            if (sortBy != null) {
                SortedNodeSet sorted = new SortedNodeSet(this.brokerPool, user, sortBy, AccessContext.XMLRPC);
                sorted.addAll(resultSeq);
                resultSeq = sorted;
            }
            if (resultSeq != null) {
                SequenceIterator i = resultSeq.iterate();
                if (i != null) {
                    while (i.hasNext()) {
                        Item next = i.nextItem();
                        if (Type.subTypeOf(next.getType(), -1)) {
                            Vector<String> entry = new Vector<String>();
                            if (((NodeValue)next).getImplementationType() == 1) {
                                NodeProxy p = (NodeProxy)next;
                                entry.addElement(p.getDocument().getURI().toString());
                                entry.addElement(p.getNodeId().toString());
                            } else {
                                entry.addElement("temp_xquery/" + next.hashCode());
                                entry.addElement(String.valueOf(((NodeImpl)next).getNodeNumber()));
                            }
                            result.addElement(entry);
                            continue;
                        }
                        result.addElement(next.getStringValue());
                    }
                } else {
                    LOG.debug((Object)"sequence iterator is null. Should not");
                }
            } else {
                LOG.debug((Object)"result sequence is null. Skipping it...");
            }
        }
        finally {
            this.brokerPool.release(broker);
        }
        queryResult.result = resultSeq;
        queryResult.queryTime = System.currentTimeMillis() - startTime;
        int id = this.connectionPool.resultSets.add(queryResult);
        ret.put("id", new Integer(id));
        ret.put("results", result);
        return ret;
    }

    public void releaseQueryResult(int handle) {
        this.connectionPool.resultSets.remove(handle);
        this.documentCache.clear();
        LOG.debug((Object)("removed query result with handle " + handle));
    }

    public void remove(User user, String documentPath) throws Exception, URISyntaxException {
        this.remove(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(User user, XmldbURI docUri) throws Exception {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(docUri.removeLastSegment(), 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            transaction.registerLock(collection.getLock(), 1);
            DocumentImpl doc = collection.getDocument(broker, docUri.lastSegment());
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("Document " + docUri + " not found");
            }
            if (doc.getResourceType() == 1) {
                collection.removeBinaryResource(transaction, broker, doc);
            } else {
                collection.removeXMLResource(transaction, broker, docUri.lastSegment());
            }
            transact.commit(transaction);
            this.documentCache.clear();
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public boolean removeCollection(User user, String collectionName) throws Exception, URISyntaxException {
        return this.removeCollection(user, XmldbURI.xmldbUriFor(collectionName));
    }

    public boolean removeCollection(User user, XmldbURI collURI) throws Exception {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collURI, 1);
            if (collection == null) {
                transact.abort(transaction);
                boolean bl = false;
                return bl;
            }
            transaction.registerLock(collection.getLock(), 1);
            LOG.debug((Object)("removing collection " + collURI));
            this.documentCache.clear();
            boolean removed = broker.removeCollection(transaction, collection);
            transact.commit(transaction);
            boolean bl = removed;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public boolean removeUser(User user, String name) throws EXistException, PermissionDeniedException {
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (!manager.hasAdminPrivileges(user)) {
            throw new PermissionDeniedException("you are not allowed to remove users");
        }
        manager.deleteUser(name);
        return true;
    }

    public String retrieve(User user, String documentPath, String s_id, Hashtable parameters) throws Exception, URISyntaxException {
        return this.retrieve(user, XmldbURI.xmldbUriFor(documentPath), s_id, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve(User user, XmldbURI docUri, String s_id, Hashtable parameters) throws Exception {
        DBBroker broker = this.brokerPool.get(user);
        try {
            DocumentImpl doc;
            NodeId nodeId = this.brokerPool.getNodeFactory().createFromString(s_id);
            if (!this.documentCache.containsKey(docUri)) {
                LOG.debug((Object)("loading doc " + docUri));
                doc = (DocumentImpl)broker.getXMLResource(docUri);
                this.documentCache.put(docUri, doc);
            } else {
                doc = (DocumentImpl)this.documentCache.get(docUri);
            }
            NodeProxy node = new NodeProxy(doc, nodeId);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            String string = serializer.serialize(node);
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve(User user, int resultId, int num, Hashtable parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = this.connectionPool.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            Item item = qr.result.itemAt(num);
            if (item == null) {
                throw new EXistException("index out of range");
            }
            if (Type.subTypeOf(item.getType(), -1)) {
                NodeValue nodeValue = (NodeValue)item;
                Serializer serializer = broker.getSerializer();
                serializer.reset();
                this.checkPragmas(qr.context, parameters);
                serializer.setProperties(parameters);
                String string = serializer.serialize(nodeValue);
                return string;
            }
            String string = item.getStringValue();
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveAll(User user, int resultId, Hashtable parameters) throws Exception {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            QueryResult qr = this.connectionPool.resultSets.get(resultId);
            if (qr == null) {
                throw new EXistException("result set unknown or timed out");
            }
            qr.timestamp = System.currentTimeMillis();
            this.checkPragmas(qr.context, parameters);
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            serializer.setProperties(parameters);
            SAXSerializer handler = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            StringWriter writer = new StringWriter();
            handler.setOutput(writer, this.getProperties(parameters));
            handler.startDocument();
            handler.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "hitCount", "hitCount", "CDATA", Integer.toString(qr.result.getItemCount()));
            handler.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attribs);
            SequenceIterator i = qr.result.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                if (Type.subTypeOf(current.getType(), -1)) {
                    ((NodeValue)current).toSAX(broker, handler, null);
                    continue;
                }
                char[] value = current.toString().toCharArray();
                handler.characters(value, 0, value.length);
            }
            handler.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            handler.endPrefixMapping("exist");
            handler.endDocument();
            SerializerPool.getInstance().returnObject(handler);
            String string = writer.toString();
            return string;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RpcConnection rpcConnection = this;
        synchronized (rpcConnection) {
            while (!this.terminate) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(user, XmldbURI.xmldbUriFor(resource), owner, ownerGroup, permissions);
    }

    public boolean setPermissions(User user, XmldbURI uri, String owner, String ownerGroup, String permissions) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            SecurityManager manager = this.brokerPool.getSecurityManager();
            collection = broker.openCollection(uri, 1);
            if (collection == null) {
                doc = broker.getXMLResource(uri, 1);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new EXistException("document or collection " + uri + " not found");
                }
                LOG.debug((Object)("changing permissions on document " + uri));
                Permission perm = doc.getPermissions();
                if (perm.validate(user, 2) || manager.hasAdminPrivileges(user)) {
                    if (owner != null) {
                        if (!perm.getOwner().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                            throw new PermissionDeniedException("not allowed to change permissions");
                        }
                        perm.setOwner(owner);
                        if (!manager.hasGroup(ownerGroup)) {
                            manager.addGroup(ownerGroup);
                        }
                        perm.setGroup(ownerGroup);
                    }
                    if (permissions != null && permissions.length() > 0) {
                        perm.setPermissions(permissions);
                    }
                    broker.storeXMLResource(transaction, doc);
                    transact.commit(transaction);
                    broker.flush();
                    boolean bl = true;
                    return bl;
                }
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            transaction.registerLock(collection.getLock(), 1);
            LOG.debug((Object)("changing permissions on collection " + uri));
            Permission perm = collection.getPermissions();
            if (perm.validate(user, 2) || manager.hasAdminPrivileges(user)) {
                if (permissions != null) {
                    perm.setPermissions(permissions);
                }
                if (owner != null) {
                    if (!perm.getOwner().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                        throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    perm.setOwner(owner);
                    if (!manager.hasGroup(ownerGroup)) {
                        manager.addGroup(ownerGroup);
                    }
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(transaction, collection);
                transact.commit(transaction);
                broker.flush();
                boolean bl = true;
                return bl;
            }
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            catch (SyntaxException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (PermissionDeniedException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public boolean setPermissions(User user, String resource, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.setPermissions(user, XmldbURI.xmldbUriFor(resource), owner, ownerGroup, permissions);
    }

    public boolean setPermissions(User user, XmldbURI uri, String owner, String ownerGroup, int permissions) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            SecurityManager manager = this.brokerPool.getSecurityManager();
            collection = broker.openCollection(uri, 1);
            if (collection == null) {
                doc = broker.getXMLResource(uri, 1);
                if (doc == null) {
                    transact.abort(transaction);
                    throw new EXistException("document or collection " + uri + " not found");
                }
                LOG.debug((Object)("changing permissions on document " + uri));
                Permission perm = doc.getPermissions();
                if (perm.validate(user, 2) || manager.hasAdminPrivileges(user)) {
                    if (owner != null) {
                        if (!perm.getOwner().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                            throw new PermissionDeniedException("not allowed to change permissions");
                        }
                        perm.setOwner(owner);
                        if (!manager.hasGroup(ownerGroup)) {
                            manager.addGroup(ownerGroup);
                        }
                        perm.setGroup(ownerGroup);
                    }
                    perm.setPermissions(permissions);
                    broker.storeXMLResource(transaction, doc);
                    transact.commit(transaction);
                    broker.flush();
                    boolean bl = true;
                    return bl;
                }
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            transaction.registerLock(collection.getLock(), 1);
            LOG.debug((Object)("changing permissions on collection " + uri));
            Permission perm = collection.getPermissions();
            if (perm.validate(user, 2) || manager.hasAdminPrivileges(user)) {
                perm.setPermissions(permissions);
                if (owner != null) {
                    if (!perm.getOwner().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                        throw new PermissionDeniedException("not allowed to change permissions");
                    }
                    perm.setOwner(owner);
                    if (!manager.hasGroup(ownerGroup)) {
                        manager.addGroup(ownerGroup);
                    }
                    perm.setGroup(ownerGroup);
                }
                broker.saveCollection(transaction, collection);
                transact.commit(transaction);
                broker.flush();
                boolean bl = true;
                return bl;
            }
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("not allowed to change permissions");
            }
            catch (PermissionDeniedException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new EXistException(e.getMessage());
            }
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public boolean setUser(User user, String name, String passwd, String passwdDigest, Vector groups, String home) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager;
        if (passwd.length() == 0) {
            passwd = null;
        }
        if (!(manager = this.brokerPool.getSecurityManager()).hasUser(name)) {
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
            u.setEncodedPassword(passwd);
            u.setPasswordDigest(passwdDigest);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
            u.setEncodedPassword(passwd);
            u.setPasswordDigest(passwdDigest);
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (u.hasGroup(g)) continue;
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User is not allowed to add groups");
            }
            u.addGroup(g);
        }
        if (home != null) {
            try {
                u.setHome(XmldbURI.xmldbUriFor(home));
            }
            catch (URISyntaxException e) {
                throw new EXistException("Invalid home URI", e);
            }
        }
        manager.setUser(u);
        return true;
    }

    public boolean setUser(User user, String name, Vector groups) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (u.hasGroup(g)) continue;
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User is not allowed to add groups");
            }
            u.addGroup(g);
        }
        manager.setUser(u);
        return true;
    }

    public boolean setUser(User user, String name, Vector groups, String rgroup) throws EXistException, PermissionDeniedException {
        User u;
        SecurityManager manager = this.brokerPool.getSecurityManager();
        if (!manager.hasUser(name)) {
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("not allowed to create user");
            }
            u = new User(name);
        } else {
            u = manager.getUser(name);
            if (!u.getName().equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("you are not allowed to change this user");
            }
        }
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            String g = (String)i.next();
            if (!g.equals(rgroup)) continue;
            if (!manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User is not allowed to remove groups");
            }
            u.remGroup(g);
        }
        manager.setUser(u);
        return true;
    }

    public boolean lockResource(User user, String documentPath, String userName) throws Exception, URISyntaxException {
        return this.lockResource(user, XmldbURI.xmldbUriFor(documentPath), userName);
    }

    public boolean lockResource(User user, XmldbURI docURI, String userName) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docURI, 1);
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.brokerPool.getSecurityManager();
            if (!userName.equals(user.getName()) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("User " + user.getName() + " is not allowed " + "to lock the resource for user " + userName);
            }
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            doc.setUserLock(user);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw e;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public String hasUserLock(User user, String documentPath) throws Exception, URISyntaxException {
        return this.hasUserLock(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hasUserLock(User user, XmldbURI docURI) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docURI, 0);
            if (!doc.getPermissions().validate(user, 4)) {
                throw new PermissionDeniedException("Insufficient privileges to read resource");
            }
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            User u = doc.getUserLock();
            String string = u == null ? "" : u.getName();
            return string;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public boolean unlockResource(User user, String documentPath) throws Exception, URISyntaxException {
        return this.unlockResource(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockResource(User user, XmldbURI docURI) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docURI, 1);
            if (doc == null) {
                throw new EXistException("Resource " + docURI + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                throw new PermissionDeniedException("User is not allowed to lock resource " + docURI);
            }
            SecurityManager manager = this.brokerPool.getSecurityManager();
            User lockOwner = doc.getUserLock();
            if (lockOwner != null && !lockOwner.equals(user) && !manager.hasAdminPrivileges(user)) {
                throw new PermissionDeniedException("Resource is already locked by user " + lockOwner.getName());
            }
            TransactionManager transact = this.brokerPool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            doc.setUserLock(null);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable summary(User user, String xpath) throws Exception {
        long startTime = System.currentTimeMillis();
        DBBroker broker = null;
        try {
            NodeCount counter;
            broker = this.brokerPool.get(user);
            QueryResult qr = this.doQuery(user, broker, xpath, null, null);
            if (qr == null) {
                Hashtable hashtable = new Hashtable();
                return hashtable;
            }
            if (qr.hasErrors()) {
                throw qr.getException();
            }
            NodeList resultSet = (NodeList)((Object)qr.result);
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            NodeSetIterator i = ((NodeSet)resultSet).iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDocument().getURI().toString();
                DocumentType doctype = p.getDocument().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDocument());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
            result.put("queryTime", new Integer((int)(System.currentTimeMillis() - startTime)));
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileURI().toString());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            Hashtable<String, Serializable> hashtable = result;
            return hashtable;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable summary(User user, int resultId) throws EXistException, XPathException {
        QueryResult qr = this.connectionPool.resultSets.get(resultId);
        if (qr == null) {
            throw new EXistException("result set unknown or timed out");
        }
        qr.timestamp = System.currentTimeMillis();
        Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
        result.put("queryTime", new Integer((int)qr.queryTime));
        if (qr.result == null) {
            result.put("hits", new Integer(0));
            return result;
        }
        DBBroker broker = this.brokerPool.get(user);
        try {
            NodeCount counter;
            NodeSet resultSet = qr.result.toNodeSet();
            HashMap<String, NodeCount> map = new HashMap<String, NodeCount>();
            HashMap<String, DoctypeCount> doctypes = new HashMap<String, DoctypeCount>();
            NodeSetIterator i = resultSet.iterator();
            while (i.hasNext()) {
                DoctypeCount doctypeCounter;
                NodeProxy p = (NodeProxy)i.next();
                String docName = p.getDocument().getURI().toString();
                DocumentType doctype = p.getDocument().getDoctype();
                if (map.containsKey(docName)) {
                    counter = (NodeCount)map.get(docName);
                    counter.inc();
                } else {
                    counter = new NodeCount(p.getDocument());
                    map.put(docName, counter);
                }
                if (doctype == null) continue;
                if (doctypes.containsKey(doctype.getName())) {
                    doctypeCounter = (DoctypeCount)doctypes.get(doctype.getName());
                    doctypeCounter.inc();
                    continue;
                }
                doctypeCounter = new DoctypeCount(doctype);
                doctypes.put(doctype.getName(), doctypeCounter);
            }
            result.put("hits", new Integer(resultSet.getLength()));
            Vector documents = new Vector();
            Iterator i2 = map.values().iterator();
            while (i2.hasNext()) {
                counter = (NodeCount)i2.next();
                Vector<Object> hitsByDoc = new Vector<Object>();
                hitsByDoc.addElement(counter.doc.getFileURI().toString());
                hitsByDoc.addElement(new Integer(counter.doc.getDocId()));
                hitsByDoc.addElement(new Integer(counter.count));
                documents.addElement(hitsByDoc);
            }
            result.put("documents", documents);
            Vector dtypes = new Vector();
            Iterator i3 = doctypes.values().iterator();
            while (i3.hasNext()) {
                DoctypeCount docTemp = (DoctypeCount)i3.next();
                Vector<Object> hitsByType = new Vector<Object>();
                hitsByType.addElement(docTemp.doctype.getName());
                hitsByType.addElement(new Integer(docTemp.count));
                dtypes.addElement(hitsByType);
            }
            result.put("doctypes", dtypes);
            Hashtable<String, Serializable> hashtable = result;
            return hashtable;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public Vector getIndexedElements(User user, String collectionName, boolean inclusive) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.getIndexedElements(user, XmldbURI.xmldbUriFor(collectionName), inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getIndexedElements(User user, XmldbURI collUri, boolean inclusive) throws EXistException, PermissionDeniedException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            Occurrences[] occurrences = broker.getElementIndex().scanIndexedElements(collection, inclusive);
            Vector result = new Vector(occurrences.length);
            for (int i = 0; i < occurrences.length; ++i) {
                QName qname = (QName)occurrences[i].getTerm();
                Vector<Object> temp = new Vector<Object>(4);
                temp.addElement(qname.getLocalName());
                temp.addElement(qname.getNamespaceURI());
                temp.addElement(qname.getPrefix() == null ? "" : qname.getPrefix());
                temp.addElement(new Integer(occurrences[i].getOccurrences()));
                result.addElement(temp);
            }
            Vector vector = result;
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public Vector scanIndexTerms(User user, String collectionName, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.scanIndexTerms(user, XmldbURI.xmldbUriFor(collectionName), start, end, inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector scanIndexTerms(User user, XmldbURI collUri, String start, String end, boolean inclusive) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            Vector result;
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, 0);
            if (collection == null) {
                throw new EXistException("collection " + collUri + " not found");
            }
            DocumentSet docs = new DocumentSet();
            collection.allDocs(broker, docs, inclusive, true);
            NodeSet nodes = docs.toNodeSet();
            Vector vector = result = this.scanIndexTerms(start, end, broker, docs, nodes);
            return vector;
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector scanIndexTerms(User user, String xpath, String start, String end) throws PermissionDeniedException, EXistException, XPathException {
        DBBroker broker = null;
        try {
            Vector result;
            broker = this.brokerPool.get(user);
            XQuery xquery = broker.getXQueryService();
            Sequence nodes = xquery.execute(xpath, null, AccessContext.XMLRPC);
            Vector vector = result = this.scanIndexTerms(start, end, broker, nodes.getDocumentSet(), nodes.toNodeSet());
            return vector;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    private Vector scanIndexTerms(String start, String end, DBBroker broker, DocumentSet docs, NodeSet nodes) throws PermissionDeniedException {
        Occurrences[] occurrences = broker.getTextEngine().scanIndexTerms(docs, nodes, start, end);
        Vector result = new Vector(occurrences.length);
        for (int i = 0; i < occurrences.length; ++i) {
            Vector<Object> temp = new Vector<Object>(2);
            temp.addElement(occurrences[i].getTerm().toString());
            temp.addElement(new Integer(occurrences[i].getOccurrences()));
            result.addElement(temp);
        }
        return result;
    }

    public void synchronize() {
        this.documentCache.clear();
    }

    public void terminate() {
        this.terminate = true;
    }

    private Properties getProperties(Hashtable parameters) {
        Properties properties = new Properties();
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            properties.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
        return properties;
    }

    public byte[] getDocumentChunk(User user, String name, int start, int len) throws EXistException, PermissionDeniedException, IOException {
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + name);
        if (!file.canRead()) {
            throw new EXistException("unable to read file " + name);
        }
        if (file.length() < (long)(start + len)) {
            throw new EXistException("address too big " + name);
        }
        byte[] buffer = new byte[len];
        RandomAccessFile os = new RandomAccessFile(file.getAbsolutePath(), "r");
        LOG.debug((Object)("Read from: " + start + " to: " + (start + len)));
        os.seek(start);
        os.read(buffer);
        os.close();
        return buffer;
    }

    public boolean moveOrCopyResource(User user, String documentPath, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyResource(user, XmldbURI.xmldbUriFor(documentPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveOrCopyResource(User user, XmldbURI docUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(docUri.removeLastSegment(), move ? 1 : 0);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + docUri.removeLastSegment() + " not found");
            }
            doc = collection.getDocumentWithLock(broker, docUri.lastSegment(), 1);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("Document " + docUri + " not found");
            }
            destination = broker.openCollection(destUri, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new EXistException("Destination collection " + destUri + " not found");
            }
            if (move) {
                broker.moveXMLResource(transaction, doc, destination, newName);
            } else {
                broker.copyXMLResource(transaction, doc, destination, newName);
            }
            transact.commit(transaction);
            this.documentCache.clear();
            boolean bl = true;
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            if (collection != null) {
                collection.release(move ? 1 : 0);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException("Could not acquire lock on document " + docUri);
                catch (IOException e2) {
                    transact.abort(transaction);
                    throw new EXistException("Could not acquire lock on document " + docUri);
                }
            }
            catch (Throwable throwable) {
                if (doc != null) {
                    doc.getUpdateLock().release(1);
                }
                if (collection != null) {
                    collection.release(move ? 1 : 0);
                }
                if (destination != null) {
                    destination.release(1);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public boolean moveOrCopyCollection(User user, String collectionName, String destinationPath, String newName, boolean move) throws EXistException, PermissionDeniedException, URISyntaxException {
        return this.moveOrCopyCollection(user, XmldbURI.xmldbUriFor(collectionName), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName), move);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean moveOrCopyCollection(User user, XmldbURI collUri, XmldbURI destUri, XmldbURI newName, boolean move) throws EXistException, PermissionDeniedException {
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            broker = this.brokerPool.get(user);
            collection = broker.openCollection(collUri, move ? 1 : 0);
            if (collection == null) {
                transact.abort(transaction);
                throw new EXistException("Collection " + collUri + " not found");
            }
            destination = broker.openCollection(destUri, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new EXistException("Destination collection " + destUri + " not found");
            }
            if (move) {
                broker.moveCollection(transaction, collection, destination, newName);
            } else {
                broker.copyCollection(transaction, collection, destination, newName);
            }
            transact.commit(transaction);
            this.documentCache.clear();
            boolean bl = true;
            if (collection != null) {
                collection.release(move ? 1 : 0);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.brokerPool.release(broker);
            return bl;
        }
        catch (LockException e) {
            try {
                transact.abort(transaction);
                throw new PermissionDeniedException(e.getMessage());
                catch (IOException e2) {
                    transact.abort(transaction);
                    throw new EXistException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (collection != null) {
                    collection.release(move ? 1 : 0);
                }
                if (destination != null) {
                    destination.release(1);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
    }

    public void reindexCollection(User user, String collectionName) throws Exception, PermissionDeniedException, URISyntaxException {
        this.reindexCollection(user, XmldbURI.xmldbUriFor(collectionName));
    }

    public void reindexCollection(User user, XmldbURI collUri) throws Exception, PermissionDeniedException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            broker.reindexCollection(collUri);
            LOG.debug((Object)("collection " + collUri + " and sub collection reindexed"));
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    public void backup(User user, String userbackup, String password, String destcollection, String collection) throws Exception, PermissionDeniedException {
        try {
            Backup backup = new Backup(userbackup, password, destcollection + "-backup", XmldbURI.xmldbUriFor(XmldbURI.EMBEDDED_SERVER_URI.toString() + collection));
            backup.backup(false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid(User user, String documentPath) throws PermissionDeniedException, Exception, URISyntaxException {
        return this.isValid(user, XmldbURI.xmldbUriFor(documentPath));
    }

    public boolean isValid(User user, XmldbURI docUri) throws PermissionDeniedException, Exception {
        boolean retVal = false;
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(user);
            BrokerPool pPool = broker.getBrokerPool();
            Validator validator = new Validator(pPool);
            EmbeddedInputStream is = new EmbeddedInputStream(new XmldbURL(docUri));
            ValidationReport veh = validator.validate(is);
            retVal = veh.isValid();
        }
        catch (Exception e) {
            LOG.debug((Object)e);
            throw e;
        }
        finally {
            this.brokerPool.release(broker);
        }
        return retVal;
    }

    public Vector getDocType(User user, String documentPath) throws PermissionDeniedException, EXistException, URISyntaxException {
        return this.getDocType(user, XmldbURI.xmldbUriFor(documentPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDocType(User user, XmldbURI docUri) throws PermissionDeniedException, EXistException {
        DBBroker broker = null;
        DocumentImpl doc = null;
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docUri, 0);
            if (doc == null) {
                LOG.debug((Object)("document " + docUri + " not found!"));
                throw new EXistException("document not found");
            }
            Vector<String> vector = new Vector<String>(3);
            if (doc.getDoctype() != null) {
                vector.addElement(doc.getDoctype().getName());
                if (doc.getDoctype().getPublicId() != null) {
                    vector.addElement(doc.getDoctype().getPublicId());
                } else {
                    vector.addElement("");
                }
                if (doc.getDoctype().getSystemId() != null) {
                    vector.addElement(doc.getDoctype().getSystemId());
                } else {
                    vector.addElement("");
                }
            } else {
                vector.addElement("");
                vector.addElement("");
                vector.addElement("");
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public boolean setDocType(User user, String documentPath, String doctypename, String publicid, String systemid) throws Exception, URISyntaxException {
        return this.setDocType(user, XmldbURI.xmldbUriFor(documentPath), doctypename, publicid, systemid);
    }

    public boolean setDocType(User user, XmldbURI docUri, String doctypename, String publicid, String systemid) throws Exception {
        DBBroker broker = null;
        DocumentImpl doc = null;
        DocumentTypeImpl result = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(user);
            doc = broker.getXMLResource(docUri, 1);
            if (doc == null) {
                transact.abort(transaction);
                throw new EXistException("Resource " + docUri + " not found");
            }
            if (!doc.getPermissions().validate(user, 1)) {
                transact.abort(transaction);
                throw new PermissionDeniedException("User is not allowed to lock resource " + docUri);
            }
            if (!"".equals(doctypename)) {
                result = new DocumentTypeImpl(doctypename, "".equals(publicid) ? null : publicid, "".equals(systemid) ? null : systemid);
            }
            doc.setDocumentType(result);
            broker.storeXMLResource(transaction, doc);
            transact.commit(transaction);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transact.abort(transaction);
            throw e;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    class NodeCount {
        int count = 1;
        DocumentImpl doc;

        public NodeCount(DocumentImpl doc) {
            this.doc = doc;
        }

        public void inc() {
            ++this.count;
        }
    }

    class DoctypeCount {
        int count = 1;
        DocumentType doctype;

        public DoctypeCount(DocumentType doctype) {
            this.doctype = doctype;
        }

        public void inc() {
            ++this.count;
        }
    }

    class CachedQuery {
        PathExpr expression;
        String queryString;
        long timestamp;

        public CachedQuery(PathExpr expr, String query) {
            this.expression = expr;
            this.queryString = query;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

