/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.recovery;

import java.io.File;
import org.apache.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.Journal;
import org.exist.storage.journal.JournalReader;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.journal.Lsn;
import org.exist.storage.txn.Checkpoint;
import org.exist.util.ProgressBar;
import org.exist.util.hashtable.Long2ObjectHashMap;
import org.exist.util.sanity.SanityCheck;

public class RecoveryManager {
    private static final Logger LOG = Logger.getLogger((Class)RecoveryManager.class);
    private Journal logManager;
    private DBBroker broker;

    public RecoveryManager(DBBroker broker, Journal log) {
        this.broker = broker;
        this.logManager = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws LogException {
        boolean recoveryRun = false;
        File[] files = this.logManager.getFiles();
        int lastNum = Journal.findLastFile(files);
        if (-1 < lastNum) {
            File last = this.logManager.getFile(lastNum);
            JournalReader reader = new JournalReader(this.broker, last, lastNum);
            try {
                boolean checkpointFound = false;
                try {
                    Checkpoint checkpoint;
                    Loggable lastLog = reader.lastEntry();
                    if (lastLog != null && lastLog.getLogType() == 2 && (checkpoint = (Checkpoint)lastLog).getStoredLsn() == checkpoint.getLsn()) {
                        checkpointFound = true;
                        LOG.debug((Object)("Database is in clean state. Last checkpoint: " + checkpoint.getDateString()));
                    }
                }
                catch (LogException e) {
                    LOG.debug((Object)("Reading last journal log entry failed: " + e.getMessage() + ". Will scan the log..."));
                    checkpointFound = false;
                }
                if (!checkpointFound) {
                    Loggable next;
                    long lastLsn;
                    AbstractLoggable lastCheckpoint;
                    Long2ObjectHashMap txnsStarted;
                    block21: {
                        reader.position(1L);
                        txnsStarted = new Long2ObjectHashMap();
                        lastCheckpoint = null;
                        lastLsn = -1L;
                        try {
                            ProgressBar progress = new ProgressBar("Scanning journal ", last.length());
                            while ((next = reader.nextEntry()) != null) {
                                progress.set(Lsn.getOffset(next.getLsn()));
                                if (next.getLogType() == 0) {
                                    txnsStarted.put(next.getTransactionId(), next);
                                } else if (next.getLogType() == 3) {
                                    txnsStarted.remove(next.getTransactionId());
                                } else if (next.getLogType() == 2) {
                                    txnsStarted.clear();
                                    lastCheckpoint = (Checkpoint)next;
                                }
                                lastLsn = next.getLsn();
                            }
                        }
                        catch (LogException e) {
                            if (!LOG.isDebugEnabled()) break block21;
                            LOG.debug((Object)"Caught exception while reading log", (Throwable)e);
                            LOG.debug((Object)("Last readable log entry lsn: " + Lsn.dump(lastLsn)));
                        }
                    }
                    if ((lastCheckpoint == null || lastCheckpoint.getLsn() != lastLsn) && txnsStarted.size() > 0) {
                        LOG.debug((Object)("Found dirty transactions: " + txnsStarted.size()));
                        if (lastCheckpoint == null) {
                            reader.position(1L);
                        } else {
                            reader.position(lastCheckpoint.getLsn());
                            next = reader.nextEntry();
                        }
                        recoveryRun = true;
                        this.doRecovery(last, reader, lastLsn);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Database is in clean state.");
                    }
                }
                this.cleanDirectory(files);
            }
            finally {
                reader.close();
            }
        }
        this.logManager.setCurrentFileNum(lastNum);
        this.logManager.switchFiles();
        return recoveryRun;
    }

    private void doRecovery(File last, JournalReader reader, long lastLsn) throws LogException {
        Loggable next;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Running recovery ...");
        }
        this.logManager.setInRecovery(true);
        Long2ObjectHashMap runningTxns = new Long2ObjectHashMap();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"First pass: redoing operations");
        }
        ProgressBar progress = new ProgressBar("Redo ", last.length());
        while ((next = reader.nextEntry()) != null) {
            SanityCheck.ASSERT(next.getLogType() != 2, "Found a checkpoint during recovery run! This should not ever happen.");
            if (next.getLogType() == 0) {
                runningTxns.put(next.getTransactionId(), next);
            } else if (next.getLogType() == 1) {
                runningTxns.remove(next.getTransactionId());
            } else if (next.getLogType() == 3) {
                runningTxns.remove(next.getTransactionId());
            }
            next.redo();
            progress.set(Lsn.getOffset(next.getLsn()));
            if (next.getLsn() != lastLsn) continue;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Second pass: undoing dirty transactions. Uncommitted transactions: " + runningTxns.size()));
        }
        if (runningTxns.size() > 0) {
            while ((next = reader.previousEntry()) != null) {
                if (next.getLogType() == 0) {
                    if (runningTxns.get(next.getTransactionId()) != null) {
                        runningTxns.remove(next.getTransactionId());
                        if (runningTxns.size() == 0) {
                            break;
                        }
                    }
                } else if (next.getLogType() != 1 && next.getLogType() == 2) break;
                if (runningTxns.get(next.getTransactionId()) == null) continue;
                next.undo();
            }
        }
        this.broker.sync(1);
        this.logManager.setInRecovery(false);
    }

    private void cleanDirectory(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
    }
}

