/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class CreateBTNodeLoggable
extends BTAbstractLoggable {
    protected byte status;
    protected long pageNum;
    protected long parentNum;

    public CreateBTNodeLoggable(Txn transaction, byte fileId, byte status, long pageNum, long parentNum) {
        super((byte)33, fileId, transaction);
        this.pageNum = pageNum;
        this.parentNum = parentNum;
        this.status = status;
    }

    public CreateBTNodeLoggable(DBBroker broker, long transactionId) {
        super((byte)33, broker, transactionId);
    }

    public void redo() throws LogException {
        this.getStorage().redoCreateBTNode(this);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.put(this.status);
        out.putLong(this.pageNum);
        out.putLong(this.parentNum);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.status = in.get();
        this.pageNum = in.getLong();
        this.parentNum = in.getLong();
    }

    public int getLogSize() {
        return super.getLogSize() + 17;
    }

    public String dump() {
        return super.dump() + " - create btree node: " + this.pageNum;
    }
}

