/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Observer;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.collections.Collection;
import org.exist.collections.CollectionCache;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.AttrImpl;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.dom.TextImpl;
import org.exist.fulltext.FTIndex;
import org.exist.fulltext.FTIndexWorker;
import org.exist.indexing.StreamListener;
import org.exist.memtree.DOMIndexer;
import org.exist.memtree.DocumentImpl;
import org.exist.numbering.NodeId;
import org.exist.security.MD5;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.DBBroker;
import org.exist.storage.ElementIndex;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NativeElementIndex;
import org.exist.storage.NativeTextEngine;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.RangeIndexSpec;
import org.exist.storage.StorageAddress;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Paged;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.dom.DOMTransaction;
import org.exist.storage.dom.NodeIterator;
import org.exist.storage.dom.RawNodeIterator;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.NativeSerializer;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;

public class NativeBroker
extends DBBroker {
    public static final byte PREPEND_DB_ALWAYS = 0;
    public static final byte PREPEND_DB_NEVER = 1;
    public static final byte PREPEND_DB_AS_NEEDED = 2;
    public static final byte COLLECTIONS_DBX_ID = 0;
    public static final byte ELEMENTS_DBX_ID = 1;
    public static final byte VALUES_DBX_ID = 2;
    public static final byte DOM_DBX_ID = 3;
    public static final String PAGE_SIZE_ATTRIBUTE = "pageSize";
    public static final String INDEX_DEPTH_ATTRIBUTE = "index-depth";
    public static final String PROPERTY_PAGE_SIZE = "db-connection.page-size";
    public static final String PROPERTY_INDEX_DEPTH = "indexer.index-depth";
    private static final byte[] ALL_STORAGE_FILES = new byte[]{0, 1, 2, 3};
    private static final String EXCEPTION_DURING_REINDEX = "exception during reindex";
    private static final String DATABASE_IS_READ_ONLY = "database is read-only";
    public static final String DEFAULT_DATA_DIR = "data";
    public static final int DEFAULT_PAGE_SIZE = 4096;
    public static final int DEFAULT_INDEX_DEPTH = 1;
    public static final int DEFAULT_MIN_MEMORY = 5000000;
    public static final long TEMP_FRAGMENT_TIMEOUT = 60000L;
    public static final int BUFFERS = 256;
    public static final int DEFAULT_NODES_BEFORE_MEMORY_CHECK = 500;
    public static int OFFSET_COLLECTION_ID = 0;
    public static int OFFSET_VALUE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
    protected CollectionStore collectionsDb;
    protected DOMFile domDb;
    protected File symbolsFile;
    protected SymbolTable symbols = null;
    protected NativeElementIndex elementIndex;
    protected NativeValueIndex valueIndex;
    protected IndexSpec indexConfiguration;
    protected int defaultIndexDepth;
    protected Serializer xmlSerializer;
    protected boolean readOnly = false;
    protected int nodesCount = 0;
    protected String dataDir;
    protected int pageSize;
    protected byte prepend;
    private final Runtime run = Runtime.getRuntime();
    private NodeProcessor nodeProcessor = new NodeProcessor();
    private EmbeddedXMLStreamReader streamReader = null;

    public NativeBroker(BrokerPool pool, Configuration config) throws EXistException {
        super(pool, config);
        LOG.debug((Object)("Initializing broker " + this.hashCode()));
        String prependDB = (String)config.getProperty("db-connection.prepend-db");
        this.prepend = "always".equalsIgnoreCase(prependDB) ? (byte)0 : ("never".equalsIgnoreCase(prependDB) ? (byte)1 : (byte)2);
        this.dataDir = (String)config.getProperty("db-connection.data-dir");
        if (this.dataDir == null) {
            this.dataDir = DEFAULT_DATA_DIR;
        }
        this.pageSize = config.getInteger(PROPERTY_PAGE_SIZE);
        if (this.pageSize < 0) {
            this.pageSize = 4096;
        }
        Paged.setPageSize(this.pageSize);
        this.defaultIndexDepth = config.getInteger(PROPERTY_INDEX_DEPTH);
        if (this.defaultIndexDepth < 0) {
            this.defaultIndexDepth = 1;
        }
        this.indexConfiguration = (IndexSpec)config.getProperty("indexer.config");
        this.xmlSerializer = new NativeSerializer(this, config);
        this.user = SecurityManager.SYSTEM_USER;
        this.readOnly = pool.isReadOnly();
        try {
            this.domDb = (DOMFile)config.getProperty(DOMFile.getConfigKeyForFile());
            if (this.domDb == null) {
                this.domDb = new DOMFile(pool, 3, this.dataDir, config);
            }
            this.readOnly = this.readOnly || this.domDb.isReadOnly();
            this.collectionsDb = (CollectionStore)config.getProperty(CollectionStore.getConfigKeyForFile());
            if (this.collectionsDb == null) {
                this.collectionsDb = new CollectionStore(pool, 0, this.dataDir, config);
            }
            this.readOnly = this.readOnly || this.collectionsDb.isReadOnly();
            this.symbols = (SymbolTable)config.getProperty("db-connection.symbol-table");
            if (this.symbols == null) {
                this.symbols = new SymbolTable(pool, this.dataDir, config);
            }
            this.readOnly = this.readOnly || !this.symbols.getFile().canWrite();
            this.elementIndex = new NativeElementIndex(this, 1, this.dataDir, config);
            this.valueIndex = new NativeValueIndex(this, 2, this.dataDir, config);
            if (this.readOnly) {
                LOG.info((Object)"Database runs in read-only mode");
            }
        }
        catch (DBException e) {
            LOG.debug((Object)e.getMessage(), (Throwable)e);
            throw new EXistException(e);
        }
    }

    public void addObserver(Observer o) {
        super.addObserver(o);
        this.elementIndex.addObserver(o);
    }

    public void deleteObservers() {
        super.deleteObservers();
        if (this.elementIndex != null) {
            this.elementIndex.deleteObservers();
        }
    }

    private void notifyRemoveNode(StoredNode node, NodePath currentPath, String content) {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.removeNode(node, currentPath, content);
        }
    }

    private void notifyStoreText(TextImpl text, NodePath currentPath, int indexingHint) {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.storeText(text, currentPath, indexingHint);
        }
    }

    private void notifyDropIndex(Collection collection) {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.dropIndex(collection);
        }
    }

    private void notifyDropIndex(org.exist.dom.DocumentImpl doc) throws ReadOnlyException {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.dropIndex(doc);
        }
    }

    private void notifyRemove() {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.remove();
        }
    }

    private void notifySync() {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.sync();
        }
    }

    private void notifyFlush() {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            try {
                observer.flush();
                continue;
            }
            catch (DBException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void notifyPrintStatistics() throws DBException {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.printStatistics();
        }
    }

    private void notifyClose() throws DBException {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.close();
        }
        this.clearContentLoadingObservers();
    }

    private void notifyCloseAndRemove() {
        for (int i = 0; i < this.contentLoadingObservers.size(); ++i) {
            ContentLoadingObserver observer = (ContentLoadingObserver)this.contentLoadingObservers.get(i);
            observer.closeAndRemove();
        }
        this.clearContentLoadingObservers();
    }

    public void endElement(StoredNode node, NodePath currentPath, String content, boolean remove) {
        int indexType = ((ElementImpl)node).getIndexType();
        if (RangeIndexSpec.hasRangeIndex(indexType)) {
            node.getQName().setNameType((byte)0);
            if (content == null) {
                content = this.getNodeValue(node, false);
            }
            this.valueIndex.setDocument((org.exist.dom.DocumentImpl)node.getOwnerDocument());
            this.valueIndex.storeElement((ElementImpl)node, content, RangeIndexSpec.indexTypeToXPath(indexType), (byte)0, remove);
        }
        if (RangeIndexSpec.hasQNameIndex(indexType)) {
            node.getQName().setNameType((byte)0);
            if (content == null) {
                content = this.getNodeValue(node, false);
            }
            this.valueIndex.setDocument((org.exist.dom.DocumentImpl)node.getOwnerDocument());
            this.valueIndex.storeElement((ElementImpl)node, content, RangeIndexSpec.indexTypeToXPath(indexType), (byte)1, remove);
        }
    }

    public void endRemove(Txn transaction) {
        this.notifyRemove();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public DOMFile getDOMFile() {
        return this.domDb;
    }

    public BTree getStorage(byte id) {
        switch (id) {
            case 3: {
                return this.domDb;
            }
            case 0: {
                return this.collectionsDb;
            }
            case 1: {
                return this.elementIndex.dbNodes;
            }
            case 2: {
                return this.valueIndex.dbValues;
            }
        }
        return null;
    }

    public byte[] getStorageFileIds() {
        return ALL_STORAGE_FILES;
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        for (byte i = 0; i < ALL_STORAGE_FILES.length; i = (byte)(i + 1)) {
            BTree paged = this.getStorage(i);
            if (paged == null) {
                LOG.warn((Object)("Storage file is null: " + i));
                continue;
            }
            OutputStream os = backup.newEntry(paged.getFile().getName());
            paged.backupToStream(os);
            backup.closeEntry();
        }
        OutputStream os = backup.newEntry(this.getSymbols().getFile().getName());
        this.getSymbols().backupSymbolsTo(os);
        backup.closeEntry();
        this.pool.getIndexManager().backupToArchive(backup);
    }

    public SymbolTable getSymbols() {
        return this.symbols;
    }

    public IndexSpec getIndexConfiguration() {
        return this.indexConfiguration;
    }

    public ElementIndex getElementIndex() {
        return this.elementIndex;
    }

    public NativeValueIndex getValueIndex() {
        return this.valueIndex;
    }

    public TextSearchEngine getTextEngine() {
        FTIndexWorker worker = (FTIndexWorker)this.indexController.getWorkerByIndexId(FTIndex.ID);
        if (worker == null) {
            LOG.warn((Object)"Fulltext index is not configured. Please check the <modules> section in conf.xml");
            return null;
        }
        return worker.getEngine();
    }

    public EmbeddedXMLStreamReader getXMLStreamReader(StoredNode node, boolean reportAttributes) throws IOException, XMLStreamException {
        if (this.streamReader == null) {
            RawNodeIterator iterator = new RawNodeIterator((Object)this, this.domDb, node);
            this.streamReader = new EmbeddedXMLStreamReader((org.exist.dom.DocumentImpl)node.getOwnerDocument(), iterator, reportAttributes);
        } else {
            this.streamReader.reposition(node, reportAttributes);
        }
        return this.streamReader;
    }

    public EmbeddedXMLStreamReader getXMLStreamReader(NodeProxy proxy, boolean reportAttributes) throws IOException, XMLStreamException {
        if (this.streamReader == null) {
            RawNodeIterator iterator = new RawNodeIterator((Object)this, this.domDb, proxy);
            this.streamReader = new EmbeddedXMLStreamReader((org.exist.dom.DocumentImpl)proxy.getOwnerDocument(), iterator, reportAttributes);
        } else {
            this.streamReader.reposition(proxy, reportAttributes);
        }
        return this.streamReader;
    }

    public Iterator getNodeIterator(StoredNode node) {
        if (node == null) {
            throw new IllegalArgumentException("The node parameter cannot be null.");
        }
        try {
            return new NodeIterator((Object)this, this.domDb, node, false);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"failed to create node iterator", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"failed to create node iterator", (Throwable)e);
        }
        return null;
    }

    public Serializer getSerializer() {
        this.xmlSerializer.reset();
        return this.xmlSerializer;
    }

    public Serializer newSerializer() {
        return new NativeSerializer(this, this.getConfiguration());
    }

    public XmldbURI prepend(XmldbURI uri) {
        switch (this.prepend) {
            case 0: {
                return uri.prepend(XmldbURI.ROOT_COLLECTION_URI);
            }
            case 2: {
                return uri.startsWith(XmldbURI.ROOT_COLLECTION_URI) ? uri : uri.prepend(XmldbURI.ROOT_COLLECTION_URI);
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection createTempCollection(Txn transaction) throws LockException, PermissionDeniedException, IOException {
        User u = this.user;
        try {
            this.user = this.pool.getSecurityManager().getUser("admin");
            Collection temp = this.getOrCreateCollection(transaction, XmldbURI.TEMP_COLLECTION_URI);
            temp.setPermissions(505);
            this.saveCollection(transaction, temp);
            Collection collection = temp;
            return collection;
        }
        finally {
            this.user = u;
        }
    }

    public Collection getOrCreateCollection(Txn transaction, XmldbURI name) throws PermissionDeniedException, IOException {
        CollectionCache collectionsCache;
        name = this.prepend(name.normalizeCollectionPath());
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            try {
                XmldbURI[] segments = name.getPathSegments();
                XmldbURI path = XmldbURI.ROOT_COLLECTION_URI;
                Collection current = this.getCollection(XmldbURI.ROOT_COLLECTION_URI);
                if (current == null) {
                    LOG.debug((Object)("Creating root collection '" + XmldbURI.ROOT_COLLECTION_URI + "'"));
                    current = new Collection(XmldbURI.ROOT_COLLECTION_URI);
                    current.getPermissions().setPermissions(511);
                    current.getPermissions().setOwner(this.user);
                    current.getPermissions().setGroup(this.user.getPrimaryGroup());
                    current.setId(this.getNextCollectionId(transaction));
                    current.setCreationTime(System.currentTimeMillis());
                    if (transaction != null) {
                        transaction.acquireLock(current.getLock(), 1);
                    }
                    this.saveCollection(transaction, current);
                }
                for (int i = 1; i < segments.length; ++i) {
                    XmldbURI temp = segments[i];
                    path = path.append(temp);
                    if (current.hasSubcollectionNoLock(temp)) {
                        current = this.getCollection(path);
                        if (current != null) continue;
                        LOG.debug((Object)("Collection '" + path + "' not found!"));
                        continue;
                    }
                    if (this.readOnly) {
                        throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
                    }
                    if (!current.getPermissionsNoLock().validate(this.user, 2)) {
                        LOG.error((Object)("Permission denied to create collection '" + path + "'"));
                        throw new PermissionDeniedException("User '" + this.user.getName() + "' not allowed to write to collection '" + current.getURI() + "'");
                    }
                    LOG.debug((Object)("Creating collection '" + path + "'..."));
                    Collection sub = new Collection(path);
                    sub.getPermissions().setOwner(this.user);
                    sub.getPermissions().setGroup(this.user.getPrimaryGroup());
                    sub.setId(this.getNextCollectionId(transaction));
                    sub.setCreationTime(System.currentTimeMillis());
                    if (transaction != null) {
                        transaction.acquireLock(sub.getLock(), 1);
                    }
                    current.addCollection(this, sub, true);
                    this.saveCollection(transaction, current);
                    current = sub;
                }
                return current;
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
                return null;
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
        }
    }

    public Collection getCollection(XmldbURI uri) {
        return this.openCollection(uri, -1L, -1);
    }

    public Collection openCollection(XmldbURI uri, int lockMode) {
        return this.openCollection(uri, -1L, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection openCollection(XmldbURI uri, long addr, int lockMode) {
        uri = this.prepend(uri.toCollectionPathURI());
        var7_5 = collectionsCache = this.pool.getCollectionsCache();
        synchronized (var7_5) {
            collection = collectionsCache.get(uri);
            if (collection == null) {
                lock = this.collectionsDb.getLock();
                try {
                    lock.acquire(0);
                    if (addr == -1L) {
                        key = new CollectionStore.CollectionKey(uri.toString());
                        is = this.collectionsDb.getAsStream(key);
                    } else {
                        is = this.collectionsDb.getAsStream(addr);
                    }
                    if (is == null) {
                        var10_9 = null;
                        return var10_9;
                    }
                    collection = new Collection(uri);
                    collection.read(this, is);
                    if (this.pool.isInitializing()) ** GOTO lbl45
                    collectionsCache.add(collection);
                }
                catch (UnsupportedEncodingException e) {
                    NativeBroker.LOG.error((Object)("Unable to encode '" + uri + "' in UTF-8"));
                    var10_9 = null;
                    return var10_9;
                }
                catch (LockException e) {
                    NativeBroker.LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
                    var10_9 = null;
                    {
                        catch (Throwable var11_14) {
                            throw var11_14;
                        }
                    }
                    return var10_9;
                    catch (IOException e) {
                        NativeBroker.LOG.error((Object)e.getMessage(), (Throwable)e);
                        var10_9 = null;
                        return var10_9;
                    }
                }
                finally {
                    lock.release(0);
                }
            } else {
                if (!collection.getURI().equalsInternal(uri)) {
                    NativeBroker.LOG.error((Object)("The collection received from the cache is not the requested: " + uri + "; received: " + collection.getURI()));
                }
                collectionsCache.add(collection);
            }
        }
lbl45:
        // 3 sources

        if (lockMode == -1) return collection;
        try {
            collection.getLock().acquire(lockMode);
            return collection;
        }
        catch (LockException e) {
            NativeBroker.LOG.warn((Object)("Failed to acquire lock on collection '" + uri + "'"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCollection(Txn transaction, Collection collection, Collection destination, XmldbURI newUri) throws PermissionDeniedException, LockException, IOException {
        Collection old;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (newUri != null && newUri.numSegments() != 1) {
            throw new PermissionDeniedException("New collection name must have one segment!");
        }
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Read permission denied on collection " + collection.getURI());
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot move collection to itself");
        }
        if (!destination.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getURI());
        }
        if (newUri == null) {
            newUri = collection.getURI().lastSegment();
        }
        if ((old = this.openCollection(destination.getURI().append(newUri), 1)) != null) {
            LOG.debug((Object)("removing old collection: " + newUri));
            try {
                this.removeCollection(transaction, old);
            }
            finally {
                old.release(1);
            }
        }
        Collection destCollection = null;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            newUri = destination.getURI().append(newUri);
            LOG.debug((Object)("Copying collection to '" + newUri + "'"));
            destCollection = this.getOrCreateCollection(transaction, newUri);
            Iterator i = collection.iterator(this);
            while (i.hasNext()) {
                org.exist.dom.DocumentImpl newDoc;
                org.exist.dom.DocumentImpl child = (org.exist.dom.DocumentImpl)i.next();
                LOG.debug((Object)("Copying resource: '" + child.getURI() + "'"));
                if (child.getResourceType() == 0) {
                    newDoc = new org.exist.dom.DocumentImpl(this, destCollection, child.getFileURI());
                    newDoc.copyOf(child);
                    newDoc.setDocId(this.getNextResourceId(transaction, destination));
                    this.copyXMLResource(transaction, child, newDoc);
                    this.storeXMLResource(transaction, newDoc);
                    destCollection.addDocument(transaction, this, newDoc);
                    continue;
                }
                newDoc = new BinaryDocument(this, destCollection, child.getFileURI());
                newDoc.copyOf(child);
                newDoc.setDocId(this.getNextResourceId(transaction, destination));
                byte[] data = this.getBinaryResource((BinaryDocument)child);
                this.storeBinaryResource(transaction, (BinaryDocument)newDoc, data);
                this.storeXMLResource(transaction, newDoc);
                destCollection.addDocument(transaction, this, newDoc);
            }
            this.saveCollection(transaction, destCollection);
        }
        finally {
            lock.release(1);
        }
        XmldbURI name = collection.getURI();
        Iterator i = collection.collectionIterator();
        while (i.hasNext()) {
            XmldbURI childName = (XmldbURI)i.next();
            Collection child = this.openCollection(name.append(childName), 1);
            if (child == null) {
                LOG.warn((Object)("Child collection '" + childName + "' not found"));
                continue;
            }
            try {
                this.copyCollection(transaction, child, destCollection, childName);
            }
            finally {
                child.release(1);
            }
        }
        this.saveCollection(transaction, destCollection);
        this.saveCollection(transaction, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCollection(Txn transaction, Collection collection, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException {
        CollectionCache collectionsCache;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (newName != null && newName.numSegments() != 1) {
            throw new PermissionDeniedException("New collection name must have one segment!");
        }
        if (collection.getId() == destination.getId()) {
            throw new PermissionDeniedException("Cannot move collection to itself");
        }
        if (collection.getURI().equals(XmldbURI.ROOT_COLLECTION_URI)) {
            throw new PermissionDeniedException("Cannot move the db root collection");
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move collection " + collection.getURI());
        }
        if (!destination.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getURI());
        }
        Collection old = this.openCollection(destination.getURI().append(newName), 1);
        if (old != null) {
            try {
                this.removeCollection(transaction, old);
            }
            finally {
                old.release(1);
            }
        }
        XmldbURI uri = collection.getURI();
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            Collection parent = this.openCollection(collection.getParentURI(), 1);
            if (parent != null) {
                try {
                    parent.removeCollection(uri.lastSegment());
                }
                finally {
                    parent.release(1);
                }
            }
            Lock lock = this.collectionsDb.getLock();
            try {
                lock.acquire(1);
                collectionsCache.remove(collection);
                CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(uri.toString());
                this.collectionsDb.remove(transaction, key);
                collection.setPath(destination.getURI().append(newName));
                collection.setCreationTime(System.currentTimeMillis());
                destination.addCollection(this, collection, false);
                if (parent != null) {
                    this.saveCollection(transaction, parent);
                }
                if (parent != destination) {
                    this.saveCollection(transaction, destination);
                }
                this.saveCollection(transaction, collection);
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
            finally {
                lock.release(1);
            }
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI childName = (XmldbURI)i.next();
                Collection child = this.openCollection(uri.append(childName), 1);
                if (child == null) {
                    LOG.warn((Object)("Child collection " + childName + " not found"));
                    continue;
                }
                try {
                    this.moveCollection(transaction, child, collection, childName);
                }
                finally {
                    child.release(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canRemoveCollection(Collection collection) throws PermissionDeniedException {
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("User '" + this.user.getName() + "' not allowed to remove collection '" + collection.getURI() + "'");
        }
        XmldbURI uri = collection.getURI();
        Iterator i = collection.collectionIterator();
        while (i.hasNext()) {
            XmldbURI childName = (XmldbURI)i.next();
            Collection childCollection = this.openCollection(uri.append(childName), 1);
            try {
                this.canRemoveCollection(childCollection);
            }
            finally {
                if (childCollection != null) {
                    childCollection.getLock().release(1);
                    continue;
                }
                LOG.warn((Object)"childCollection is null !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCollection(final Txn transaction, Collection collection) throws PermissionDeniedException, IOException {
        CollectionCache collectionsCache;
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("User '" + this.user.getName() + "' not allowed to remove collection '" + collection.getURI() + "'");
        }
        long start = System.currentTimeMillis();
        CollectionCache collectionCache = collectionsCache = this.pool.getCollectionsCache();
        synchronized (collectionCache) {
            this.canRemoveCollection(collection);
            XmldbURI uri = collection.getURI();
            String collName = uri.getRawCollectionPath();
            boolean isRoot = collection.getParentURI() == null;
            this.pool.getConfigurationManager().invalidateAll(uri);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing children collections from their parent '" + collName + "'..."));
            }
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI childName = (XmldbURI)i.next();
                Collection childCollection = this.openCollection(uri.append(childName), 1);
                try {
                    this.removeCollection(transaction, childCollection);
                }
                finally {
                    if (childCollection != null) {
                        childCollection.getLock().release(1);
                        continue;
                    }
                    LOG.warn((Object)"childCollection is null !");
                }
            }
            this.notifyDropIndex(collection);
            this.indexController.removeCollection(collection, this);
            if (!isRoot) {
                Collection parentCollection = this.openCollection(collection.getParentURI(), 1);
                if (transaction != null) {
                    transaction.registerLock(parentCollection.getLock(), 1);
                }
                if (parentCollection != null) {
                    try {
                        LOG.debug((Object)("Removing collection '" + collName + "' from its parent..."));
                        parentCollection.removeCollection(uri.lastSegment());
                        this.saveCollection(transaction, parentCollection);
                    }
                    catch (LockException e) {
                        LOG.warn((Object)("LockException while removing collection '" + collName + "'"));
                    }
                    finally {
                        if (transaction == null) {
                            parentCollection.getLock().release(1);
                        }
                    }
                }
            }
            Lock lock = this.collectionsDb.getLock();
            try {
                lock.acquire(1);
                CollectionStore.DocumentKey docKey = new CollectionStore.DocumentKey(collection.getId());
                IndexQuery query = new IndexQuery(7, (Value)docKey);
                this.collectionsDb.removeAll(transaction, query);
                if (!isRoot) {
                    CollectionStore.CollectionKey key = new CollectionStore.CollectionKey(collName);
                    this.collectionsDb.remove(transaction, key);
                    collectionsCache.remove(collection);
                    this.freeCollectionId(transaction, collection.getId());
                } else {
                    this.saveCollection(transaction, collection);
                }
            }
            catch (LockException e) {
                LOG.warn((Object)("Failed to acquire lock on '" + this.collectionsDb.getFile().getName() + "'"));
            }
            catch (ReadOnlyException e) {
                throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
            }
            catch (BTreeException e) {
                LOG.warn((Object)("Exception while removing collection: " + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while removing collection: " + e.getMessage()), (Throwable)e);
            }
            finally {
                lock.release(1);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing resources in '" + collName + "'..."));
            }
            Iterator i2 = collection.iterator(this);
            while (i2.hasNext()) {
                final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)i2.next();
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() {
                        try {
                            NodeRef ref = new NodeRef(doc.getDocId());
                            IndexQuery query = new IndexQuery(7, (Value)ref);
                            NativeBroker.this.domDb.remove(transaction, query, null);
                        }
                        catch (BTreeException e) {
                            DBBroker.LOG.warn((Object)"btree error while removing document", (Throwable)e);
                        }
                        catch (IOException e) {
                            DBBroker.LOG.warn((Object)"io error while removing document", (Throwable)e);
                        }
                        catch (TerminatedException e) {
                            DBBroker.LOG.warn((Object)"method terminated", (Throwable)e);
                        }
                        return null;
                    }
                }.run();
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() {
                        if (doc.getResourceType() == 1) {
                            long page = ((BinaryDocument)doc).getPage();
                            if (page > -1L) {
                                NativeBroker.this.domDb.removeOverflowValue(transaction, page);
                            }
                        } else {
                            StoredNode node = (StoredNode)doc.getFirstChild();
                            NativeBroker.this.domDb.removeAll(transaction, node.getInternalAddress());
                        }
                        return null;
                    }
                }.run();
                this.freeResourceId(transaction, doc.getDocId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing collection '" + collName + "' took " + (System.currentTimeMillis() - start)));
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCollection(Txn transaction, Collection collection) throws PermissionDeniedException, IOException {
        if (collection == null) {
            LOG.error((Object)"NativeBroker.saveCollection called with collection == null! Aborting.");
            return;
        }
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!this.pool.isInitializing()) {
            this.pool.getCollectionsCache().add(collection);
        }
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            if (collection.getId() == -1) {
                collection.setId(this.getNextCollectionId(transaction));
            }
            CollectionStore.CollectionKey name = new CollectionStore.CollectionKey(collection.getURI().toString());
            VariableByteOutputStream ostream = new VariableByteOutputStream(8);
            collection.write(this, ostream);
            long addr = this.collectionsDb.put(transaction, (Value)name, ostream.data(), true);
            if (addr == -1L) {
                LOG.warn((Object)("could not store collection data for '" + collection.getURI() + "'"));
                return;
            }
            collection.setAddress(addr);
            ostream.close();
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    protected void freeCollectionId(Txn transaction, int id) throws PermissionDeniedException {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__free_collection_id");
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                byte[] ndata = new byte[data.length + Collection.LENGTH_COLLECTION_ID];
                System.arraycopy(data, 0, ndata, OFFSET_VALUE, data.length);
                ByteConversion.intToByte(id, ndata, OFFSET_COLLECTION_ID);
                this.collectionsDb.put(transaction, (Value)key, ndata, true);
            } else {
                byte[] data = new byte[Collection.LENGTH_COLLECTION_ID];
                ByteConversion.intToByte(id, data, OFFSET_COLLECTION_ID);
                this.collectionsDb.put(transaction, (Value)key, data, true);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeCollectionId(Txn transaction) throws ReadOnlyException {
        int freeCollectionId = -1;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__free_collection_id");
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                freeCollectionId = ByteConversion.byteToInt(data, data.length - Collection.LENGTH_COLLECTION_ID);
                if (data.length - Collection.LENGTH_COLLECTION_ID > 0) {
                    byte[] ndata = new byte[data.length - Collection.LENGTH_COLLECTION_ID];
                    System.arraycopy(data, 0, ndata, OFFSET_COLLECTION_ID, ndata.length);
                    this.collectionsDb.put(transaction, (Value)key, ndata, true);
                } else {
                    this.collectionsDb.remove(transaction, key);
                }
            }
            int n = freeCollectionId;
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextCollectionId(Txn transaction) throws ReadOnlyException {
        int nextCollectionId = this.getFreeCollectionId(transaction);
        if (nextCollectionId != -1) {
            return nextCollectionId;
        }
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__next_collection_id");
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextCollectionId = ByteConversion.byteToInt(data.getData(), OFFSET_COLLECTION_ID);
                ++nextCollectionId;
            }
            byte[] d = new byte[Collection.LENGTH_COLLECTION_ID];
            ByteConversion.intToByte(nextCollectionId, d, OFFSET_COLLECTION_ID);
            this.collectionsDb.put(transaction, (Value)key, d, true);
            int n = nextCollectionId;
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(1);
        }
    }

    public void reindexCollection(XmldbURI collectionName) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = this.getCollection(collectionName = this.prepend(collectionName.toCollectionPathURI()));
        if (collection == null) {
            LOG.debug((Object)("collection " + collectionName + " not found!"));
            return;
        }
        this.reindexCollection(collection, 0);
    }

    public void reindexCollection(Collection collection, int mode) throws PermissionDeniedException {
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            this.reindexCollection(transaction, collection, mode);
            transact.commit(transaction);
        }
        catch (TransactionException e) {
            transact.abort(transaction);
            LOG.warn((Object)("An error occurred during reindex: " + e.getMessage()), (Throwable)e);
        }
    }

    public void reindexCollection(Txn transaction, Collection collection, int mode) throws PermissionDeniedException {
        Comparable next;
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("insufficient privileges on collection " + collection.getURI());
        }
        LOG.debug((Object)("Reindexing collection " + collection.getURI()));
        if (mode == 0) {
            this.dropCollectionIndex(transaction, collection);
        }
        Iterator i = collection.iterator(this);
        while (i.hasNext()) {
            next = (org.exist.dom.DocumentImpl)i.next();
            this.reindexXMLResource(transaction, (org.exist.dom.DocumentImpl)next, mode);
        }
        i = collection.collectionIterator();
        while (i.hasNext()) {
            next = (XmldbURI)i.next();
            Collection child = this.getCollection(collection.getURI().append((XmldbURI)next));
            if (child == null) {
                LOG.warn((Object)("Collection '" + next + "' not found"));
                continue;
            }
            this.reindexCollection(transaction, child, mode);
        }
    }

    public void dropCollectionIndex(final Txn transaction, Collection collection) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("insufficient privileges on collection " + collection.getURI());
        }
        this.notifyDropIndex(collection);
        this.indexController.removeCollection(collection, this);
        Iterator i = collection.iterator(this);
        while (i.hasNext()) {
            final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)i.next();
            LOG.debug((Object)("Dropping index for document " + doc.getFileURI()));
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    try {
                        NodeRef ref = new NodeRef(doc.getDocId());
                        IndexQuery query = new IndexQuery(7, (Value)ref);
                        NativeBroker.this.domDb.remove(transaction, query, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (BTreeException e) {
                        DBBroker.LOG.warn((Object)"btree error while removing document", (Throwable)e);
                    }
                    catch (DBException e) {
                        DBBroker.LOG.warn((Object)"db error while removing document", (Throwable)e);
                    }
                    catch (IOException e) {
                        DBBroker.LOG.warn((Object)"io error while removing document", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        DBBroker.LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.exist.dom.DocumentImpl storeTempResource(DocumentImpl doc) throws EXistException, PermissionDeniedException, LockException {
        User currentUser = this.user;
        this.user = this.pool.getSecurityManager().getUser("admin");
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        XmldbURI docName = XmldbURI.create(MD5.md(Thread.currentThread().getName() + Long.toString(System.currentTimeMillis()), false) + ".xml");
        Collection temp = this.openCollection(XmldbURI.TEMP_COLLECTION_URI, 1);
        boolean created = false;
        try {
            if (temp == null) {
                temp = this.createTempCollection(transaction);
                if (temp == null) {
                    LOG.warn((Object)"Failed to create temporary collection");
                }
                created = true;
            }
            org.exist.dom.DocumentImpl targetDoc = new org.exist.dom.DocumentImpl(this, temp, docName);
            targetDoc.setPermissions(505);
            long now = System.currentTimeMillis();
            DocumentMetadata metadata = new DocumentMetadata();
            metadata.setLastModified(now);
            metadata.setCreated(now);
            targetDoc.setMetadata(metadata);
            targetDoc.setDocId(this.getNextResourceId(transaction, temp));
            DOMIndexer indexer = new DOMIndexer(this, transaction, doc, targetDoc);
            indexer.scan();
            indexer.store();
            temp.addDocument(transaction, this, targetDoc);
            if (transaction == null) {
                temp.getLock().release(1);
            } else if (!created) {
                transaction.registerLock(temp.getLock(), 1);
            }
            this.storeXMLResource(transaction, targetDoc);
            this.flush();
            this.closeDocument();
            transact.commit(transaction);
            org.exist.dom.DocumentImpl documentImpl = targetDoc;
            return documentImpl;
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to store temporary fragment: " + e.getMessage()), (Throwable)e);
            transact.abort(transaction);
        }
        finally {
            this.user = currentUser;
        }
        return null;
    }

    public void cleanUpTempResources() {
        this.cleanUpTempResources(false);
    }

    public void cleanUpTempResources(boolean forceRemoval) {
        Collection temp = this.getCollection(XmldbURI.TEMP_COLLECTION_URI);
        if (temp == null) {
            return;
        }
        boolean removeCollection = true;
        if (!forceRemoval) {
            long now = System.currentTimeMillis();
            Iterator i = temp.iterator(this);
            while (i.hasNext()) {
                org.exist.dom.DocumentImpl next = (org.exist.dom.DocumentImpl)i.next();
                long modified = next.getMetadata().getLastModified();
                if (now - modified >= 60000L) continue;
                removeCollection = false;
                break;
            }
        }
        if (removeCollection) {
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            try {
                this.removeCollection(transaction, temp);
                transact.commit(transaction);
            }
            catch (Exception e) {
                transact.abort(transaction);
                LOG.warn((Object)("Failed to remove temp collection: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeXMLResource(Txn transaction, org.exist.dom.DocumentImpl doc) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            VariableByteOutputStream ostream = new VariableByteOutputStream(8);
            doc.write(ostream);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(doc.getCollection().getId(), doc.getResourceType(), doc.getDocId());
            this.collectionsDb.put(transaction, (Value)key, ostream.data(), true);
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException while writing document data", (Throwable)e);
        }
        finally {
            lock.release(1);
        }
    }

    public void storeBinaryResource(final Txn transaction, final BinaryDocument blob, final byte[] data) {
        if (data.length == 0) {
            blob.setPage(-1L);
            return;
        }
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                DBBroker.LOG.debug((Object)("Storing binary resource " + blob.getFileURI()));
                blob.setPage(NativeBroker.this.domDb.addBinary(transaction, (org.exist.dom.DocumentImpl)blob, data));
                return null;
            }
        }.run();
    }

    public void storeBinaryResource(final Txn transaction, final BinaryDocument blob, final InputStream is) {
        if (is == null) {
            blob.setPage(-1L);
            return;
        }
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                DBBroker.LOG.debug((Object)("Storing binary resource as a stream " + blob.getFileURI()));
                blob.setPage(NativeBroker.this.domDb.addBinary(transaction, (org.exist.dom.DocumentImpl)blob, is));
                return null;
            }
        }.run();
    }

    public Document getXMLResource(XmldbURI fileName) throws PermissionDeniedException {
        fileName = this.prepend(fileName.toCollectionPathURI());
        XmldbURI collUri = fileName.removeLastSegment();
        XmldbURI docUri = fileName.lastSegment();
        Collection collection = this.getCollection(collUri);
        if (collection == null) {
            LOG.debug((Object)("collection '" + collUri + "' not found!"));
            return null;
        }
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Permission denied to read collection '" + collUri + "'");
        }
        org.exist.dom.DocumentImpl doc = collection.getDocument(this, docUri);
        if (doc == null) {
            LOG.debug((Object)("document '" + fileName + "' not found!"));
            return null;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.exist.dom.DocumentImpl getXMLResource(XmldbURI fileName, int lockMode) throws PermissionDeniedException {
        if (fileName == null) {
            return null;
        }
        fileName = this.prepend(fileName.toCollectionPathURI());
        XmldbURI collUri = fileName.removeLastSegment();
        XmldbURI docUri = fileName.lastSegment();
        Collection collection = this.openCollection(collUri, lockMode);
        if (collection == null) {
            LOG.debug((Object)("collection '" + collUri + "' not found!"));
            return null;
        }
        try {
            if (!collection.getPermissions().validate(this.user, 4)) {
                throw new PermissionDeniedException("Permission denied to read collection '" + collUri + "'");
            }
            org.exist.dom.DocumentImpl doc = collection.getDocumentWithLock(this, docUri, lockMode);
            if (doc == null) {
                org.exist.dom.DocumentImpl documentImpl = null;
                return documentImpl;
            }
            org.exist.dom.DocumentImpl documentImpl = doc;
            return documentImpl;
        }
        catch (LockException e) {
            LOG.warn((Object)("Could not acquire lock on document " + fileName), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(lockMode);
            }
        }
        return null;
    }

    public byte[] getBinaryResource(final BinaryDocument blob) {
        if (blob.getPage() == -1L) {
            return new byte[0];
        }
        byte[] data = (byte[])new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                return NativeBroker.this.domDb.getBinary(blob.getPage());
            }
        }.run();
        return data;
    }

    public void readBinaryResource(final BinaryDocument blob, final OutputStream os) {
        if (blob.getPage() == -1L) {
            return;
        }
        new DOMTransaction(this, this.domDb, 1){

            public Object start() throws ReadOnlyException {
                NativeBroker.this.domDb.readBinary(blob.getPage(), os);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCollectionResources(Collection collection) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(0);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(collection.getId());
            IndexQuery query = new IndexQuery(7, (Value)key);
            this.collectionsDb.query(query, new DocumentCallback(collection));
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException while reading document data", (Throwable)e);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"Exception while reading document data", (Throwable)e);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"Exception while reading document data", (Throwable)e);
        }
        finally {
            lock.release(0);
        }
    }

    public DocumentSet getXMLResourcesByDoctype(String doctypeName, DocumentSet result) {
        DocumentSet docs = this.getAllXMLResources(new DocumentSet());
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)i.next();
            DocumentType doctype = doc.getDoctype();
            if (doctype == null || !doctypeName.equals(doctype.getName()) || !doc.getCollection().getPermissions().validate(this.user, 4) || !doc.getPermissions().validate(this.user, 4)) continue;
            result.add(doc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentSet getAllXMLResources(DocumentSet docs) {
        long start = System.currentTimeMillis();
        Collection rootCollection = null;
        try {
            rootCollection = this.openCollection(XmldbURI.ROOT_COLLECTION_URI, 0);
            rootCollection.allDocs(this, docs, true, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getAllDocuments(DocumentSet) - end - loading " + docs.getLength() + " documents from " + docs.getCollectionCount() + "collections took " + (System.currentTimeMillis() - start) + "ms."));
            }
            DocumentSet documentSet = docs;
            return documentSet;
        }
        finally {
            if (rootCollection != null) {
                rootCollection.release(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getResourceMetadata(org.exist.dom.DocumentImpl document) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(0);
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(document.getCollection().getId(), document.getResourceType(), document.getDocId());
            VariableByteInput istream = this.collectionsDb.getAsStream(key);
            document.readDocumentMeta(istream);
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException while reading document data", (Throwable)e);
        }
        finally {
            lock.release(0);
        }
    }

    public void copyXMLResource(Txn transaction, org.exist.dom.DocumentImpl doc, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Insufficient privileges to copy resource " + doc.getFileURI());
        }
        if (!doc.getPermissions().validate(this.user, 4)) {
            throw new PermissionDeniedException("Insufficient privileges to copy resource " + doc.getFileURI());
        }
        if (newName == null) {
            newName = doc.getFileURI();
        }
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            if (this.getCollection(destination.getURI().append(newName)) != null) {
                throw new PermissionDeniedException("A resource can not replace an existing collection");
            }
            org.exist.dom.DocumentImpl oldDoc = destination.getDocument(this, newName);
            if (oldDoc != null) {
                if (doc.getDocId() == oldDoc.getDocId()) {
                    throw new PermissionDeniedException("Cannot copy resource to itself");
                }
                if (!destination.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (!oldDoc.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (oldDoc.getResourceType() == 1) {
                    destination.removeBinaryResource(transaction, (DBBroker)this, oldDoc);
                } else {
                    destination.removeXMLResource(transaction, this, oldDoc.getFileURI());
                }
            } else if (!destination.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getURI());
            }
            if (doc.getResourceType() == 1) {
                byte[] data = this.getBinaryResource((BinaryDocument)doc);
                destination.addBinaryResource(transaction, this, newName, data, doc.getMetadata().getMimeType());
            } else {
                org.exist.dom.DocumentImpl newDoc = new org.exist.dom.DocumentImpl(this, destination, newName);
                newDoc.copyOf(doc);
                newDoc.setDocId(this.getNextResourceId(transaction, destination));
                newDoc.setPermissions(doc.getPermissions());
                this.copyXMLResource(transaction, doc, newDoc);
                destination.addDocument(transaction, this, newDoc);
                this.storeXMLResource(transaction, newDoc);
            }
        }
        catch (EXistException e) {
            LOG.warn((Object)"An error occurred while copying resource", (Throwable)e);
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        finally {
            lock.release(1);
        }
    }

    private void copyXMLResource(Txn transaction, org.exist.dom.DocumentImpl oldDoc, org.exist.dom.DocumentImpl newDoc) {
        LOG.debug((Object)("Copying document " + oldDoc.getFileURI() + " to " + newDoc.getURI()));
        long start = System.currentTimeMillis();
        NodeList nodes = oldDoc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StoredNode node = (StoredNode)nodes.item(i);
            Iterator iterator = this.getNodeIterator(node);
            iterator.next();
            this.copyNodes(transaction, iterator, node, new NodePath(), newDoc, false, true);
        }
        this.flush();
        this.closeDocument();
        LOG.debug((Object)("Copy took " + (System.currentTimeMillis() - start) + "ms."));
    }

    public void moveXMLResource(Txn transaction, org.exist.dom.DocumentImpl doc, Collection destination, XmldbURI newName) throws PermissionDeniedException, LockException, IOException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        Collection collection = doc.getCollection();
        if (!collection.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move resource " + doc.getFileURI());
        }
        if (!doc.getPermissions().validate(this.user, 2)) {
            throw new PermissionDeniedException("Insufficient privileges to move resource " + doc.getFileURI());
        }
        User docUser = doc.getUserLock();
        if (docUser != null && !this.user.getName().equals(docUser.getName())) {
            throw new PermissionDeniedException("Cannot move '" + doc.getFileURI() + " because is locked by user '" + docUser.getName() + "'");
        }
        if (newName == null) {
            newName = doc.getFileURI();
        }
        try {
            if (this.getCollection(destination.getURI().append(newName)) != null) {
                throw new PermissionDeniedException("A resource can not replace an existing collection");
            }
            org.exist.dom.DocumentImpl oldDoc = destination.getDocument(this, newName);
            if (oldDoc != null) {
                if (doc.getDocId() == oldDoc.getDocId()) {
                    throw new PermissionDeniedException("Cannot move resource to itself");
                }
                if (!destination.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (!oldDoc.getPermissions().validate(this.user, 1)) {
                    throw new PermissionDeniedException("Resource with same name exists in target collection and update is denied");
                }
                if (oldDoc.getResourceType() == 1) {
                    destination.removeBinaryResource(transaction, (DBBroker)this, oldDoc);
                } else {
                    destination.removeXMLResource(transaction, this, oldDoc.getFileURI());
                }
            } else if (!destination.getPermissions().validate(this.user, 2)) {
                throw new PermissionDeniedException("Insufficient privileges on target collection " + destination.getURI());
            }
            boolean renameOnly = collection.getId() == destination.getId();
            collection.unlinkDocument(doc);
            this.removeResourceMetadata(transaction, doc);
            doc.setFileURI(newName);
            doc.setCollection(destination);
            if (doc.getResourceType() == 0) {
                if (!renameOnly) {
                    this.dropIndex(transaction, doc);
                    this.saveCollection(transaction, collection);
                }
                destination.addDocument(transaction, this, doc);
                if (!renameOnly) {
                    this.reindexXMLResource(transaction, doc, 1);
                }
            } else {
                destination.addDocument(transaction, this, doc);
            }
            this.storeXMLResource(transaction, doc);
            this.saveCollection(transaction, destination);
        }
        catch (TriggerException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(e.getMessage());
        }
    }

    public void removeXMLResource(final Txn transaction, final org.exist.dom.DocumentImpl document, boolean freeDocId) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Removing document " + document.getFileURI() + " (" + document.getDocId() + ") ..."));
            }
            this.dropIndex(transaction, document);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"removeDocument() - removing dom");
            }
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    StoredNode node = (StoredNode)document.getFirstChild();
                    NativeBroker.this.domDb.removeAll(transaction, node.getInternalAddress());
                    return null;
                }
            }.run();
            NodeRef ref = new NodeRef(document.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(transaction, idx, null);
                    }
                    catch (BTreeException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        DBBroker.LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            this.removeResourceMetadata(transaction, document);
            if (freeDocId) {
                this.freeResourceId(transaction, document.getDocId());
            }
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"removeDocument(String) - database is read-only");
        }
    }

    private void dropIndex(Txn transaction, org.exist.dom.DocumentImpl document) throws ReadOnlyException {
        this.indexController.setDocument(document, 1);
        StreamListener listener = this.indexController.getStreamListener();
        NodeList nodes = document.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StoredNode node = (StoredNode)nodes.item(i);
            Iterator iterator = this.getNodeIterator(node);
            iterator.next();
            this.scanNodes(transaction, iterator, node, new NodePath(), 2, listener);
        }
        this.notifyDropIndex(document);
        this.indexController.flush();
    }

    public void removeBinaryResource(final Txn transaction, final BinaryDocument blob) throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        LOG.info((Object)("removing binary resource " + blob.getDocId() + "..."));
        if (blob.getPage() != -1L) {
            new DOMTransaction(this, this.domDb, 1){

                public Object start() throws ReadOnlyException {
                    NativeBroker.this.domDb.removeOverflowValue(transaction, blob.getPage());
                    return null;
                }
            }.run();
        }
        this.removeResourceMetadata(transaction, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResourceMetadata(Txn transaction, org.exist.dom.DocumentImpl document) {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(0);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing resource metadata for " + document.getDocId()));
            }
            CollectionStore.DocumentKey key = new CollectionStore.DocumentKey(document.getCollection().getId(), document.getResourceType(), document.getDocId());
            this.collectionsDb.remove(transaction, key);
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY);
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()));
        }
        finally {
            lock.release(0);
        }
    }

    protected void freeResourceId(Txn transaction, int id) throws PermissionDeniedException {
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__free_doc_id");
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                byte[] ndata = new byte[data.length + 4];
                System.arraycopy(data, 0, ndata, 4, data.length);
                ByteConversion.intToByte(id, ndata, 0);
                this.collectionsDb.put(transaction, (Value)key, ndata, true);
            } else {
                byte[] data = new byte[4];
                ByteConversion.intToByte(id, data, 0);
                this.collectionsDb.put(transaction, (Value)key, data, true);
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
        }
        catch (ReadOnlyException e) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        finally {
            lock.release(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeResourceId(Txn transaction) throws ReadOnlyException {
        int freeDocId = -1;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__free_doc_id");
            Value value = this.collectionsDb.get(key);
            if (value != null) {
                byte[] data = value.getData();
                freeDocId = ByteConversion.byteToInt(data, data.length - 4);
                if (data.length - 4 > 0) {
                    byte[] ndata = new byte[data.length - 4];
                    System.arraycopy(data, 0, ndata, 0, ndata.length);
                    this.collectionsDb.put(transaction, (Value)key, ndata, true);
                } else {
                    this.collectionsDb.remove(transaction, key);
                }
            }
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            lock.release(1);
        }
        return freeDocId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextResourceId(Txn transaction, Collection collection) {
        int nextDocId;
        try {
            nextDocId = this.getFreeResourceId(transaction);
        }
        catch (ReadOnlyException e) {
            return 1;
        }
        if (nextDocId != -1) {
            return nextDocId;
        }
        nextDocId = 1;
        Lock lock = this.collectionsDb.getLock();
        try {
            lock.acquire(1);
            CollectionStore.CollectionKey key = new CollectionStore.CollectionKey("__next_doc_id");
            Value data = this.collectionsDb.get(key);
            if (data != null) {
                nextDocId = ByteConversion.byteToInt(data.getData(), 0);
                ++nextDocId;
            }
            byte[] d = new byte[4];
            ByteConversion.intToByte(nextDocId, d, 0);
            this.collectionsDb.put(transaction, (Value)key, d, true);
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)"Database is read-only");
            int n = -1;
            return n;
        }
        catch (LockException e) {
            LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
        }
        finally {
            lock.release(1);
        }
        return nextDocId;
    }

    private void reindexXMLResource(Txn transaction, org.exist.dom.DocumentImpl doc, int mode) {
        if ("collection.xconf".equals(doc.getFileURI())) {
            doc.getCollection().setConfigEnabled(false);
        }
        this.indexController.setDocument(doc, 0);
        StreamListener listener = this.indexController.getStreamListener();
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StoredNode node = (StoredNode)nodes.item(i);
            Iterator iterator = this.getNodeIterator(node);
            iterator.next();
            this.scanNodes(transaction, iterator, node, new NodePath(), mode, listener);
        }
        this.flush();
        if ("collection.xconf".equals(doc.getFileURI())) {
            doc.getCollection().setConfigEnabled(true);
        }
    }

    public void defragXMLResource(final Txn transaction, org.exist.dom.DocumentImpl doc) {
        LOG.debug((Object)("============> Defragmenting document " + doc.getCollection().getURI() + "/" + doc.getFileURI()));
        long start = System.currentTimeMillis();
        try {
            final long firstChild = doc.getFirstChildAddress();
            this.dropIndex(transaction, doc);
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.remove(transaction, idx, null);
                        NativeBroker.this.domDb.flush();
                    }
                    catch (BTreeException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (TerminatedException e) {
                        DBBroker.LOG.warn((Object)"method terminated", (Throwable)e);
                    }
                    catch (DBException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            org.exist.dom.DocumentImpl tempDoc = new org.exist.dom.DocumentImpl(this, doc.getCollection(), doc.getFileURI());
            tempDoc.copyOf(doc);
            tempDoc.setDocId(doc.getDocId());
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                StoredNode node = (StoredNode)nodes.item(i);
                Iterator iterator = this.getNodeIterator(node);
                iterator.next();
                this.copyNodes(transaction, iterator, node, new NodePath(), tempDoc, true, true);
            }
            this.flush();
            new DOMTransaction(this, this.domDb, 1){

                public Object start() {
                    NativeBroker.this.domDb.removeAll(transaction, firstChild);
                    try {
                        NativeBroker.this.domDb.flush();
                    }
                    catch (DBException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
            doc.copyChildren(tempDoc);
            doc.getMetadata().setSplitCount(0);
            doc.getMetadata().setPageCount(tempDoc.getMetadata().getPageCount());
            this.storeXMLResource(transaction, doc);
            this.closeDocument();
            LOG.debug((Object)("Defragmentation took " + (System.currentTimeMillis() - start) + "ms."));
        }
        catch (ReadOnlyException e) {
            LOG.warn((Object)DATABASE_IS_READ_ONLY, (Throwable)e);
        }
    }

    public void checkXMLResourceConsistency(org.exist.dom.DocumentImpl doc) throws EXistException {
        boolean xupdateConsistencyChecks = false;
        if (this.customProperties.get("xupdate.consistency-checks") != null) {
            xupdateConsistencyChecks = (Boolean)this.customProperties.get("xupdate.consistency-checks");
        }
        if (xupdateConsistencyChecks) {
            LOG.debug((Object)("Checking document " + doc.getFileURI()));
            this.checkXMLResourceTree(doc);
        }
    }

    public void checkXMLResourceTree(final org.exist.dom.DocumentImpl doc) {
        LOG.debug((Object)("Checking DOM tree for document " + doc.getFileURI()));
        boolean xupdateConsistencyChecks = false;
        if (this.customProperties.get("xupdate.consistency-checks") != null) {
            xupdateConsistencyChecks = (Boolean)this.customProperties.get("xupdate.consistency-checks");
        }
        if (xupdateConsistencyChecks) {
            new DOMTransaction(this, this.domDb, 0){

                public Object start() throws ReadOnlyException {
                    DBBroker.LOG.debug((Object)("Pages used: " + NativeBroker.this.domDb.debugPages(doc, false)));
                    return null;
                }
            }.run();
            NodeList nodes = doc.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                StoredNode node = (StoredNode)nodes.item(i);
                Iterator iterator = this.getNodeIterator(node);
                iterator.next();
                StringBuffer buf = new StringBuffer();
                if (this.checkNodeTree(iterator, node, buf)) continue;
                LOG.debug((Object)("node tree: " + buf.toString()));
                throw new RuntimeException("Error in document tree structure");
            }
            NodeRef ref = new NodeRef(doc.getDocId());
            final IndexQuery idx = new IndexQuery(7, (Value)ref);
            new DOMTransaction(this, this.domDb, 0){

                public Object start() {
                    try {
                        NativeBroker.this.domDb.findKeys(idx);
                    }
                    catch (BTreeException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    catch (IOException e) {
                        DBBroker.LOG.warn((Object)"start() - error while removing doc", (Throwable)e);
                    }
                    return null;
                }
            }.run();
        }
    }

    public void storeNode(final Txn transaction, final StoredNode node, NodePath currentPath, IndexSpec indexSpec, boolean fullTextIndex) {
        this.checkAvailableMemory();
        final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)node.getOwnerDocument();
        final short nodeType = node.getNodeType();
        final byte[] data = node.serialize();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() throws ReadOnlyException {
                long address = nodeType == 3 || nodeType == 2 || nodeType == 4 || node.getNodeId().getTreeLevel() > NativeBroker.this.defaultIndexDepth ? NativeBroker.this.domDb.add(transaction, data) : NativeBroker.this.domDb.put(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), data);
                if (address == -1L) {
                    DBBroker.LOG.warn((Object)"address is missing");
                }
                node.setInternalAddress(address);
                return null;
            }
        }.run();
        ++this.nodesCount;
        ByteArrayPool.releaseByteArray(data);
        this.nodeProcessor.reset(transaction, node, currentPath, indexSpec, fullTextIndex);
        this.nodeProcessor.doIndex();
    }

    public void updateNode(final Txn transaction, final StoredNode node, boolean reindex) {
        try {
            final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)node.getOwnerDocument();
            final long internalAddress = node.getInternalAddress();
            final byte[] data = node.serialize();
            new DOMTransaction(this, this.domDb, 1){

                public Object start() throws ReadOnlyException {
                    if (internalAddress != -1L) {
                        NativeBroker.this.domDb.update(transaction, internalAddress, data);
                    } else {
                        NativeBroker.this.domDb.update(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), data);
                    }
                    return null;
                }
            }.run();
            ByteArrayPool.releaseByteArray(data);
        }
        catch (Exception e) {
            Value oldVal = this.domDb.get(node.getInternalAddress());
            StoredNode old = StoredNode.deserialize(oldVal.data(), oldVal.start(), oldVal.getLength(), (org.exist.dom.DocumentImpl)node.getOwnerDocument(), false);
            LOG.warn((Object)("Exception while storing " + node.getNodeName() + "; gid = " + node.getNodeId() + "; old = " + old.getNodeName()), (Throwable)e);
        }
    }

    public void insertNodeAfter(final Txn transaction, final StoredNode previous, final StoredNode node) {
        final byte[] data = node.serialize();
        final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)previous.getOwnerDocument();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() {
                long address = previous.getInternalAddress();
                if (address != -1L) {
                    address = NativeBroker.this.domDb.insertAfter(transaction, doc, address, data);
                } else {
                    NodeRef ref = new NodeRef(doc.getDocId(), previous.getNodeId());
                    address = NativeBroker.this.domDb.insertAfter(transaction, doc, ref, data);
                }
                node.setInternalAddress(address);
                return null;
            }
        }.run();
    }

    private void copyNodes(Txn transaction, Iterator iterator, StoredNode node, NodePath currentPath, org.exist.dom.DocumentImpl newDoc, boolean defrag, boolean index) {
        this.copyNodes(transaction, iterator, node, currentPath, newDoc, defrag, index, null);
    }

    private void copyNodes(Txn transaction, Iterator iterator, StoredNode node, NodePath currentPath, org.exist.dom.DocumentImpl newDoc, boolean defrag, boolean index, NodeId oldNodeId) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getQName());
        }
        org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)node.getOwnerDocument();
        long oldAddress = node.getInternalAddress();
        node.setOwnerDocument(newDoc);
        node.setInternalAddress(-1L);
        this.storeNode(transaction, node, currentPath, null, index);
        if (defrag && oldNodeId != null) {
            this.pool.getNotificationService().notifyMove(oldNodeId, node);
        }
        if (node.getNodeType() == 1) {
            long address = node.getInternalAddress();
            node.setInternalAddress(oldAddress);
            this.endElement(node, currentPath, null);
            node.setInternalAddress(address);
            node.setDirty(false);
        }
        if (node.getNodeId().getTreeLevel() == 1) {
            newDoc.appendChild(node);
        }
        node.setOwnerDocument(doc);
        if (node.hasChildNodes()) {
            int count = node.getChildCount();
            NodeId nodeId = node.getNodeId();
            for (int i = 0; i < count; ++i) {
                StoredNode child = (StoredNode)iterator.next();
                oldNodeId = child.getNodeId();
                if (defrag) {
                    nodeId = i == 0 ? nodeId.newChild() : nodeId.nextSibling();
                    child.setNodeId(nodeId);
                }
                this.copyNodes(transaction, iterator, child, currentPath, newDoc, defrag, index, oldNodeId);
            }
        }
        if (node.getNodeType() == 1) {
            currentPath.removeLastComponent();
        }
    }

    public void removeNode(final Txn transaction, final StoredNode node, NodePath currentPath, String content) {
        final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)node.getOwnerDocument();
        new DOMTransaction(this, this.domDb, 1, doc){

            public Object start() {
                long address = node.getInternalAddress();
                if (address != -1L) {
                    NativeBroker.this.domDb.remove(transaction, new NodeRef(doc.getDocId(), node.getNodeId()), address);
                } else {
                    NativeBroker.this.domDb.remove(transaction, new NodeRef(doc.getDocId(), node.getNodeId()));
                }
                return null;
            }
        }.run();
        this.notifyRemoveNode(node, currentPath, content);
        NodeProxy p = new NodeProxy(node);
        switch (node.getNodeType()) {
            case 1: {
                QNameRangeIndexSpec qnSpec;
                QName qname = node.getQName();
                qname.setNameType((byte)0);
                this.elementIndex.setDocument(doc);
                this.elementIndex.addNode(qname, p);
                GeneralRangeIndexSpec spec1 = doc.getCollection().getIndexByPathConfiguration(this, currentPath);
                if (spec1 != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeElement((ElementImpl)node, content, spec1.getType(), (byte)0, false);
                }
                if ((qnSpec = doc.getCollection().getIndexByQNameConfiguration(this, qname)) == null) break;
                this.valueIndex.setDocument(doc);
                this.valueIndex.storeElement((ElementImpl)node, content, qnSpec.getType(), (byte)1, false);
                break;
            }
            case 2: {
                QNameRangeIndexSpec qnSpec;
                GeneralRangeIndexSpec spec2;
                QName qname = node.getQName();
                qname.setNameType((byte)1);
                currentPath.addComponent(qname);
                this.elementIndex.setDocument(doc);
                this.elementIndex.addNode(qname, p);
                if (((AttrImpl)node).getType() == 1) {
                    qname = new QName(((AttrImpl)node).getValue(), "", null);
                    qname.setNameType((byte)2);
                    this.elementIndex.addNode(qname, p);
                }
                if (((AttrImpl)node).getType() == 2) {
                    qname = new QName(((AttrImpl)node).getValue(), "", null);
                    qname.setNameType((byte)3);
                    this.elementIndex.addNode(qname, p);
                }
                if (((AttrImpl)node).getType() == 3) {
                    qname = new QName(((AttrImpl)node).getValue(), "", null);
                    qname.setNameType((byte)4);
                    this.elementIndex.addNode(qname, p);
                }
                if ((spec2 = doc.getCollection().getIndexByPathConfiguration(this, currentPath)) != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeAttribute((AttrImpl)node, null, 2, spec2, false);
                }
                if ((qnSpec = doc.getCollection().getIndexByQNameConfiguration(this, qname)) != null) {
                    this.valueIndex.setDocument(doc);
                    this.valueIndex.storeAttribute((AttrImpl)node, null, 2, qnSpec, false);
                }
                currentPath.removeLastComponent();
                break;
            }
        }
    }

    public void removeAllNodes(Txn transaction, StoredNode node, NodePath currentPath, StreamListener listener) {
        Iterator iterator = this.getNodeIterator(node);
        iterator.next();
        Stack stack = new Stack();
        this.collectNodesForRemoval(transaction, stack, iterator, listener, node, currentPath);
        while (!stack.isEmpty()) {
            RemovedNode next = (RemovedNode)stack.pop();
            this.removeNode(transaction, next.node, next.path, next.content);
        }
    }

    private void collectNodesForRemoval(Txn transaction, Stack stack, Iterator iterator, StreamListener listener, StoredNode node, NodePath currentPath) {
        RemovedNode removed;
        switch (node.getNodeType()) {
            case 1: {
                org.exist.dom.DocumentImpl doc = node.getDocument();
                String content = null;
                GeneralRangeIndexSpec spec = doc.getCollection().getIndexByPathConfiguration(this, currentPath);
                if (spec != null) {
                    content = this.getNodeValue(node, false);
                } else {
                    QNameRangeIndexSpec qnIdx = doc.getCollection().getIndexByQNameConfiguration(this, node.getQName());
                    if (qnIdx != null) {
                        content = this.getNodeValue(node, false);
                    }
                }
                removed = new RemovedNode(node, new NodePath(currentPath), content);
                stack.push(removed);
                if (listener != null) {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                }
                if (node.hasChildNodes()) {
                    int childCount = node.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        StoredNode child = (StoredNode)iterator.next();
                        if (child.getNodeType() == 1) {
                            currentPath.addComponent(child.getQName());
                        }
                        this.collectNodesForRemoval(transaction, stack, iterator, listener, child, currentPath);
                        if (child.getNodeType() != 1) continue;
                        currentPath.removeLastComponent();
                    }
                }
                if (listener == null) break;
                listener.endElement(transaction, (ElementImpl)node, currentPath);
                break;
            }
            case 3: {
                if (listener == null) break;
                listener.characters(transaction, (TextImpl)node, currentPath);
                break;
            }
            case 2: {
                if (listener == null) break;
                listener.attribute(transaction, (AttrImpl)node, currentPath);
            }
        }
        if (node.getNodeType() != 1) {
            removed = new RemovedNode(node, new NodePath(currentPath), null);
            stack.push(removed);
        }
    }

    public void indexNode(Txn transaction, StoredNode node, NodePath currentPath) {
        this.indexNode(transaction, node, currentPath, 0);
    }

    public void indexNode(Txn transaction, StoredNode node, NodePath currentPath, int repairMode) {
        this.elementIndex.setInUpdateMode(true);
        this.nodeProcessor.reset(transaction, node, currentPath, null, true);
        this.nodeProcessor.setMode(repairMode);
        this.nodeProcessor.index();
    }

    private boolean checkNodeTree(Iterator iterator, StoredNode node, StringBuffer buf) {
        if (buf != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(node.getNodeId());
        }
        boolean docIsValid = true;
        if (node.hasChildNodes()) {
            int count = node.getChildCount();
            if (buf != null) {
                buf.append('[').append(count).append(']');
            }
            StoredNode previous = null;
            for (int i = 0; i < count; ++i) {
                NodeId parentId;
                StoredNode child = (StoredNode)iterator.next();
                if (!(i <= 0 || child.getNodeId().isSiblingOf(previous.getNodeId()) && child.getNodeId().compareTo(previous.getNodeId()) > 0)) {
                    LOG.fatal((Object)("node " + child.getNodeId() + " cannot be a sibling of " + previous.getNodeId() + "; node read from " + StorageAddress.toString(child.getInternalAddress())));
                    docIsValid = false;
                }
                previous = child;
                if (child == null) {
                    LOG.fatal((Object)("child " + i + " not found for node: " + node.getNodeName() + ": " + node.getNodeId() + "; children = " + node.getChildCount()));
                    docIsValid = false;
                }
                if (!(parentId = child.getNodeId().getParentId()).equals(node.getNodeId())) {
                    LOG.fatal((Object)(child.getNodeId() + " is not a child of " + node.getNodeId()));
                    docIsValid = false;
                }
                boolean check = this.checkNodeTree(iterator, child, buf);
                if (!docIsValid) continue;
                docIsValid = check;
            }
        }
        return docIsValid;
    }

    private void scanNodes(Txn transaction, Iterator iterator, StoredNode node, NodePath currentPath, int mode, StreamListener listener) {
        if (node.getNodeType() == 1) {
            currentPath.addComponent(node.getQName());
        }
        this.indexNode(transaction, node, currentPath, mode);
        if (listener != null) {
            switch (node.getNodeType()) {
                case 3: {
                    listener.characters(transaction, (TextImpl)node, currentPath);
                    break;
                }
                case 1: {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                    break;
                }
                case 2: {
                    listener.attribute(transaction, (AttrImpl)node, currentPath);
                    break;
                }
                default: {
                    LOG.debug((Object)("Unhandled node type: " + node.getNodeType()));
                }
            }
        }
        if (node.hasChildNodes()) {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                StoredNode child = (StoredNode)iterator.next();
                if (child == null) {
                    LOG.fatal((Object)("child " + i + " not found for node: " + node.getNodeName() + "; children = " + node.getChildCount()));
                    throw new IllegalStateException("Wrong node id");
                }
                this.scanNodes(transaction, iterator, child, currentPath, mode, listener);
            }
        }
        if (node.getNodeType() == 1) {
            this.endElement(node, currentPath, null, mode == 2);
            if (listener != null) {
                listener.endElement(transaction, (ElementImpl)node, currentPath);
            }
            currentPath.removeLastComponent();
        }
    }

    public String getNodeValue(final StoredNode node, final boolean addWhitespace) {
        return (String)new DOMTransaction(this, this.domDb, 0){

            public Object start() {
                return NativeBroker.this.domDb.getNodeValue(node, addWhitespace);
            }
        }.run();
    }

    public StoredNode objectWith(final Document doc, final NodeId nodeId) {
        return (StoredNode)new DOMTransaction(this, this.domDb, 0){

            public Object start() {
                Value val = NativeBroker.this.domDb.get(new NodeProxy((org.exist.dom.DocumentImpl)doc, nodeId));
                if (val == null) {
                    if (DBBroker.LOG.isDebugEnabled()) {
                        DBBroker.LOG.debug((Object)("Node " + nodeId + " not found"));
                    }
                    return null;
                }
                StoredNode node = StoredNode.deserialize(val.getData(), 0, val.getLength(), (org.exist.dom.DocumentImpl)doc);
                node.setOwnerDocument((org.exist.dom.DocumentImpl)doc);
                node.setInternalAddress(val.getAddress());
                return node;
            }
        }.run();
    }

    public StoredNode objectWith(final NodeProxy p) {
        if (p.getInternalAddress() == -1L) {
            return this.objectWith(p.getDocument(), p.getNodeId());
        }
        return (StoredNode)new DOMTransaction(this, this.domDb, 0){

            public Object start() {
                Value val = NativeBroker.this.domDb.get(p.getInternalAddress());
                if (val == null) {
                    DBBroker.LOG.debug((Object)("Node " + p.getNodeId() + " not found in document " + p.getDocument().getURI() + "; docId = " + p.getDocument().getDocId() + ": " + StorageAddress.toString(p.getInternalAddress())));
                    return NativeBroker.this.objectWith(p.getDocument(), p.getNodeId());
                }
                StoredNode node = StoredNode.deserialize(val.getData(), 0, val.getLength(), p.getDocument());
                node.setOwnerDocument((org.exist.dom.DocumentImpl)p.getOwnerDocument());
                node.setInternalAddress(p.getInternalAddress());
                return node;
            }
        }.run();
    }

    public void repair() throws PermissionDeniedException {
        if (this.readOnly) {
            throw new PermissionDeniedException(DATABASE_IS_READ_ONLY);
        }
        LOG.info((Object)"Removing index files ...");
        this.notifyCloseAndRemove();
        try {
            this.pool.getIndexManager().removeIndexes();
        }
        catch (DBException e) {
            LOG.warn((Object)("Failed to remove index failes during repair: " + e.getMessage()), (Throwable)e);
        }
        LOG.info((Object)"Recreating index files ...");
        try {
            this.elementIndex = new NativeElementIndex(this, 1, this.dataDir, this.config);
            this.valueIndex = new NativeValueIndex(this, 2, this.dataDir, this.config);
        }
        catch (DBException e) {
            LOG.warn((Object)("Exception during repair: " + e.getMessage()), (Throwable)e);
        }
        try {
            this.pool.getIndexManager().reopenIndexes();
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn((Object)("Failed to reopen index files after repair: " + e.getMessage()), (Throwable)e);
        }
        this.initIndexModules();
        LOG.info((Object)"Reindexing database files ...");
        this.reindexCollection(null, this.getCollection(XmldbURI.ROOT_COLLECTION_URI), 1);
    }

    public void flush() {
        this.notifyFlush();
        try {
            this.symbols.flush();
        }
        catch (EXistException e) {
            LOG.warn((Object)e);
        }
        this.indexController.flush();
        this.nodesCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(int syncEvent) {
        block8: {
            if (this.isReadOnly()) {
                return;
            }
            try {
                new DOMTransaction(this, this.domDb, 1){

                    public Object start() {
                        try {
                            NativeBroker.this.domDb.flush();
                        }
                        catch (DBException e) {
                            DBBroker.LOG.warn((Object)"error while flushing dom.dbx", (Throwable)e);
                        }
                        return null;
                    }
                }.run();
                if (syncEvent != 1) break block8;
                Lock lock = this.collectionsDb.getLock();
                try {
                    lock.acquire(1);
                    this.collectionsDb.flush();
                }
                catch (LockException e) {
                    LOG.warn((Object)("Failed to acquire lock on " + this.collectionsDb.getFile().getName()), (Throwable)e);
                }
                finally {
                    lock.release(1);
                }
                this.notifySync();
                this.pool.getIndexManager().sync();
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.info((Object)("Memory: " + nf.format(this.run.totalMemory() / 1024L) + "K total; " + nf.format(this.run.maxMemory() / 1024L) + "K max; " + nf.format(this.run.freeMemory() / 1024L) + "K free"));
                this.domDb.printStatistics();
                this.collectionsDb.printStatistics();
                this.notifyPrintStatistics();
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
                LOG.warn((Object)dbe);
            }
        }
    }

    public void shutdown() {
        try {
            this.flush();
            this.sync(1);
            this.domDb.close();
            this.collectionsDb.close();
            this.notifyClose();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        super.shutdown();
    }

    public void checkAvailableMemory() {
        if (this.nodesCount > 500) {
            if (this.run.totalMemory() >= this.run.maxMemory() && this.run.freeMemory() < this.pool.getReservedMem()) {
                this.flush();
                System.gc();
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.info((Object)("total memory: " + nf.format(this.run.totalMemory()) + "; free: " + nf.format(this.run.freeMemory())));
            }
            this.nodesCount = 0;
        }
    }

    public void closeDocument() {
        new DOMTransaction(this, this.domDb, 1){

            public Object start() {
                NativeBroker.this.domDb.closeDocument();
                return null;
            }
        }.run();
    }

    private final class DocumentCallback
    implements BTreeCallback {
        private Collection collection;

        public DocumentCallback(Collection collection) {
            this.collection = collection;
        }

        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            try {
                byte type = key.data()[key.start() + Collection.LENGTH_COLLECTION_ID + org.exist.dom.DocumentImpl.LENGTH_DOCUMENT_TYPE];
                VariableByteInput istream = NativeBroker.this.collectionsDb.getAsStream(pointer);
                org.exist.dom.DocumentImpl doc = null;
                doc = type == 1 ? new BinaryDocument((DBBroker)NativeBroker.this, this.collection) : new org.exist.dom.DocumentImpl((DBBroker)NativeBroker.this, this.collection);
                doc.read(istream);
                this.collection.addDocument(null, NativeBroker.this, doc);
            }
            catch (EOFException e) {
                DBBroker.LOG.warn((Object)"EOFException while reading document data", (Throwable)e);
            }
            catch (IOException e) {
                DBBroker.LOG.warn((Object)"IOException while reading document data", (Throwable)e);
            }
            return true;
        }
    }

    private class NodeProcessor {
        static final int MODE_STORE = 0;
        static final int MODE_REPAIR = 1;
        static final int MODE_REMOVE = 2;
        private Txn transaction;
        private StoredNode node;
        private NodePath currentPath;
        private org.exist.dom.DocumentImpl doc;
        private long address;
        private IndexSpec idxSpec;
        private FulltextIndexSpec ftIdx;
        private int level;
        private int mode = 0;
        private boolean fullTextIndex = true;

        NodeProcessor() {
        }

        public void reset(Txn transaction, StoredNode node, NodePath currentPath, IndexSpec indexSpec, boolean fullTextIndex) {
            if (node.getNodeId() == null) {
                DBBroker.LOG.warn((Object)("illegal node: " + node.getNodeName()));
            }
            this.transaction = transaction;
            this.node = node;
            this.currentPath = currentPath;
            this.mode = 0;
            this.doc = (org.exist.dom.DocumentImpl)node.getOwnerDocument();
            this.address = node.getInternalAddress();
            if (indexSpec == null) {
                indexSpec = this.doc.getCollection().getIndexConfiguration(NativeBroker.this);
            }
            this.idxSpec = indexSpec;
            this.ftIdx = this.idxSpec == null ? null : this.idxSpec.getFulltextIndexSpec();
            this.level = node.getNodeId().getTreeLevel();
            this.fullTextIndex = fullTextIndex;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public void doIndex() {
            boolean isTemp = XmldbURI.TEMP_COLLECTION_URI.equalsInternal(((org.exist.dom.DocumentImpl)this.node.getOwnerDocument()).getCollection().getURI());
            switch (this.node.getNodeType()) {
                case 1: {
                    QNameRangeIndexSpec qnIdx;
                    int indexType = 0;
                    if (this.idxSpec != null && this.idxSpec.getIndexByPath(this.currentPath) != null) {
                        indexType |= this.idxSpec.getIndexByPath(this.currentPath).getIndexType();
                    }
                    if (this.ftIdx == null || this.currentPath == null || this.ftIdx.match(this.currentPath)) {
                        indexType |= 0x80;
                    }
                    if (this.ftIdx != null && this.currentPath != null && this.ftIdx.matchMixedElement(this.currentPath)) {
                        indexType |= 0x20;
                    }
                    if (this.node.getChildCount() - this.node.getAttributesCount() > 1) {
                        indexType |= 0x40;
                    }
                    if (this.idxSpec != null && (qnIdx = this.idxSpec.getIndexByQName(this.node.getQName())) != null && !RangeIndexSpec.hasRangeIndex(indexType |= 0x10)) {
                        indexType |= qnIdx.getIndexType();
                    }
                    ((ElementImpl)this.node).setIndexType(indexType);
                    if (this.mode == 2) break;
                    NodeProxy p = new NodeProxy(this.node);
                    p.setIndexType(indexType);
                    NativeBroker.this.elementIndex.setDocument(this.doc);
                    NativeBroker.this.elementIndex.addNode(this.node.getQName(), p);
                    break;
                }
                case 2: {
                    QName qname = this.node.getQName();
                    if (this.currentPath != null) {
                        this.currentPath.addComponent(qname);
                    }
                    boolean fullTextIndexing = false;
                    int indexType = 0;
                    if (this.fullTextIndex && (this.ftIdx == null || this.currentPath == null || this.ftIdx.matchAttribute(this.currentPath))) {
                        indexType |= 0x80;
                        fullTextIndexing = true;
                    }
                    if (this.idxSpec != null) {
                        QNameRangeIndexSpec qnIdx;
                        GeneralRangeIndexSpec rangeSpec = this.idxSpec.getIndexByPath(this.currentPath);
                        if (rangeSpec != null) {
                            indexType |= rangeSpec.getIndexType();
                        }
                        if (rangeSpec != null) {
                            NativeBroker.this.valueIndex.setDocument((org.exist.dom.DocumentImpl)this.node.getOwnerDocument());
                            NativeBroker.this.valueIndex.storeAttribute((AttrImpl)this.node, this.currentPath, 2, rangeSpec, this.mode == 2);
                        }
                        if ((qnIdx = this.idxSpec.getIndexByQName(this.node.getQName())) != null) {
                            if (!RangeIndexSpec.hasRangeIndex(indexType |= 0x10)) {
                                indexType |= qnIdx.getIndexType();
                            }
                            NativeBroker.this.valueIndex.setDocument((org.exist.dom.DocumentImpl)this.node.getOwnerDocument());
                            NativeBroker.this.valueIndex.storeAttribute((AttrImpl)this.node, this.currentPath, 2, qnIdx, this.mode == 2);
                        }
                    }
                    NativeBroker.this.elementIndex.setDocument(this.doc);
                    NodeProxy tempProxy = new NodeProxy(this.doc, this.node.getNodeId(), this.address);
                    tempProxy.setIndexType(indexType);
                    qname.setNameType((byte)1);
                    if (this.mode != 2) {
                        NativeBroker.this.elementIndex.addNode(qname, tempProxy);
                    }
                    if (((AttrImpl)this.node).getType() == 1) {
                        qname = new QName(((AttrImpl)this.node).getValue(), "", null);
                        qname.setNameType((byte)2);
                        NativeBroker.this.elementIndex.addNode(qname, tempProxy);
                    }
                    if (((AttrImpl)this.node).getType() == 2) {
                        qname = new QName(((AttrImpl)this.node).getValue(), "", null);
                        qname.setNameType((byte)3);
                        NativeBroker.this.elementIndex.addNode(qname, tempProxy);
                    }
                    if (((AttrImpl)this.node).getType() == 3) {
                        qname = new QName(((AttrImpl)this.node).getValue(), "", null);
                        qname.setNameType((byte)4);
                        NativeBroker.this.elementIndex.addNode(qname, tempProxy);
                    }
                    if (this.currentPath == null) break;
                    this.currentPath.removeLastComponent();
                    break;
                }
                case 3: {
                    NativeBroker.this.notifyStoreText((TextImpl)this.node, this.currentPath, this.fullTextIndex ? NativeTextEngine.DO_NOT_TOKENIZE : NativeTextEngine.TOKENIZE);
                }
            }
        }

        public void store() {
            final org.exist.dom.DocumentImpl doc = (org.exist.dom.DocumentImpl)this.node.getOwnerDocument();
            if (this.mode == 0 && this.node.getNodeType() == 1 && this.level <= NativeBroker.this.defaultIndexDepth) {
                new DOMTransaction(NativeBroker.this, NativeBroker.this.domDb, 1){

                    public Object start() throws ReadOnlyException {
                        try {
                            ((NodeProcessor)NodeProcessor.this).NativeBroker.this.domDb.addValue(NodeProcessor.this.transaction, new NodeRef(doc.getDocId(), NodeProcessor.this.node.getNodeId()), NodeProcessor.this.address);
                        }
                        catch (BTreeException e) {
                            DBBroker.LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                        }
                        catch (IOException e) {
                            DBBroker.LOG.warn((Object)NativeBroker.EXCEPTION_DURING_REINDEX, (Throwable)e);
                        }
                        return null;
                    }
                }.run();
            }
        }

        private void checkAvailableMemory() {
            if (this.mode != 2 && NativeBroker.this.nodesCount > 500) {
                if (NativeBroker.this.run.totalMemory() >= NativeBroker.this.run.maxMemory() && NativeBroker.this.run.freeMemory() < NativeBroker.this.pool.getReservedMem()) {
                    NativeBroker.this.flush();
                    System.gc();
                    DBBroker.LOG.info((Object)("total memory: " + NativeBroker.this.run.totalMemory() + "; free: " + NativeBroker.this.run.freeMemory()));
                }
                NativeBroker.this.nodesCount = 0;
            }
        }

        public void index() {
            ++NativeBroker.this.nodesCount;
            this.checkAvailableMemory();
            this.doIndex();
            this.store();
        }
    }

    private static final class RemovedNode {
        StoredNode node;
        String content;
        NodePath path;

        RemovedNode(StoredNode node, NodePath path, String content) {
            this.node = node;
            this.path = path;
            this.content = content;
        }
    }

    public static final class NodeRef
    extends Value {
        public static int OFFSET_DOCUMENT_ID = 0;
        public static int OFFSET_NODE_ID = OFFSET_DOCUMENT_ID + org.exist.dom.DocumentImpl.LENGTH_DOCUMENT_ID;

        public NodeRef(int docId) {
            this.len = org.exist.dom.DocumentImpl.LENGTH_DOCUMENT_ID;
            this.data = new byte[this.len];
            ByteConversion.intToByte(docId, this.data, OFFSET_DOCUMENT_ID);
            this.pos = OFFSET_DOCUMENT_ID;
        }

        public NodeRef(int docId, NodeId nodeId) {
            this.len = org.exist.dom.DocumentImpl.LENGTH_DOCUMENT_ID + nodeId.size();
            this.data = new byte[this.len];
            ByteConversion.intToByte(docId, this.data, OFFSET_DOCUMENT_ID);
            nodeId.serialize(this.data, OFFSET_NODE_ID);
            this.pos = OFFSET_DOCUMENT_ID;
        }

        int getDocId() {
            return ByteConversion.byteToInt(this.data, OFFSET_DOCUMENT_ID);
        }
    }
}

