/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Delete
extends AbstractWebDAVMethod {
    public Delete(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(path, 1);
            if (collection == null) {
                XmldbURI collName = path.removeLastSegment();
                XmldbURI docName = path.lastSegment();
                LOG.debug((Object)("collection = " + collName + "; doc = " + docName));
                collection = broker.openCollection(collName, 1);
                if (collection == null) {
                    transact.abort(txn);
                    LOG.debug((Object)("No resource or collection found for path: " + path));
                    response.sendError(404, "No resource or collection found");
                    return;
                }
                resource = collection.getDocument(broker, docName);
                if (resource == null) {
                    LOG.debug((Object)("No resource found for path: " + path));
                    transact.abort(txn);
                    response.sendError(404, "No resource or collection found");
                    return;
                }
            }
            if (!collection.getPermissions().validate(user, 4)) {
                LOG.debug((Object)"Permission denied to read collection");
                transact.abort(txn);
                response.sendError(403);
                return;
            }
            if (resource == null) {
                broker.removeCollection(txn, collection);
            } else if (resource.getResourceType() == 1) {
                collection.removeBinaryResource(txn, broker, resource.getFileURI());
            } else {
                collection.removeXMLResource(txn, broker, resource.getFileURI());
            }
            transact.commit(txn);
        }
        catch (EXistException e) {
            transact.abort(txn);
            response.sendError(500, e.getMessage());
        }
        catch (PermissionDeniedException e) {
            transact.abort(txn);
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            transact.abort(txn);
            response.sendError(409, e.getMessage());
        }
        catch (TriggerException e) {
            transact.abort(txn);
            response.sendError(409, e.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(1);
            }
            this.pool.release(broker);
        }
        response.setStatus(204);
    }
}

