/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.exist.dom.AbstractNodeSet;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualNodeSet
extends AbstractNodeSet {
    protected int axis = -1;
    protected NodeTest test;
    protected NodeSet context;
    protected NodeSet realSet = null;
    protected boolean realSetIsComplete = false;
    protected boolean inPredicate = false;
    protected boolean useSelfAsContext = false;
    protected int contextId = -1;
    private static final int MAX_CHILD_COUNT_FOR_OPTIMIZE = 5;
    private DocumentSet realDocumentSet = null;
    private boolean knownIsEmptyCardinality = false;
    private boolean knownHasOneCardinality = false;
    private boolean knownHasManyCardinality = false;
    protected boolean hasMany = false;

    public VirtualNodeSet(int axis, NodeTest test, int contextId, NodeSet context) {
        this.isEmpty = true;
        this.hasOne = false;
        this.axis = axis;
        this.test = test;
        this.context = context;
        this.contextId = contextId;
    }

    public boolean contains(NodeProxy p) {
        NodeProxy firstParent = this.getFirstParent(p, null, this.axis == 12, 0);
        return firstParent != null;
    }

    public void setInPredicate(boolean predicate) {
        this.inPredicate = predicate;
    }

    public DocumentSet getDocumentSet() {
        if (this.realDocumentSet != null) {
            return this.realDocumentSet;
        }
        return this.context.getDocumentSet();
    }

    public Iterator getCollectionIterator() {
        return this.context.getCollectionIterator();
    }

    private NodeProxy getFirstParent(NodeProxy self, NodeProxy firstParent, boolean includeSelf, int recursions) {
        return this.getFirstParent(self, firstParent, includeSelf, true, recursions);
    }

    private NodeProxy getFirstParent(NodeProxy self, NodeProxy candidateFirstParent, boolean includeSelf, boolean restrictToDirectParent, int recursions) {
        NodeProxy parent;
        NodeId parentOfSelfId = self.getNodeId().getParentId();
        if (recursions == 0 && includeSelf && this.test.matches(self)) {
            if (this.axis == 5) {
                parent = this.context.get(self.getDocument(), parentOfSelfId);
                if (parent != null) {
                    self.copyContext(parent);
                    if (this.useSelfAsContext && this.inPredicate) {
                        self.addContextNode(this.contextId, self);
                    } else if (this.inPredicate) {
                        self.addContextNode(this.contextId, parent);
                    }
                    return self;
                }
            } else {
                candidateFirstParent = self;
            }
        }
        if (candidateFirstParent == null) {
            if (parentOfSelfId == NodeId.DOCUMENT_NODE) {
                return null;
            }
            candidateFirstParent = new NodeProxy(self.getDocument(), parentOfSelfId, 1);
            if (this.axis == 8 && (parent = this.context.get(candidateFirstParent.getDocument(), parentOfSelfId)) != null && this.test.matches(parent)) {
                candidateFirstParent.copyContext(parent);
                if (this.useSelfAsContext && this.inPredicate) {
                    candidateFirstParent.addContextNode(this.contextId, candidateFirstParent);
                } else if (this.inPredicate) {
                    candidateFirstParent.addContextNode(this.contextId, parent);
                }
                return candidateFirstParent;
            }
            return this.getFirstParent(candidateFirstParent, candidateFirstParent, false, restrictToDirectParent, recursions + 1);
        }
        NodeProxy parentOfSelf = this.context.get(self.getDocument(), parentOfSelfId);
        if (parentOfSelf != null && this.test.matches(self)) {
            if (this.axis != 5) {
                self = candidateFirstParent;
            }
            self.copyContext(parentOfSelf);
            if (this.useSelfAsContext && this.inPredicate) {
                self.addContextNode(this.contextId, self);
            } else if (this.inPredicate) {
                self.addContextNode(this.contextId, parentOfSelf);
            }
            return self;
        }
        if (parentOfSelfId == NodeId.DOCUMENT_NODE) {
            return null;
        }
        if (restrictToDirectParent && this.axis == 5 && recursions == 1) {
            return null;
        }
        parentOfSelf = new NodeProxy(self.getDocument(), parentOfSelfId, 1);
        return this.getFirstParent(parentOfSelf, candidateFirstParent, false, false, recursions + 1);
    }

    private void addInternal(NodeProxy p) {
        if (this.realSet == null) {
            this.realSet = new ExtArrayNodeSet(256);
        }
        this.realSet.add(p);
        this.knownIsEmptyCardinality = true;
        this.knownHasOneCardinality = true;
        this.knownHasManyCardinality = true;
        this.isEmpty = this.realSet.isEmpty();
        this.hasOne = this.realSet.hasOne();
        this.hasMany = !this.isEmpty && !this.hasOne;
        this.realDocumentSet = null;
        this.realSetIsComplete = false;
    }

    public NodeProxy parentWithChild(NodeProxy proxy, boolean restrictToDirectParent, boolean includeSelf, int level) {
        NodeProxy first = this.getFirstParent(proxy, null, includeSelf, restrictToDirectParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean restrictToDirectParent, boolean includeSelf) {
        NodeProxy first = this.getFirstParent(new NodeProxy(doc, nodeId), null, includeSelf, restrictToDirectParent, 0);
        if (first != null) {
            this.addInternal(first);
        }
        return first;
    }

    private final NodeSet getNodes() {
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator i = this.context.iterator();
        while (i.hasNext()) {
            NodeProxy proxy = (NodeProxy)i.next();
            if (proxy.getNodeId() == NodeId.DOCUMENT_NODE) {
                if (proxy.getDocument().getResourceType() == 1) continue;
                if (this.test.matches(proxy) && (this.axis == 12 || this.axis == 1 || this.axis == 8)) {
                    result.add(proxy);
                }
                NodeList cl = proxy.getDocument().getChildNodes();
                for (int j = 0; j < cl.getLength(); ++j) {
                    StoredNode node = (StoredNode)cl.item(j);
                    NodeProxy p = new NodeProxy(node);
                    if (this.test.matches(p)) {
                        if (this.useSelfAsContext && this.inPredicate) {
                            p.addContextNode(this.contextId, p);
                        }
                        result.add(p);
                    }
                    if (node.getNodeType() == 1 && (this.axis == 7 || this.axis == 8 || this.axis == 13)) {
                        NodeProxy contextNode = new NodeProxy(p);
                        contextNode.deepCopyContext(proxy);
                        Iterator domIter = contextNode.getDocument().getBroker().getNodeIterator(new StoredNode(contextNode));
                        domIter.next();
                        contextNode.setMatches(proxy.getMatches());
                        this.addChildren(contextNode, result, node, domIter, 0);
                    }
                    if (node.getNodeType() != 7 || this.axis != 5 && this.axis != 7 && this.axis != 8 && this.axis != 12 && this.axis != 3 && this.axis != 9 || !this.test.matches(node)) continue;
                    result.add(p);
                }
                continue;
            }
            if (this.test.matches(proxy) && (this.axis == 12 || this.axis == 1 || this.axis == 8)) {
                if (this.useSelfAsContext && this.inPredicate) {
                    proxy.addContextNode(this.contextId, proxy);
                }
                result.add(proxy);
            }
            if (this.test.getType() == 4 || this.test.getType() == 5 || this.test.getType() == 501) {
                DocumentImpl doc = proxy.getDocument();
                if (this.axis == 3) {
                    StoredNode ps = (StoredNode)doc.getFirstChild();
                    StoredNode pe = (StoredNode)((Object)doc.getDocumentElement());
                    while (ps != null && !ps.equals(pe)) {
                        if (this.test.matches(ps)) {
                            result.add(new NodeProxy(ps));
                        }
                        ps = (StoredNode)doc.getFollowingSibling(ps);
                    }
                }
                if (this.axis == 9) {
                    StoredNode pe = (StoredNode)((Object)doc.getDocumentElement());
                    StoredNode pf = (StoredNode)doc.getFollowingSibling(pe);
                    while (pf != null) {
                        if (this.test.matches(pf)) {
                            result.add(new NodeProxy(pf));
                        }
                        pf = (StoredNode)doc.getFollowingSibling(pf);
                    }
                }
                if (this.axis == 12 || this.axis == 1 || this.axis == 8) {
                    result.add(proxy);
                }
            }
            if (this.axis == 12) continue;
            Iterator domIter = proxy.getDocument().getBroker().getNodeIterator(new StoredNode(proxy));
            StoredNode node = (StoredNode)domIter.next();
            node.setOwnerDocument(proxy.getDocument());
            node.setNodeId(proxy.getNodeId());
            this.addChildren(proxy, result, node, domIter, 0);
        }
        this.realDocumentSet = result.getDocumentSet();
        return result;
    }

    private final void addChildren(NodeProxy contextNode, NodeSet result, StoredNode node, Iterator iter, int recursions) {
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                StoredNode child = (StoredNode)iter.next();
                if (child == null) {
                    LOG.debug((Object)("CHILD == NULL; doc = " + ((DocumentImpl)node.getOwnerDocument()).getURI()));
                }
                if (node.getOwnerDocument() == null) {
                    LOG.debug((Object)"DOC == NULL");
                }
                child.setOwnerDocument((DocumentImpl)node.getOwnerDocument());
                NodeProxy p = new NodeProxy(child);
                p.setMatches(contextNode.getMatches());
                if (this.test.matches(child) && ((this.axis == 5 || this.axis == 6) && recursions == 0 || this.axis == 7 || this.axis == 8 || this.axis == 13)) {
                    p.deepCopyContext(contextNode);
                    if (this.useSelfAsContext && this.inPredicate) {
                        p.addContextNode(this.contextId, p);
                    } else if (this.inPredicate) {
                        p.addContextNode(this.contextId, contextNode);
                    }
                    result.add(p);
                }
                this.addChildren(contextNode, result, child, iter, recursions + 1);
            }
        }
    }

    public final void realize() {
        if (this.realSet != null && this.realSetIsComplete) {
            return;
        }
        this.realSet = this.getNodes();
        this.knownIsEmptyCardinality = true;
        this.knownHasOneCardinality = true;
        this.knownHasManyCardinality = true;
        this.isEmpty = this.realSet.isEmpty();
        this.hasOne = this.realSet.hasOne();
        this.hasMany = this.realSet.hasMany();
        this.realSetIsComplete = true;
    }

    public boolean preferTreeTraversal() {
        int docs;
        if (this.realSet != null && this.realSetIsComplete) {
            return true;
        }
        if (this.axis != 5) {
            return false;
        }
        int contextLen = this.context.getLength();
        if (contextLen > (docs = this.context.getDocumentSet().getLength()) * 5) {
            return false;
        }
        NodeSetIterator i = this.context.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            if (p.getNodeId() == NodeId.DOCUMENT_NODE) {
                return false;
            }
            NodeImpl n = (NodeImpl)p.getNode();
            if (n.getNodeType() != 1 || n.getChildCount() <= 5) continue;
            return false;
        }
        return true;
    }

    public void setSelfIsContext() {
        this.useSelfAsContext = true;
    }

    public void setContextId(int contextId) {
        this.contextId = contextId;
    }

    public boolean hasIndex() {
        return false;
    }

    public boolean isEmpty() {
        if (this.knownIsEmptyCardinality) {
            return this.isEmpty;
        }
        return this.getLength() == 0;
    }

    public boolean hasOne() {
        if (this.knownHasOneCardinality) {
            return this.hasOne;
        }
        return this.getLength() == 1;
    }

    public boolean hasMany() {
        if (this.knownHasManyCardinality) {
            return this.hasMany;
        }
        return this.getLength() > 1;
    }

    public void add(DocumentImpl doc, long nodeId) {
    }

    public void add(Node node) {
    }

    public void add(NodeProxy proxy) {
    }

    public void addAll(NodeList other) {
    }

    public void addAll(NodeSet other) {
    }

    public void set(int position, DocumentImpl doc, long nodeId) {
    }

    public void remove(NodeProxy node) {
    }

    public int getLength() {
        this.realize();
        return this.realSet.getLength();
    }

    public int getItemCount() {
        this.realize();
        return this.realSet.getItemCount();
    }

    public Node item(int pos) {
        this.realize();
        return this.realSet.item(pos);
    }

    public NodeProxy get(int pos) {
        this.realize();
        return this.realSet.get(pos);
    }

    public Item itemAt(int pos) {
        this.realize();
        return this.realSet.itemAt(pos);
    }

    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.realize();
        return this.realSet.get(doc, nodeId);
    }

    public NodeProxy get(NodeProxy proxy) {
        this.realize();
        return this.realSet.get(proxy);
    }

    public NodeSetIterator iterator() {
        this.realize();
        return this.realSet.iterator();
    }

    public SequenceIterator iterate() throws XPathException {
        this.realize();
        return this.realSet.iterate();
    }

    public SequenceIterator unorderedIterator() {
        this.realize();
        return this.realSet.unorderedIterator();
    }

    public NodeSet intersection(NodeSet other) {
        this.realize();
        return this.realSet.intersection(other);
    }

    public NodeSet union(NodeSet other) {
        this.realize();
        return this.realSet.union(other);
    }

    public NodeSet filterDocuments(NodeSet otherSet) {
        return this;
    }

    public void clearContext() {
    }

    public String toString() {
        if (this.realSet == null) {
            return "Virtual#unknown";
        }
        StringBuffer result = new StringBuffer();
        return result.toString();
    }
}

