/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import org.exist.dom.CharacterDataImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteConversion;
import org.exist.util.pool.NodePool;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public class CommentImpl
extends CharacterDataImpl
implements Comment {
    public CommentImpl() {
        super((short)8);
    }

    public CommentImpl(String data) {
        super((short)8, data);
    }

    public CommentImpl(char[] data, int start, int howmany) {
        super((short)8, data, start, howmany);
    }

    public String getLocalName() {
        return "";
    }

    public String getNamespaceURI() {
        return "";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<!-- ");
        buf.append(this.cdata.toString());
        buf.append(" -->");
        return buf.toString();
    }

    public byte[] serialize() {
        byte[] cd;
        String s;
        try {
            s = StringValue.expand(this.cdata);
        }
        catch (XPathException e) {
            LOG.warn((Object)e);
            s = this.cdata.toString();
        }
        try {
            cd = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            cd = s.getBytes();
        }
        int nodeIdLen = this.nodeId.size();
        byte[] data = new byte[3 + nodeIdLen + cd.length];
        int pos = 0;
        data[pos] = 96;
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        System.arraycopy(cd, 0, data, pos += nodeIdLen, cd.length);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        String cdata;
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBroker().getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        int nodeIdLen = dln.size();
        pos += nodeIdLen;
        try {
            cdata = new String(data, pos, len - (pos - start), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            cdata = new String(data, pos, len - (pos - start));
        }
        CommentImpl comment = pooled ? (CommentImpl)NodePool.getInstance().borrowNode((short)8) : new CommentImpl();
        comment.setNodeId(dln);
        comment.appendData(cdata);
        return comment;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getFirstChild() {
        return null;
    }
}

