/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.exist.backup.BackupWriter;

public class FileSystemWriter
implements BackupWriter {
    private File currentDir;
    private File currentContents;
    private Writer currentContentsOut;
    private OutputStream currentOut;

    public FileSystemWriter(String path) {
        File file = new File(path);
        if (file.exists()) {
            System.out.println("removing " + path);
            file.delete();
        }
        file.mkdirs();
        this.currentDir = file;
    }

    public void newCollection(String name) {
        File file = new File(this.currentDir, name);
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        this.currentDir = file;
    }

    public void closeCollection() {
        this.currentDir = this.currentDir.getParentFile();
    }

    public void close() throws IOException {
    }

    public Writer newContents() throws IOException {
        this.currentContents = new File(this.currentDir, "__contents__.xml");
        this.currentContentsOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentContents), "UTF-8"));
        return this.currentContentsOut;
    }

    public void closeContents() throws IOException {
        this.currentContentsOut.close();
    }

    public OutputStream newEntry(String name) throws IOException {
        this.currentOut = new FileOutputStream(new File(this.currentDir, name));
        return this.currentOut;
    }

    public void closeEntry() throws IOException {
        this.currentOut.close();
    }
}

