/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.atom.Atom;
import org.exist.atom.IncomingMessage;
import org.exist.atom.OutgoingMessage;
import org.exist.atom.modules.AtomFeeds;
import org.exist.atom.util.DOM;
import org.exist.atom.util.DOMDB;
import org.exist.atom.util.DateFormatter;
import org.exist.atom.util.NodeHandler;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeListImpl;
import org.exist.dom.StoredNode;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.UUIDGenerator;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AtomProtocol
extends AtomFeeds
implements Atom {
    protected static final Logger LOG = Logger.getLogger((Class)AtomProtocol.class);
    public static final String FEED_DOCUMENT_NAME = ".feed.atom";
    public static final XmldbURI FEED_DOCUMENT_URI = XmldbURI.create(".feed.atom");

    public void doPost(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        XmldbURI pathUri = XmldbURI.create(request.getPath());
        String contentType = request.getHeader("Content-Type");
        String charset = this.getContext().getDefaultCharset();
        MimeType mime = MimeType.BINARY_TYPE;
        if (contentType != null) {
            String param;
            int semicolon = contentType.indexOf(59);
            if (semicolon > 0) {
                contentType = contentType.substring(0, semicolon).trim();
            }
            mime = MimeTable.getInstance().getContentType(contentType);
            int equals = contentType.indexOf(61, semicolon);
            if (equals > 0 && (param = contentType.substring(semicolon + 1, equals).trim()).compareToIgnoreCase("charset=") == 0) {
                charset = param.substring(equals + 1).trim();
            }
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
            }
        }
        Collection collection = broker.getCollection(pathUri);
        if (mime.getName().equals("application/atom+xml")) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = null;
            Document doc = null;
            try {
                InputSource src = new InputSource(new InputStreamReader(request.getInputStream(), charset));
                docBuilder = docFactory.newDocumentBuilder();
                doc = docBuilder.parse(src);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            catch (SAXException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            Element root = doc.getDocumentElement();
            String ns = root.getNamespaceURI();
            if (ns == null || !ns.equals(Atom.NAMESPACE_STRING)) {
                throw new BadRequestException("Any content posted with the Atom mime type must be in the Atom namespace.");
            }
            if (root.getLocalName().equals("entry")) {
                if (collection == null) {
                    throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
                }
                LOG.debug((Object)("Adding entry to " + request.getPath()));
                DocumentImpl feedDoc = null;
                TransactionManager transact = broker.getBrokerPool().getTransactionManager();
                Txn transaction = transact.beginTransaction();
                String id = "urn:uuid:" + UUIDGenerator.getUUID();
                String currentDateTime = DateFormatter.toXSDDateTime(new Date());
                Element publishedE = DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "published", currentDateTime, true, true);
                DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "updated", currentDateTime, true, true);
                DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "id", id, true, true);
                Element editLink = this.findLink(root, "edit");
                Element editLinkSrc = this.findLink(root, "edit-media");
                if (editLink != null || editLinkSrc != null) {
                    throw new BadRequestException("An edit link relation cannot be specified in the entry.");
                }
                editLink = doc.createElementNS(Atom.NAMESPACE_STRING, "link");
                editLink.setAttribute("rel", "edit");
                editLink.setAttribute("type", "application/atom+xml");
                editLink.setAttribute("href", "?id=" + id);
                Node next = publishedE.getNextSibling();
                if (next == null) {
                    root.appendChild(editLink);
                } else {
                    root.insertBefore(editLink, next);
                }
                try {
                    LOG.debug((Object)"Acquiring lock on feed document...");
                    feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
                    if (!feedDoc.getPermissions().validate(broker.getUser(), 1)) {
                        throw new PermissionDeniedException("Permission denied to update feed " + collection.getURI());
                    }
                    ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
                    feedDoc.getUpdateLock().acquire(1);
                    NodeListImpl nl = new NodeListImpl(1);
                    nl.add(root);
                    feedRoot.appendChildren(transaction, nl, -1);
                    DOMDB.replaceTextElement(transaction, feedRoot, Atom.NAMESPACE_STRING, "updated", currentDateTime, true);
                    LOG.debug((Object)"Storing change...");
                    broker.storeXMLResource(transaction, feedDoc);
                    transact.commit(transaction);
                    LOG.debug((Object)"Done!");
                    response.setStatusCode(201);
                    response.setHeader("Location", request.getModuleBase() + request.getPath() + "?id=" + id);
                    this.getEntryById(broker, request.getPath(), id, response);
                }
                catch (LockException ex) {
                    transact.abort(transaction);
                    throw new EXistException("Cannot acquire write lock.", ex);
                }
                finally {
                    if (feedDoc != null) {
                        feedDoc.getUpdateLock().release(1);
                    }
                }
            }
            if (root.getLocalName().equals("feed")) {
                DocumentImpl feedDoc = null;
                TransactionManager transact = broker.getBrokerPool().getTransactionManager();
                Txn transaction = transact.beginTransaction();
                try {
                    if (collection != null) {
                        feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
                        if (feedDoc != null) {
                            throw new PermissionDeniedException("Collection at " + request.getPath() + " already exists.");
                        }
                    } else {
                        collection = broker.getOrCreateCollection(transaction, pathUri);
                        broker.saveCollection(transaction, collection);
                    }
                    String id = UUIDGenerator.getUUID();
                    String currentDateTime = DateFormatter.toXSDDateTime(new Date());
                    DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "updated", currentDateTime, true);
                    DOM.replaceTextElement(root, Atom.NAMESPACE_STRING, "id", "urn:uuid:" + id, true);
                    Element editLink = this.findLink(root, "edit");
                    if (editLink != null) {
                        throw new BadRequestException("An edit link relation cannot be specified in the feed.");
                    }
                    editLink = doc.createElementNS(Atom.NAMESPACE_STRING, "link");
                    editLink.setAttribute("rel", "edit");
                    editLink.setAttribute("type", "application/atom+xml");
                    editLink.setAttribute("href", "#");
                    root.appendChild(editLink);
                    Element selfLink = this.findLink(root, "self");
                    if (selfLink != null) {
                        throw new BadRequestException("A self link relation cannot be specified in the feed.");
                    }
                    selfLink = doc.createElementNS(Atom.NAMESPACE_STRING, "link");
                    selfLink.setAttribute("rel", "self");
                    selfLink.setAttribute("type", "application/atom+xml");
                    selfLink.setAttribute("href", "#");
                    root.appendChild(selfLink);
                    IndexInfo info = collection.validateXMLResource(transaction, broker, FEED_DOCUMENT_URI, doc);
                    collection.store(transaction, broker, info, doc, false);
                    transact.commit(transaction);
                    response.setStatusCode(204);
                    response.setHeader("Location", request.getModuleBase() + request.getPath());
                }
                catch (IOException ex) {
                    transact.abort(transaction);
                    throw new EXistException("IO error: " + ex.getMessage(), ex);
                }
                catch (SAXException ex) {
                    transact.abort(transaction);
                    throw new EXistException("SAX error: " + ex.getMessage(), ex);
                }
                catch (TriggerException ex) {
                    transact.abort(transaction);
                    throw new EXistException("Trigger failed: " + ex.getMessage(), ex);
                }
                catch (LockException ex) {
                    transact.abort(transaction);
                    throw new EXistException("Cannot acquire write lock.", ex);
                }
            }
            throw new BadRequestException("Unexpected element: {http://www.w3.org/2005/Atom}" + root.getLocalName());
        }
        if (collection == null) {
            throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
        }
        DocumentImpl feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
        if (feedDoc == null) {
            throw new BadRequestException("Feed at " + request.getPath() + " does not exist.");
        }
        String filename = request.getHeader("Slug");
        if (filename == null) {
            String ext = MimeTable.getInstance().getPreferredExtension(mime);
            int count = 1;
            while (filename == null) {
                filename = "resource" + count + ext;
                if (collection.getDocument(broker, XmldbURI.create(filename)) != null) {
                    filename = null;
                }
                ++count;
            }
        }
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            FileInputStream is;
            XmldbURI docUri = XmldbURI.create(filename);
            if (collection.getDocument(broker, docUri) != null) {
                transact.abort(transaction);
                throw new BadRequestException("Resource " + docUri + " already exists in collection " + pathUri);
            }
            File tempFile = this.storeInTemporaryFile(request.getInputStream(), request.getContentLength());
            if (mime.isXMLType()) {
                is = new FileInputStream(tempFile);
                IndexInfo info = collection.validateXMLResource(transaction, broker, docUri, new InputSource(new InputStreamReader((InputStream)is, charset)));
                ((InputStream)is).close();
                info.getDocument().getMetadata().setMimeType(contentType);
                is = new FileInputStream(tempFile);
                collection.store(transaction, broker, info, new InputSource(new InputStreamReader((InputStream)is, charset)), false);
                ((InputStream)is).close();
            } else {
                is = new FileInputStream(tempFile);
                collection.addBinaryResource(transaction, broker, docUri, is, contentType, (int)tempFile.length());
                is.close();
            }
            try {
                LOG.debug((Object)"Acquiring lock on feed document...");
                feedDoc.getUpdateLock().acquire(1);
                String title = request.getHeader("Title");
                if (title == null) {
                    title = filename;
                }
                String created = DateFormatter.toXSDDateTime(new Date());
                ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
                DOMDB.replaceTextElement(transaction, feedRoot, Atom.NAMESPACE_STRING, "updated", created, true);
                String id = "urn:uuid:" + UUIDGenerator.getUUID();
                Element mediaEntry = AtomProtocol.generateMediaEntry(id, created, title, filename, mime.getName());
                DOMDB.appendChild(transaction, feedRoot, mediaEntry);
                LOG.debug((Object)"Storing change...");
                broker.storeXMLResource(transaction, feedDoc);
                transact.commit(transaction);
                LOG.debug((Object)"Done!");
                response.setStatusCode(201);
                response.setHeader("Location", request.getModuleBase() + request.getPath() + "?id=" + id);
                response.setContentType("application/atom+xml; charset=" + charset);
                OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream(), charset);
                Transformer identity = TransformerFactory.newInstance().newTransformer();
                identity.transform(new DOMSource(mediaEntry), new StreamResult(w));
                w.flush();
                w.close();
            }
            catch (ParserConfigurationException ex) {
                transact.abort(transaction);
                throw new EXistException("DOM implementation is misconfigured.", ex);
            }
            catch (TransformerException ex) {
                throw new EXistException("Serialization error.", ex);
            }
            catch (LockException ex) {
                transact.abort(transaction);
                throw new EXistException("Cannot acquire write lock.", ex);
            }
            finally {
                if (feedDoc != null) {
                    feedDoc.getUpdateLock().release(1);
                }
            }
        }
        catch (IOException ex) {
            transact.abort(transaction);
            throw new EXistException("I/O error while handling temporary files.", ex);
        }
        catch (SAXParseException e) {
            transact.abort(transaction);
            throw new BadRequestException("Parsing exception at " + e.getLineNumber() + "/" + e.getColumnNumber() + ": " + e.toString());
        }
        catch (SAXException e) {
            transact.abort(transaction);
            Exception o = e.getException();
            if (o == null) {
                o = e;
            }
            throw new BadRequestException("Parsing exception: " + o.getMessage());
        }
        catch (TriggerException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
    }

    public void doPut(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException {
        XmldbURI pathUri = XmldbURI.create(request.getPath());
        String contentType = request.getHeader("Content-Type");
        String charset = this.getContext().getDefaultCharset();
        MimeType mime = MimeType.BINARY_TYPE;
        if (contentType != null) {
            String param;
            int equals;
            int semicolon = contentType.indexOf(59);
            if (semicolon > 0) {
                contentType = contentType.substring(0, semicolon).trim();
            }
            if ((mime = MimeTable.getInstance().getContentType(contentType)) == null) {
                mime = MimeType.BINARY_TYPE;
            }
            if ((equals = contentType.indexOf(61, semicolon)) > 0 && (param = contentType.substring(semicolon + 1, equals).trim()).compareToIgnoreCase("charset=") == 0) {
                charset = param.substring(equals + 1).trim();
            }
        }
        if (mime.getName().equals("application/atom+xml")) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = null;
            Document doc = null;
            try {
                InputSource src = new InputSource(new InputStreamReader(request.getInputStream(), charset));
                docBuilder = docFactory.newDocumentBuilder();
                doc = docBuilder.parse(src);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            catch (SAXException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessage());
            }
            Element root = doc.getDocumentElement();
            String ns = root.getNamespaceURI();
            if (ns == null || !ns.equals(Atom.NAMESPACE_STRING)) {
                throw new BadRequestException("Any content posted with the Atom mime type must be in the Atom namespace.");
            }
            if (root.getLocalName().equals("feed")) {
                Collection collection = broker.getCollection(pathUri);
                DocumentImpl feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
                if (feedDoc == null) {
                    throw new BadRequestException("Collection at " + request.getPath() + " does not exist.");
                }
                if (DOM.findChild(root, Atom.NAMESPACE_STRING, "title") == null) {
                    throw new BadRequestException("The feed metadata sent does not contain a title.");
                }
                TransactionManager transact = broker.getBrokerPool().getTransactionManager();
                Txn transaction = transact.beginTransaction();
                try {
                    feedDoc.getUpdateLock().acquire(1);
                    ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
                    this.mergeFeed(broker, transaction, feedRoot, root, DateFormatter.toXSDDateTime(new Date()));
                    broker.storeXMLResource(transaction, feedDoc);
                    transact.commit(transaction);
                    response.setStatusCode(204);
                }
                catch (LockException ex) {
                    transact.abort(transaction);
                    throw new EXistException("Cannot acquire write lock.", ex);
                }
                catch (RuntimeException ex) {
                    transact.abort(transaction);
                    throw ex;
                }
                finally {
                    if (feedDoc != null) {
                        feedDoc.getUpdateLock().release(1);
                    }
                }
            }
            if (root.getLocalName().equals("entry")) {
                Collection collection = broker.getCollection(pathUri);
                if (collection == null) {
                    throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
                }
                String id = request.getParameter("id");
                if (id == null) {
                    throw new BadRequestException("The 'id' parameter for the entry is missing.");
                }
                LOG.debug((Object)("Updating entry " + id + " in collection " + request.getPath()));
                DocumentImpl feedDoc = null;
                TransactionManager transact = broker.getBrokerPool().getTransactionManager();
                Txn transaction = transact.beginTransaction();
                String currentDateTime = DateFormatter.toXSDDateTime(new Date());
                try {
                    LOG.debug((Object)"Acquiring lock on feed document...");
                    feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
                    feedDoc.getUpdateLock().acquire(1);
                    FindEntry finder = new FindEntry(id);
                    DOM.findChildren(feedDoc.getDocumentElement(), Atom.NAMESPACE_STRING, "entry", finder);
                    Element entry = finder.getEntry();
                    if (entry == null) {
                        throw new BadRequestException("Cannot find entry with id " + id);
                    }
                    this.mergeEntry(transaction, (ElementImpl)entry, root, currentDateTime);
                    DOMDB.replaceTextElement(transaction, (ElementImpl)feedDoc.getDocumentElement(), Atom.NAMESPACE_STRING, "updated", currentDateTime, true);
                    broker.storeXMLResource(transaction, feedDoc);
                    transact.commit(transaction);
                    response.setStatusCode(200);
                    this.getEntryById(broker, request.getPath(), id, response);
                }
                catch (LockException ex) {
                    transact.abort(transaction);
                    throw new EXistException("Cannot acquire write lock.", ex);
                }
                finally {
                    if (feedDoc != null) {
                        feedDoc.getUpdateLock().release(1);
                    }
                }
            }
            throw new BadRequestException("Unexpected element: {http://www.w3.org/2005/Atom}" + root.getLocalName());
        }
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            XmldbURI docUri = pathUri.lastSegment();
            XmldbURI collUri = pathUri.removeLastSegment();
            if (docUri == null || collUri == null) {
                transact.abort(transaction);
                throw new BadRequestException("The path is not valid: " + request.getPath());
            }
            Collection collection = broker.getCollection(collUri);
            if (collection == null) {
                transact.abort(transaction);
                throw new BadRequestException("The collection does not exist: " + collUri);
            }
            if (collection.getDocument(broker, docUri) == null) {
                transact.abort(transaction);
                throw new BadRequestException("Resource " + docUri + " does not exist in collection " + collUri);
            }
            File tempFile = this.storeInTemporaryFile(request.getInputStream(), request.getContentLength());
            if (mime.isXMLType()) {
                FileInputStream is = new FileInputStream(tempFile);
                IndexInfo info = collection.validateXMLResource(transaction, broker, docUri, new InputSource(new InputStreamReader((InputStream)is, charset)));
                ((InputStream)is).close();
                info.getDocument().getMetadata().setMimeType(contentType);
                is = new FileInputStream(tempFile);
                collection.store(transaction, broker, info, new InputSource(new InputStreamReader((InputStream)is, charset)), false);
                ((InputStream)is).close();
            } else {
                FileInputStream is = new FileInputStream(tempFile);
                collection.addBinaryResource(transaction, broker, docUri, is, contentType, (int)tempFile.length());
                is.close();
            }
            transact.commit(transaction);
            response.setStatusCode(200);
        }
        catch (IOException ex) {
            transact.abort(transaction);
            throw new EXistException("I/O error while handling temporary files.", ex);
        }
        catch (SAXParseException e) {
            transact.abort(transaction);
            throw new BadRequestException("Parsing exception at " + e.getLineNumber() + "/" + e.getColumnNumber() + ": " + e.toString());
        }
        catch (SAXException e) {
            transact.abort(transaction);
            Exception o = e.getException();
            if (o == null) {
                o = e;
            }
            throw new BadRequestException("Parsing exception: " + o.getMessage());
        }
        catch (TriggerException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DBBroker broker, IncomingMessage request, OutgoingMessage response) throws BadRequestException, PermissionDeniedException, NotFoundException, EXistException, IOException {
        XmldbURI pathUri = XmldbURI.create(request.getPath());
        XmldbURI srcUri = null;
        Collection collection = broker.getCollection(pathUri);
        if (collection == null) {
            throw new BadRequestException("Collection " + request.getPath() + " does not exist.");
        }
        String id = request.getParameter("id");
        if (id == null) {
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            Txn transaction = transact.beginTransaction();
            try {
                broker.removeCollection(transaction, collection);
                transact.commit(transaction);
                response.setStatusCode(204);
            }
            finally {
                transact.abort(transaction);
            }
            return;
        }
        LOG.info((Object)("Deleting entry " + id + " in collection " + request.getPath()));
        DocumentImpl feedDoc = null;
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        String currentDateTime = DateFormatter.toXSDDateTime(new Date());
        try {
            feedDoc = collection.getDocument(broker, FEED_DOCUMENT_URI);
            if (!feedDoc.getPermissions().validate(broker.getUser(), 1)) {
                throw new PermissionDeniedException("Permission denied to update feed " + collection.getURI());
            }
            feedDoc.getUpdateLock().acquire(1);
            FindEntry finder = new FindEntry(id);
            DOM.findChildren(feedDoc.getDocumentElement(), Atom.NAMESPACE_STRING, "entry", finder);
            Element entry = finder.getEntry();
            if (entry == null) {
                transact.abort(transaction);
                throw new BadRequestException("Entry with id " + id + " cannot be found.");
            }
            Element content = DOM.findChild(entry, Atom.NAMESPACE_STRING, "content");
            if (content != null) {
                DocumentImpl resource;
                String src = content.getAttribute("src");
                LOG.debug((Object)("Found content element, checking for resource " + src));
                if (src != null && src.indexOf(47) < 0 && (resource = collection.getDocument(broker, srcUri = XmldbURI.create(src))) != null) {
                    LOG.debug((Object)("Deleting resource " + src + " from " + request.getPath()));
                    if (resource.getResourceType() == 1) {
                        collection.removeBinaryResource(transaction, broker, srcUri);
                    } else {
                        collection.removeXMLResource(transaction, broker, srcUri);
                    }
                }
            }
            ElementImpl feedRoot = (ElementImpl)feedDoc.getDocumentElement();
            feedRoot.removeChild(transaction, entry);
            DOMDB.replaceTextElement(transaction, feedRoot, Atom.NAMESPACE_STRING, "updated", currentDateTime, true);
            LOG.debug((Object)"Storing change...");
            broker.storeXMLResource(transaction, feedDoc);
            transact.commit(transaction);
            LOG.debug((Object)"Done!");
            response.setStatusCode(204);
        }
        catch (TriggerException ex) {
            transact.abort(transaction);
            throw new EXistException("Cannot delete media resource " + srcUri, ex);
        }
        catch (LockException ex) {
            transact.abort(transaction);
            throw new EXistException("Cannot acquire write lock.", ex);
        }
        finally {
            if (feedDoc != null) {
                feedDoc.getUpdateLock().release(1);
            }
        }
    }

    public void mergeEntry(final Txn transaction, final ElementImpl target, Element source, final String updated) {
        final ArrayList toRemove = new ArrayList();
        DOM.forEachChild(target, new NodeHandler(){

            public void process(Node parent, Node child) {
                if (child.getNodeType() == 1) {
                    String ns = child.getNamespaceURI();
                    if (ns != null && ns.equals(Atom.NAMESPACE_STRING)) {
                        String lname = child.getLocalName();
                        if (lname.equals("updated")) {
                            DOMDB.replaceText(transaction, (ElementImpl)child, updated);
                        } else if (lname.equals("link")) {
                            String rel = ((Element)child).getAttribute("rel");
                            if (!rel.equals("edit") && !rel.equals("edit-media")) {
                                toRemove.add(child);
                            }
                        } else if (!lname.equals("id") && !lname.equals("published")) {
                            toRemove.add(child);
                        }
                    } else {
                        toRemove.add(child);
                    }
                } else {
                    toRemove.add(child);
                }
            }
        });
        Iterator childrenToRemove = toRemove.iterator();
        while (childrenToRemove.hasNext()) {
            Node child = (Node)childrenToRemove.next();
            target.removeChild(transaction, child);
        }
        Document ownerDocument = target.getOwnerDocument();
        DOM.forEachChild(source, new NodeHandler(){

            public void process(Node parent, Node child) {
                if (child.getNodeType() == 1) {
                    String ns = child.getNamespaceURI();
                    if (ns != null && ns.equals(Atom.NAMESPACE_STRING)) {
                        String rel;
                        String lname = child.getLocalName();
                        if (lname.equals("updated") || lname.equals("published") || lname.equals("id")) {
                            return;
                        }
                        if (lname.equals("link") && ((rel = ((Element)child).getAttribute("rel")).equals("edit") || rel.equals("edit-media"))) {
                            return;
                        }
                    }
                    DOMDB.appendChild(transaction, target, child);
                }
            }
        });
    }

    public void mergeFeed(DBBroker broker, final Txn transaction, ElementImpl target, Element source, final String updated) {
        DocumentImpl ownerDocument = (DocumentImpl)target.getOwnerDocument();
        final ArrayList toRemove = new ArrayList();
        DOM.forEachChild(target, new NodeHandler(){

            public void process(Node parent, Node child) {
                if (child.getNodeType() == 1) {
                    String ns = child.getNamespaceURI();
                    if (ns != null && ns.equals(Atom.NAMESPACE_STRING)) {
                        String lname = child.getLocalName();
                        if (lname.equals("updated")) {
                            DOMDB.replaceText(transaction, (ElementImpl)child, updated);
                        } else if (lname.equals("link")) {
                            Element echild = (Element)child;
                            String rel = echild.getAttribute("rel");
                            if (!rel.equals("edit")) {
                                toRemove.add(child);
                            }
                        } else if (!(lname.equals("id") || lname.equals("published") || lname.equals("entry"))) {
                            toRemove.add(child);
                        }
                    } else {
                        toRemove.add(child);
                    }
                } else {
                    toRemove.add(child);
                }
            }
        });
        Iterator childrenToRemove = toRemove.iterator();
        while (childrenToRemove.hasNext()) {
            Node child = (Node)childrenToRemove.next();
            target.removeChild(transaction, child);
        }
        NodeList nl = source.getChildNodes();
        NodeListener firstEntry = null;
        Element theFirstEntry = DOM.findChild(target, Atom.NAMESPACE_STRING, "entry");
        if (theFirstEntry != null) {
            firstEntry = new NodeListener((StoredNode)((Object)theFirstEntry));
            ownerDocument.getMetadata().setIndexListener(firstEntry);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            String rel;
            String lname;
            String ns;
            Node child = nl.item(i);
            if (child.getNodeType() != 1 || (ns = child.getNamespaceURI()) != null && ns.equals(Atom.NAMESPACE_STRING) && ((lname = child.getLocalName()).equals("updated") || lname.equals("published") || lname.equals("id") || lname.equals("link") && (rel = ((Element)child).getAttribute("rel")).equals("edit"))) continue;
            if (firstEntry == null) {
                DOMDB.appendChild(transaction, target, child);
                continue;
            }
            DOMDB.insertBefore(transaction, target, child, firstEntry.node);
        }
        ownerDocument.getMetadata().clearIndexListener();
        ownerDocument.getMetadata().setLastModified(System.currentTimeMillis());
    }

    protected Element findLink(Element parent, String rel) {
        NodeList nl = parent.getElementsByTagNameNS(Atom.NAMESPACE_STRING, "link");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element link = (Element)nl.item(i);
            if (!link.getAttribute("rel").equals(rel)) continue;
            return link;
        }
        return null;
    }

    public static Element generateMediaEntry(String id, String created, String title, String filename, String mimeType) throws ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        Document owner = docFactory.newDocumentBuilder().getDOMImplementation().createDocument(Atom.NAMESPACE_STRING, "entry", null);
        Element entry = owner.getDocumentElement();
        Element idE = owner.createElementNS(Atom.NAMESPACE_STRING, "id");
        idE.appendChild(owner.createTextNode(id));
        entry.appendChild(idE);
        Element publishedE = owner.createElementNS(Atom.NAMESPACE_STRING, "published");
        publishedE.appendChild(owner.createTextNode(created));
        entry.appendChild(publishedE);
        Element updatedE = owner.createElementNS(Atom.NAMESPACE_STRING, "updated");
        updatedE.appendChild(owner.createTextNode(created));
        entry.appendChild(updatedE);
        Element titleE = owner.createElementNS(Atom.NAMESPACE_STRING, "title");
        titleE.appendChild(owner.createTextNode(title));
        entry.appendChild(titleE);
        Element linkE = owner.createElementNS(Atom.NAMESPACE_STRING, "link");
        linkE.setAttribute("rel", "edit");
        linkE.setAttribute("type", "application/atom+xml");
        linkE.setAttribute("href", "?id=" + id);
        entry.appendChild(linkE);
        linkE = owner.createElementNS(Atom.NAMESPACE_STRING, "link");
        linkE.setAttribute("rel", "edit-media");
        linkE.setAttribute("type", mimeType);
        linkE.setAttribute("href", filename);
        entry.appendChild(linkE);
        Element contentE = owner.createElementNS(Atom.NAMESPACE_STRING, "content");
        entry.appendChild(contentE);
        contentE.setAttribute("src", filename);
        contentE.setAttribute("type", mimeType);
        return entry;
    }

    class FindEntry
    implements NodeHandler {
        String id;
        Element matching;

        FindEntry(String id) {
            this.id = id;
        }

        public void process(Node parent, Node child) {
            String value;
            Element entry = (Element)child;
            NodeList nl = entry.getElementsByTagNameNS(Atom.NAMESPACE_STRING, "id");
            if (nl.getLength() != 0 && (value = DOM.textContent(nl.item(0))).equals(this.id)) {
                this.matching = entry;
            }
        }

        public Element getEntry() {
            return this.matching;
        }
    }

    static final class NodeListener
    implements NodeIndexListener {
        StoredNode node;

        public NodeListener(StoredNode node) {
            this.node = node;
        }

        public void nodeChanged(StoredNode newNode) {
            long address = newNode.getInternalAddress();
            if (StorageAddress.equals(this.node.getInternalAddress(), address)) {
                this.node = newNode;
            }
        }
    }
}

