/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.cdlib.xtf.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocSelCache
extends HashMap {
    public String dependencies;
    public HashMap<String, Entry> map = new HashMap();
    public boolean modified = true;

    public void load(File file) throws IOException {
        this.clear();
        FileInputStream fis = null;
        InflaterInputStream iis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            iis = new InflaterInputStream(fis);
            ois = new ObjectInputStream(iis);
            String fileVersion = ois.readUTF();
            if (!fileVersion.equals("docSelectorCache v1.0")) {
                Trace.warning("Unrecognized docSelector cache \"" + file + "\"");
                return;
            }
            try {
                this.dependencies = ois.readUTF();
                this.map = (HashMap)ois.readObject();
                this.modified = false;
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void save(File file) throws IOException {
        if (!this.modified) {
            return;
        }
        File newFile = new File(String.valueOf(file.toString()) + ".new");
        FileOutputStream fos = null;
        DeflaterOutputStream dos = null;
        ObjectOutputStream oos = null;
        try {
            try {
                fos = new FileOutputStream(newFile);
                dos = new DeflaterOutputStream(fos);
                oos = new ObjectOutputStream(dos);
                oos.writeUTF("docSelectorCache v1.0");
                oos.writeUTF(this.dependencies);
                oos.writeObject(this.map);
                oos.close();
                dos.close();
                fos.close();
                file.delete();
                newFile.renameTo(file);
            }
            catch (IOException e) {
                newFile.delete();
                throw e;
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void clear() {
        this.modified = true;
        this.map.clear();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Entry get(String key) {
        return this.map.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Entry put(String key, Entry value) {
        this.modified = true;
        return this.map.put(key, value);
    }

    @Override
    public Entry remove(Object key) {
        this.modified = true;
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<Map.Entry<String, Entry>> entrySet() {
        return this.map.entrySet();
    }

    static class Entry
    implements Serializable {
        String filesAndTimes;
        boolean anyProcessed;

        Entry() {
        }

        Entry(String filesAndTimes, boolean anyProcessed) {
            this.filesAndTimes = filesAndTimes;
            this.anyProcessed = anyProcessed;
        }
    }
}

