/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.cdlib.xtf.textEngine.facet.GroupData;

public class StaticGroupData
extends GroupData {
    private String field;
    private int[] docs;
    private int[] links;
    private String[] groups;
    private int[] groupParents;
    private int[] groupChildren;
    private int[] groupSiblings;
    private static WeakHashMap cache = new WeakHashMap();

    public static synchronized StaticGroupData getCachedData(IndexReader reader, String field) throws IOException {
        StaticGroupData data;
        HashMap<String, StaticGroupData> readerCache = (HashMap<String, StaticGroupData>)cache.get(reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, StaticGroupData>();
            cache.put(reader, readerCache);
        }
        if ((data = (StaticGroupData)readerCache.get(field)) == null) {
            data = new StaticGroupData(reader, field);
            readerCache.put(field, data);
        }
        return data;
    }

    public StaticGroupData(IndexReader reader, String field) throws IOException {
        this.field = field;
        TermPositions termPositions = reader.termPositions();
        TermEnum termEnum = reader.terms(new Term(field, ""));
        HashMap<String, Integer> groupMap = new HashMap<String, Integer>();
        Vector<String> groupVec = new Vector<String>();
        HashMap childMap = new HashMap();
        HashMap docMap = new HashMap();
        HashSet<String> lcTerms = new HashSet<String>();
        int nLinks = 0;
        groupVec.add("");
        groupMap.put("", 0);
        try {
            if (termEnum.term() == null) {
                throw new RuntimeException("no terms in field " + field);
            }
            do {
                Term term;
                if (!(term = termEnum.term()).field().equals(field)) {
                    break;
                }
                String lcTerm = term.text().toLowerCase();
                if (lcTerms.contains(lcTerm)) continue;
                lcTerms.add(lcTerm);
                String termText = term.text();
                if (termText.length() == 0) {
                    termText = "<empty>";
                }
                Integer termKey = this.addTermKey(termText, groupVec, groupMap, childMap);
                termPositions.seek(termEnum);
                while (termPositions.next()) {
                    int docId = termPositions.doc();
                    Integer docKey = docId;
                    Vector<Integer> docGroups = (Vector<Integer>)docMap.get(docKey);
                    if (docGroups == null) {
                        docGroups = new Vector<Integer>(1);
                        docMap.put(docKey, docGroups);
                    }
                    if (docGroups.size() == 1) {
                        ++nLinks;
                    }
                    docGroups.add(termKey);
                    ++nLinks;
                }
            } while (termEnum.next());
        }
        finally {
            termPositions.close();
            termEnum.close();
        }
        this.groups = groupVec.toArray(new String[groupVec.size()]);
        int i = 0;
        while (i < this.groups.length) {
            int lastSep = this.groups[i].lastIndexOf("::");
            if (lastSep >= 0) {
                this.groups[i] = this.groups[i].substring(lastSep + 2);
            }
            ++i;
        }
        this.buildHierarchy(childMap);
        this.docs = new int[docMap.size()];
        this.links = new int[nLinks];
        this.buildLinks(docMap);
    }

    private Integer addTermKey(String termText, Vector groupVec, HashMap groupMap, HashMap childMap) {
        String curName = termText;
        Integer childKey = null;
        Integer termKey = null;
        while (true) {
            String parentName;
            Integer parentKey;
            if ((parentKey = (Integer)groupMap.get(parentName = curName)) == null) {
                parentKey = groupVec.size();
                groupVec.add(parentName);
                groupMap.put(parentName, parentKey);
            }
            if (termKey == null) {
                termKey = parentKey;
            } else {
                HashSet<Integer> parentChildSet = (HashSet<Integer>)childMap.get(parentKey);
                if (parentChildSet == null) {
                    parentChildSet = new HashSet<Integer>();
                    childMap.put(parentKey, parentChildSet);
                }
                parentChildSet.add(childKey);
            }
            if (curName.length() == 0) break;
            childKey = parentKey;
            int lastColon = curName.lastIndexOf("::");
            if (lastColon >= 0) {
                curName = curName.substring(0, lastColon);
                continue;
            }
            curName = "";
        }
        return termKey;
    }

    private void buildHierarchy(HashMap childMap) {
        this.groupParents = new int[this.groups.length];
        Arrays.fill(this.groupParents, -1);
        this.groupChildren = new int[this.groups.length];
        Arrays.fill(this.groupChildren, -1);
        this.groupSiblings = new int[this.groups.length];
        Arrays.fill(this.groupSiblings, -1);
        for (Integer parentKey : childMap.keySet()) {
            int parent = parentKey;
            HashSet childSet = (HashSet)childMap.get(parentKey);
            assert (this.groupChildren[parent] < 0) : "multiple child lists for parent";
            int prev = -1;
            ArrayList children = new ArrayList(childSet);
            Collections.sort(children);
            int i = 0;
            while (i < children.size()) {
                int child = (Integer)children.get(i);
                this.groupParents[child] = parent;
                assert (child != prev);
                if (prev < 0) {
                    this.groupChildren[parent] = child;
                } else {
                    this.groupSiblings[prev] = child;
                }
                prev = child;
                ++i;
            }
        }
    }

    private void buildLinks(HashMap docMap) {
        ArrayList keyList = new ArrayList(docMap.keySet());
        assert (keyList.size() == this.docs.length) : "incorrect calculation";
        Collections.sort(keyList);
        int topLink = this.docs.length;
        int i = 0;
        while (i < this.docs.length) {
            int docNum;
            Integer docKey = (Integer)keyList.get(i);
            Vector docGroups = (Vector)docMap.get(docKey);
            this.docs[i] = docNum = docKey.intValue();
            if (docGroups.size() == 1) {
                this.links[i] = (Integer)docGroups.get(0);
            } else {
                this.links[i] = -topLink;
                Iterator iter = docGroups.iterator();
                while (iter.hasNext()) {
                    int groupNum = (Integer)iter.next();
                    if (!iter.hasNext()) {
                        groupNum = -groupNum;
                    }
                    this.links[topLink++] = groupNum;
                }
            }
            ++i;
        }
        assert (topLink == this.links.length) : "incorrect calculation";
    }

    public final int firstLink(int docId) {
        int found = Arrays.binarySearch(this.docs, docId);
        if (found < 0 || found >= this.docs.length) {
            return -1;
        }
        if (this.links[found] >= 0) {
            return found;
        }
        return -this.links[found];
    }

    public final int nextLink(int linkId) {
        if (linkId < this.docs.length) {
            return -1;
        }
        if (this.links[linkId] < 0) {
            return -1;
        }
        return linkId + 1;
    }

    public final int linkGroup(int linkId) {
        int n = this.links[linkId];
        return n < 0 ? -n : n;
    }

    public final String field() {
        return this.field;
    }

    public final int nGroups() {
        return this.groups.length;
    }

    public final String name(int groupId) {
        return this.groups[groupId];
    }

    public final int parent(int groupId) {
        return this.groupParents[groupId];
    }

    public final int nChildren(int groupId) {
        int nChildren = 0;
        int kid = this.groupChildren[groupId];
        while (kid >= 0) {
            ++nChildren;
            kid = this.groupSiblings[kid];
        }
        return nChildren;
    }

    public final int child(int groupId) {
        return this.groupChildren[groupId];
    }

    public final int sibling(int groupId) {
        return this.groupSiblings[groupId];
    }

    public final int compare(int group1, int group2) {
        return group1 < group2 ? -1 : (group1 > group2 ? 1 : 0);
    }

    public final int findGroup(String name) {
        int i = 0;
        while (i < this.groups.length) {
            if (name.equals(this.groups[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

