/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.pipe;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.ElementWithContent;
import org.cdlib.xtf.saxonExt.InstructionWithContent;
import org.cdlib.xtf.saxonExt.pipe.PipeBufferPool;
import org.cdlib.xtf.servletBase.TextServlet;

public class PipeRequestElement
extends ElementWithContent {
    public void prepareAttributes() throws XPathException {
        String[] mandatoryAtts = new String[]{"url"};
        String[] optionalAtts = new String[]{"timeout", "method"};
        this.parseAttributes(mandatoryAtts, optionalAtts);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new PipeRequestInstruction(this.attribs, this.compileContent(exec));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PipeRequestInstruction
    extends InstructionWithContent {
        public PipeRequestInstruction(Map<String, Expression> attribs, Expression content) {
            super("pipe:pipeRequest", attribs, content);
        }

        @Override
        public TailCall processLeavingTail(XPathContext context) throws XPathException {
            String inputStr;
            String timeoutStr;
            byte[] buf = null;
            OutputStream postOut = null;
            InputStream reqIn = null;
            OutputStream servOut = null;
            URL fullURL = null;
            try {
                fullURL = new URL(((Expression)this.attribs.get("url")).evaluateAsString(context));
            }
            catch (MalformedURLException e) {
                this.dynamicError("'url' must be a well-formed URL", "PIPE_REQ_001", context);
            }
            int timeoutMsec = 0;
            if (this.attribs.containsKey("timeout") && (timeoutStr = ((Expression)this.attribs.get("timeout")).evaluateAsString(context)) != null) {
                try {
                    timeoutMsec = (int)(Float.parseFloat(timeoutStr) * 1000.0f);
                    timeoutMsec = Math.max(0, timeoutMsec);
                }
                catch (NumberFormatException e) {
                    this.dynamicError("'timeout' must be a number", "PIPE_REQ_002", context);
                }
            }
            String method = "GET";
            if (this.attribs.containsKey("method")) {
                String methodStr = ((Expression)this.attribs.get("method")).evaluateAsString(context);
                if (methodStr == null || methodStr.equals("GET")) {
                    method = "GET";
                } else if (methodStr.equals("POST")) {
                    method = "POST";
                } else {
                    this.dynamicError("'method' must be 'GET' or 'POST'", "PIPE_REQ_003", context);
                }
            }
            byte[] inputBytes = new byte[]{};
            if (this.content != null && (inputStr = PipeRequestInstruction.sequenceToString(this.content, context).trim()).length() > 0) {
                try {
                    inputBytes = inputStr.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                method = "POST";
            }
            try {
                try {
                    int got;
                    HttpURLConnection conn = (HttpURLConnection)fullURL.openConnection();
                    if (timeoutMsec > 0) {
                        conn.setConnectTimeout(timeoutMsec);
                        conn.setReadTimeout(timeoutMsec);
                    }
                    if (method.equals("POST") || inputBytes.length > 0) {
                        conn.setRequestMethod("POST");
                        conn.setRequestProperty("Content-Type", "text/plain");
                        conn.setRequestProperty("Content-Length", Integer.toString(inputBytes.length));
                        conn.setUseCaches(false);
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.connect();
                        postOut = conn.getOutputStream();
                        postOut.write(inputBytes);
                        postOut.flush();
                        postOut.close();
                        postOut = null;
                    } else {
                        conn.connect();
                    }
                    HttpServletResponse servletResponse = TextServlet.getCurResponse();
                    int resCode = conn.getResponseCode();
                    servletResponse.setStatus(resCode);
                    int i = 0;
                    while (true) {
                        String key = conn.getHeaderFieldKey(i);
                        String val = conn.getHeaderField(i);
                        if (val == null) break;
                        if (key != null && !key.equals("Connection")) {
                            servletResponse.setHeader(key, val);
                        }
                        ++i;
                    }
                    reqIn = conn.getInputStream();
                    servOut = servletResponse.getOutputStream();
                    buf = PipeBufferPool.allocBuffer();
                    while ((got = reqIn.read(buf)) >= 0) {
                        servOut.write(buf, 0, got);
                    }
                    servOut.flush();
                }
                catch (SocketTimeoutException e) {
                    this.dynamicError("External piped request timed out", "PIPE_REQ_004", context);
                    if (buf != null) {
                        PipeBufferPool.deallocBuffer(buf);
                    }
                    if (servOut != null) {
                        try {
                            servOut.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (reqIn != null) {
                        try {
                            reqIn.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (postOut != null) {
                        try {
                            postOut.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException e) {
                    block62: {
                        this.dynamicError("IO Error during pipe request: " + e.toString(), "PIPE_REQ_005", context);
                        if (buf == null) break block62;
                        PipeBufferPool.deallocBuffer(buf);
                    }
                    if (servOut != null) {
                        try {
                            servOut.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (reqIn != null) {
                        try {
                            reqIn.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (postOut != null) {
                        try {
                            postOut.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            finally {
                if (buf != null) {
                    PipeBufferPool.deallocBuffer(buf);
                }
                if (servOut != null) {
                    try {
                        servOut.close();
                    }
                    catch (IOException iOException) {}
                }
                if (reqIn != null) {
                    try {
                        reqIn.close();
                    }
                    catch (IOException iOException) {}
                }
                if (postOut != null) {
                    try {
                        postOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return null;
        }
    }
}

