/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.pipe;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ListIterator;

class PipeBufferPool {
    static final int MAX_SPARE_BUFS = 4;
    static final int BUF_SIZE = 32768;
    static LinkedList spareBuffers = new LinkedList();

    PipeBufferPool() {
    }

    static synchronized byte[] allocBuffer() {
        byte[] buf = null;
        ListIterator iter = spareBuffers.listIterator();
        while (iter.hasNext() && buf == null) {
            Object obj = iter.next();
            iter.remove();
            if (obj instanceof WeakReference) {
                WeakReference ref = (WeakReference)obj;
                buf = (byte[])ref.get();
                continue;
            }
            buf = (byte[])obj;
        }
        if (buf == null) {
            buf = new byte[32768];
        }
        return buf;
    }

    static synchronized void deallocBuffer(byte[] buf) {
        ListIterator iter = spareBuffers.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof WeakReference) || ((WeakReference)obj).get() != null) continue;
            iter.remove();
        }
        if (spareBuffers.size() < 4) {
            spareBuffers.addFirst(buf);
        } else {
            spareBuffers.addFirst(new WeakReference<byte[]>(buf));
        }
    }
}

