/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.dynaXML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.tree.TreeBuilder;
import org.cdlib.xtf.dynaXML.Authenticator;
import org.cdlib.xtf.dynaXML.DefaultDocLocator;
import org.cdlib.xtf.dynaXML.DocLocator;
import org.cdlib.xtf.dynaXML.DocRequest;
import org.cdlib.xtf.dynaXML.DynaXMLConfig;
import org.cdlib.xtf.dynaXML.DynaXMLException;
import org.cdlib.xtf.dynaXML.InvalidDocumentException;
import org.cdlib.xtf.dynaXML.UnsupportedQueryException;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.LazyKeyManager;
import org.cdlib.xtf.lazyTree.LazyProfilingListener;
import org.cdlib.xtf.lazyTree.LazyTreeBuilder;
import org.cdlib.xtf.lazyTree.PersistentTree;
import org.cdlib.xtf.lazyTree.SearchTree;
import org.cdlib.xtf.servletBase.RedirectException;
import org.cdlib.xtf.servletBase.StylesheetCache;
import org.cdlib.xtf.servletBase.TextConfig;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.textEngine.IndexUtil;
import org.cdlib.xtf.textEngine.QueryRequestParser;
import org.cdlib.xtf.util.AttribList;
import org.cdlib.xtf.util.EasyNode;
import org.cdlib.xtf.util.GeneralException;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.XMLFormatter;
import org.cdlib.xtf.util.XMLWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DynaXML
extends TextServlet {
    Authenticator authenticator;
    private DynaXMLConfig config;
    private DocLocator docLocator = this.createDocLocator();

    public String getConfigName() {
        return "conf/dynaXML.conf";
    }

    protected TextConfig readConfig(String configPath) {
        this.config = new DynaXMLConfig(this, configPath);
        this.authenticator = new Authenticator(this);
        return this.config;
    }

    public TextConfig getConfig() {
        return this.config;
    }

    private String getClientIP(HttpServletRequest req) {
        String ip = req.getRemoteAddr();
        Trace.debug("Checking IP \"" + ip + "\" vs reverse proxy IP \"" + this.config.reverseProxyIP + "\"");
        if (ip.equals(this.config.reverseProxyIP)) {
            Trace.debug("...matches reverseProxyIP");
            String header = req.getHeader(this.config.reverseProxyDefaultMarker);
            if (!DynaXML.isEmpty(header)) {
                Trace.debug("...using marker " + this.config.reverseProxyDefaultMarker + " -> " + header);
                ip = header;
            }
            if (!DynaXML.isEmpty(this.config.reverseProxyMarker) && !DynaXML.isEmpty(header = req.getHeader(this.config.reverseProxyMarker))) {
                Trace.debug("...using marker " + this.config.reverseProxyMarker + " -> " + header);
                ip = header;
            }
        }
        while (ip.length() > 0 && !Character.isDigit(ip.charAt(0))) {
            ip = ip.substring(1);
        }
        return ip;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            String source = req.getParameter("source");
            StylesheetCache.TraceListenerFactory tlf = null;
            if (this.config.stylesheetProfiling) {
                tlf = new StylesheetCache.TraceListenerFactory(){

                    public TraceListener createListener() {
                        return new LazyProfilingListener();
                    }
                };
            }
            this.stylesheetCache.enableProfiling(tlf);
            res.setContentType("text/html");
            Trace.debug("Processing request: " + DynaXML.getRequestURL(req));
            DocRequest docReq = this.runDocReqParser(req, this.makeAttribList(req));
            if (!DynaXML.isEmpty(source) && source.startsWith("http://")) {
                docReq = new DocRequest(docReq);
                docReq.source = source;
            } else {
                File docFile = new File(docReq.source);
                if (!docFile.canRead()) {
                    throw new InvalidDocumentException();
                }
            }
            if (!this.authenticate(docReq, req, res)) {
                return;
            }
            this.apply(docReq, req, res);
        }
        catch (Exception e) {
            if (!(e instanceof RedirectException) && !(e instanceof SocketException)) {
                try {
                    this.genErrorPage(req, res, e);
                }
                catch (RedirectException redirectException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DocRequest runDocReqParser(HttpServletRequest req, AttribList attribs) throws Exception {
        DocRequest info = new DocRequest();
        Iterator di = this.stylesheetCache.getDependencies(this.config.docLookupSheet);
        LinkedList oldStylesheetDeps = new LinkedList();
        while (di.hasNext()) {
            oldStylesheetDeps.add(di.next());
        }
        Templates sheet = this.stylesheetCache.find(this.config.docLookupSheet);
        Transformer trans = sheet.newTransformer();
        DynaXML.stuffAttribs(trans, this.config.attribs);
        DynaXML.stuffAttribs(trans, attribs);
        this.stuffSpecialAttribs(req, trans);
        if (!(trans.getErrorListener() instanceof XTFSaxonErrorListener)) {
            trans.setErrorListener(new XTFSaxonErrorListener());
        }
        XMLFormatter fmt = new XMLFormatter();
        fmt.blankLineAfterTag(false);
        this.buildParamBlock(attribs, fmt, this.config.tokenizerMap, null);
        if (Trace.getOutputLevel() >= 8) {
            String tmp = fmt.toString();
            if (tmp.endsWith("\n")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            Trace.debug("*** docReqParser input ***\n" + tmp);
        }
        TreeBuilder result = new TreeBuilder();
        trans.transform(fmt.toSource(), result);
        if (Trace.getOutputLevel() >= 8) {
            Trace.debug("*** docReqParser output ***");
            Trace.tab();
            Trace.debug(XMLWriter.toString(result.getCurrentRoot()));
            Trace.untab();
        }
        EasyNode root = new EasyNode(result.getCurrentRoot());
        int i = 0;
        while (i < root.nChildren()) {
            EasyNode el = root.child(i);
            String tagName = el.name();
            if (tagName.equals("style")) {
                info.style = this.getRealPath(el.attrValue("path"));
            } else if (tagName.equals("source")) {
                info.source = this.getRealPath(el.attrValue("path"));
            } else if (tagName.equals("index")) {
                info.indexConfig = this.getRealPath(el.attrValue("configPath"));
                info.indexName = el.attrValue("name");
            } else if (tagName.equals("brand")) {
                info.brand = this.getRealPath(el.attrValue("path"));
            } else if (tagName.equals("auth")) {
                info.authSpecs.add(this.authenticator.processAuthTag(el));
            } else if (tagName.equals("query")) {
                info.query = new QueryRequestParser().parseRequest(el.getWrappedNode(), new File(this.getRealPath("")));
            } else if (tagName.equalsIgnoreCase("preFilter")) {
                info.preFilter = this.getRealPath(el.attrValue("path"));
            } else {
                if (!tagName.equalsIgnoreCase("removeDoctypeDecl")) throw new DynaXMLException("Unknown tag '" + tagName + "' specified by docReqParser");
                String val = el.attrValue("flag");
                if (val.matches("^yes$|^true$")) {
                    info.removeDoctypeDecl = true;
                } else {
                    if (!val.matches("^no$|^false$")) throw new DynaXMLException("Expected 'true', 'false', 'yes', or 'no' for flag attribute of " + tagName + " tag specified by docReqParser, but found '" + val + "'");
                    info.removeDoctypeDecl = false;
                }
            }
            ++i;
        }
        if (DynaXML.isEmpty(info.source)) {
            throw new InvalidDocumentException();
        }
        DynaXML.requireOrElse(info.style, "docReqParser didn't specify 'style'");
        if (DynaXML.isEmpty(info.indexConfig) && !DynaXML.isEmpty(info.indexName)) {
            throw new GeneralException("docReqParser specified 'indexName' without 'indexConfig'");
        }
        if (DynaXML.isEmpty(info.indexConfig) || !DynaXML.isEmpty(info.indexName)) return info;
        throw new GeneralException("docReqParser specified 'indexConfig' without 'indexName'");
    }

    protected boolean authenticate(DocRequest docReq, HttpServletRequest req, HttpServletResponse res) throws Exception {
        String ipAddr = this.getClientIP(req);
        return this.authenticator.checkAuth(ipAddr, docReq.authSpecs, req, res);
    }

    public String getServletInfo() {
        return "dynaXML dynamic publishing servlet";
    }

    private void apply(DocRequest docReq, HttpServletRequest req, HttpServletResponse res) throws Exception {
        boolean dump = false;
        Templates pss = this.stylesheetCache.find(docReq.style);
        res.setContentType(DynaXML.calcMimeType(pss));
        Transformer transformer = pss.newTransformer();
        this.stuffAttribs(transformer, req);
        DynaXML.stuffAttribs(transformer, this.config.attribs);
        this.readBranding(docReq.brand, req, transformer);
        Source sourceDoc = this.getSourceDoc(docReq, transformer);
        String raw = req.getParameter("raw");
        if ("yes".equals(raw) || "true".equals(raw) || "1".equals(raw)) {
            res.setContentType("text/xml");
            transformer = IndexUtil.createTransformer();
            Properties props = transformer.getOutputProperties();
            props.put("indent", "yes");
            props.put("method", "xml");
            transformer.setOutputProperties(props);
        }
        if (dump && sourceDoc instanceof PersistentTree) {
            ((PersistentTree)((Object)sourceDoc)).setAllPermanent(true);
        }
        if (!(transformer.getErrorListener() instanceof XTFSaxonErrorListener)) {
            transformer.setErrorListener(new XTFSaxonErrorListener());
        }
        ((Controller)transformer).getExecutable().setStripsWhitespace(false);
        try {
            transformer.transform(sourceDoc, this.createFilteredReceiver(transformer, req, res));
        }
        finally {
            if (this.config.stylesheetProfiling) {
                Trace.info("Profile for request: " + DynaXML.getRequestURL(req));
                Trace.tab();
                ((PersistentTree)((Object)sourceDoc)).printProfile();
                Trace.untab();
                Trace.info("End of profile.");
            }
            if (dump && sourceDoc instanceof SearchTree) {
                ((SearchTree)sourceDoc).pruneUnused();
                File file = new File("C:\\tmp\\tree.dump");
                Trace.info("Dumping " + file.getAbsolutePath());
                PrintWriter outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                outWriter.println(XMLWriter.toString(sourceDoc));
                outWriter.close();
            }
            if (sourceDoc instanceof PersistentTree) {
                ((PersistentTree)((Object)sourceDoc)).close();
            }
        }
    }

    protected Source getSourceDoc(DocRequest docReq, Transformer transformer) throws IOException, SAXException, ParserConfigurationException, InvalidDocumentException {
        StructuredStore lazyStore;
        Templates preFilter = null;
        if (docReq.preFilter != null) {
            try {
                preFilter = this.stylesheetCache.find(docReq.preFilter);
            }
            catch (IOException e) {
                throw e;
            }
            catch (SAXException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((lazyStore = this.docLocator.getLazyStore(docReq.indexConfig, docReq.indexName, docReq.source, preFilter, docReq.removeDoctypeDecl)) == null) {
            File srcFile;
            if (docReq.query != null) {
                throw new UnsupportedQueryException();
            }
            if (!(docReq.source.startsWith("http://") || (srcFile = new File(docReq.source)).isFile() && srcFile.canRead())) {
                throw new InvalidDocumentException();
            }
            XMLReader xmlReader = IndexUtil.createXMLReader();
            InputSource inSrc = this.docLocator.getInputSource(docReq.source, docReq.removeDoctypeDecl);
            return new SAXSource(xmlReader, inSrc);
        }
        NodeInfo sourceDoc = null;
        Controller controller = (Controller)transformer;
        Configuration config = controller.getConfiguration();
        if (docReq.query != null && docReq.query.query != null) {
            String docKey = IndexUtil.calcDocKey(new File(this.getRealPath("")), new File(docReq.indexConfig), docReq.indexName, new File(docReq.source));
            SearchTree tree = new SearchTree(config, docKey, lazyStore);
            tree.search(this.createQueryProcessor(), docReq.query);
            sourceDoc = tree;
        } else {
            LazyTreeBuilder builder = new LazyTreeBuilder(config);
            builder.setNamePool(NamePool.getDefaultNamePool());
            sourceDoc = builder.load(lazyStore);
        }
        ((LazyDocument)sourceDoc).setDebug(true);
        Executable e = controller.getExecutable();
        KeyManager k = e.getKeyManager();
        if (!(k instanceof LazyKeyManager)) {
            e.setKeyManager(new LazyKeyManager(controller.getConfiguration(), k));
        }
        return sourceDoc;
    }

    public DocLocator createDocLocator() {
        String propName = "org.cdlib.xtf.DocLocatorClass";
        String className = System.getProperty("org.cdlib.xtf.DocLocatorClass");
        Class theClass = DefaultDocLocator.class;
        try {
            if (className != null) {
                theClass = Class.forName(className);
            }
            DocLocator loc = (DocLocator)theClass.newInstance();
            loc.setServlet(this);
            return loc;
        }
        catch (ClassCastException e) {
            Trace.error("Error: Class '" + className + "' specified by " + "the '" + "org.cdlib.xtf.DocLocatorClass" + "' property does not support the " + DocLocator.class.getName() + " interface");
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Trace.error("Error creating instance of class '" + className + "' specified by the '" + "org.cdlib.xtf.DocLocatorClass" + "' property");
            throw new RuntimeException(e);
        }
    }

    public void setProfiling(boolean flag) {
        this.config.stylesheetProfiling = flag;
    }
}

