/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;

public class LongList {
    private long[] data;
    private int size = 0;

    public LongList() {
        this(10);
    }

    public LongList(int initialCapacity) {
        this.data = new long[initialCapacity];
    }

    public final void add(long value) {
        if (this.size == this.data.length) {
            this.resize(Math.max(this.size + 5, this.size * 3 / 2));
        }
        this.data[this.size++] = value;
    }

    public final void ensureCapacity(int cap) {
        if (cap > this.data.length) {
            this.resize(cap);
        }
    }

    public final void compact() {
        this.resize(this.size);
    }

    public final void resize(int newSize) {
        if (newSize != this.data.length) {
            long[] oldData = this.data;
            this.data = new long[newSize];
            System.arraycopy(oldData, 0, this.data, 0, Math.min(this.size, newSize));
            this.size = Math.min(this.size, newSize);
        }
    }

    public final long[] toArray() {
        long[] ret = new long[this.size];
        System.arraycopy(this.data, 0, ret, 0, this.size);
        return ret;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        this.size = 0;
    }

    public final int size() {
        return this.size;
    }

    public final long get(int index) {
        return this.data[index];
    }

    public final long getLast() {
        return this.data[this.size - 1];
    }

    public final void set(int index, long value) {
        this.data[index] = value;
    }

    public final void fill(long value) {
        Arrays.fill(this.data, value);
    }

    public final void sort() {
        this.compact();
        Arrays.sort(this.data);
    }

    public final int binarySearch(long searchFor) {
        this.compact();
        return Arrays.binarySearch(this.data, searchFor);
    }

    public final int[] calcSortMap() {
        int[] map = new int[this.size];
        int i = 0;
        while (i < this.size) {
            if (this.data[i] < 0L) {
                throw new RuntimeException("This radix-sort cannot handle negative numbers");
            }
            map[i] = i;
            ++i;
        }
        int MAX_BITS = 64;
        short[] curByte = new short[this.size];
        int[] count = new int[256];
        int[] newMap = new int[this.size];
        int shift = 0;
        while (shift < 64) {
            Arrays.fill(count, 0);
            i = 0;
            while (i < this.size) {
                curByte[i] = (short)(this.data[map[i]] >> shift & 0xFFL);
                count[curByte[i]] = count[curByte[i]] + 1;
                ++i;
            }
            int pos = 0;
            i = 0;
            while (i < 256) {
                int tmp = pos;
                pos += count[i];
                count[i] = tmp;
                ++i;
            }
            i = 0;
            while (i < this.size) {
                short s = curByte[i];
                int n = count[s];
                count[s] = n + 1;
                newMap[n] = map[i];
                ++i;
            }
            int[] tmp = map;
            map = newMap;
            newMap = tmp;
            shift += 8;
        }
        long prev = Long.MIN_VALUE;
        i = 0;
        while (i < this.size) {
            long tmp = this.data[map[i]];
            if (tmp < prev) {
                throw new RuntimeException("Fatal internal error: sort algorithm has a bug");
            }
            prev = tmp;
            ++i;
        }
        return map;
    }

    public final void remap(int[] map) {
        long[] newData = new long[this.size];
        assert (map.length == this.size);
        int i = 0;
        while (i < this.size) {
            newData[i] = this.data[map[i]];
            ++i;
        }
        this.data = newData;
    }
}

