/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.PriorityQueue;

public class SpanOrQuery
extends SpanQuery {
    private List clauses;
    private String field;

    public SpanOrQuery(SpanQuery[] clauses) {
        this.clauses = new ArrayList(clauses.length);
        int i = 0;
        while (i < clauses.length) {
            SpanQuery clause = clauses[i];
            if (i == 0) {
                this.field = clause.getField();
            } else if (!clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
            ++i;
        }
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList terms = new ArrayList();
        for (SpanQuery clause : this.clauses) {
            terms.addAll(clause.getTerms());
        }
        return terms;
    }

    public Query[] getSubQueries() {
        return this.clauses.toArray(new Query[this.clauses.size()]);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ArrayList<SpanQuery> newClauses = new ArrayList<SpanQuery>(this.clauses.size());
        boolean anyChanged = false;
        for (SpanQuery clause : this.clauses) {
            SpanQuery rewrittenClause = (SpanQuery)clause.rewrite(reader);
            newClauses.add(rewrittenClause);
            if (clause == rewrittenClause) continue;
            anyChanged = true;
        }
        if (!anyChanged) {
            return this;
        }
        SpanOrQuery clone = (SpanOrQuery)this.clone();
        clone.clauses = newClauses;
        return clone;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanOr([");
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = (SpanQuery)i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        return buffer.toString();
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(reader, searcher);
        }
        return new Spans(reader, searcher){
            private List all;
            private SpanQueue queue;
            private boolean firstTime;
            {
                this.all = new ArrayList(SpanOrQuery.this.clauses.size());
                this.queue = new SpanQueue(SpanOrQuery.this.clauses.size());
                Iterator i = SpanOrQuery.this.clauses.iterator();
                while (i.hasNext()) {
                    this.all.add(((SpanQuery)i.next()).getSpans(indexReader, searcher));
                }
                this.firstTime = true;
            }

            public boolean next() throws IOException {
                if (this.firstTime) {
                    int i = 0;
                    while (i < this.all.size()) {
                        Spans spans = (Spans)this.all.get(i);
                        if (spans.next()) {
                            this.queue.put(spans);
                        } else {
                            this.all.remove(i--);
                        }
                        ++i;
                    }
                    this.firstTime = false;
                    return this.queue.size() != 0;
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.adjustTop();
                    return true;
                }
                this.all.remove(this.queue.pop());
                return this.queue.size() != 0;
            }

            private Spans top() {
                return (Spans)this.queue.top();
            }

            /*
             * Unable to fully structure code
             */
            public boolean skipTo(int target) throws IOException {
                block5: {
                    if (!this.firstTime) ** GOTO lbl19
                    i = 0;
                    while (i < this.all.size()) {
                        spans = (Spans)this.all.get(i);
                        if (spans.skipTo(target)) {
                            this.queue.put(spans);
                        } else {
                            this.all.remove(i--);
                        }
                        ++i;
                    }
                    this.firstTime = false;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        if (this.top().skipTo(target)) {
                            this.queue.adjustTop();
                            continue;
                        }
                        this.all.remove(this.queue.pop());
lbl19:
                        // 3 sources

                        ** while (this.queue.size() != 0 && this.top().doc() < target)
                    }
                }
                return this.queue.size() != 0;
            }

            public int doc() {
                return this.top().doc();
            }

            public int start() {
                return this.top().start();
            }

            public int end() {
                return this.top().end();
            }

            public float score() {
                return this.top().score() * SpanOrQuery.this.getBoost();
            }

            public String toString() {
                return "spans(" + SpanOrQuery.this + ")@" + (this.firstTime ? "START" : (this.queue.size() > 0 ? String.valueOf(this.doc()) + ":" + this.start() + "-" + this.end() : "END"));
            }

            public Explanation explain() throws IOException {
                if (SpanOrQuery.this.getBoost() == 1.0f) {
                    return this.top().explain();
                }
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanOrQuery.this.getBoost(), "boost");
                result.addDetail(boostExpl);
                Explanation inclExpl = this.top().explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }

    private class SpanQueue
    extends PriorityQueue {
        public SpanQueue(int size) {
            this.initialize(size);
        }

        protected final boolean lessThan(Object o1, Object o2) {
            Spans spans1 = (Spans)o1;
            Spans spans2 = (Spans)o2;
            if (spans1.doc() == spans2.doc()) {
                if (spans1.start() == spans2.start()) {
                    if (spans1.score() == spans2.score()) {
                        return spans1.end() < spans2.end();
                    }
                    return spans1.score() > spans2.score();
                }
                return spans1.start() < spans2.start();
            }
            return spans1.doc() < spans2.doc();
        }
    }
}

