/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class FlippableStringComparator
implements SortComparatorSource {
    private static final WeakHashMap cache = new WeakHashMap();

    public ScoreDocComparator newComparator(IndexReader reader, String fieldName) throws IOException {
        FlippableComp comp;
        HashMap<String, FlippableComp> readerCache = (HashMap<String, FlippableComp>)cache.get(reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, FlippableComp>();
            cache.put(reader, readerCache);
        }
        if ((comp = (FlippableComp)readerCache.get(fieldName = fieldName.intern())) == null) {
            comp = new FlippableComp(reader, fieldName);
            readerCache.put(fieldName, comp);
        }
        return comp;
    }

    private class FlippableComp
    implements ScoreDocComparator {
        boolean flipEmpty = false;
        FieldCache.StringIndex index;

        FlippableComp(IndexReader reader, String field) throws IOException {
            if (field.endsWith(":flipEmpty")) {
                this.flipEmpty = true;
                field = field.replace(":flipEmpty", "");
            }
            field = field.intern();
            this.index = FieldCache.DEFAULT.getStringIndex(reader, field);
        }

        public final int compare(ScoreDoc i, ScoreDoc j) {
            int fi = this.index.order[i.doc];
            int fj = this.index.order[j.doc];
            if (!this.flipEmpty) {
                if (fi == 0) {
                    fi = Integer.MAX_VALUE;
                }
                if (fj == 0) {
                    fj = Integer.MAX_VALUE;
                }
            }
            if (fi < fj) {
                return -1;
            }
            if (fi > fj) {
                return 1;
            }
            return 0;
        }

        public Comparable sortValue(ScoreDoc i) {
            return this.index.lookup[this.index.order[i.doc]];
        }

        public int sortType() {
            return 9;
        }
    }
}

