/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bigram;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class BigramStopFilter
extends TokenFilter {
    private Set stopSet;
    private boolean firstTime = true;
    private Token nextToken = null;
    private Token outputQueue = null;
    private int accumIncrement = 0;
    private int outputPos = 0;
    private int inputPos = 0;
    public static final Object tester = new Object(){
        private HashSet stopSet = new HashSet();

        private String testFilter(String in) throws IOException {
            Token t;
            StringTokenStream sts = new StringTokenStream(in, " .");
            BigramStopFilter nsf = new BigramStopFilter(sts, this.stopSet);
            StringBuffer outBuf = new StringBuffer();
            while ((t = nsf.next()) != null) {
                int i = 0;
                while (i < t.getPositionIncrement()) {
                    outBuf.append('/');
                    ++i;
                }
                if (t.getPositionIncrement() == 0) {
                    outBuf.append(',');
                }
                outBuf.append(in.substring(t.startOffset(), t.endOffset()));
            }
            String out = outBuf.toString();
            out = out.replaceAll(" ", "");
            return out;
        }

        protected void testImpl() {
            block17: {
                this.stopSet.add("a");
                this.stopSet.add("b");
                this.stopSet.add("c");
                this.stopSet.add("d");
                this.stopSet.add("e");
                try {
                    if (!$assertionsDisabled && !this.testFilter("x y").equals("/x/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a y").equals("/x,xa/ay/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b y z").equals("/x,xa/ab/by/y/z")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b c y").equals("/x,xa/ab/bc/cy/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b c d y e").equals("/x,xa/ab/bc/cd/dy/y,ye")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b").equals("/x,xa/ab")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("a b y").equals("/ab/by/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x.y.z").equals("/x/////y/////z")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a.b y").equals("/x,xa//////by/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x.a b y").equals("/x/////ab/by/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b.y").equals("/x,xa/ab//////y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b.c y").equals("/x,xa/ab//////cy/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x a b.c d y").equals("/x,xa/ab//////cd/dy/y")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("a x.y b z").equals("/ax/x/////y,yb/bz/z")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !this.testFilter("x y a.z").equals("/x/y,ya//////z")) {
                        throw new AssertionError();
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block17;
                    throw new AssertionError();
                }
            }
        }

        class StringTokenStream
        extends TokenStream {
            private String str;
            private int prevEnd = 0;
            private StringTokenizer tok;
            private int count = 0;

            public StringTokenStream(String str, String delim) {
                this.str = str;
                this.tok = new StringTokenizer(str, delim);
            }

            public Token next() {
                if (!this.tok.hasMoreTokens()) {
                    return null;
                }
                ++this.count;
                String term = this.tok.nextToken();
                Token t = new Token(term, this.str.indexOf(term, this.prevEnd), this.str.indexOf(term, this.prevEnd) + term.length(), "word");
                if (t.startOffset() > 0 && this.str.charAt(t.startOffset() - 1) == '.') {
                    t.setPositionIncrement(5);
                }
                this.prevEnd = t.endOffset();
                return t;
            }
        }
    };

    public BigramStopFilter(TokenStream input, Set stopSet) {
        super(input);
        this.stopSet = stopSet;
    }

    public static Set makeStopSet(String stopWords) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer stok = new StringTokenizer(stopWords, " \r\n\t\f\b,;");
        while (stok.hasMoreTokens()) {
            set.add(stok.nextToken().toLowerCase());
        }
        return set;
    }

    public Token next() throws IOException {
        Token t = this.nextInternal();
        if (t != null) {
            this.outputPos += t.getPositionIncrement();
            assert (this.outputPos <= this.inputPos);
        }
        return t;
    }

    public Token nextInternal() throws IOException {
        Token curToken;
        if (this.firstTime) {
            this.nextToken = this.nextInput();
            this.firstTime = false;
        }
        if (this.outputQueue != null) {
            Token t = this.outputQueue;
            this.outputQueue = null;
            return t;
        }
        while (true) {
            boolean curIsReal;
            if ((curToken = this.nextToken) == null) {
                return null;
            }
            this.nextToken = this.nextInput();
            boolean bl = curIsReal = !this.isStopWord(curToken.termText());
            if (curIsReal) {
                boolean nextIsReal;
                boolean bl2 = nextIsReal = this.nextToken != null && !this.isStopWord(this.nextToken.termText()) && this.nextToken.getPositionIncrement() == 1;
                if (this.accumIncrement > 0) {
                    curToken.setPositionIncrement(curToken.getPositionIncrement() + this.accumIncrement);
                    this.accumIncrement = 0;
                }
                if (nextIsReal) {
                    return curToken;
                }
                if (this.nextToken != null && this.nextToken.getPositionIncrement() == 1) {
                    this.outputQueue = this.glomToken(curToken, this.nextToken, 0);
                }
                return curToken;
            }
            if (this.nextToken != null && this.nextToken.getPositionIncrement() <= 1) break;
            this.accumIncrement += curToken.getPositionIncrement();
        }
        return this.glomToken(curToken, this.nextToken, 1);
    }

    private Token nextInput() throws IOException {
        Token t = this.input.next();
        if (t != null) {
            this.inputPos += t.getPositionIncrement();
        }
        return t;
    }

    protected boolean isStopWord(String word) {
        return this.stopSet.contains(word);
    }

    private Token glomToken(Token token1, Token token2, int increment) {
        Token token = new Token(String.valueOf(token1.termText()) + "~" + token2.termText(), token1.startOffset(), token2.endOffset(), token1.type());
        assert (token2.getPositionIncrement() == 1) : "Cannot glom around word bumps";
        if (increment == 0) {
            token.setPositionIncrement(0);
        } else {
            token.setPositionIncrement(token1.getPositionIncrement() - 1 + increment + this.accumIncrement);
        }
        this.accumIncrement = 0;
        return token;
    }
}

