/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.Tokenize;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.IdrefTest;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class KeyManager
implements Serializable {
    public IntHashMap keyList = new IntHashMap(10);
    private transient WeakHashMap docIndexes = new WeakHashMap(10);

    public KeyManager(Configuration config) {
        this.registerIdrefKey(config);
    }

    private void registerIdrefKey(Configuration config) {
        IdrefTest idref = IdrefTest.getInstance();
        Atomizer eval = new Atomizer(new ContextItemExpression(), config);
        Tokenize use = (Tokenize)SystemFunction.makeSystemFunction("tokenize", 2, config.getNamePool());
        StringLiteral regex = new StringLiteral("\\s");
        Expression[] params = new Expression[]{eval, regex};
        use.setArguments(params);
        KeyDefinition key = new KeyDefinition(idref, use, null, null);
        key.setIndexedItemType(BuiltInAtomicType.STRING);
        try {
            this.addKeyDefinition(562, key, config);
        }
        catch (StaticError err) {
            throw new AssertionError((Object)err);
        }
    }

    public void addKeyDefinition(int fingerprint, KeyDefinition keydef, Configuration config) throws StaticError {
        int i;
        ArrayList<KeyDefinition> v = (ArrayList<KeyDefinition>)this.keyList.get(fingerprint);
        if (v == null) {
            v = new ArrayList<KeyDefinition>(3);
            this.keyList.put(fingerprint, v);
        } else {
            String collation = keydef.getCollationName();
            if (collation == null) {
                i = 0;
                while (i < v.size()) {
                    if (((KeyDefinition)v.get(i)).getCollationName() != null) {
                        StaticError err = new StaticError("All keys with the same name must use the same collation");
                        err.setErrorCode("XTSE1220");
                        throw err;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < v.size()) {
                    if (!collation.equals(((KeyDefinition)v.get(i)).getCollationName())) {
                        StaticError err = new StaticError("All keys with the same name must use the same collation");
                        err.setErrorCode("XTSE1220");
                        throw err;
                    }
                    ++i;
                }
            }
        }
        v.add(keydef);
        boolean backwardsCompatible = false;
        i = 0;
        while (i < v.size()) {
            if (((KeyDefinition)v.get(i)).isBackwardsCompatible()) {
                backwardsCompatible = true;
                break;
            }
            ++i;
        }
        if (backwardsCompatible) {
            i = 0;
            while (i < v.size()) {
                KeyDefinition kd = (KeyDefinition)v.get(i);
                kd.setBackwardsCompatible(true);
                if (!kd.getBody().getItemType(config.getTypeHierarchy()).equals(BuiltInAtomicType.STRING)) {
                    AtomicSequenceConverter exp = new AtomicSequenceConverter(kd.getBody(), BuiltInAtomicType.STRING);
                    kd.setBody(exp);
                }
                ++i;
            }
        }
    }

    public List getKeyDefinitions(int fingerprint) {
        return (List)this.keyList.get(fingerprint);
    }

    public synchronized Map buildIndex(int keyNameFingerprint, BuiltInAtomicType itemType, Set foundItemTypes, DocumentInfo doc, XPathContext context) throws XPathException {
        List definitions = this.getKeyDefinitions(keyNameFingerprint);
        if (definitions == null) {
            DynamicError de = new DynamicError("Key " + context.getNamePool().getDisplayName(keyNameFingerprint) + " has not been defined");
            de.setXPathContext(context);
            de.setErrorCode("XTDE1260");
            throw de;
        }
        HashMap index = new HashMap(100);
        int k = 0;
        while (k < definitions.size()) {
            this.constructIndex(doc, index, (KeyDefinition)definitions.get(k), itemType, foundItemTypes, context, k == 0);
            ++k;
        }
        return index;
    }

    protected void constructIndex(DocumentInfo doc, Map index, KeyDefinition keydef, BuiltInAtomicType soughtItemType, Set foundItemTypes, XPathContext context, boolean isFirst) throws XPathException {
        Item item;
        PatternFinder match = keydef.getMatch();
        XPathContextMajor xc = context.newContext();
        xc.setOrigin(keydef);
        SlotManager map = keydef.getStackFrameMap();
        if (map != null) {
            xc.openStackFrame(map);
        }
        SequenceIterator iter = match.selectNodes(doc, xc);
        while ((item = iter.next()) != null) {
            this.processKeyNode((NodeInfo)item, soughtItemType, foundItemTypes, keydef, index, xc, isFirst);
        }
    }

    private void processKeyNode(NodeInfo curr, BuiltInAtomicType soughtItemType, Set foundItemTypes, KeyDefinition keydef, Map index, XPathContext xc, boolean isFirst) throws XPathException {
        AtomicValue item;
        AxisIterator si = SingleNodeIterator.makeIterator(curr);
        si.next();
        xc.setCurrentIterator(si);
        Platform platform = null;
        StringCollator collation = keydef.getCollation();
        if (collation != null) {
            platform = Configuration.getPlatform();
        }
        SequenceIterable use = keydef.getUse();
        SequenceIterator useval = use.iterate(xc);
        while ((item = (AtomicValue)useval.next()) != null) {
            Object val;
            BuiltInAtomicType actualItemType = item.getPrimitiveType();
            if (foundItemTypes != null) {
                foundItemTypes.add(actualItemType);
            }
            if (!Type.isComparable(actualItemType, soughtItemType, false)) {
                if (keydef.isStrictComparison()) {
                    DynamicError de = new DynamicError("Cannot compare " + soughtItemType + " to " + actualItemType + " using 'eq'");
                    de.setErrorCode("XPTY0004");
                    throw de;
                }
                if (keydef.isConvertUntypedToOther() && actualItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    item = item.convert(soughtItemType, xc);
                } else if (!keydef.isConvertUntypedToOther() || !soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) continue;
            }
            if (soughtItemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                val = collation == null ? item.getStringValue() : collation.getCollationKey(item.getStringValue(), platform);
            } else if (soughtItemType.equals(BuiltInAtomicType.STRING)) {
                val = collation == null ? item.getStringValue() : collation.getCollationKey(item.getStringValue(), platform);
            } else {
                if (item instanceof NumericValue && ((NumericValue)item).isNaN()) break;
                try {
                    val = item.convert(soughtItemType, xc);
                }
                catch (XPathException err) {
                    break;
                }
            }
            ArrayList<NodeInfo> nodes = (ArrayList<NodeInfo>)index.get(val);
            if (nodes == null) {
                nodes = new ArrayList<NodeInfo>(4);
                index.put(val, nodes);
                nodes.add(curr);
                continue;
            }
            if (isFirst) {
                if (nodes.get(nodes.size() - 1) == curr) continue;
                nodes.add(curr);
                continue;
            }
            LocalOrderComparer comparer = LocalOrderComparer.getInstance();
            int i = 0;
            while (i < nodes.size()) {
                int d = comparer.compare(curr, (NodeInfo)nodes.get(i));
                if (d <= 0) {
                    if (d != 0) {
                        nodes.add(i, curr);
                    }
                    return;
                }
                ++i;
            }
            nodes.add(curr);
        }
    }

    public SequenceIterator selectByKey(int keyNameFingerprint, DocumentInfo doc, AtomicValue soughtValue, XPathContext context) throws XPathException {
        Map indexList;
        BuiltInAtomicType itemType;
        Object indexObject;
        boolean backwardsCompatible;
        if (soughtValue == null) {
            return EmptyIterator.getInstance();
        }
        List definitions = this.getKeyDefinitions(keyNameFingerprint);
        if (definitions == null) {
            throw new DynamicError("Key " + context.getNamePool().getDisplayName(keyNameFingerprint) + " has not been defined", "XTDE1260", context);
        }
        KeyDefinition definition = (KeyDefinition)definitions.get(0);
        StringCollator collation = definition.getCollation();
        Platform platform = null;
        if (collation != null) {
            platform = Configuration.getPlatform();
        }
        if (backwardsCompatible = definition.isBackwardsCompatible()) {
            soughtValue = soughtValue.convert(BuiltInAtomicType.STRING, context);
        } else {
            BuiltInAtomicType itemType2 = soughtValue.getPrimitiveType();
            if (itemType2.equals(BuiltInAtomicType.INTEGER) || itemType2.equals(BuiltInAtomicType.DECIMAL) || itemType2.equals(BuiltInAtomicType.FLOAT)) {
                soughtValue = new DoubleValue(((NumericValue)soughtValue).getDoubleValue());
            }
        }
        HashSet foundItemTypes = null;
        AtomicValue value = soughtValue;
        if (soughtValue instanceof UntypedAtomicValue && definition.isConvertUntypedToOther()) {
            BuiltInAtomicType useType = definition.getIndexedItemType();
            if (useType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                foundItemTypes = new HashSet(10);
                useType = BuiltInAtomicType.STRING;
            }
            value = soughtValue.convert(useType, context);
        }
        if ((indexObject = this.getIndex(doc, keyNameFingerprint, itemType = value.getPrimitiveType())) instanceof String) {
            DynamicError de = new DynamicError("Key definition is circular");
            de.setXPathContext(context);
            de.setErrorCode("XTDE0640");
            throw de;
        }
        Map index = (Map)indexObject;
        if (index == null) {
            this.putIndex(doc, keyNameFingerprint, itemType, "Under Construction", context);
            index = this.buildIndex(keyNameFingerprint, itemType, foundItemTypes, doc, context);
            this.putIndex(doc, keyNameFingerprint, itemType, index, context);
            if (foundItemTypes != null) {
                for (BuiltInAtomicType t : foundItemTypes) {
                    if (t.equals(BuiltInAtomicType.STRING)) continue;
                    this.putIndex(doc, keyNameFingerprint, t, "Under Construction", context);
                    index = this.buildIndex(keyNameFingerprint, t, null, doc, context);
                    this.putIndex(doc, keyNameFingerprint, t, index, context);
                }
            }
        }
        if (foundItemTypes == null) {
            ArrayList nodes = (ArrayList)index.get(KeyManager.getCollationKey(value, itemType, collation, platform));
            if (nodes == null) {
                return EmptyIterator.getInstance();
            }
            return new ListIterator(nodes);
        }
        LookaheadIterator result = null;
        WeakReference ref = (WeakReference)this.docIndexes.get(doc);
        if (ref != null && (indexList = (Map)ref.get()) != null) {
            Iterator i = indexList.keySet().iterator();
            while (i.hasNext()) {
                ArrayList nodes;
                long key = (Long)i.next();
                if ((key >> 32 & 0xFFFFFFFFFFFFFFFFL) != (long)keyNameFingerprint) continue;
                int typefp = (int)(key & 0xFFFFFFFFFFFFFFFFL);
                BuiltInAtomicType type = (BuiltInAtomicType)BuiltInType.getSchemaType(typefp);
                Object indexObject2 = this.getIndex(doc, keyNameFingerprint, type);
                if (indexObject2 instanceof String) {
                    DynamicError de = new DynamicError("Key definition is circular");
                    de.setXPathContext(context);
                    de.setErrorCode("XTDE0640");
                    throw de;
                }
                Map index2 = (Map)indexObject2;
                if (index2.size() <= 0 || (nodes = (ArrayList)index2.get(KeyManager.getCollationKey(value = soughtValue.convert(type, context), type, collation, platform))) == null) continue;
                result = result == null ? new ListIterator(nodes) : new UnionEnumeration(result, new ListIterator(nodes), LocalOrderComparer.getInstance());
            }
        }
        if (result == null) {
            return EmptyIterator.getInstance();
        }
        return result;
    }

    private static Object getCollationKey(AtomicValue value, BuiltInAtomicType itemType, StringCollator collation, Platform platform) {
        Object val = itemType.equals(BuiltInAtomicType.STRING) || itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? (collation == null ? value.getStringValue() : collation.getCollationKey(value.getStringValue(), platform)) : value;
        return val;
    }

    private synchronized void putIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType, Object index, XPathContext context) {
        Map<Long, Object> indexList;
        WeakReference indexRef;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((indexRef = (WeakReference)this.docIndexes.get(doc)) == null || indexRef.get() == null) {
            indexList = new HashMap(10);
            context.getController().setUserData(doc, "key-index-list", indexList);
            this.docIndexes.put(doc, new WeakReference(indexList));
        } else {
            indexList = (Map)indexRef.get();
        }
        indexList.put(new Long((long)keyFingerprint << 32 | (long)itemType.getFingerprint()), index);
    }

    private synchronized Object getIndex(DocumentInfo doc, int keyFingerprint, AtomicType itemType) {
        WeakReference ref;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap(10);
        }
        if ((ref = (WeakReference)this.docIndexes.get(doc)) == null) {
            return null;
        }
        Map indexList = (Map)ref.get();
        if (indexList == null) {
            return null;
        }
        return indexList.get(new Long((long)keyFingerprint << 32 | (long)itemType.getFingerprint()));
    }

    public void explainKeys(Configuration config, PrintStream out) {
        if (this.keyList.size() < 2) {
            return;
        }
        out.println("============ Indexes ======================");
        IntIterator keyIter = this.keyList.keyIterator();
        while (keyIter.hasNext()) {
            int fp = keyIter.next();
            List list = (List)this.keyList.get(fp);
            int i = 0;
            while (i < list.size()) {
                KeyDefinition kd = (KeyDefinition)list.get(i);
                out.println(" Index " + config.getNamePool().getDisplayName(fp));
                out.println("   match = ");
                out.println(kd.getMatch().toString());
                if (kd.getUse() instanceof Expression) {
                    out.println("   use = ");
                    ((Expression)kd.getUse()).display(10, out, config);
                }
                ++i;
            }
        }
        out.println("===========================================");
    }
}

