/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.marc4j.MarcHandler;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcException;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.util.CharacterConverter;
import org.marc4j.util.UnicodeToAnsel;

public class MarcWriter
implements MarcHandler {
    private Record record;
    private DataField datafield;
    private Writer out;
    private CharacterConverter charconv = null;

    public MarcWriter() throws IOException {
        this(System.out);
    }

    public MarcWriter(OutputStream outputStream) throws IOException {
        this(new OutputStreamWriter(outputStream));
    }

    public MarcWriter(OutputStream outputStream, String string) throws IOException {
        this(new OutputStreamWriter(outputStream, string));
    }

    public MarcWriter(Writer writer) {
        this.setWriter(writer);
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public void setUnicodeToAnsel(boolean bl) {
        if (bl) {
            this.charconv = new UnicodeToAnsel();
        }
    }

    public void setCharacterConverter(CharacterConverter characterConverter) {
        this.charconv = characterConverter;
    }

    public void setWriter(Writer writer, boolean bl) {
        this.out = writer;
        this.setUnicodeToAnsel(bl);
    }

    public void startCollection() {
        if (this.out == null) {
            System.exit(0);
        }
    }

    public void startRecord(Leader leader) {
        this.record = new Record();
        this.record.add(leader);
    }

    public void controlField(String string, char[] cArray) {
        this.record.add(new ControlField(string, cArray));
    }

    public void startDataField(String string, char c, char c2) {
        this.datafield = new DataField(string, c, c2);
    }

    public void subfield(char c, char[] cArray) {
        if (this.charconv != null) {
            this.datafield.add(new Subfield(c, this.charconv.convert(cArray)));
        } else {
            this.datafield.add(new Subfield(c, cArray));
        }
    }

    public void endDataField(String string) {
        this.record.add(this.datafield);
    }

    public void endRecord() {
        try {
            this.rawWrite(this.record.marshal());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MarcException marcException) {
            marcException.printStackTrace();
        }
    }

    public void endCollection() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void rawWrite(String string) throws IOException {
        this.out.write(string);
    }
}

