/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.marc4j.marc.MarcException;
import org.marc4j.marc.Verifier;

public class Leader
implements Serializable {
    private int recordLength;
    private char recordStatus;
    private char typeOfRecord;
    private char[] implDefined1;
    private char charCodingScheme;
    private int indicatorCount;
    private int subfieldCodeLength;
    private int baseAddressOfData;
    private char[] implDefined2;
    private char[] entryMap;
    DecimalFormat df = new DecimalFormat("00000");

    public Leader() {
    }

    public Leader(String string) throws MarcException {
        this.unmarshal(string);
    }

    public void setRecordLength(int n) {
        this.recordLength = n;
    }

    public void setRecordStatus(char c) {
        Verifier.checkDataElement(c);
        this.recordStatus = c;
    }

    public void setTypeOfRecord(char c) {
        Verifier.checkDataElement(c);
        this.typeOfRecord = c;
    }

    public void setImplDefined1(char[] cArray) {
        Verifier.checkDataElement(cArray);
        this.implDefined1 = cArray;
    }

    public void setCharCodingScheme(char c) {
        Verifier.checkDataElement(c);
        this.charCodingScheme = c;
    }

    public void setIndicatorCount(int n) {
        this.indicatorCount = n;
    }

    public void setSubfieldCodeLength(int n) {
        this.subfieldCodeLength = n;
    }

    public void setBaseAddressOfData(int n) {
        this.baseAddressOfData = n;
    }

    public void setImplDefined2(char[] cArray) {
        Verifier.checkDataElement(cArray);
        this.implDefined2 = cArray;
    }

    public void setEntryMap(char[] cArray) {
        Verifier.checkDataElement(cArray);
        this.entryMap = cArray;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public char getRecordStatus() {
        return this.recordStatus;
    }

    public char getTypeOfRecord() {
        return this.typeOfRecord;
    }

    public char[] getImplDefined1() {
        return this.implDefined1;
    }

    public char getCharCodingScheme() {
        return this.charCodingScheme;
    }

    public int getIndicatorCount() {
        return this.indicatorCount;
    }

    public int getSubfieldCodeLength() {
        return this.subfieldCodeLength;
    }

    public int getBaseAddressOfData() {
        return this.baseAddressOfData;
    }

    public char[] getImplDefined2() {
        return this.implDefined2;
    }

    public char[] getEntryMap() {
        return this.entryMap;
    }

    public void unmarshal(String string) throws MarcException {
        try {
            String string2 = string.substring(0, 5);
            if (this.isInteger(string2)) {
                this.setRecordLength(Integer.parseInt(string2));
            } else {
                this.setRecordLength(0);
            }
            this.setRecordStatus(string.charAt(5));
            this.setTypeOfRecord(string.charAt(6));
            this.setImplDefined1(string.substring(7, 9).toCharArray());
            this.setCharCodingScheme(string.charAt(9));
            string2 = String.valueOf(string.charAt(10));
            if (this.isInteger(string2)) {
                this.setIndicatorCount(Integer.parseInt(string2));
            } else {
                this.setIndicatorCount(2);
            }
            string2 = String.valueOf(string.charAt(10));
            if (this.isInteger(string2)) {
                this.setSubfieldCodeLength(Integer.parseInt(string2));
            } else {
                this.setSubfieldCodeLength(2);
            }
            string2 = string.substring(12, 17);
            if (this.isInteger(string2)) {
                this.setBaseAddressOfData(Integer.parseInt(string2));
            } else {
                this.setBaseAddressOfData(0);
            }
            this.setImplDefined2(string.substring(17, 20).toCharArray());
            this.setEntryMap(string.substring(20, 24).toCharArray());
        }
        catch (NumberFormatException numberFormatException) {
            throw new MarcException("Unable to parse leader", numberFormatException);
        }
    }

    public String marshal() {
        return this.df.format(this.recordLength).toString() + this.recordStatus + this.typeOfRecord + this.implDefined1 + this.charCodingScheme + this.indicatorCount + this.subfieldCodeLength + this.df.format(this.baseAddressOfData).toString() + this.implDefined2 + this.entryMap;
    }

    private boolean isInteger(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        do {
            switch (string.charAt(n2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++n2 < n);
        return true;
    }
}

