/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db.internal;

import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.EventHandler;
import com.sleepycat.db.FeedbackHandler;
import com.sleepycat.db.LockRequest;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogRecordHandler;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.MessageHandler;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.PanicHandler;
import com.sleepycat.db.PreparedTransaction;
import com.sleepycat.db.RecoveryOperation;
import com.sleepycat.db.ReplicationHostAddress;
import com.sleepycat.db.ReplicationManagerStats;
import com.sleepycat.db.ReplicationStats;
import com.sleepycat.db.ReplicationTransport;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.internal.DbLock;
import com.sleepycat.db.internal.DbLogc;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.db_java;
import com.sleepycat.db.internal.db_javaJNI;
import com.sleepycat.util.ErrorBuffer;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;

public class DbEnv {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private long dbenv_ref;
    public Environment wrapper;
    private LogRecordHandler app_dispatch_handler;
    private EventHandler event_notify_handler;
    private FeedbackHandler env_feedback_handler;
    private ErrorHandler error_handler;
    private String errpfx;
    private MessageHandler message_handler;
    private PanicHandler panic_handler;
    private ReplicationTransport rep_transport_handler;
    private OutputStream error_stream;
    private OutputStream message_stream;
    private ThreadLocal errBuf;

    protected DbEnv(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DbEnv obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            throw new UnsupportedOperationException("C++ destructor does not have public access");
        }
        this.swigCPtr = 0L;
    }

    void initialize() {
        this.dbenv_ref = db_java.initDbEnvRef0(this, this);
        this.errBuf = new ThreadLocal();
        this.set_error_stream(System.err);
        this.set_message_stream(System.out);
    }

    void cleanup() {
        this.swigCPtr = 0L;
        db_java.deleteRef0(this.dbenv_ref);
        this.dbenv_ref = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(int flags) throws DatabaseException {
        try {
            this.close0(flags);
        }
        finally {
            this.cleanup();
        }
    }

    private final int handle_app_dispatch(DatabaseEntry dbt, LogSequenceNumber lsn, int recops) {
        return this.app_dispatch_handler.handleLogRecord(this.wrapper, dbt, lsn, RecoveryOperation.fromFlag(recops));
    }

    public LogRecordHandler get_app_dispatch() throws DatabaseException {
        return this.app_dispatch_handler;
    }

    private final void handle_panic_event_notify() {
        this.event_notify_handler.handlePanicEvent();
    }

    private final void handle_rep_client_event_notify() {
        this.event_notify_handler.handleRepClientEvent();
    }

    private final void handle_rep_elected_event_notify() {
        this.event_notify_handler.handleRepElectedEvent();
    }

    private final void handle_rep_master_event_notify() {
        this.event_notify_handler.handleRepMasterEvent();
    }

    private final void handle_rep_new_master_event_notify(int envid) {
        this.event_notify_handler.handleRepNewMasterEvent(envid);
    }

    private final void handle_rep_perm_failed_event_notify() {
        this.event_notify_handler.handleRepPermFailedEvent();
    }

    private final void handle_rep_startup_done_event_notify() {
        this.event_notify_handler.handleRepStartupDoneEvent();
    }

    private final void handle_write_failed_event_notify(int errno) {
        this.event_notify_handler.handleWriteFailedEvent(errno);
    }

    public EventHandler get_event_notify() throws DatabaseException {
        return this.event_notify_handler;
    }

    private final void handle_env_feedback(int opcode, int percent) {
        if (opcode == 64) {
            this.env_feedback_handler.recoveryFeedback(this.wrapper, percent);
        }
    }

    public FeedbackHandler get_feedback() throws DatabaseException {
        return this.env_feedback_handler;
    }

    public void set_errpfx(String errpfx) {
        this.errpfx = errpfx;
    }

    public String get_errpfx() {
        return this.errpfx;
    }

    private final void handle_error(String msg) {
        ErrorBuffer ebuf = (ErrorBuffer)this.errBuf.get();
        if (ebuf == null) {
            ebuf = new ErrorBuffer(3);
            this.errBuf.set(ebuf);
        }
        ebuf.append(msg);
        this.error_handler.error(this.wrapper, this.errpfx, msg);
    }

    private final String get_err_msg(String orig_msg) {
        ErrorBuffer ebuf = (ErrorBuffer)this.errBuf.get();
        String ret = null;
        if (ebuf != null) {
            ret = ebuf.get();
            ebuf.clear();
        }
        if (ret != null && ret.length() > 0) {
            return orig_msg + ": " + ret;
        }
        return orig_msg;
    }

    public ErrorHandler get_errcall() {
        return this.error_handler;
    }

    private final void handle_message(String msg) {
        this.message_handler.message(this.wrapper, msg);
    }

    public MessageHandler get_msgcall() {
        return this.message_handler;
    }

    private final void handle_panic(DatabaseException e) {
        this.panic_handler.panic(this.wrapper, e);
    }

    public PanicHandler get_paniccall() throws DatabaseException {
        return this.panic_handler;
    }

    private final int handle_rep_transport(DatabaseEntry control, DatabaseEntry rec, LogSequenceNumber lsn, int envid, int flags) throws DatabaseException {
        return this.rep_transport_handler.send(this.wrapper, control, rec, lsn, envid, (flags & 2) != 0, (flags & 4) != 0, (flags & 1) != 0, (flags & 8) != 0);
    }

    public void lock_vec(int locker, int flags, LockRequest[] list, int offset, int count) throws DatabaseException {
        db_javaJNI.DbEnv_lock_vec(this.swigCPtr, locker, flags, list, offset, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(String db_home, int flags) throws DatabaseException, FileNotFoundException {
        try {
            this.remove0(db_home, flags);
        }
        finally {
            this.cleanup();
        }
    }

    public void set_error_stream(OutputStream stream) {
        this.error_stream = stream;
        final PrintWriter pw = new PrintWriter(stream);
        this.set_errcall(new ErrorHandler(){

            public void error(Environment env, String prefix, String buf) {
                if (prefix != null) {
                    pw.print(prefix + ": ");
                }
                pw.println(buf);
                pw.flush();
            }
        });
    }

    public OutputStream get_error_stream() {
        return this.error_stream;
    }

    public void set_message_stream(OutputStream stream) {
        this.message_stream = stream;
        final PrintWriter pw = new PrintWriter(stream);
        this.set_msgcall(new MessageHandler(){

            public void message(Environment env, String msg) {
                pw.println(msg);
                pw.flush();
            }
        });
    }

    public OutputStream get_message_stream() {
        return this.message_stream;
    }

    public void set_tx_timestamp(Date timestamp) throws DatabaseException {
        this.set_tx_timestamp0(timestamp.getTime() / 1000L);
    }

    public DbEnv(int flags) throws DatabaseException {
        this(db_javaJNI.new_DbEnv(flags), true);
        this.initialize();
    }

    void close0(int flags) {
        db_javaJNI.DbEnv_close0(this.swigCPtr, flags);
    }

    public void dbremove(DbTxn txnid, String file, String database, int flags) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_dbremove(this.swigCPtr, DbTxn.getCPtr(txnid), file, database, flags);
    }

    public void dbrename(DbTxn txnid, String file, String database, String newname, int flags) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_dbrename(this.swigCPtr, DbTxn.getCPtr(txnid), file, database, newname, flags);
    }

    public void err(int error, String message) {
        db_javaJNI.DbEnv_err(this.swigCPtr, error, message);
    }

    public void errx(String message) {
        db_javaJNI.DbEnv_errx(this.swigCPtr, message);
    }

    public DbTxn cdsgroup_begin() throws DatabaseException {
        long cPtr = db_javaJNI.DbEnv_cdsgroup_begin(this.swigCPtr);
        return cPtr == 0L ? null : new DbTxn(cPtr, false);
    }

    public void fileid_reset(String file, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_fileid_reset(this.swigCPtr, file, flags);
    }

    public String[] get_data_dirs() throws DatabaseException {
        return db_javaJNI.DbEnv_get_data_dirs(this.swigCPtr);
    }

    public int get_encrypt_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_encrypt_flags(this.swigCPtr);
    }

    public int get_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_flags(this.swigCPtr);
    }

    public String get_home() throws DatabaseException {
        return db_javaJNI.DbEnv_get_home(this.swigCPtr);
    }

    public int get_open_flags() throws DatabaseException {
        return db_javaJNI.DbEnv_get_open_flags(this.swigCPtr);
    }

    public long get_shm_key() throws DatabaseException {
        return db_javaJNI.DbEnv_get_shm_key(this.swigCPtr);
    }

    public String get_tmp_dir() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tmp_dir(this.swigCPtr);
    }

    public boolean get_verbose(int which) throws DatabaseException {
        return db_javaJNI.DbEnv_get_verbose(this.swigCPtr, which);
    }

    public boolean is_bigendian() throws DatabaseException {
        return db_javaJNI.DbEnv_is_bigendian(this.swigCPtr);
    }

    public void lsn_reset(String file, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_lsn_reset(this.swigCPtr, file, flags);
    }

    public void open(String db_home, int flags, int mode) throws DatabaseException, FileNotFoundException {
        db_javaJNI.DbEnv_open(this.swigCPtr, db_home, flags, mode);
    }

    void remove0(String db_home, int flags) {
        db_javaJNI.DbEnv_remove0(this.swigCPtr, db_home, flags);
    }

    public void set_cachesize(long bytes, int ncache) throws DatabaseException {
        db_javaJNI.DbEnv_set_cachesize(this.swigCPtr, bytes, ncache);
    }

    public void set_cache_max(long bytes) throws DatabaseException {
        db_javaJNI.DbEnv_set_cache_max(this.swigCPtr, bytes);
    }

    public void set_data_dir(String dir) throws DatabaseException {
        db_javaJNI.DbEnv_set_data_dir(this.swigCPtr, dir);
    }

    public void set_intermediate_dir(int mode, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_set_intermediate_dir(this.swigCPtr, mode, flags);
    }

    public void set_encrypt(String passwd, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_set_encrypt(this.swigCPtr, passwd, flags);
    }

    public void set_errcall(ErrorHandler db_errcall_fcn) {
        this.error_handler = db_errcall_fcn;
        db_javaJNI.DbEnv_set_errcall(this.swigCPtr, this.error_handler != null);
    }

    public void set_flags(int flags, boolean onoff) throws DatabaseException {
        db_javaJNI.DbEnv_set_flags(this.swigCPtr, flags, onoff);
    }

    public void set_feedback(FeedbackHandler env_feedback_fcn) throws DatabaseException {
        this.env_feedback_handler = env_feedback_fcn;
        db_javaJNI.DbEnv_set_feedback(this.swigCPtr, this.env_feedback_handler != null);
    }

    public void set_mp_max_openfd(int maxopenfd) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_max_openfd(this.swigCPtr, maxopenfd);
    }

    public void set_mp_max_write(int maxwrite, long maxwrite_sleep) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_max_write(this.swigCPtr, maxwrite, maxwrite_sleep);
    }

    public void set_mp_mmapsize(long mp_mmapsize) throws DatabaseException {
        db_javaJNI.DbEnv_set_mp_mmapsize(this.swigCPtr, mp_mmapsize);
    }

    public void set_msgcall(MessageHandler db_msgcall_fcn) {
        this.message_handler = db_msgcall_fcn;
        db_javaJNI.DbEnv_set_msgcall(this.swigCPtr, this.message_handler != null);
    }

    public void set_paniccall(PanicHandler db_panic_fcn) throws DatabaseException {
        this.panic_handler = db_panic_fcn;
        db_javaJNI.DbEnv_set_paniccall(this.swigCPtr, this.panic_handler != null);
    }

    public void set_rpc_server(String host, long cl_timeout, long sv_timeout, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_set_rpc_server(this.swigCPtr, host, cl_timeout, sv_timeout, flags);
    }

    public void set_shm_key(long shm_key) throws DatabaseException {
        db_javaJNI.DbEnv_set_shm_key(this.swigCPtr, shm_key);
    }

    public void set_timeout(long timeout, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_set_timeout(this.swigCPtr, timeout, flags);
    }

    public void set_tmp_dir(String dir) throws DatabaseException {
        db_javaJNI.DbEnv_set_tmp_dir(this.swigCPtr, dir);
    }

    public void set_tx_max(int max) throws DatabaseException {
        db_javaJNI.DbEnv_set_tx_max(this.swigCPtr, max);
    }

    public void set_app_dispatch(LogRecordHandler tx_recover) throws DatabaseException {
        this.app_dispatch_handler = tx_recover;
        db_javaJNI.DbEnv_set_app_dispatch(this.swigCPtr, this.app_dispatch_handler != null);
    }

    public void set_event_notify(EventHandler event_notify) throws DatabaseException {
        this.event_notify_handler = event_notify;
        db_javaJNI.DbEnv_set_event_notify(this.swigCPtr, this.event_notify_handler != null);
    }

    void set_tx_timestamp0(long timestamp) {
        db_javaJNI.DbEnv_set_tx_timestamp0(this.swigCPtr, timestamp);
    }

    public void set_verbose(int which, boolean onoff) throws DatabaseException {
        db_javaJNI.DbEnv_set_verbose(this.swigCPtr, which, onoff);
    }

    public byte[][] get_lk_conflicts() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_conflicts(this.swigCPtr);
    }

    public int get_lk_detect() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_detect(this.swigCPtr);
    }

    public int get_lk_max_locks() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_locks(this.swigCPtr);
    }

    public int get_lk_max_lockers() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_lockers(this.swigCPtr);
    }

    public int get_lk_max_objects() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lk_max_objects(this.swigCPtr);
    }

    public int lock_detect(int flags, int atype) throws DatabaseException {
        return db_javaJNI.DbEnv_lock_detect(this.swigCPtr, flags, atype);
    }

    public DbLock lock_get(int locker, int flags, DatabaseEntry object, int lock_mode) throws DatabaseException {
        long cPtr = db_javaJNI.DbEnv_lock_get(this.swigCPtr, locker, flags, object, lock_mode);
        return cPtr == 0L ? null : new DbLock(cPtr, true);
    }

    public int lock_id() throws DatabaseException {
        return db_javaJNI.DbEnv_lock_id(this.swigCPtr);
    }

    public void lock_id_free(int id) throws DatabaseException {
        db_javaJNI.DbEnv_lock_id_free(this.swigCPtr, id);
    }

    public void lock_put(DbLock lock) throws DatabaseException {
        db_javaJNI.DbEnv_lock_put(this.swigCPtr, DbLock.getCPtr(lock));
    }

    public LockStats lock_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_lock_stat(this.swigCPtr, flags);
    }

    public void set_lk_conflicts(byte[][] conflicts) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_conflicts(this.swigCPtr, conflicts);
    }

    public void set_lk_detect(int detect) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_detect(this.swigCPtr, detect);
    }

    public void set_lk_max_lockers(int max) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_lockers(this.swigCPtr, max);
    }

    public void set_lk_max_locks(int max) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_locks(this.swigCPtr, max);
    }

    public void set_lk_max_objects(int max) throws DatabaseException {
        db_javaJNI.DbEnv_set_lk_max_objects(this.swigCPtr, max);
    }

    public int get_lg_bsize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_bsize(this.swigCPtr);
    }

    public String get_lg_dir() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_dir(this.swigCPtr);
    }

    public int get_lg_filemode() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_filemode(this.swigCPtr);
    }

    public int get_lg_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_max(this.swigCPtr);
    }

    public int get_lg_regionmax() throws DatabaseException {
        return db_javaJNI.DbEnv_get_lg_regionmax(this.swigCPtr);
    }

    public String[] log_archive(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_log_archive(this.swigCPtr, flags);
    }

    public static int log_compare(LogSequenceNumber lsn0, LogSequenceNumber lsn1) {
        return db_javaJNI.DbEnv_log_compare(lsn0, lsn1);
    }

    public DbLogc log_cursor(int flags) throws DatabaseException {
        long cPtr = db_javaJNI.DbEnv_log_cursor(this.swigCPtr, flags);
        return cPtr == 0L ? null : new DbLogc(cPtr, true);
    }

    public String log_file(LogSequenceNumber lsn) throws DatabaseException {
        return db_javaJNI.DbEnv_log_file(this.swigCPtr, lsn);
    }

    public void log_flush(LogSequenceNumber lsn_or_null) throws DatabaseException {
        db_javaJNI.DbEnv_log_flush(this.swigCPtr, lsn_or_null);
    }

    public void log_put(LogSequenceNumber lsn, DatabaseEntry data, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_log_put(this.swigCPtr, lsn, data, flags);
    }

    public void log_print(DbTxn txn, String msg) throws DatabaseException {
        db_javaJNI.DbEnv_log_print(this.swigCPtr, DbTxn.getCPtr(txn), msg);
    }

    public LogStats log_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_log_stat(this.swigCPtr, flags);
    }

    public void set_lg_bsize(int lg_bsize) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_bsize(this.swigCPtr, lg_bsize);
    }

    public void set_lg_dir(String dir) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_dir(this.swigCPtr, dir);
    }

    public void set_lg_filemode(int mode) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_filemode(this.swigCPtr, mode);
    }

    public void set_lg_max(int lg_max) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_max(this.swigCPtr, lg_max);
    }

    public void set_lg_regionmax(int lg_regionmax) throws DatabaseException {
        db_javaJNI.DbEnv_set_lg_regionmax(this.swigCPtr, lg_regionmax);
    }

    public long get_cachesize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cachesize(this.swigCPtr);
    }

    public int get_cachesize_ncache() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cachesize_ncache(this.swigCPtr);
    }

    public long get_cache_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_cache_max(this.swigCPtr);
    }

    public int get_mp_max_openfd() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_openfd(this.swigCPtr);
    }

    public int get_mp_max_write() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_write(this.swigCPtr);
    }

    public long get_mp_max_write_sleep() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_max_write_sleep(this.swigCPtr);
    }

    public long get_mp_mmapsize() throws DatabaseException {
        return db_javaJNI.DbEnv_get_mp_mmapsize(this.swigCPtr);
    }

    public CacheStats memp_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_stat(this.swigCPtr, flags);
    }

    public CacheFileStats[] memp_fstat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_fstat(this.swigCPtr, flags);
    }

    public int memp_trickle(int percent) throws DatabaseException {
        return db_javaJNI.DbEnv_memp_trickle(this.swigCPtr, percent);
    }

    public int mutex_get_align() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_align(this.swigCPtr);
    }

    public int mutex_get_increment() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_increment(this.swigCPtr);
    }

    public int mutex_get_max() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_max(this.swigCPtr);
    }

    public int mutex_get_tas_spins() throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_get_tas_spins(this.swigCPtr);
    }

    public void mutex_set_align(int align) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_align(this.swigCPtr, align);
    }

    public void mutex_set_increment(int increment) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_increment(this.swigCPtr, increment);
    }

    public void mutex_set_max(int mutex_max) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_max(this.swigCPtr, mutex_max);
    }

    public void mutex_set_tas_spins(int tas_spins) throws DatabaseException {
        db_javaJNI.DbEnv_mutex_set_tas_spins(this.swigCPtr, tas_spins);
    }

    public MutexStats mutex_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_mutex_stat(this.swigCPtr, flags);
    }

    public int get_tx_max() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tx_max(this.swigCPtr);
    }

    public long get_tx_timestamp() throws DatabaseException {
        return db_javaJNI.DbEnv_get_tx_timestamp(this.swigCPtr);
    }

    public long get_timeout(int flag) throws DatabaseException {
        return db_javaJNI.DbEnv_get_timeout(this.swigCPtr, flag);
    }

    public DbTxn txn_begin(DbTxn parent, int flags) throws DatabaseException {
        long cPtr = db_javaJNI.DbEnv_txn_begin(this.swigCPtr, DbTxn.getCPtr(parent), flags);
        return cPtr == 0L ? null : new DbTxn(cPtr, false);
    }

    public void txn_checkpoint(int kbyte, int min, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_txn_checkpoint(this.swigCPtr, kbyte, min, flags);
    }

    public PreparedTransaction[] txn_recover(int count, int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_txn_recover(this.swigCPtr, count, flags);
    }

    public TransactionStats txn_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_txn_stat(this.swigCPtr, flags);
    }

    public long rep_get_limit() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_limit(this.swigCPtr);
    }

    public void rep_elect(int nsites, int nvotes, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_rep_elect(this.swigCPtr, nsites, nvotes, flags);
    }

    public int rep_process_message(DatabaseEntry control, DatabaseEntry rec, int envid, LogSequenceNumber ret_lsn) {
        return db_javaJNI.DbEnv_rep_process_message(this.swigCPtr, control, rec, envid, ret_lsn);
    }

    public void rep_flush() throws DatabaseException {
        db_javaJNI.DbEnv_rep_flush(this.swigCPtr);
    }

    public void rep_set_config(int which, boolean onoff) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_config(this.swigCPtr, which, onoff);
    }

    public void rep_set_lease(int clock_scale_factor, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_lease(this.swigCPtr, clock_scale_factor, flags);
    }

    public void rep_start(DatabaseEntry cdata, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_rep_start(this.swigCPtr, cdata, flags);
    }

    public void rep_sync(int flags) throws DatabaseException {
        db_javaJNI.DbEnv_rep_sync(this.swigCPtr, flags);
    }

    public boolean rep_get_config(int which) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_config(this.swigCPtr, which);
    }

    public ReplicationStats rep_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_stat(this.swigCPtr, flags);
    }

    public void rep_set_limit(long bytes) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_limit(this.swigCPtr, bytes);
    }

    public void set_rep_request(int min, int max) throws DatabaseException {
        db_javaJNI.DbEnv_set_rep_request(this.swigCPtr, min, max);
    }

    public void rep_set_transport(int envid, ReplicationTransport send) throws DatabaseException {
        this.rep_transport_handler = send;
        db_javaJNI.DbEnv_rep_set_transport(this.swigCPtr, envid, this.rep_transport_handler != null);
    }

    public int rep_get_nsites() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_nsites(this.swigCPtr);
    }

    public int rep_get_priority() throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_priority(this.swigCPtr);
    }

    public int rep_get_timeout(int which) throws DatabaseException {
        return db_javaJNI.DbEnv_rep_get_timeout(this.swigCPtr, which);
    }

    public void rep_set_nsites(int number) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_nsites(this.swigCPtr, number);
    }

    public void rep_set_priority(int priority) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_priority(this.swigCPtr, priority);
    }

    public void rep_set_timeout(int which, long timeout) throws DatabaseException {
        db_javaJNI.DbEnv_rep_set_timeout(this.swigCPtr, which, timeout);
    }

    public int repmgr_add_remote_site(String host, int port, int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_add_remote_site(this.swigCPtr, host, port, flags);
    }

    public void repmgr_get_ack_policy() throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_get_ack_policy(this.swigCPtr);
    }

    public void repmgr_set_ack_policy(int policy) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_set_ack_policy(this.swigCPtr, policy);
    }

    public void repmgr_set_local_site(String host, int port, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_set_local_site(this.swigCPtr, host, port, flags);
    }

    public ReplicationHostAddress[] repmgr_site_list() throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_site_list(this.swigCPtr);
    }

    public void repmgr_start(int nthreads, int flags) throws DatabaseException {
        db_javaJNI.DbEnv_repmgr_start(this.swigCPtr, nthreads, flags);
    }

    public ReplicationManagerStats repmgr_stat(int flags) throws DatabaseException {
        return db_javaJNI.DbEnv_repmgr_stat(this.swigCPtr, flags);
    }

    public static String strerror(int error) {
        return db_javaJNI.DbEnv_strerror(error);
    }

    public static int get_version_major() {
        return db_javaJNI.DbEnv_get_version_major();
    }

    public static int get_version_minor() {
        return db_javaJNI.DbEnv_get_version_minor();
    }

    public static int get_version_patch() {
        return db_javaJNI.DbEnv_get_version_patch();
    }

    public static String get_version_string() {
        return db_javaJNI.DbEnv_get_version_string();
    }

    public static class RepProcessMessage {
        public int envid;
    }
}

