/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockRequest;
import com.sleepycat.db.LockRequestMode;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogCursor;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.PreparedTransaction;
import com.sleepycat.db.ReplicationConfig;
import com.sleepycat.db.ReplicationManagerStartPolicy;
import com.sleepycat.db.ReplicationManagerStats;
import com.sleepycat.db.ReplicationStats;
import com.sleepycat.db.ReplicationStatus;
import com.sleepycat.db.ReplicationTimeoutType;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.StatsConfig;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.internal.DbEnv;
import java.io.File;
import java.io.FileNotFoundException;

public class Environment {
    private DbEnv dbenv;
    private int autoCommitFlag;

    Environment(DbEnv dbenv) throws DatabaseException {
        this.dbenv = dbenv;
        dbenv.wrapper = this;
    }

    public Environment(File home, EnvironmentConfig config) throws DatabaseException, FileNotFoundException {
        this(EnvironmentConfig.checkNull(config).openEnvironment(home));
        this.autoCommitFlag = (this.dbenv.get_open_flags() & 0x200000) == 0 ? 0 : 0x2000000;
    }

    public void close() throws DatabaseException {
        this.dbenv.close(0);
    }

    DbEnv unwrap() {
        return this.dbenv;
    }

    public static void remove(File home, boolean force, EnvironmentConfig config) throws DatabaseException, FileNotFoundException {
        config = EnvironmentConfig.checkNull(config);
        int flags = force ? 4 : 0;
        flags |= config.getUseEnvironment() ? 16384 : 0;
        DbEnv dbenv = config.createEnvironment();
        dbenv.remove(home == null ? null : home.toString(), flags |= config.getUseEnvironmentRoot() ? 32768 : 0);
    }

    public void setConfig(EnvironmentConfig config) throws DatabaseException {
        config.configureEnvironment(this.dbenv, new EnvironmentConfig(this.dbenv));
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        return new EnvironmentConfig(this.dbenv);
    }

    public Database openDatabase(Transaction txn, String fileName, String databaseName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        return new Database(DatabaseConfig.checkNull(config).openDatabase(this.dbenv, txn == null ? null : txn.txn, fileName, databaseName));
    }

    public SecondaryDatabase openSecondaryDatabase(Transaction txn, String fileName, String databaseName, Database primaryDatabase, SecondaryConfig config) throws DatabaseException, FileNotFoundException {
        return new SecondaryDatabase(SecondaryConfig.checkNull(config).openSecondaryDatabase(this.dbenv, txn == null ? null : txn.txn, fileName, databaseName, primaryDatabase.db), primaryDatabase);
    }

    public void removeDatabase(Transaction txn, String fileName, String databaseName) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbremove(txn == null ? null : txn.txn, fileName, databaseName, txn == null ? this.autoCommitFlag : 0);
    }

    public void renameDatabase(Transaction txn, String fileName, String databaseName, String newName) throws DatabaseException, FileNotFoundException {
        this.dbenv.dbrename(txn == null ? null : txn.txn, fileName, databaseName, newName, txn == null ? this.autoCommitFlag : 0);
    }

    public File getHome() throws DatabaseException {
        String home = this.dbenv.get_home();
        return home == null ? null : new File(home);
    }

    public int trickleCacheWrite(int percent) throws DatabaseException {
        return this.dbenv.memp_trickle(percent);
    }

    public int detectDeadlocks(LockDetectMode mode) throws DatabaseException {
        return this.dbenv.lock_detect(0, mode.getFlag());
    }

    public Lock getLock(int locker, boolean noWait, DatabaseEntry object, LockRequestMode mode) throws DatabaseException {
        return Lock.wrap(this.dbenv.lock_get(locker, noWait ? 2 : 0, object, mode.getFlag()));
    }

    public void putLock(Lock lock) throws DatabaseException {
        this.dbenv.lock_put(lock.unwrap());
    }

    public int createLockerID() throws DatabaseException {
        return this.dbenv.lock_id();
    }

    public void freeLockerID(int id) throws DatabaseException {
        this.dbenv.lock_id_free(id);
    }

    public void lockVector(int locker, boolean noWait, LockRequest[] list) throws DatabaseException {
        this.dbenv.lock_vec(locker, noWait ? 2 : 0, list, 0, list.length);
    }

    public LogCursor openLogCursor() throws DatabaseException {
        return LogCursor.wrap(this.dbenv.log_cursor(0));
    }

    public String getLogFileName(LogSequenceNumber lsn) throws DatabaseException {
        return this.dbenv.log_file(lsn);
    }

    public void startReplication(DatabaseEntry cdata, boolean master) throws DatabaseException {
        this.dbenv.rep_start(cdata, master ? 3 : 1);
    }

    public void electReplicationMaster(int nsites, int nvotes) throws DatabaseException {
        this.dbenv.rep_elect(nsites, nvotes, 0);
    }

    public void flushReplication() throws DatabaseException {
        this.dbenv.rep_flush();
    }

    public ReplicationStatus processReplicationMessage(DatabaseEntry control, DatabaseEntry rec, int envid) throws DatabaseException {
        DatabaseEntry cdata = new DatabaseEntry(rec.getData(), rec.getOffset(), rec.getSize());
        LogSequenceNumber lsn = new LogSequenceNumber();
        int ret = this.dbenv.rep_process_message(control, cdata, envid, lsn);
        return ReplicationStatus.getStatus(ret, cdata, envid, lsn);
    }

    public void setReplicationConfig(ReplicationConfig config, boolean onoff) throws DatabaseException {
        this.dbenv.rep_set_config(config.getFlag(), onoff);
    }

    public boolean getReplicationConfig(ReplicationConfig config) throws DatabaseException {
        return this.dbenv.rep_get_config(config.getFlag());
    }

    public void setReplicationTimeout(ReplicationTimeoutType type, int replicationTimeout) throws DatabaseException {
        this.dbenv.rep_set_timeout(type.getId(), replicationTimeout);
    }

    public int getReplicationTimeout(ReplicationTimeoutType type) throws DatabaseException {
        return this.dbenv.rep_get_timeout(type.getId());
    }

    public void syncReplication() throws DatabaseException {
        this.dbenv.rep_sync(0);
    }

    public void replicationManagerStart(int nthreads, ReplicationManagerStartPolicy disp) throws DatabaseException {
        this.dbenv.repmgr_start(nthreads, disp.getId());
    }

    public CacheStats getCacheStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.memp_stat(StatsConfig.checkNull(config).getFlags());
    }

    public CacheFileStats[] getCacheFileStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.memp_fstat(StatsConfig.checkNull(config).getFlags());
    }

    public LogStats getLogStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.log_stat(StatsConfig.checkNull(config).getFlags());
    }

    public ReplicationStats getReplicationStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.rep_stat(StatsConfig.checkNull(config).getFlags());
    }

    public ReplicationManagerStats getReplicationManagerStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.repmgr_stat(StatsConfig.checkNull(config).getFlags());
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.lock_stat(StatsConfig.checkNull(config).getFlags());
    }

    public MutexStats getMutexStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.mutex_stat(StatsConfig.checkNull(config).getFlags());
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        return this.dbenv.txn_stat(StatsConfig.checkNull(config).getFlags());
    }

    public Transaction beginCDSGroup() throws DatabaseException {
        return new Transaction(this.dbenv.cdsgroup_begin());
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig config) throws DatabaseException {
        return new Transaction(TransactionConfig.checkNull(config).beginTransaction(this.dbenv, parent == null ? null : parent.txn));
    }

    public void checkpoint(CheckpointConfig config) throws DatabaseException {
        CheckpointConfig.checkNull(config).runCheckpoint(this.dbenv);
    }

    public void logFlush(LogSequenceNumber lsn) throws DatabaseException {
        this.dbenv.log_flush(lsn);
    }

    public LogSequenceNumber logPut(DatabaseEntry data, boolean flush) throws DatabaseException {
        LogSequenceNumber lsn = new LogSequenceNumber();
        this.dbenv.log_put(lsn, data, flush ? 1 : 0);
        return lsn;
    }

    public void logPrint(Transaction txn, String message) throws DatabaseException {
        this.dbenv.log_print(txn == null ? null : txn.txn, message);
    }

    public File[] getArchiveLogFiles(boolean includeInUse) throws DatabaseException {
        String[] logNames = this.dbenv.log_archive(1 | (includeInUse ? 4 : 0));
        int len = logNames == null ? 0 : logNames.length;
        File[] logFiles = new File[len];
        for (int i = 0; i < len; ++i) {
            logFiles[i] = new File(logNames[i]);
        }
        return logFiles;
    }

    public File[] getArchiveDatabases() throws DatabaseException {
        String home = this.dbenv.get_home();
        String[] dbNames = this.dbenv.log_archive(2);
        int len = dbNames == null ? 0 : dbNames.length;
        File[] dbFiles = new File[len];
        for (int i = 0; i < len; ++i) {
            dbFiles[i] = new File(home, dbNames[i]);
        }
        return dbFiles;
    }

    public void removeOldLogFiles() throws DatabaseException {
        this.dbenv.log_archive(8);
    }

    public PreparedTransaction[] recover(int count, boolean continued) throws DatabaseException {
        return this.dbenv.txn_recover(count, continued ? 16 : 7);
    }

    public void resetFileID(String filename, boolean encrypted) throws DatabaseException {
        this.dbenv.fileid_reset(filename, encrypted ? 131072 : 0);
    }

    public void resetLogSequenceNumber(String filename, boolean encrypted) throws DatabaseException {
        this.dbenv.lsn_reset(filename, encrypted ? 131072 : 0);
    }

    public void panic(boolean onoff) throws DatabaseException {
        this.dbenv.set_flags(0x1000000, onoff);
    }

    public static String getVersionString() {
        return DbEnv.get_version_string();
    }

    public static int getVersionMajor() {
        return DbEnv.get_version_major();
    }

    public static int getVersionMinor() {
        return DbEnv.get_version_minor();
    }

    public static int getVersionPatch() {
        return DbEnv.get_version_patch();
    }
}

