/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.data;

import java.util.Map;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;

public final class Record {
    public static final String CREATED = "created";
    public static final String MODIFIED = "modified";
    public static final String OWNER = "owner";
    public static final String GROUP = "group";
    private final Key key;
    private Value value;
    private final Map meta;

    public Record() {
        this.key = null;
        this.meta = null;
    }

    public Record(Key key, Value value, Map meta) {
        this.key = key;
        this.value = value;
        this.meta = meta;
    }

    public Record(Key key, Value value) {
        this.key = key;
        this.value = value;
        this.meta = null;
    }

    public Key getKey() {
        return this.key;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setValue(String value) {
        this.value = new Value(value);
    }

    public Value getValue() {
        return this.value;
    }

    public Object getMetaData(Object name) {
        return this.meta != null ? this.meta.get(name) : null;
    }
}

