/*
 * Decompiled with CFR 0.152.
 */
package org.z3950.zing.cql;

import java.util.Vector;
import org.z3950.zing.cql.Utils;

public class ModifierSet {
    String base;
    Vector modifiers;

    public String getBase() {
        return this.base;
    }

    public void addModifier(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        vector.add(string2);
        this.modifiers.add(vector);
    }

    public String modifier(String string) {
        int n = this.modifiers.size();
        int n2 = 0;
        while (n2 < n) {
            Vector vector = (Vector)this.modifiers.get(n2);
            if (vector.get(0).equals(string)) {
                return (String)vector.get(1);
            }
            ++n2;
        }
        return null;
    }

    public Vector[] getModifiers() {
        int n = this.modifiers.size();
        Vector[] vectorArray = new Vector[n];
        int n2 = 0;
        while (n2 < n) {
            vectorArray[n2] = (Vector)this.modifiers.get(n2);
            ++n2;
        }
        return vectorArray;
    }

    public String toXCQL(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Utils.indent(n) + "<" + string + ">\n" + Utils.indent(n + 1) + "<value>" + Utils.xq(this.base) + "</value>\n");
        Vector[] vectorArray = this.getModifiers();
        if (vectorArray.length > 0) {
            stringBuffer.append(Utils.indent(n + 1) + "<modifiers>\n");
            int n2 = 0;
            while (n2 < vectorArray.length) {
                Vector vector = vectorArray[n2];
                stringBuffer.append(Utils.indent(n + 2)).append("<modifier>");
                if (vector.get(0) != null) {
                    stringBuffer.append("<type>").append(Utils.xq((String)vector.get(0))).append("</type>");
                }
                stringBuffer.append("<value>").append(Utils.xq((String)vector.get(1))).append("</value>");
                stringBuffer.append("</modifier>\n");
                ++n2;
            }
            stringBuffer.append(Utils.indent(n + 1) + "</modifiers>\n");
        }
        stringBuffer.append(Utils.indent(n) + "</" + string + ">\n");
        return stringBuffer.toString();
    }

    public String toCQL() {
        StringBuffer stringBuffer = new StringBuffer(this.base);
        Vector[] vectorArray = this.getModifiers();
        int n = 0;
        while (n < vectorArray.length) {
            stringBuffer.append("/").append(vectorArray[n].get(1));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: ModifierSet <base> [<type> <name>]...");
            System.exit(1);
        }
        ModifierSet modifierSet = new ModifierSet(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            modifierSet.addModifier(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        System.out.println(modifierSet.toCQL());
    }

    public ModifierSet(String string) {
        this.base = string;
        this.modifiers = new Vector();
    }
}

