/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class NaiveSequenceSlicer {
    final EventSequence sequence1;
    final EventSequence sequence2;
    EventSequence start = null;
    EventSequence end = null;

    public NaiveSequenceSlicer(EventSequence eventSequence, EventSequence eventSequence2) {
        this.sequence1 = eventSequence;
        this.sequence2 = eventSequence2;
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new EventSequence();
        int n = 0;
        EventSequence.EventIterator eventIterator = this.sequence1.eventIterator();
        EventSequence.EventIterator eventIterator2 = this.sequence2.eventIterator();
        while (eventIterator.hasNext() && eventIterator2.hasNext()) {
            DiffXEvent diffXEvent = (DiffXEvent)eventIterator.next();
            if (eventIterator2.next().equals(diffXEvent)) {
                ++n;
                eventIterator.remove();
                eventIterator2.remove();
                this.start.addEvent(diffXEvent);
                continue;
            }
            return n;
        }
        return n;
    }

    public int sliceEnd() throws IllegalStateException {
        DiffXEvent diffXEvent;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new EventSequence();
        int n = 0;
        int n2 = this.sequence1.size() - 1;
        int n3 = this.sequence2.size() - 1;
        while (n2 >= 0 && n3 >= 0 && (diffXEvent = this.sequence1.getEvent(n2)).equals(this.sequence2.getEvent(n3))) {
            ++n;
            this.sequence1.removeEvent(n2--);
            this.sequence2.removeEvent(n3--);
            this.end.addEvent(0, diffXEvent);
        }
        return n;
    }

    public int sliceStart(DiffXFormatter diffXFormatter) throws IllegalStateException, NullPointerException, IOException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        int n = 0;
        EventSequence.EventIterator eventIterator = this.sequence1.eventIterator();
        EventSequence.EventIterator eventIterator2 = this.sequence2.eventIterator();
        while (eventIterator.hasNext() && eventIterator2.hasNext()) {
            DiffXEvent diffXEvent = (DiffXEvent)eventIterator.next();
            if (!eventIterator2.next().equals(diffXEvent)) break;
            ++n;
            eventIterator.remove();
            eventIterator2.remove();
            diffXFormatter.format(diffXEvent);
        }
        return n;
    }

    public int sliceEnd(DiffXFormatter diffXFormatter) throws IllegalStateException, NullPointerException, IOException {
        int n = this.sliceEnd();
        this.formatEnd(diffXFormatter);
        return n;
    }

    public void formatStart(DiffXFormatter diffXFormatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            diffXFormatter.format(this.start.getEvent(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter diffXFormatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            diffXFormatter.format(this.end.getEvent(i));
        }
        this.end = null;
    }

    public EventSequence getStart() {
        return this.start;
    }

    public EventSequence getEnd() {
        return this.end;
    }
}

