/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.EventFactory;
import com.topologi.diffx.event.impl.ProcessingInstructionEvent;
import com.topologi.diffx.event.lang.Repertory;
import com.topologi.diffx.load.AttributeComparator;
import com.topologi.diffx.load.LoadingException;
import com.topologi.diffx.load.XMLRecorder;
import com.topologi.diffx.load.text.TextTokeniser;
import com.topologi.diffx.load.text.TokeniserFactory;
import com.topologi.diffx.sequence.EventSequence;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXRecorder
implements XMLRecorder {
    private static final boolean DEBUG = false;
    private DiffXConfig config = new DiffXConfig();
    private transient EventSequence sequence = null;

    public EventSequence process(File file) throws LoadingException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        EventSequence eventSequence = null;
        eventSequence = this.process(new InputSource(bufferedInputStream));
        ((InputStream)bufferedInputStream).close();
        bufferedInputStream = null;
        return eventSequence;
    }

    public EventSequence process(String string) throws LoadingException, IOException {
        return this.process(new InputSource(new StringReader(string)));
    }

    public EventSequence process(InputSource inputSource) throws LoadingException, IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(new RecorderHandler());
            xMLReader.setErrorHandler(new RecorderErrorHandler());
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new LoadingException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LoadingException(parserConfigurationException);
        }
        return this.sequence;
    }

    public DiffXConfig getConfig() {
        return this.config;
    }

    public void setConfig(DiffXConfig diffXConfig) {
        this.config = diffXConfig;
    }

    private final class RecorderErrorHandler
    implements ErrorHandler {
        private RecorderErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private final class RecorderHandler
    extends DefaultHandler {
        private StringBuffer ch = new StringBuffer();
        private AttributeComparator comparator = new AttributeComparator();
        private transient Repertory repertory = new Repertory();
        private transient int currentWeight = -1;
        private transient ArrayList openElements = new ArrayList();
        private transient ArrayList weights = new ArrayList();
        private transient EventFactory efactory = null;
        private transient TokeniserFactory tfactory = null;

        private RecorderHandler() {
        }

        public void startDocument() {
            SAXRecorder.this.sequence = new EventSequence();
            this.efactory = new EventFactory(SAXRecorder.this.config.isNamespaceAware());
            this.tfactory = new TokeniserFactory(SAXRecorder.this.config);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.recordCharacters();
            if (this.currentWeight > 0) {
                this.weights.add(new Integer(this.currentWeight));
            }
            this.currentWeight = 1;
            OpenElementEvent openElementEvent = this.efactory.makeOpenElement(string, string2, string3);
            this.openElements.add(openElementEvent);
            SAXRecorder.this.sequence.addEvent(openElementEvent);
            this.handleAttributes(attributes);
        }

        public void endElement(String string, String string2, String string3) {
            this.recordCharacters();
            OpenElementEvent openElementEvent = this.popLastOpenElement();
            openElementEvent.setWeight(this.currentWeight);
            CloseElementEvent closeElementEvent = this.efactory.makeCloseElement(openElementEvent);
            closeElementEvent.setWeight(this.currentWeight);
            SAXRecorder.this.sequence.addEvent(closeElementEvent);
            this.currentWeight += this.popWeight();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.ch.append(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
            SAXRecorder.this.sequence.addEvent(new ProcessingInstructionEvent(string, string2));
            ++this.currentWeight;
        }

        public void endDocument() throws SAXException {
        }

        private void recordCharacters() {
            if (this.ch != null) {
                TextTokeniser textTokeniser = this.tfactory.makeTokeniser(this.ch);
                textTokeniser.useRepertory(this.repertory);
                for (int i = 0; i < textTokeniser.countTokens(); ++i) {
                    SAXRecorder.this.sequence.addEvent(textTokeniser.nextToken());
                    ++this.currentWeight;
                }
                this.ch.setLength(0);
            }
        }

        private OpenElementEvent popLastOpenElement() {
            return (OpenElementEvent)this.openElements.remove(this.openElements.size() - 1);
        }

        private int popWeight() {
            if (this.weights.size() > 0) {
                return (Integer)this.weights.remove(this.weights.size() - 1);
            }
            return 0;
        }

        private void handleAttributes(Attributes attributes) {
            if (attributes.getLength() == 1) {
                SAXRecorder.this.sequence.addEvent(this.efactory.makeAttribute(attributes.getURI(0), attributes.getLocalName(0), attributes.getQName(0), attributes.getValue(0)));
            } else if (attributes.getLength() > 1) {
                int n;
                AttributeEvent[] attributeEventArray = new AttributeEvent[attributes.getLength()];
                for (n = 0; n < attributes.getLength(); ++n) {
                    attributeEventArray[n] = this.efactory.makeAttribute(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n), attributes.getValue(n));
                    attributeEventArray[n].setWeight(2);
                    this.currentWeight += 2;
                }
                Arrays.sort(attributeEventArray, this.comparator);
                for (n = 0; n < attributeEventArray.length; ++n) {
                    SAXRecorder.this.sequence.addEvent(attributeEventArray[n]);
                }
            }
        }
    }
}

