/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;

class TabListPopupTableModel
implements TableModel {
    private transient TabDisplayer displayer = null;
    private transient ArrayList tableModelListenerList;
    private int rowHeight;
    private List tabs = new ArrayList();
    private TableModelEvent event = null;
    private int rows;
    private int cols;

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public void attach(TabDisplayer tabDisplayer) {
        if (this.displayer != null) {
            this.detach();
        }
        this.displayer = tabDisplayer;
        int n = this.displayer.getModel().size();
        int n2 = this.calcColumns(n);
        int n3 = n / n2;
        if (n > 0) {
            if (n % n3 > 0) {
                ++n3;
            }
            this.setRowsAndColumns(n3, n2);
        } else {
            this.setRowsAndColumns(0, 0);
        }
        this.tabs.clear();
        this.tabs.addAll(this.displayer.getModel().getTabs());
        Collections.sort(this.tabs);
    }

    private int calcColumns(int n) {
        int n2 = this.displayer.getHeight() / this.rowHeight;
        if (n2 <= 2) {
            n2 = 10;
        }
        int n3 = n / n2 + 1;
        return n3;
    }

    public void detach() {
        this.displayer = null;
        this.tabs.clear();
    }

    public Class getColumnClass(int n) {
        return Integer.class;
    }

    public String getColumnName(int n) {
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public Object getValueAt(int n, int n2) {
        if (n == -1 || n2 == -1) {
            return new Integer(-1);
        }
        int n3 = n2 * this.getRowCount() + n;
        if (n3 < this.tabs.size()) {
            return this.tabs.get(n3);
        }
        return null;
    }

    public synchronized void addTableModelListener(TableModelListener tableModelListener) {
        if (this.tableModelListenerList == null) {
            this.tableModelListenerList = new ArrayList();
        }
        this.tableModelListenerList.add(tableModelListener);
    }

    public synchronized void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.tableModelListenerList != null) {
            this.tableModelListenerList.remove(tableModelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChanged(TableModelEvent tableModelEvent) {
        ArrayList arrayList;
        TabListPopupTableModel tabListPopupTableModel = this;
        synchronized (tabListPopupTableModel) {
            if (this.tableModelListenerList == null) {
                return;
            }
            arrayList = (ArrayList)this.tableModelListenerList.clone();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((TableModelListener)arrayList.get(i)).tableChanged(tableModelEvent);
        }
    }

    public void setRowsAndColumns(int n, int n2) {
        if (this.rows != n || this.cols != n2) {
            this.rows = n;
            this.cols = n2;
            if (this.event == null) {
                this.event = new TableModelEvent(this);
            }
            this.fireTableChanged(this.event);
        }
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }
}

