/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.impl;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.VirtualFileName;
import org.apache.commons.vfs.impl.VirtualFileSystem;
import org.apache.commons.vfs.provider.AbstractVfsContainer;

public class VirtualFileProvider
extends AbstractVfsContainer {
    public FileObject createFileSystem(FileObject fileObject) throws FileSystemException {
        FileName fileName = this.getContext().getFileSystemManager().resolveName(fileObject.getName(), "/");
        VirtualFileSystem virtualFileSystem = new VirtualFileSystem(fileName, fileObject.getFileSystem().getFileSystemOptions());
        this.addComponent(virtualFileSystem);
        virtualFileSystem.addJunction("/", fileObject);
        return virtualFileSystem.getRoot();
    }

    public FileObject createFileSystem(String string) throws FileSystemException {
        VirtualFileName virtualFileName = new VirtualFileName(string, "/", FileType.FOLDER);
        VirtualFileSystem virtualFileSystem = new VirtualFileSystem(virtualFileName, null);
        this.addComponent(virtualFileSystem);
        return virtualFileSystem.getRoot();
    }
}

