/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xpath.function.basic;

import com.japisoft.xpath.FastVector;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.XPathContext;
import com.japisoft.xpath.function.AbstractFunction;

public final class Number
extends AbstractFunction {
    public Object eval(XPathContext xPathContext, FastVector fastVector) {
        String string = null;
        if (fastVector.size() == 0) {
            string = xPathContext.getStringValue(xPathContext.getNodeFromContext());
        } else {
            Object object = fastVector.elementAt(0);
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    return new Double(1.0);
                }
                return new Double(0.0);
            }
            if (object instanceof Double) {
                return object;
            }
            if (object instanceof NodeSet) {
                NodeSet nodeSet = (NodeSet)object;
                return xPathContext.convertNodeSetToDouble(nodeSet);
            }
            if (object instanceof String) {
                string = (String)object;
            }
        }
        try {
            if (string != null) {
                return new Double(string);
            }
            return new Double(Double.NaN);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(Double.NaN);
        }
    }
}

