/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.xmlpad.helper.model.Descriptor;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

public class CommonDescriptorRenderer
extends DefaultListCellRenderer {
    private Icon defIcon = UIManager.getIcon("xmlpad.helper.icon");
    private static CommonDescriptorRenderer RENDERER = null;
    Font f = null;

    private CommonDescriptorRenderer() {
        if (this.defIcon == null) {
            this.defIcon = new ImageIcon(this.getClass().getResource("element.png"));
        }
    }

    public static CommonDescriptorRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new CommonDescriptorRenderer();
        }
        return RENDERER;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        Icon icon = null;
        if (object != null && object instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)object;
            jLabel.setEnabled(descriptor.isEnabled());
            jLabel.setText(descriptor.getNameForHelper());
            if (descriptor.getColor() != null) {
                jLabel.setForeground(descriptor.getColor());
            } else if (bl) {
                jLabel.setForeground(jList.getSelectionForeground());
            } else {
                jLabel.setForeground(jList.getForeground());
            }
            icon = descriptor.getIcon();
            if (icon == null) {
                icon = this.defIcon;
            }
        }
        if (this.f == null) {
            this.f = new Font(this.getFont().getName(), 0, this.getFont().getSize());
            jLabel.setFont(this.f);
        } else {
            jLabel.setFont(this.f);
        }
        if (icon != null) {
            jLabel.setIcon(icon);
        }
        return jLabel;
    }
}

