/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.helper.model.AbstractHelper;
import com.japisoft.xmlpad.helper.model.EntityDescriptor;
import com.japisoft.xmlpad.helper.model.EntityHelper;
import java.util.Vector;
import javax.swing.DefaultListModel;

public abstract class AbstractEntityHelper
extends AbstractHelper
implements EntityHelper {
    private Vector entities = null;
    private EntityDescriptor[] cache = null;

    public AbstractEntityHelper() {
        this.initDefaultEntities();
    }

    public String getTitle() {
        return "Entities";
    }

    public boolean hasTitle() {
        return true;
    }

    protected boolean hasElements() {
        return this.entities != null && this.entities.size() > 0;
    }

    protected void fillList(SimpleNode simpleNode, DefaultListModel defaultListModel) {
        if (this.entities == null) {
            return;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            defaultListModel.addElement(this.entities.get(i));
        }
    }

    protected void initDefaultEntities() {
        this.addEntity("gt", ">");
        this.addEntity("lt", "<");
        this.addEntity("quot", "\"");
        this.addEntity("amp", "&");
        this.addEntity("apos", "'");
        this.addEntity("#10", "Line break");
    }

    public void addEntityDescriptor(EntityDescriptor entityDescriptor) {
        if (this.entities == null) {
            this.entities = new Vector();
        }
        this.entities.add(entityDescriptor);
    }

    public void addEntity(String string, String string2) {
        this.addEntityDescriptor(new EntityDescriptor(string, string2));
        this.cache = null;
    }

    public EntityDescriptor[] getEntities() {
        if (this.entities == null) {
            return null;
        }
        if (this.cache != null) {
            return this.cache;
        }
        Object[] objectArray = new EntityDescriptor[this.entities.size()];
        this.entities.copyInto(objectArray);
        this.cache = objectArray;
        return objectArray;
    }
}

