/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.schema;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import com.japisoft.xmlpad.helper.model.AttributeHelper;
import com.japisoft.xmlpad.helper.model.Descriptor;
import com.japisoft.xmlpad.helper.model.EnumerationDescriptor;
import com.japisoft.xmlpad.helper.model.SchemaNodable;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListModel;

public abstract class AbstractTagHandler
extends AbstractHelperHandler {
    static final boolean DEBUG_HELPER = Debug.DEBUG;
    static TagDescriptor COMMENT_DESCRIPTOR = new TagDescriptor("!-- -->", null, true, true);
    static TagDescriptor CDATA_DESCRIPTOR = new TagDescriptor("![CDATA[ ]]>", null, true, true);
    private Vector tags = null;
    protected String namespace;
    private String currentElementName = null;
    private String lastActivatorString = null;
    protected String[] locationPath;
    protected String location;
    protected String lastLocation;
    protected SimpleNode currentDocumentNode;
    protected int currentDocumentLocation;
    public boolean addedSystemTag = true;
    private String source;

    protected String getActivatorSequence() {
        return "<";
    }

    public void dispose() {
        super.dispose();
        this.tags = null;
    }

    public int getPriority() {
        return 1;
    }

    protected boolean isCtrlSpaceActivator() {
        return this.lastActivatorString == null;
    }

    public boolean haveDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, boolean bl, int n, String string) {
        this.lastActivatorString = string;
        if ("<".equals(string) || string == null && !xMLDocument.isInsideTag(n, false, false)) {
            this.flush();
            this.setLocation(simpleNode, n);
            return this.tags != null && this.tags.size() > 0;
        }
        return false;
    }

    protected void installDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, int n, String string) {
        if (this.tags != null) {
            for (int i = 0; i < this.tags.size(); ++i) {
                this.addDescriptor((Descriptor)this.tags.get(i));
                if (!(this.tags.get(i) instanceof TagDescriptor)) continue;
                TagDescriptor tagDescriptor = (TagDescriptor)this.tags.get(i);
                tagDescriptor.setAddedPart(string);
                AttDescriptor[] attDescriptorArray = tagDescriptor.getAtts();
                if (attDescriptorArray == null) continue;
                block1: for (int j = 0; j < attDescriptorArray.length; ++j) {
                    XMLContainer xMLContainer;
                    String[] stringArray;
                    AttDescriptor attDescriptor = attDescriptorArray[j];
                    if (!attDescriptor.isRequired() || (stringArray = (xMLContainer = xMLDocument.getContainer()).getDocumentInfo().getListOfAttributesWithAutoAssistant()) == null) continue;
                    for (int k = 0; k < stringArray.length; ++k) {
                        if (!stringArray[k].equals(attDescriptor.getName())) continue;
                        attDescriptor.setAutomaticNextHelper(true);
                        tagDescriptor.setAutomaticNextHelper(true);
                        continue block1;
                    }
                }
            }
        }
    }

    public String getName() {
        return "schema-elements";
    }

    public boolean mustBeJobSynchronized() {
        return true;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public TagDescriptor addTag(String string, AttDescriptor[] attDescriptorArray, boolean bl) {
        TagDescriptor tagDescriptor = this.addTagDescriptor(new TagDescriptor(string, attDescriptorArray, bl));
        tagDescriptor.namespace = this.namespace;
        return tagDescriptor;
    }

    public String getTitle() {
        return null;
    }

    public abstract TagDescriptor getTag(SimpleNode var1);

    protected SimpleNode translateNode(SimpleNode simpleNode) {
        return simpleNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(SimpleNode simpleNode, int n) {
        this.flush();
        if (simpleNode != null) {
            simpleNode = this.translateNode(simpleNode);
            this.locationPath = new String[]{simpleNode.getContent()};
        } else {
            this.locationPath = null;
        }
        this.currentDocumentNode = simpleNode;
        this.currentDocumentLocation = n;
        try {
            SchemaNodable schemaNodable;
            SchemaNode schemaNode;
            this.location = null;
            if (this.locationPath != null && this.locationPath.length > 0) {
                this.location = this.locationPath[this.locationPath.length - 1];
            }
            if (this.namespace != null && simpleNode != null) {
                while (!this.namespace.equals(simpleNode.getNameSpaceURI()) && (simpleNode = simpleNode.getSimpleParent()) != null) {
                }
                if (simpleNode != null) {
                    this.currentDocumentNode = simpleNode;
                }
            }
            this.notifyLocation();
            if (this instanceof SchemaNodable && (schemaNode = (schemaNodable = (SchemaNodable)((Object)this)).getSchemaNode()) != null) {
                if (DEBUG_HELPER) {
                    schemaNode.dump();
                }
                if (this.namespace != null && schemaNode.namespace == null) {
                    schemaNode.namespace = this.namespace;
                }
                if (this.currentDocumentNode != null) {
                    this.buildContentFromSchemaNode(schemaNode);
                } else if (schemaNode.getSchemaNodeCount() > 0) {
                    SchemaNode schemaNode2 = schemaNode.getSchemaNode(0);
                    this.addFirstSchemaNode(schemaNode2);
                }
                this.completeContentForElementWithoutPrefix();
            }
            this.lastLocation = this.location;
        }
        finally {
            this.currentDocumentNode = null;
        }
    }

    protected void completeContentForElementWithoutPrefix() {
    }

    private void addFirstSchemaNode(SchemaNode schemaNode) {
        if (schemaNode.isElement()) {
            this.addTagDescriptor(schemaNode.element);
        } else if (schemaNode.isOpOR()) {
            for (int i = 0; i < schemaNode.getSchemaNodeCount(); ++i) {
                if (schemaNode.getSchemaNode(i) == schemaNode) continue;
                this.addFirstSchemaNode(schemaNode.getSchemaNode(i));
            }
        } else if (schemaNode.isOpAND() && schemaNode.getSchemaNodeCount() > 0 && schemaNode.getSchemaNode(0) != schemaNode) {
            this.addFirstSchemaNode(schemaNode.getSchemaNode(0));
        }
    }

    protected void notifyLocation() {
    }

    public AttributeHelper getAttributeHelperForNode(SimpleNode simpleNode) {
        TagDescriptor tagDescriptor = this.getTag(simpleNode);
        if (tagDescriptor != null) {
            AttributeHelper attributeHelper = new AttributeHelper(tagDescriptor);
            attributeHelper.prepare(tagDescriptor);
            return attributeHelper;
        }
        return null;
    }

    public void addEnumerationDescriptor(EnumerationDescriptor enumerationDescriptor) {
        if (this.tags == null) {
            this.tags = new Vector();
        }
        this.tags.add(enumerationDescriptor);
    }

    public TagDescriptor addTagDescriptor(TagDescriptor tagDescriptor) {
        if (tagDescriptor == null) {
            return null;
        }
        if (this.tags == null) {
            this.tags = new Vector();
        }
        int n = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            String string = ((TagDescriptor)this.tags.get(i)).getName();
            if (string == null) continue;
            if (string.equals(tagDescriptor.getName())) {
                return null;
            }
            if (n != -1 || string.compareTo(tagDescriptor.name) < 0) continue;
            n = i;
        }
        if (n == -1) {
            this.tags.add(tagDescriptor);
        } else {
            this.tags.add(n, tagDescriptor);
        }
        tagDescriptor.namespace = this.namespace;
        return tagDescriptor;
    }

    protected void flush() {
        this.tags = new Vector();
    }

    public boolean hasElements() {
        return this.tags != null && this.tags.size() > 0;
    }

    public TagDescriptor[] getTags() {
        if (this.tags == null) {
            return null;
        }
        Object[] objectArray = new TagDescriptor[this.tags.size()];
        this.tags.copyInto(objectArray);
        return objectArray;
    }

    protected boolean addSystemTag() {
        return this.addedSystemTag;
    }

    public void fillList(SimpleNode simpleNode, DefaultListModel defaultListModel) {
        if (this.tags == null) {
            if (this.addSystemTag()) {
                defaultListModel.addElement(COMMENT_DESCRIPTOR);
                defaultListModel.addElement(CDATA_DESCRIPTOR);
            }
            return;
        }
        for (int i = 0; i < this.tags.size(); ++i) {
            Object e = this.tags.get(i);
            defaultListModel.addElement(e);
        }
        if (this.addSystemTag()) {
            defaultListModel.addElement(COMMENT_DESCRIPTOR);
            defaultListModel.addElement(CDATA_DESCRIPTOR);
        }
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getSource() {
        return this.source;
    }

    private void buildContentFromSchemaNode(SchemaNode schemaNode) {
        ArrayList<SimpleNode> arrayList = null;
        String string = this.currentDocumentNode.getDocument().getRoot().getNameSpacePrefix();
        for (int i = 0; i < this.currentDocumentNode.childCount(); ++i) {
            if (arrayList == null) {
                arrayList = new ArrayList<SimpleNode>();
            }
            if (!this.currentDocumentNode.childAt(i).isTag() || string != null && !string.equals(this.currentDocumentNode.childAt(i).getNameSpacePrefix())) continue;
            arrayList.add(this.currentDocumentNode.childAt(i));
        }
        if (schemaNode.getSchemaNodeCount() > 0) {
            Object object;
            this.namespace = schemaNode.namespace;
            ArrayList arrayList2 = new ArrayList();
            this.manageSchemaNode(arrayList, schemaNode.getSchemaNode(0), arrayList2);
            String string2 = null;
            if (this.tags != null && this.namespace != null) {
                block1: for (SimpleNode simpleNode = this.currentDocumentNode; simpleNode != null; simpleNode = simpleNode.getSimpleParent()) {
                    object = simpleNode.getNameSpaceDeclaration();
                    if (object == null) continue;
                    while (object.hasMoreElements()) {
                        String string3 = (String)object.nextElement();
                        String string4 = simpleNode.getNameSpaceDeclarationURI(string3);
                        if (!this.namespace.equals(string4)) continue;
                        string2 = string3;
                        break block1;
                    }
                }
            }
            if (string2 != null) {
                for (int i = 0; i < this.tags.size(); ++i) {
                    object = (TagDescriptor)this.tags.get(i);
                    ((TagDescriptor)object).name = string2 + ":" + ((TagDescriptor)object).name;
                    for (int j = 0; j < ((TagDescriptor)object).getSynonymousTagDescriptorCount(); ++j) {
                        ((TagDescriptor)object).getSynonymousTagDescriptor((int)j).name = string2 + ":" + ((TagDescriptor)object).getSynonymousTagDescriptor((int)j).name;
                    }
                }
            }
        }
    }

    private int manageSchemaNode(ArrayList arrayList, SchemaNode schemaNode, ArrayList arrayList2) {
        if (arrayList2.contains(schemaNode)) {
            return 0;
        }
        arrayList2.add(schemaNode);
        if (schemaNode.isRoot()) {
            for (int i = 0; i < schemaNode.getSchemaNodeCount(); ++i) {
                this.manageSchemaNode(arrayList, schemaNode.getSchemaNode(i), arrayList2);
            }
            return 1;
        }
        if (schemaNode.isOpAND()) {
            return this.manageAnd(arrayList, schemaNode, arrayList2);
        }
        if (schemaNode.isOpOR()) {
            return this.manageOr(arrayList, schemaNode, arrayList2);
        }
        if (schemaNode.isElement()) {
            int n = this.manageElement(arrayList, schemaNode, arrayList2);
            if (n == 1) {
                arrayList2.removeAll(arrayList2);
            }
            return n;
        }
        return 2;
    }

    private int manageAnd(ArrayList arrayList, SchemaNode schemaNode, ArrayList arrayList2) {
        schemaNode.marked = true;
        int n = 1;
        for (int i = 0; i < schemaNode.getSchemaNodeCount(); ++i) {
            SchemaNode schemaNode2 = schemaNode.getSchemaNode(i);
            int n2 = this.manageSchemaNode(arrayList, schemaNode2, arrayList2);
            if (n2 != 0) continue;
            if (i == schemaNode.getSchemaNodeCount() - 1 || i == schemaNode.getSchemaNodeCount() - 2 && schemaNode.getSchemaNode(schemaNode.getSchemaNodeCount() - 1) == schemaNode) {
                n = 1;
                break;
            }
            n = 0;
            break;
        }
        return n;
    }

    private int manageOr(ArrayList arrayList, SchemaNode schemaNode, ArrayList arrayList2) {
        SchemaNode schemaNode2;
        int n;
        int n2 = 0;
        schemaNode.marked = true;
        for (n = 0; n < schemaNode.getSchemaNodeCount(); ++n) {
            schemaNode2 = schemaNode.getSchemaNode(n);
            int n3 = this.manageSchemaNode(arrayList, schemaNode2, arrayList2);
            if (n3 == 1) {
                n2 = 1;
                break;
            }
            if (n3 != 2) continue;
            n2 = 2;
        }
        if (n2 == 2) {
            return 2;
        }
        if (n2 == 0) {
            for (n = 0; n < schemaNode.getSchemaNodeCount(); ++n) {
                schemaNode2 = schemaNode.getSchemaNode(n);
                if (!schemaNode2.isSigma()) continue;
                return 2;
            }
        } else {
            for (n = 0; n < schemaNode.getSchemaNodeCount(); ++n) {
                schemaNode2 = schemaNode.getSchemaNode(n);
                if (schemaNode2 != schemaNode) continue;
                return this.manageSchemaNode(arrayList, schemaNode, arrayList2);
            }
        }
        return n2;
    }

    private int manageElement(ArrayList arrayList, SchemaNode schemaNode, ArrayList arrayList2) {
        SimpleNode simpleNode = this.nextXMLnode(arrayList);
        if (simpleNode == null) {
            this.addTagDescriptor(schemaNode.element);
        } else if (this.match(simpleNode, schemaNode)) {
            arrayList.remove(0);
            schemaNode.marked = true;
            for (int i = 0; i < schemaNode.getSchemaNodeCount(); ++i) {
                schemaNode.getSchemaNode((int)i).marked = false;
                arrayList2.remove(schemaNode.getSchemaNode(i));
                this.manageSchemaNode(arrayList, schemaNode.getSchemaNode(i), arrayList2);
            }
            return 1;
        }
        return 0;
    }

    private boolean matchWithNS(SimpleNode simpleNode, TagDescriptor tagDescriptor) {
        String string = simpleNode.getContent();
        boolean bl = string.equals(tagDescriptor.getName()) && (tagDescriptor.namespace == null || tagDescriptor.namespace.equals(simpleNode.getNameSpaceURI()));
        return bl;
    }

    private boolean match(SimpleNode simpleNode, SchemaNode schemaNode) {
        TagDescriptor tagDescriptor = schemaNode.element;
        if (!this.matchWithNS(simpleNode, tagDescriptor)) {
            for (int i = 0; i < tagDescriptor.getSynonymousTagDescriptorCount(); ++i) {
                TagDescriptor tagDescriptor2 = tagDescriptor.getSynonymousTagDescriptor(i);
                if (!this.matchWithNS(simpleNode, tagDescriptor2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private SimpleNode nextXMLnode(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        SimpleNode simpleNode = (SimpleNode)arrayList.get(0);
        if (simpleNode.getStartingOffset() >= this.currentDocumentLocation) {
            return null;
        }
        return simpleNode;
    }
}

