/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad;

import com.japisoft.xmlpad.DefaultView;
import com.japisoft.xmlpad.IView;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.EditorContext;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xmlpad.elementview.ElementView;
import com.japisoft.xmlpad.elementview.table.TableElementView;
import com.japisoft.xmlpad.error.DefaultErrorView;
import com.japisoft.xmlpad.error.ErrorView;
import com.japisoft.xmlpad.helper.ui.BasicTitledPanelHelper;
import com.japisoft.xmlpad.helper.ui.TitledPanelHelper;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;

public class ComponentFactory {
    static ComponentFactory FACTORY;

    protected ComponentFactory() {
    }

    public static ComponentFactory getFactory() {
        if (FACTORY == null) {
            FACTORY = new ComponentFactory();
        }
        return FACTORY;
    }

    public static void setFactory(ComponentFactory componentFactory) {
        FACTORY = componentFactory;
    }

    public JScrollPane getNewScrollPane() {
        return new JScrollPane();
    }

    public JPanel getNewPanel() {
        return new JPanel();
    }

    public JSplitPane getNewVerticalSplitPane() {
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    public JSplitPane getNewHorizontalSplitPane() {
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    public JTree getNewTree() {
        return new JTree();
    }

    public JToolBar getNewToolBar() {
        return new JToolBar();
    }

    public XMLEditor getNewXMLEditor(EditorContext editorContext) {
        XMLEditor xMLEditor = new XMLEditor(editorContext);
        return xMLEditor;
    }

    public JPopupMenu getNewPopupMenu() {
        return new JPopupMenu();
    }

    public ElementView getNewElementView(XMLContainer xMLContainer) {
        return new TableElementView(xMLContainer);
    }

    public TitledPanelHelper getNewTitledPanelHelper() {
        return new BasicTitledPanelHelper();
    }

    public TitledPanelHelper getNewFooterPanelHelper() {
        return null;
    }

    public IView getUIContainer(XMLContainer xMLContainer) {
        return new DefaultView(xMLContainer);
    }

    public ErrorView getDefaultErrorView() {
        return new DefaultErrorView();
    }
}

