/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.properties;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.xmlform.designer.properties.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyDescriptorImpl
implements PropertyDescriptor {
    private Object component = null;
    private String name = null;
    private Class paramType = null;
    private Method setter = null;
    private Method getter = null;
    private boolean displayable = true;

    public PropertyDescriptorImpl(String string, Class clazz, Object object) throws Exception {
        this.name = string;
        this.component = object;
        this.paramType = clazz;
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        }
        this.setter = object.getClass().getMethod("set" + string, clazz);
        this.getter = object.getClass().getMethod("get" + string, null);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.paramType;
    }

    public boolean displayable() {
        return this.displayable;
    }

    public Object getValue() {
        try {
            return this.getter.invoke(this.component, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ApplicationModel.debug(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ApplicationModel.debug(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ApplicationModel.debug(invocationTargetException);
        }
        return null;
    }

    public void setValue(Object object) {
        try {
            this.setter.invoke(this.component, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ApplicationModel.debug(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ApplicationModel.debug(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ApplicationModel.debug(invocationTargetException);
        }
    }

    public String toString() {
        return this.getName();
    }
}

