/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.framework.ui.FastLabel;
import com.japisoft.treefilebrowser.FileTree;
import com.japisoft.treefilebrowser.FileTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;

class TreeCellEditor
extends JPanel
implements javax.swing.tree.TreeCellEditor,
KeyListener {
    private JTextField tf;
    private FastLabel lbl;
    JTree tree = null;
    ArrayList listeners = null;

    public TreeCellEditor() {
        this.setLayout(new BorderLayout());
        this.tf = new JTextField();
        this.lbl = new FastLabel(false);
        this.lbl.setOpaque(false);
        this.add((Component)this.lbl, "West");
        this.add((Component)this.tf, "Center");
        this.setOpaque(false);
    }

    public void addNotify() {
        super.addNotify();
        this.addKeyListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeKeyListener(this);
        this.tree = null;
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.setBackground(jTree.getBackground());
        FileTreeNode fileTreeNode = (FileTreeNode)object;
        this.tf.setText(fileTreeNode.getFile().getName());
        FastLabel fastLabel = (FastLabel)jTree.getCellRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
        this.lbl.setIcon(fastLabel.getIcon());
        this.tree = jTree;
        return this;
    }

    public Object getCellEditorValue() {
        String string = this.tf.getText();
        if ("".equals(string)) {
            return null;
        }
        FileTree fileTree = (FileTree)this.tree;
        fileTree.renameSelection(string);
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            JTree jTree = (JTree)eventObject.getSource();
            TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return false;
            }
            FileTreeNode fileTreeNode = (FileTreeNode)treePath.getLastPathComponent();
            if (fileTreeNode.isRoot() || fileTreeNode.root) {
                return false;
            }
            if (mouseEvent.getClickCount() == 1 && treePath.equals(jTree.getSelectionPath())) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return false;
    }

    public boolean stopCellEditing() {
        return false;
    }

    public void cancelCellEditing() {
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (this.listeners != null) {
            this.listeners.remove(cellEditorListener);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                CellEditorListener cellEditorListener = (CellEditorListener)this.listeners.get(i);
                cellEditorListener.editingStopped(new ChangeEvent(keyEvent.getSource()));
            }
        }
    }
}

