/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class GradientLabel
extends JComponent {
    private String title = null;
    private Icon icon = null;
    private int height = 0;
    private int ascent = 0;
    private Color gradientStart;
    private Color gradientStop;
    private Color gradientSelectedStart;
    private Color gradientSelectedStop;
    private Color titleColor;
    private boolean focusMode = true;

    public GradientLabel() {
        this.setFont(new Font("dialog", 0, 12));
        this.resetColors();
        this.gradientSelectedStart = UIManager.getColor("jdock.innerwindow.gradient.selectedStartColor");
        if (this.gradientSelectedStart == null) {
            this.gradientSelectedStart = new Color(0, 0, 128);
        }
        this.gradientSelectedStop = UIManager.getColor("jdock.innerwindow.gradient.selectedStopColor");
        if (this.gradientSelectedStop == null) {
            this.gradientSelectedStop = UIManager.getColor("Panel.background");
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.height == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.height = fontMetrics.getHeight() + fontMetrics.getHeight() / 2;
            this.ascent = fontMetrics.getDescent();
        }
        if (dimension == null) {
            dimension = new Dimension(1, this.height);
        } else {
            dimension.height = this.height;
        }
        return dimension;
    }

    public void setTitle(String string) {
        this.title = string;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    private void resetColors() {
        this.gradientStart = UIManager.getColor("jdock.innerwindow.gradient.startColor");
        if (this.gradientStart == null) {
            this.gradientStart = new Color(128, 128, 128);
        }
        this.gradientStop = UIManager.getColor("jdock.innerwindow.gradient.stopColor");
        if (this.gradientStop == null) {
            this.gradientStop = UIManager.getColor("Panel.background");
        }
        this.titleColor = UIManager.getColor("jdock.innerwindow.titleColor");
        if (this.titleColor == null) {
            this.titleColor = Color.white;
        }
    }

    public void setBackground(Color color) {
        if (color == null) {
            this.resetColors();
        } else {
            if (this.gradientStop == this.gradientSelectedStart) {
                this.gradientStop = color;
            }
            this.gradientStart = color;
        }
        this.repaint();
    }

    public void setForeground(Color color) {
        if (color == null) {
            this.resetColors();
        } else {
            this.titleColor = color;
        }
        this.repaint();
    }

    public void setFocusMode(boolean bl) {
        this.focusMode = bl;
    }

    public boolean hasFocusMode() {
        return this.focusMode;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = this.gradientStart;
        Color color2 = this.gradientStop;
        if (this.focusMode) {
            color = this.gradientSelectedStart;
            color2 = this.gradientSelectedStop;
        }
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, this.getWidth() / 2, this.getHeight(), color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(this.titleColor);
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics2D, 2, (this.getHeight() - this.icon.getIconHeight()) / 2);
        }
        if (this.title != null) {
            graphics2D.drawString(this.title, this.icon == null ? 10 : this.icon.getIconWidth() + 5, this.getHeight() / 2 + this.ascent + 2);
        }
        graphics2D.drawRect(1, 1, this.getWidth() - 2, this.getHeight() - 3);
    }
}

