/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.Windowable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class BasicStatusBar
extends JToolBar {
    public BasicStatusBar() {
        this.setFloatable(false);
    }

    public void prepare(JDock jDock) {
        this.prepare(jDock, false);
    }

    public void prepare(JDock jDock, boolean bl) {
        Object object;
        Object object2;
        int n;
        if (bl) {
            this.removeAll();
        }
        JComponent jComponent = jDock.getDockingView();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < jComponent.getComponentCount(); ++n) {
            object2 = jComponent.getComponent(n);
            object = jDock.componentToWindowable((Component)object2);
            if (object == null) continue;
            this.addWindowable(jDock, (Windowable)object);
            arrayList.add(object.getId());
        }
        if (jDock.hasHiddenWindows()) {
            Enumeration enumeration = jDock.hiddenWindows();
            while (enumeration.hasMoreElements()) {
                object2 = (Windowable)enumeration.nextElement();
                this.addWindowable(jDock, (Windowable)object2);
            }
        }
        for (n = 0; n < this.getComponentCount(); ++n) {
            object = (HideShowAction)((AbstractButton)(object2 = (JButton)this.getComponent(n))).getAction();
            this.resetButtonUI((JButton)object2, !arrayList.contains(((HideShowAction)object).id));
        }
    }

    void addWindowable(JDock jDock, Windowable windowable) {
        JButton jButton = this.getButtonById(windowable.getId());
        if (jButton == null) {
            HideShowAction hideShowAction = new HideShowAction(windowable.getId(), jDock);
            if (windowable.getIcon() != null) {
                hideShowAction.putValue("SmallIcon", windowable.getIcon());
            }
            if (windowable.getTitle() != null) {
                hideShowAction.putValue("ShortDescription", windowable.getTitle());
            }
            hideShowAction.putValue("Name", windowable.getId());
            jButton = this.add(hideShowAction);
            if (jDock.isUIReady()) {
                jDock.getView().invalidate();
                jDock.getView().validate();
                this.invalidate();
                this.validate();
                this.repaint();
            }
        }
    }

    void resetButtonUI(JButton jButton, boolean bl) {
        if (jButton != null) {
            if (bl) {
                jButton.setBackground(Color.gray);
            } else {
                jButton.setBackground(UIManager.getColor("button.background"));
            }
        }
    }

    public void dispose() {
        this.removeAll();
    }

    private JButton getButtonById(String string) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JButton jButton = (JButton)this.getComponent(i);
            HideShowAction hideShowAction = (HideShowAction)jButton.getAction();
            if (!string.equals(hideShowAction.id)) continue;
            return jButton;
        }
        return null;
    }

    class HideShowAction
    extends AbstractAction {
        private String id;
        private JDock dock;

        public HideShowAction(String string, JDock jDock) {
            this.id = string;
            this.dock = jDock;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dock.isInnerWindowHidden(this.id)) {
                this.dock.showInnerWindow(this.id);
            } else {
                this.dock.hideInnerWindow(this.id);
            }
        }
    }
}

