/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog;

import com.japisoft.framework.dialog.BasicDialogComponent;
import com.japisoft.framework.dialog.BasicDialogFooter;
import com.japisoft.framework.dialog.BasicDialogHeader;
import com.japisoft.framework.dialog.DialogComponent;
import com.japisoft.framework.dialog.DialogFooter;
import com.japisoft.framework.dialog.DialogHeader;
import com.japisoft.framework.dialog.actions.CancelAction;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.actions.OKAction;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;

public final class DialogManager {
    private static Class HEADER = null;
    private static Class FOOTER = null;
    private static DialogComponent COMPONENT = null;
    private static Icon ICON = null;
    public static int OK_ID = OKAction.ID;
    public static int CANCEL_ID = CancelAction.ID;
    public static int DEF_ACTION = OK_ID;
    private static DialogActionModel DEFAULT_ACTIONMODEL = null;
    private static int showCounter = 0;
    private static DialogComponent CURRENT_DIALOG = null;
    private static boolean AUTO_CENTER = false;
    private static Dimension DEFAULT_SIZE = null;
    private static Point DEFAULT_LOCATION = null;

    public static void setDefaultDialogIcon(Icon icon) {
        ICON = icon;
    }

    public static void setDefaultDialogIcon(String string) {
        try {
            ICON = new ImageIcon(ClassLoader.getSystemResource(string));
        }
        catch (Throwable throwable) {
            System.err.println("Can't find " + string);
        }
    }

    public static Icon getDefaultDialogIcon() {
        if (ICON == null) {
            ICON = new ImageIcon(ClassLoader.getSystemResource("images/gear.png"));
        }
        return ICON;
    }

    public static void setDefaultDialogActionModel(DialogActionModel dialogActionModel) {
        DEFAULT_ACTIONMODEL = dialogActionModel;
    }

    public static DialogActionModel getDefaultDialogActionModel() {
        if (DEFAULT_ACTIONMODEL == null) {
            DEFAULT_ACTIONMODEL = DialogActionModel.getDefaultDialogActionModel();
        }
        return DEFAULT_ACTIONMODEL;
    }

    public static DialogActionModel getDefaultDialogActionModel(boolean bl) {
        DialogManager.getDefaultDialogActionModel();
        if (DEFAULT_ACTIONMODEL != null) {
            return (DialogActionModel)DEFAULT_ACTIONMODEL.clone();
        }
        return null;
    }

    public static DialogActionModel buildNewActionModel() {
        DialogActionModel dialogActionModel = DialogManager.getDefaultDialogActionModel();
        return (DialogActionModel)dialogActionModel.clone();
    }

    public static void setDefaultDialogHeader(Class clazz) {
        if (!clazz.isAssignableFrom(DialogHeader.class)) {
            throw new RuntimeException("Invalid class, must implement DialogHeader");
        }
        if (clazz != null) {
            HEADER = clazz;
        }
    }

    public static DialogHeader getDefaultDialogHeader() {
        if (HEADER == null) {
            return new BasicDialogHeader();
        }
        try {
            return (DialogHeader)HEADER.newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new BasicDialogHeader();
        }
    }

    public static DialogFooter getDefaultDialogFooter() {
        if (FOOTER == null) {
            return new BasicDialogFooter();
        }
        try {
            return (DialogFooter)FOOTER.newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new BasicDialogFooter();
        }
    }

    public static void setDefaultDialogFooter(Class clazz) {
        if (!clazz.isAssignableFrom(DialogFooter.class)) {
            throw new RuntimeException("Invalid class, must implement DialogFooter");
        }
        if (clazz != null) {
            FOOTER = clazz;
        }
    }

    public static void setDefaultAction(int n) {
        DEF_ACTION = n;
    }

    public static int getDefaultAction() {
        return DEF_ACTION;
    }

    public static void setDefaultClosingAction(int n) {
        CANCEL_ID = n;
    }

    public static int getDefaultClosingAction() {
        return CANCEL_ID;
    }

    public static int showDialog(Window window, String string, String string2, String string3, Icon icon, JComponent jComponent) {
        return DialogManager.showDialog(window, string, string2, string3, icon, jComponent, null, null);
    }

    public static int showDialog(Window window, String string, String string2, String string3, Icon icon, JComponent jComponent, Dimension dimension) {
        return DialogManager.showDialog(window, string, string2, string3, icon, jComponent, null, dimension);
    }

    public static int showDialog(Window window, String string, String string2, String string3, Icon icon, JComponent jComponent, DialogActionModel dialogActionModel, Dimension dimension) {
        DialogComponent dialogComponent = null;
        dialogComponent = DialogManager.buildDialog(window, string, string2, string3, icon, jComponent, dialogActionModel);
        ++showCounter;
        if (dimension != null) {
            dialogComponent.getView().setSize(dimension);
        }
        if (AUTO_CENTER) {
            Dimension dimension2 = dialogComponent.getView().getSize();
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            dialogComponent.getView().setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
        } else if (DEFAULT_LOCATION != null) {
            dialogComponent.getView().setLocation(DEFAULT_LOCATION);
        }
        CURRENT_DIALOG = dialogComponent;
        dialogComponent.setVisible(true);
        CURRENT_DIALOG = null;
        dialogComponent.dispose();
        --showCounter;
        return dialogComponent.getLastAction();
    }

    public static DialogComponent getCurrentDialog() {
        return CURRENT_DIALOG;
    }

    public static void setAutoCenter(boolean bl) {
        AUTO_CENTER = bl;
    }

    public static void resetDefaultSize(Dimension dimension) {
        DEFAULT_SIZE = dimension;
    }

    public static void resetDefaultLocation(Point point) {
        DEFAULT_LOCATION = point;
    }

    private static DialogComponent buildDialog(Window window, String string, String string2, String string3, Icon icon, JComponent jComponent, DialogActionModel dialogActionModel) {
        BasicDialogComponent basicDialogComponent = null;
        basicDialogComponent = window instanceof Dialog ? new BasicDialogComponent((Dialog)window, string) : (window instanceof Frame ? new BasicDialogComponent((Frame)window, string) : new BasicDialogComponent(string));
        DialogHeader dialogHeader = DialogManager.getDefaultDialogHeader();
        dialogHeader.setTitle(string2);
        dialogHeader.setComment(string3);
        dialogHeader.setIcon(icon == null ? DialogManager.getDefaultDialogIcon() : icon);
        if (dialogActionModel == null) {
            dialogActionModel = DialogManager.getDefaultDialogActionModel();
        }
        DialogFooter dialogFooter = DialogManager.getDefaultDialogFooter();
        dialogFooter.setDialogTarget(basicDialogComponent);
        dialogFooter.setModel(dialogActionModel);
        basicDialogComponent.init(dialogHeader, jComponent, dialogFooter);
        if (DEFAULT_SIZE != null) {
            if (basicDialogComponent instanceof JDialog) {
                if (basicDialogComponent instanceof BasicDialogComponent) {
                    basicDialogComponent.setSize(DialogManager.DEFAULT_SIZE.width, DialogManager.DEFAULT_SIZE.height, true);
                } else {
                    ((JDialog)basicDialogComponent).setSize(DialogManager.DEFAULT_SIZE.width, DialogManager.DEFAULT_SIZE.height);
                }
            }
            DEFAULT_SIZE = null;
        }
        return basicDialogComponent;
    }
}

