/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.dom;

import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.dom.AttrImpl;
import com.japisoft.fastparser.dom.DOMExceptionImpl;
import com.japisoft.fastparser.dom.DOMImplementationImpl;
import com.japisoft.fastparser.dom.DocumentFragmentImpl;
import com.japisoft.fastparser.dom.DocumentTypeImpl;
import com.japisoft.fastparser.dom.DomNodeFactory;
import com.japisoft.fastparser.dom.NodeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class DocumentImpl
extends NodeImpl
implements org.w3c.dom.Document {
    Document d;
    private Element root;

    public DocumentImpl(Document document) {
        this.d = document;
        if (document.getRoot() instanceof Element) {
            this.root = (Element)((Object)document.getRoot());
        }
    }

    public DocumentImpl(Element element) {
        this.root = element;
    }

    Document getInnerDocument() {
        if (this.d == null) {
            this.d = new Document();
            this.d.setNodeFactory(new DomNodeFactory());
        }
        return this.d;
    }

    public DocumentType getDoctype() {
        return new DocumentTypeImpl();
    }

    public short getNodeType() {
        return 9;
    }

    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    public Element getDocumentElement() {
        if (this.root != null) {
            return this.root;
        }
        if (this.d != null) {
            return (Element)((Object)this.d.getRoot());
        }
        return null;
    }

    public Node getFirstChild() {
        return this.getDocumentElement();
    }

    public Node getNextSibling() {
        return null;
    }

    public Element createElement(String string) throws DOMException {
        return (Element)((Object)this.getInnerDocument().getNodeFactory().getTagNode(string));
    }

    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    public Text createTextNode(String string) {
        return (Text)((Object)this.getInnerDocument().getNodeFactory().getTextNode(string));
    }

    public Comment createComment(String string) {
        return (Comment)((Object)this.getInnerDocument().getNodeFactory().getCommentNode(string));
    }

    public CDATASection createCDATASection(String string) throws DOMException {
        throw new DOMExceptionImpl(9, "Not supported");
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DOMExceptionImpl(9, "Not supported");
    }

    public Attr createAttribute(String string) throws DOMException {
        return new AttrImpl(string, null);
    }

    public EntityReference createEntityReference(String string) throws DOMException {
        throw new DOMExceptionImpl(9, "Not supported");
    }

    public NodeList getElementsByTagName(String string) {
        if (this.d == null || this.root == null) {
            return null;
        }
        return this.root.getElementsByTagName(string);
    }

    public Node importNode(Node node, boolean bl) throws DOMException {
        NodeImpl nodeImpl = (NodeImpl)node.cloneNode(bl);
        nodeImpl.setOwnerDocument(this);
        return nodeImpl;
    }

    public Element createElementNS(String string, String string2) throws DOMException {
        NodeImpl nodeImpl = (NodeImpl)((Object)this.createElement(string2));
        nodeImpl.setNamespaceURI(string);
        return (Element)((Object)nodeImpl);
    }

    public Attr createAttributeNS(String string, String string2) throws DOMException {
        NodeImpl nodeImpl = (NodeImpl)((Object)this.createAttribute(string2));
        nodeImpl.setNamespaceURI(string);
        return (Attr)((Object)nodeImpl);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        throw new RuntimeException("Not supported");
    }

    public Element getElementById(String string) {
        return null;
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }

    public Node adoptNode(Node node) throws DOMException {
        return null;
    }

    public String getDocumentURI() {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public String getInputEncoding() {
        return null;
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public String getXmlEncoding() {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public String getXmlVersion() {
        return null;
    }

    public void normalizeDocument() {
    }

    public Node renameNode(Node node, String string, String string2) throws DOMException {
        return null;
    }

    public void setDocumentURI(String string) {
    }

    public void setStrictErrorChecking(boolean bl) {
    }

    public void setXmlStandalone(boolean bl) throws DOMException {
    }

    public void setXmlVersion(String string) throws DOMException {
    }
}

