/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.TextFragmentValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLParam;
import com.icl.saxon.style.XSLVariable;
import com.japisoft.editix.xslt.debug.ContextVariableImpl;
import com.japisoft.editix.xslt.debug.NodeDebug;
import com.japisoft.editix.xslt.debug.XPathNodeContextImpl;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Saxon1NodeDebug
implements NodeDebug {
    private NodeInfo ni;
    private Context ctx;
    private String systemUri;

    public Saxon1NodeDebug(NodeInfo nodeInfo, Context context) {
        this.ni = nodeInfo;
        this.ctx = context;
        this.systemUri = nodeInfo.getSystemId();
    }

    public String getSystemUri() {
        return this.systemUri;
    }

    public String getLocalName() {
        if (this.ni.getNodeType() == 3) {
            return "text()";
        }
        return this.ni.getLocalName();
    }

    public String getPrefix() {
        return this.ni.getPrefix();
    }

    public int getLineNumber() {
        return this.ni.getLineNumber();
    }

    public String getAttributeValue(String string) {
        return this.ni.getAttributeValue("", string);
    }

    public String getNamespace() {
        return this.ni.getURI();
    }

    public ArrayList getXPathContext() {
        NodeInfo nodeInfo = this.ctx.getContextNodeInfo();
        if (nodeInfo != null) {
            ArrayList<XPathNodeContextImpl> arrayList = new ArrayList<XPathNodeContextImpl>();
            String string = nodeInfo.getDisplayName();
            if (nodeInfo.getNodeType() == 3) {
                string = "text()";
            } else if (nodeInfo.getNodeType() == 9) {
                string = "document()";
            }
            arrayList.add(new XPathNodeContextImpl(string, nodeInfo.getLineNumber(), true));
            return arrayList;
        }
        return null;
    }

    public Object evalXPath(String string) throws Exception {
        return null;
    }

    public ArrayList getVariables() {
        ArrayList arrayList = new ArrayList();
        if (this.ni instanceof Node) {
            this.scanVariablesParameters((Node)this.ni, arrayList, true);
        }
        if (arrayList.size() > 0) {
            Collections.reverse(arrayList);
            return arrayList;
        }
        return null;
    }

    public ArrayList getParameters() {
        ArrayList arrayList = new ArrayList();
        if (this.ni instanceof Node) {
            this.scanVariablesParameters((Node)this.ni, arrayList, false);
        }
        if (arrayList.size() > 0) {
            Collections.reverse(arrayList);
            return arrayList;
        }
        return null;
    }

    private void scanVariablesParameters(Node node, ArrayList arrayList, boolean bl) {
        if (node.getParentNode() instanceof Element) {
            Node node2 = node;
            while (node2 != null) {
                if (node2 instanceof Binding) {
                    Binding binding = (Binding)node2;
                    if (bl && binding instanceof XSLVariable || !bl && binding instanceof XSLParam) {
                        String string = binding.getVariableName();
                        Value value = this.ctx.getBindery().getValue(binding);
                        if (value != null) {
                            String string2 = "?";
                            switch (value.getDataType()) {
                                case -1: {
                                    string2 = "ANY";
                                    break;
                                }
                                case 1: {
                                    string2 = "BOOLEAN";
                                    break;
                                }
                                case 4: {
                                    string2 = "NODESET";
                                    break;
                                }
                                case 2: {
                                    string2 = "NUMBER";
                                    break;
                                }
                                case 6: {
                                    string2 = "OBJECT";
                                    break;
                                }
                                case 3: {
                                    string2 = "STRING";
                                }
                            }
                            String string3 = null;
                            if (value instanceof NodeSetValue && !(value instanceof TextFragmentValue)) {
                                NodeSetValue nodeSetValue = (NodeSetValue)value;
                                try {
                                    NodeEnumeration nodeEnumeration = nodeSetValue.enumerate(this.ctx, false);
                                    int n = 0;
                                    while (nodeEnumeration.hasMoreElements()) {
                                        nodeEnumeration.nextElement();
                                        ++n;
                                    }
                                    string3 = n + " nodes";
                                }
                                catch (XPathException xPathException) {
                                    string3 = "[CAN'T EVALUATE]";
                                }
                            } else {
                                try {
                                    string3 = value.asString();
                                }
                                catch (XPathException xPathException) {
                                    string3 = "[CAN'T EVALUATE]";
                                }
                            }
                            if (value instanceof TextFragmentValue) {
                                string2 = "STRING";
                            }
                            arrayList.add(new ContextVariableImpl(string, string2, string3, ((StyleElement)node2).getLineNumber()));
                        }
                    }
                }
                if (node2.getPreviousSibling() == null) {
                    if (!(node2.getParentNode() instanceof Element)) break;
                    node2 = node2.getParentNode();
                    continue;
                }
                node2 = node2.getPreviousSibling();
            }
        }
    }
}

