/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.project;

import com.japisoft.editix.project.Path;
import com.japisoft.editix.project.ProjectListener;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.xslt.XSLTEditor;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.NodeFactoryImpl;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.fastparser.walker.AndCriteria;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.helper.model.SchemaLocator;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ProjectManager {
    private static String lastProjectFile;
    private static ProjectListener pl;
    static SwingNode projectContent;

    public static void cleanProject() {
        if (lastProjectFile != null) {
            ProjectManager.saveProject(lastProjectFile);
        }
        lastProjectFile = null;
        ProjectManager.cleanProjectContent();
        if (pl != null) {
            pl.clean();
        }
        ProjectManager.initProjectActions(false);
        ProjectManager.cleanProjectContent();
    }

    public static boolean hasItem(String string) {
        TreeWalker treeWalker = new TreeWalker(ProjectManager.getProjectRoot());
        return treeWalker.getOneNodeByCriteria(new AttributeCriteria("path", string), true) != null;
    }

    public static void setProjectListener(ProjectListener projectListener) {
        pl = projectListener;
    }

    public static ProjectListener getProjectListener() {
        return pl;
    }

    public static boolean openProject(String string) {
        if (lastProjectFile != null) {
            ProjectManager.saveProject(lastProjectFile);
        }
        lastProjectFile = string;
        if (string != null) {
            try {
                ProjectManager.loadProject(string);
                ActionModel.setEnabled("prj.addf2", true);
            }
            catch (Throwable throwable) {
                lastProjectFile = null;
                ApplicationModel.debug(throwable);
                ActionModel.setEnabled("prj.addf2", false);
                return false;
            }
        } else {
            ActionModel.setEnabled("prj.addf2", false);
        }
        return true;
    }

    public static void updateFileType(String string, String string2) {
        if (projectContent == null) {
            return;
        }
        SwingNode swingNode = projectContent;
        TreeWalker treeWalker = new TreeWalker(swingNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("item"), true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            String string3 = simpleNode.getAttribute("path");
            if (!string3.equals(string)) continue;
            simpleNode.setAttribute("type", string2);
        }
    }

    public static void searchFilesForType(List list, String string) {
        ProjectManager.searchFilesForType(ProjectManager.getProjectRoot(), list, string);
    }

    private static void searchFilesForType(SimpleNode simpleNode, List list, String string) {
        if (string.equals(simpleNode.getAttribute("type")) && !list.contains(simpleNode.getAttribute("path"))) {
            list.add(simpleNode.getAttribute("path"));
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            ProjectManager.searchFilesForType(simpleNode.childAt(i), list, string);
        }
    }

    public static ArrayList getAllFiles() {
        Object object;
        if (projectContent == null) {
            object = Preferences.getPreference(Preferences.SYSTEM_GP, "project.lastFile", (String)null);
            if (object != null) {
                ProjectManager.openProject((String)object);
            } else {
                return null;
            }
        }
        object = new TreeWalker(projectContent);
        Enumeration enumeration = ((TreeWalker)object).getNodeByCriteria(new NodeNameCriteria("item"), true);
        ArrayList<File> arrayList = null;
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            if (arrayList == null) {
                arrayList = new ArrayList<File>();
            }
            if (!simpleNode.hasAttribute("path")) continue;
            arrayList.add(new File(simpleNode.getAttribute("path")));
        }
        return arrayList;
    }

    public static void checkFilesPath() {
        ProjectManager.checkFilesPath(ProjectManager.getProjectRoot());
    }

    public static void checkFilesPath(SimpleNode simpleNode) {
        if (simpleNode.matchContent("item")) {
            String string = simpleNode.getAttribute("path");
            if (string.indexOf("://") == -1) {
                File file;
                if (string.startsWith("$PJPATH/")) {
                    file = new File(lastProjectFile);
                    string = new File(file.getParentFile(), string.substring(8)).toString();
                    simpleNode.setAttribute("path", string);
                }
                file = new File(string);
                simpleNode.setAttribute("test", file.exists());
            }
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                String string2;
                SimpleNode simpleNode2 = simpleNode.childAt(i);
                if (!simpleNode2.matchContent("property") || !(string2 = simpleNode2.getAttribute("value", "")).startsWith("$PJPATH/")) continue;
                File file = new File(lastProjectFile);
                string = new File(file.getParentFile(), string2.substring(8)).toString();
                simpleNode2.setAttribute("value", string);
            }
        } else {
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                ProjectManager.checkFilesPath(simpleNode.childAt(i));
            }
        }
    }

    public static void updateFileEncoding(String string, String string2) {
        if (projectContent == null) {
            return;
        }
        SwingNode swingNode = projectContent;
        TreeWalker treeWalker = new TreeWalker(swingNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("item"), true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            String string3 = simpleNode.getAttribute("path");
            if (!string3.equals(string)) continue;
            simpleNode.setAttribute("encoding", string2);
        }
    }

    public static void updateFilePath(String string, String string2) {
        if (projectContent == null) {
            return;
        }
        SwingNode swingNode = projectContent;
        TreeWalker treeWalker = new TreeWalker(swingNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("item"), true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            String string3 = simpleNode.getAttribute("path");
            if (!string3.equals(string)) continue;
            simpleNode.setAttribute("path", string2);
            pl.refresh();
        }
    }

    public static void initProjectActions(boolean bl) {
        ActionModel.setEnabled("prjSave", bl);
        ActionModel.setEnabled("prjSaveAs", bl);
        ActionModel.setEnabled("prjClose", bl);
    }

    static void loadProject(String string) throws Throwable {
        Parser parser = new Parser();
        parser.setNodeFactory(new SwingNodeFactory());
        parser.setInputStream(new FileInputStream(string));
        parser.parse();
        SwingNode swingNode = (SwingNode)parser.getDocument().getRoot();
        if (Preferences.getPreference("project", "relativePath", true)) {
            ProjectManager.resolveRelativePath(string, swingNode);
        }
        ProjectManager.checkFilesPath(swingNode);
        projectContent = swingNode;
        swingNode.setAttribute("path", string);
        Iterator iterator = ProjectManager.getOpenedItems();
        while (iterator.hasNext()) {
            ProjectManager.openItem((SimpleNode)iterator.next());
        }
        String string2 = swingNode.getAttribute("lastbrowsed");
        if (pl != null) {
            pl.loadProject(string);
        }
        ProjectManager.initProjectActions(true);
    }

    private static void resolveRelativePath(String string, SimpleNode simpleNode) {
        String string2;
        if (simpleNode.matchContent("item")) {
            string2 = simpleNode.getAttribute("path");
            simpleNode.setAttribute("path", Path.getAbsolutePath(string, string2));
        } else if (simpleNode.matchContent("property") && (string2 = simpleNode.getAttribute("name")).endsWith(".file")) {
            simpleNode.setAttribute("value", Path.getAbsolutePath(string, simpleNode.getAttribute("value")));
        }
        for (int i = 0; i < simpleNode.getViewChildCount(); ++i) {
            ProjectManager.resolveRelativePath(string, (SimpleNode)simpleNode.getViewChildAt(i));
        }
    }

    public static SwingNode addItem(XMLContainer xMLContainer, SimpleNode simpleNode) {
        String string = xMLContainer.getCurrentDocumentLocation();
        TreeWalker treeWalker = new TreeWalker(ProjectManager.getProjectRoot());
        SwingNode swingNode = (SwingNode)treeWalker.getOneNodeByCriteria(new AndCriteria(new NodeNameCriteria("item"), new AttributeCriteria("path", string)), true);
        if (swingNode != null) {
            swingNode.setApplicationObject("select");
            return swingNode;
        }
        SwingNode swingNode2 = new SwingNode(1, "item");
        swingNode2.setAttribute("path", string);
        swingNode2.setAttribute("type", xMLContainer.getDocumentInfo().getType());
        if (xMLContainer.getProperty("encoding") != null) {
            swingNode2.setAttribute("encoding", (String)xMLContainer.getProperty("encoding"));
        }
        if (xMLContainer.getSchemaAccessibility().getRelaxNGValidationLocation() != null) {
            xMLContainer.setProperty("relaxng", xMLContainer.getSchemaAccessibility().getRelaxNGValidationLocation());
        }
        ProjectManager.synchronizedItemWithXMLContainerProperties(swingNode2, xMLContainer);
        simpleNode.addChildNode(swingNode2);
        return swingNode2;
    }

    public static SwingNode addGroup(String string, SimpleNode simpleNode) {
        SwingNode swingNode = new SwingNode(1, "group");
        swingNode.setAttribute("path", string);
        simpleNode.addChildNode(swingNode);
        return swingNode;
    }

    public static String getGroupName(SimpleNode simpleNode) {
        if (simpleNode.isRoot()) {
            return simpleNode.getContent();
        }
        return simpleNode.getAttribute("path");
    }

    public static void updateGroupName(String string, SimpleNode simpleNode) {
        if (simpleNode.isRoot()) {
            simpleNode.setContent(string);
        } else {
            simpleNode.setAttribute("path", string);
        }
    }

    public static void delete(SimpleNode simpleNode) {
        simpleNode.getSimpleParent().removeChildNode(simpleNode);
    }

    public static int getProjectElementCount() {
        if (projectContent == null) {
            return 0;
        }
        return projectContent.childCount();
    }

    public static SwingNode getProjectRoot() {
        if (projectContent == null) {
            projectContent = new SwingNode(1, "MyProject");
            Document document = new Document();
            document.setNodeFactory(new NodeFactoryImpl());
            projectContent.setDocument(document);
            ProjectManager.initProjectActions(true);
        }
        return projectContent;
    }

    public static Iterator getOpenedItems() {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        TreeWalker treeWalker = new TreeWalker(ProjectManager.getProjectRoot());
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("item"), true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode = (SimpleNode)enumeration.nextElement();
            if (!"true".equals(simpleNode.getAttribute("open")) && simpleNode.hasAttribute("open")) continue;
            arrayList.add(simpleNode);
        }
        return arrayList.iterator();
    }

    public static boolean openItem(SimpleNode simpleNode) {
        String string = simpleNode.getAttribute("path");
        String string2 = simpleNode.getAttribute("type");
        String string3 = simpleNode.getAttribute("encoding");
        ProjectManager.checkFilesPath(simpleNode);
        boolean bl = EditixFrame.ACCESSOR.activeXMLContainer(string);
        if (bl) {
            simpleNode.setAttribute("open", true);
            return true;
        }
        HashMap hashMap = ProjectManager.getProjectPropertiesAt(simpleNode);
        String string4 = (String)hashMap.get("vfs.user");
        String string5 = (String)hashMap.get("vfs.password");
        ActionEvent actionEvent = null;
        if (string4 != null) {
            actionEvent = new ActionEvent(string4, 0, string4 + "$$" + string5);
        }
        ActionModel.activeActionById("open", actionEvent, string, string2, string3);
        if (ActionModel.LAST_ACTION_STATE) {
            EditixFrame.ACCESSOR.getSelectedContainer().resetProperties(new HashMap());
            IXMLPanel iXMLPanel = EditixFrame.ACCESSOR.getSelectedPanel();
            for (String string6 : hashMap.keySet()) {
                String string7 = (String)hashMap.get(string6);
                iXMLPanel.setProperty(string6, string7);
                if (!"relaxng".equals(string6)) continue;
                iXMLPanel.getMainContainer().getSchemaAccessibility().setRelaxNGValidationLocation(string7);
            }
            iXMLPanel.setProperty("system-end", null);
            simpleNode.setAttribute("open", true);
            ActionModel.synchronizeState(iXMLPanel.getMainContainer());
        }
        return ActionModel.LAST_ACTION_STATE;
    }

    public static String getProjectElementAt(int n) {
        return projectContent.childAt(n).getAttribute("path");
    }

    public static String getProjectTypeAt(int n) {
        return projectContent.childAt(n).getAttribute("type");
    }

    public static String getProjectEncodingAt(int n) {
        return projectContent.childAt(n).getAttribute("encoding");
    }

    public static HashMap getProjectPropertiesAt(int n) {
        SimpleNode simpleNode = projectContent.childAt(n);
        return ProjectManager.getProjectPropertiesAt(simpleNode);
    }

    public static HashMap getProjectPropertiesAt(SimpleNode simpleNode) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("property"), false);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            hashMap.put(simpleNode2.getAttribute("name"), simpleNode2.getAttribute("value"));
        }
        return hashMap;
    }

    public static boolean isEmpty() {
        return projectContent == null;
    }

    public static void cleanProjectContent() {
        projectContent = null;
    }

    public static void addProjectElement(XMLContainer xMLContainer) {
        String string = xMLContainer.getCurrentDocumentLocation();
        SimpleNode simpleNode = new SimpleNode(1, "item");
        simpleNode.setAttribute("path", string);
        simpleNode.setAttribute("type", xMLContainer.getDocumentInfo().getType());
        if (xMLContainer.getProperty("encoding") != null) {
            simpleNode.setAttribute("encoding", (String)xMLContainer.getProperty("encoding"));
        }
        if (xMLContainer.getSchemaAccessibility().getRelaxNGValidationLocation() != null) {
            xMLContainer.setProperty("relaxng", xMLContainer.getSchemaAccessibility().getRelaxNGValidationLocation());
        }
        ProjectManager.synchronizedItemWithXMLContainerProperties(simpleNode, xMLContainer);
        String string2 = (String)xMLContainer.getProperty(XSLTEditor.MAXIMIZED_CMD);
        if (string2 != null) {
            SimpleNode simpleNode2 = new SimpleNode(1, "property");
            simpleNode2.setAttribute("name", XSLTEditor.MAXIMIZED_CMD);
            simpleNode2.setAttribute("value", string2);
            simpleNode.addChildNode(simpleNode2);
        }
        ProjectManager.getProjectRoot().addChildNode(simpleNode);
    }

    private static void synchronizedItemWithXMLContainerProperties(SimpleNode simpleNode, XMLContainer xMLContainer) {
        Object object;
        int n = 0;
        while (n < simpleNode.childCount()) {
            object = simpleNode.childAt(n);
            if (((SimpleNode)object).matchContent("property")) {
                simpleNode.removeChildNode((SimpleNode)object);
                continue;
            }
            ++n;
        }
        object = xMLContainer.getProperties();
        if (object != null) {
            while (object.hasNext()) {
                Object object2;
                String string = (String)object.next();
                Object object3 = xMLContainer.getProperty(string);
                if (object3 instanceof SchemaLocator) {
                    object2 = (SchemaLocator)object3;
                    if (((SchemaLocator)object2).location != null) {
                        object3 = ((SchemaLocator)object2).location;
                    }
                }
                if (!(object3 instanceof String)) continue;
                object2 = (String)object3;
                SimpleNode simpleNode2 = new SimpleNode(1, "property");
                simpleNode2.setAttribute("name", string);
                simpleNode2.setAttribute("value", (String)object2);
                simpleNode.addChildNode(simpleNode2);
            }
        }
    }

    public static String getLastOpenProject(boolean bl) {
        if (lastProjectFile == null && bl) {
            lastProjectFile = new File(ApplicationModel.getAppUserPath(), "myproject.pre").toString();
            return lastProjectFile.toString();
        }
        return lastProjectFile;
    }

    public static boolean saveProject(String string) {
        if (projectContent == null) {
            return false;
        }
        if (string.indexOf(".") == -1) {
            string = string + ".pre";
        }
        try {
            Document document = ProjectManager.synchronizeProjectContent();
            if (Preferences.getPreference("project", "relativePath", true)) {
                document = new Document(((SimpleNode)document.getRoot()).clone(true));
                ProjectManager.createRelativePathDocument(document, string);
            }
            document.write(new FileOutputStream(string));
        }
        catch (Throwable throwable) {
            ApplicationModel.debug(throwable);
            return false;
        }
        return true;
    }

    private static void createRelativePathDocument(Document document, String string) {
        ProjectManager.createRelativePathDocument((SimpleNode)document.getRoot(), string);
    }

    private static void createRelativePathDocument(SimpleNode simpleNode, String string) {
        String string2;
        if (simpleNode.matchContent("item")) {
            string2 = simpleNode.getAttribute("path");
            simpleNode.setAttribute("path", Path.getRelativePath(string, string2));
        } else if (simpleNode.matchContent("property") && (string2 = simpleNode.getAttribute("name")).endsWith(".file")) {
            String string3 = simpleNode.getAttribute("value");
            simpleNode.setAttribute("value", Path.getRelativePath(string, string3));
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            ProjectManager.createRelativePathDocument(simpleNode.childAt(i), string);
        }
    }

    public static Document synchronizeProjectContent() {
        Object object;
        if (projectContent == null) {
            return null;
        }
        Document document = new Document(projectContent);
        ArrayList<SimpleNode> arrayList = null;
        SimpleNode simpleNode = (SimpleNode)document.getRoot();
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("item"), true);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            object = simpleNode2.getAttribute("path");
            simpleNode2.setAttribute("open", false);
            for (int i = 0; i < EditixFrame.ACCESSOR.getXMLContainerCount(); ++i) {
                XMLContainer xMLContainer = EditixFrame.ACCESSOR.getXMLContainer(i);
                if (xMLContainer == null || !((String)object).equals(xMLContainer.getCurrentDocumentLocation())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<SimpleNode>();
                }
                arrayList.add(simpleNode2);
                arrayList.add((SimpleNode)((Object)xMLContainer));
                simpleNode2.setAttribute("open", true);
            }
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); i += 2) {
                object = (SimpleNode)arrayList.get(i);
                XMLContainer xMLContainer = (XMLContainer)arrayList.get(i + 1);
                ProjectManager.synchronizedItemWithXMLContainerProperties((SimpleNode)object, xMLContainer);
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToZip(File file) throws Throwable {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        try {
            SimpleNode simpleNode = ProjectManager.getProjectRoot().clone(true);
            ProjectManager.writeContent("", zipOutputStream, simpleNode, simpleNode);
            String string = ProjectManager.getProjectRoot().getContent() + ".pre";
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            Document document = new Document(simpleNode);
            simpleNode.setDocument(document);
            document.write(zipOutputStream);
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (ZipException zipException) {
                EditixFactory.buildAndShowErrorDialog("Can't export to a zip file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeContent(String string, ZipOutputStream zipOutputStream, SimpleNode simpleNode, SimpleNode simpleNode2) throws Throwable {
        block10: {
            String string2;
            block9: {
                if (!simpleNode2.matchContent("group") && !simpleNode2.isRoot()) break block9;
                if (!simpleNode2.isRoot()) {
                    string = string + "/" + simpleNode2.getAttribute("path") + "/";
                }
                for (int i = 0; i < simpleNode2.childCount(); ++i) {
                    ProjectManager.writeContent(string, zipOutputStream, simpleNode, simpleNode2.childAt(i));
                }
                break block10;
            }
            if (!simpleNode2.matchContent("item") || (string2 = simpleNode2.getAttribute("path")).indexOf("://") != -1) break block10;
            String string3 = string2;
            File file = new File(string2);
            if (file.exists()) {
                int n = string2.lastIndexOf("\\");
                if (n == -1) {
                    n = string2.lastIndexOf("/");
                }
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = string + string2;
                String string4 = "$PJPATH";
                string4 = string2.startsWith("/") ? string4 + string2 : string4 + "/" + string2;
                simpleNode2.setAttribute("path", string4);
                ProjectManager.replacePathInsideParams(string3, string4, simpleNode);
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    byte[] byArray = new byte[1024];
                    int n2 = 0;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                }
                finally {
                    fileInputStream.close();
                }
            }
        }
    }

    private static void replacePathInsideParams(String string, String string2, SimpleNode simpleNode) {
        if (simpleNode.matchContent("property") && string.equals(simpleNode.getAttribute("value"))) {
            simpleNode.setAttribute("value", string2);
        }
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            ProjectManager.replacePathInsideParams(string, string2, simpleNode.childAt(i));
        }
    }

    static {
        pl = null;
        projectContent = null;
    }
}

