/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.ui;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.db.Driver;
import com.japisoft.editix.db.DriverDbManager;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.ui.DbBrowser;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.panels.AbstractPanel;
import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;

public class DbPanel
extends AbstractPanel {
    protected JComponent buildView() {
        return new DbBrowser();
    }

    protected String getTitle() {
        return "Database browser";
    }

    public void stop() {
        this.preHide();
    }

    protected void preShow() {
    }

    protected void preHide() {
        Object object;
        super.preHide();
        DefaultMutableTreeNode defaultMutableTreeNode = ((DbBrowser)this.getView()).getRoot();
        StringBuffer stringBuffer = new StringBuffer("<db>");
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            object = (RootNodeDb)defaultMutableTreeNode.getChildAt(i);
            String string = object.toXml();
            if (string == null) continue;
            stringBuffer.append(string);
        }
        stringBuffer.append("</db>");
        File file = new File(EditixApplicationModel.getAppUserPath(), "db.xml");
        try {
            object = new FileWriter(file);
            ((Writer)object).write(stringBuffer.toString());
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            EditixApplicationModel.debug(iOException);
        }
        ((DbBrowser)this.getView()).close();
    }

    protected void postShow() {
        super.postShow();
        File file = new File(EditixApplicationModel.getAppUserPath(), "db.xml");
        if (file.exists()) {
            DefaultMutableTreeNode defaultMutableTreeNode = ((DbBrowser)this.getView()).getRoot();
            try {
                Parser parser = new Parser();
                parser.setInputStream(new FileInputStream(file));
                parser.parse();
                Document document = parser.getDocument();
                SimpleNode simpleNode = (SimpleNode)document.getRoot();
                StringBuffer stringBuffer = null;
                for (int i = 0; i < simpleNode.childCount(); ++i) {
                    SimpleNode simpleNode2 = simpleNode.childAt(i);
                    if (!simpleNode2.matchContent("connection")) continue;
                    String string = simpleNode2.getAttribute("driver");
                    String string2 = simpleNode2.getAttribute("url");
                    String string3 = simpleNode2.getAttribute("user");
                    String string4 = simpleNode2.getAttribute("password");
                    Driver driver = DriverDbManager.getDriverByName(string);
                    if (driver == null) continue;
                    try {
                        RootNodeDb rootNodeDb = driver.getRoot(string2, string3, string4);
                        defaultMutableTreeNode.add(rootNodeDb);
                        continue;
                    }
                    catch (Exception exception) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        if (stringBuffer != null) {
                            stringBuffer.append("\n");
                        }
                        stringBuffer.append("Can't connect to " + string2 + " : " + exception.getMessage());
                    }
                }
                ((DbBrowser)this.getView()).initTree();
                if (stringBuffer != null) {
                    EditixFactory.buildAndShowErrorDialog(stringBuffer.toString());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

