/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestListings
extends FTPTestCase {
    private static String cvsId = "@(#)$Id: TestListings.java,v 1.4 2004/05/01 17:05:43 bruceb Exp $";
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$test$TestListings;

    protected String getLogName() {
        return "TestListings.log";
    }

    public void testDir() throws Exception {
        block2: {
            this.connect();
            this.login();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir();
            this.print(list);
            list = this.ftp.dir(".");
            this.print(list);
            list = this.ftp.dir(this.remoteEmptyDir);
            this.print(list);
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550) break block2;
                TestListings.fail((String)("dir(" + randomName + ") should throw 550 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testDirFull() throws Exception {
        block2: {
            this.connect();
            this.login();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir(".", true);
            this.print(list);
            this.log.debug("******* dirDetails *******");
            FTPFile[] files = this.ftp.dirDetails(".");
            this.print(files);
            this.log.debug("******* end dirDetails *******");
            list = this.ftp.dir(this.remoteEmptyDir, true);
            this.print(list);
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName, true);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550) break block2;
                TestListings.fail((String)("dir(" + randomName + ") should throw 550 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    private void print(String[] list) {
        this.log.debug("Directory listing:");
        for (int i = 0; i < list.length; ++i) {
            this.log.debug(list[i]);
        }
        this.log.debug("Listing complete");
    }

    private void print(FTPFile[] list) {
        this.log.debug("Directory listing:");
        for (int i = 0; i < list.length; ++i) {
            this.log.debug(list[i].toString());
        }
        this.log.debug("Listing complete");
    }

    public static Test suite() {
        return new TestSuite(class$com$enterprisedt$net$ftp$test$TestListings == null ? (class$com$enterprisedt$net$ftp$test$TestListings = TestListings.class$("com.enterprisedt.net.ftp.test.TestListings")) : class$com$enterprisedt$net$ftp$test$TestListings);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestListings.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

