/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPActiveDataSocket;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPDataSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class FTPControlSocket {
    public static String cvsId = "@(#)$Id: FTPControlSocket.java,v 1.13 2004/07/23 08:30:40 bruceb Exp $";
    static final String EOL = "\r\n";
    public static final int CONTROL_PORT = 21;
    private static final String DEBUG_ARROW = "---> ";
    private static final String PASSWORD_MESSAGE = "---> PASS";
    private Logger log = Logger.getLogger(class$com$enterprisedt$net$ftp$FTPControlSocket == null ? (class$com$enterprisedt$net$ftp$FTPControlSocket = FTPControlSocket.class$("com.enterprisedt.net.ftp.FTPControlSocket")) : class$com$enterprisedt$net$ftp$FTPControlSocket);
    private boolean debugResponses = false;
    private boolean strictReturnCodes = true;
    protected Socket controlSock = null;
    protected Writer writer = null;
    protected BufferedReader reader = null;
    private FTPMessageListener messageListener = null;
    static /* synthetic */ Class class$com$enterprisedt$net$ftp$FTPControlSocket;

    FTPControlSocket(InetAddress remoteAddr, int controlPort, int timeout, FTPMessageListener messageListener) throws IOException, FTPException {
        this(new Socket(remoteAddr, controlPort), timeout, messageListener);
    }

    protected FTPControlSocket(Socket controlSock, int timeout, FTPMessageListener messageListener) throws IOException, FTPException {
        this.controlSock = controlSock;
        this.messageListener = messageListener;
        this.setTimeout(timeout);
        this.initStreams();
        this.validateConnection();
    }

    private void validateConnection() throws IOException, FTPException {
        String reply = this.readReply();
        this.validateReply(reply, "220");
    }

    private void initStreams() throws IOException {
        InputStream is = this.controlSock.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
        OutputStream os = this.controlSock.getOutputStream();
        this.writer = new OutputStreamWriter(os, "US-ASCII");
    }

    String getRemoteHostName() {
        InetAddress addr = this.controlSock.getInetAddress();
        return addr.getHostName();
    }

    void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
    }

    void setTimeout(int millis) throws IOException {
        if (this.controlSock == null) {
            throw new IllegalStateException("Failed to set timeout - no control socket");
        }
        this.controlSock.setSoTimeout(millis);
    }

    void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
    }

    public void logout() throws IOException {
        IOException ex = null;
        try {
            this.writer.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            this.controlSock.close();
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null) {
            throw ex;
        }
    }

    FTPDataSocket createDataSocket(FTPConnectMode connectMode) throws IOException, FTPException {
        if (connectMode == FTPConnectMode.ACTIVE) {
            return this.createDataSocketActive();
        }
        return this.createDataSocketPASV();
    }

    FTPDataSocket createDataSocketActive() throws IOException, FTPException {
        FTPDataSocket socket = this.newActiveDataSocket(0);
        InetAddress localhost = this.controlSock.getLocalAddress();
        this.setDataPort(localhost, (short)socket.getLocalPort());
        return socket;
    }

    private short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    protected byte[] toByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    private void setDataPort(InetAddress host, short portNo) throws IOException, FTPException {
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = this.toByteArray(portNo);
        String cmd = "PORT " + this.toUnsignedShort(hostBytes[0]) + "," + this.toUnsignedShort(hostBytes[1]) + "," + this.toUnsignedShort(hostBytes[2]) + "," + this.toUnsignedShort(hostBytes[3]) + "," + this.toUnsignedShort(portBytes[0]) + "," + this.toUnsignedShort(portBytes[1]);
        String reply = this.sendCommand(cmd);
        this.validateReply(reply, "200");
    }

    FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        String reply = this.sendCommand("PASV");
        this.validateReply(reply, "227");
        int startIP = reply.indexOf(40);
        int endIP = reply.indexOf(41);
        if (startIP < 0 && endIP < 0) {
            startIP = reply.toUpperCase().lastIndexOf("MODE") + 4;
            endIP = reply.length();
        }
        String ipData = reply.substring(startIP + 1, endIP);
        int[] parts = new int[6];
        int len = ipData.length();
        int partCount = 0;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len && partCount <= 6; ++i) {
            char ch = ipData.charAt(i);
            if (Character.isDigit(ch)) {
                buf.append(ch);
            } else if (ch != ',') {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
            if (ch != ',' && i + 1 != len) continue;
            try {
                parts[partCount++] = Integer.parseInt(buf.toString());
                buf.setLength(0);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new FTPException("Malformed PASV reply: " + reply);
            }
        }
        String ipAddress = parts[0] + "." + parts[1] + "." + parts[2] + "." + parts[3];
        int port = (parts[4] << 8) + parts[5];
        return this.newPassiveDataSocket(ipAddress, port);
    }

    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        return new FTPPassiveDataSocket(new Socket(remoteHost, port));
    }

    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        return new FTPActiveDataSocket(new ServerSocket(port));
    }

    protected String sendCommand(String command) throws IOException {
        this.log(DEBUG_ARROW + command, true);
        this.writer.write(command + EOL);
        this.writer.flush();
        return this.readReply();
    }

    String readReply() throws IOException {
        String firstLine = this.reader.readLine();
        if (firstLine == null || firstLine.length() == 0) {
            throw new IOException("Unexpected null reply received");
        }
        StringBuffer reply = new StringBuffer(firstLine);
        this.log(reply.toString(), false);
        String replyCode = reply.toString().substring(0, 3);
        if (reply.charAt(3) == '-') {
            boolean complete = false;
            while (!complete) {
                String line = this.reader.readLine();
                if (line == null) {
                    throw new IOException("Unexpected null reply received");
                }
                this.log(line, false);
                if (line.length() > 3 && line.substring(0, 3).equals(replyCode) && line.charAt(3) == ' ') {
                    reply.append(line.substring(3));
                    complete = true;
                    continue;
                }
                reply.append(" ");
                reply.append(line);
            }
        }
        return reply.toString();
    }

    FTPReply validateReply(String reply, String expectedReplyCode) throws IOException, FTPException {
        FTPReply replyObj = new FTPReply(reply);
        if (this.validateReply(replyObj, expectedReplyCode)) {
            return replyObj;
        }
        throw new FTPException(replyObj);
    }

    public FTPReply validateReply(String reply, String[] expectedReplyCodes) throws IOException, FTPException {
        FTPReply replyObj = new FTPReply(reply);
        for (int i = 0; i < expectedReplyCodes.length; ++i) {
            if (!this.validateReply(replyObj, expectedReplyCodes[i])) continue;
            return replyObj;
        }
        throw new FTPException(replyObj);
    }

    private boolean validateReply(FTPReply reply, String expectedReplyCode) {
        String replyCode = reply.getReplyCode();
        if (this.strictReturnCodes) {
            return replyCode.equals(expectedReplyCode);
        }
        return replyCode.charAt(0) == expectedReplyCode.charAt(0);
    }

    void log(String msg, boolean command) {
        if (msg.startsWith(PASSWORD_MESSAGE)) {
            msg = "---> PASS ********";
        }
        this.log.debug(msg);
        if (this.messageListener != null) {
            if (command) {
                this.messageListener.logCommand(msg);
            } else {
                this.messageListener.logReply(msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

