/*
 * Decompiled with CFR 0.152.
 */
package org.textmining.extraction.word;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;
import org.textmining.extraction.word.ComplexFileTable;
import org.textmining.extraction.word.PasswordProtectedException;
import org.textmining.extraction.word.WordTextExtractor;
import org.textmining.extraction.word.WordTextScrubber;
import org.textmining.extraction.word.model.CHPBinTable;
import org.textmining.extraction.word.model.CHPX;
import org.textmining.extraction.word.model.ComplexNodeHelper;
import org.textmining.extraction.word.model.NodeHelper;
import org.textmining.extraction.word.model.TextPiece;
import org.textmining.extraction.word.model.TextPieceTable;
import org.textmining.extraction.word.sprm.SprmIterator;
import org.textmining.extraction.word.sprm.SprmOperation;

public class Word97TextExtractor
extends WordTextExtractor {
    Word97TextExtractor(byte[] byArray, POIFSFileSystem pOIFSFileSystem, boolean bl) {
        this._header = byArray;
        this._fsys = pOIFSFileSystem;
        this._fastSave = bl;
    }

    public Word97TextExtractor(InputStream inputStream) throws IOException, PasswordProtectedException {
        super.initWordHeader(inputStream);
    }

    public String getText() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.getText(stringWriter);
        return stringWriter.toString();
    }

    public void getText(Writer writer) throws IOException {
        short s = LittleEndian.getShort((byte[])this._header, (int)10);
        boolean bl = (s & 0x200) != 0;
        int n = LittleEndian.getInt((byte[])this._header, (int)418);
        String string = null;
        string = bl ? "1Table" : "0Table";
        DocumentEntry documentEntry = (DocumentEntry)this._fsys.getRoot().getEntry(string);
        byte[] byArray = new byte[documentEntry.getSize()];
        DocumentInputStream documentInputStream = this._fsys.createDocumentInputStream(string);
        documentInputStream.read(byArray);
        documentInputStream.close();
        int n2 = LittleEndian.getInt((byte[])this._header, (int)24);
        ComplexFileTable complexFileTable = new ComplexFileTable(this._header, byArray, n, n2);
        TextPieceTable textPieceTable = complexFileTable.getTextPieceTable();
        List list = textPieceTable.getTextPieces();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            TextPiece textPiece = (TextPiece)list.get(i);
            String string2 = textPiece.getText(this._header);
            stringBuffer.append(string2);
        }
        NodeHelper nodeHelper = null;
        nodeHelper = this._fastSave ? new ComplexNodeHelper(textPieceTable) : new NodeHelper(textPieceTable);
        int n3 = LittleEndian.getInt((byte[])this._header, (int)250);
        int n4 = LittleEndian.getInt((byte[])this._header, (int)254);
        CHPBinTable cHPBinTable = new CHPBinTable(this._header, byArray, n3, n4, n2, nodeHelper);
        documentInputStream = null;
        this._fsys = null;
        documentEntry = null;
        List list2 = cHPBinTable.getTextRuns();
        WordTextScrubber wordTextScrubber = new WordTextScrubber();
        for (int i = 0; i < list2.size(); ++i) {
            CHPX cHPX = (CHPX)list2.get(i);
            if (this.isDeleted(cHPX.getGrpprl())) continue;
            String string3 = stringBuffer.substring(cHPX.getStart(), cHPX.getEnd());
            wordTextScrubber.append(writer, string3);
        }
    }

    protected boolean isDeleted(byte[] byArray) {
        SprmIterator sprmIterator = new SprmIterator(byArray);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getOperation() != 0 || sprmOperation.getOperand() == 0) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsUnicode() {
        return true;
    }
}

