/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.sax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.modules.XMLResource;

public class SetContentHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$sax$SetContentHandler == null ? (class$org$apache$xindice$xml$sax$SetContentHandler = SetContentHandler.class$("org.apache.xindice.xml.sax.SetContentHandler")) : class$org$apache$xindice$xml$sax$SetContentHandler));
    protected XMLResource resource = null;
    protected StringBuffer newContent = null;
    protected Map namespaces = null;
    static /* synthetic */ Class class$org$apache$xindice$xml$sax$SetContentHandler;

    public SetContentHandler(XMLResource resource) {
        this.resource = resource;
        this.namespaces = new HashMap();
    }

    public void startDocument() throws SAXException {
        this.newContent = new StringBuffer();
        this.newContent.append("<?xml version=\"1.0\"?>");
    }

    public void endDocument() throws SAXException {
        try {
            this.resource.setContent((Object)this.newContent.toString());
        }
        catch (Exception e) {
            log.warn((Object)"Exception in endDocument", (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    private String getLocalName(String qn) {
        if (qn.indexOf(58) != -1) {
            return qn.substring(qn.indexOf(58) + 1);
        }
        return qn;
    }

    private String getQNameAtt(String uri, String localName) throws SAXException {
        String prefix = null;
        if ("".equals(uri)) {
            return localName;
        }
        Iterator prefixes = this.namespaces.keySet().iterator();
        while (prefixes.hasNext()) {
            String key = (String)prefixes.next();
            if ("".equals(key) || !this.namespaces.get(key).equals(uri)) continue;
            prefix = key;
            break;
        }
        if (prefix == null) {
            throw new SAXException("No declared prefix for namespace '" + uri + "'.");
        }
        return prefix + ":" + localName;
    }

    private String getQNameElement(String uri, String localName) throws SAXException {
        String prefix = null;
        if ("".equals(uri)) {
            if (this.namespaces.get("") != null) {
                throw new SAXException("default namespace is declared here!");
            }
            return localName;
        }
        Iterator prefixes = this.namespaces.keySet().iterator();
        while (prefixes.hasNext()) {
            String key = (String)prefixes.next();
            if (!this.namespaces.get(key).equals(uri)) continue;
            prefix = key;
            break;
        }
        if (prefix == null) {
            throw new SAXException("No declared prefix for namespace '" + uri + "'.");
        }
        return "".equals(prefix) ? localName : prefix + ":" + localName;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.newContent.append("<");
        if ("".equals(qName)) {
            this.newContent.append(this.getQNameElement(uri, localName));
        } else {
            this.newContent.append(qName);
        }
        int i = 0;
        while (i < attributes.getLength()) {
            String qn = attributes.getQName(i);
            if ("".equals(qn)) {
                qn = this.getQNameAtt(attributes.getURI(i), attributes.getLocalName(i));
            }
            this.newContent.append(" ");
            this.newContent.append(qn);
            this.newContent.append("=");
            this.newContent.append("\"");
            this.newContent.append(attributes.getValue(i));
            this.newContent.append("\"");
            if (qn.equals("xmlns")) {
                this.namespaces.remove("");
            }
            if (qn.startsWith("xmlns:")) {
                String ln = this.getLocalName(qn);
                this.namespaces.remove(ln);
            }
            ++i;
        }
        Iterator iter = this.namespaces.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.newContent.append(" xmlns");
            if (key.length() > 0) {
                this.newContent.append(":");
                this.newContent.append(key);
            }
            this.newContent.append("=");
            this.newContent.append("\"");
            this.newContent.append(this.namespaces.get(key));
            this.newContent.append("\"");
            this.namespaces.remove(key);
        }
        this.newContent.append(">");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.newContent.append("</");
        if ("".equals(qName)) {
            qName = this.getQNameElement(uri, localName);
        }
        this.newContent.append(qName);
        this.newContent.append(">");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        while (i < length) {
            char c = ch[start + i];
            switch (c) {
                case '&': {
                    this.newContent.append("&amp;");
                    break;
                }
                case '<': {
                    this.newContent.append("&lt;");
                    break;
                }
                case '>': {
                    this.newContent.append("&gt;");
                    break;
                }
                case '\"': {
                    this.newContent.append("&quot;");
                    break;
                }
                case '\'': {
                    this.newContent.append("&apos;");
                    break;
                }
                default: {
                    if (c > '\u007f') {
                        this.newContent.append("&#" + c + ";");
                        break;
                    }
                    this.newContent.append(c);
                }
            }
            ++i;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        while (i < length) {
            this.newContent.append(ch[start + i]);
            ++i;
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.newContent.append("<?");
        this.newContent.append(target);
        this.newContent.append(" ");
        if (data != null) {
            this.newContent.append(data);
        }
        this.newContent.append("?>");
    }

    public void skippedEntity(String name) throws SAXException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

